/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.api.model;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.apache.maven.api.annotations.Experimental;
import org.apache.maven.api.annotations.Generated;
import org.apache.maven.api.annotations.Immutable;
import org.apache.maven.api.annotations.Nonnull;
import org.apache.maven.api.annotations.NotThreadSafe;
import org.apache.maven.api.annotations.ThreadSafe;
import org.apache.maven.api.model.ImmutableCollections;
import org.apache.maven.api.model.InputLocation;
import org.apache.maven.api.model.InputLocationTracker;

@Experimental
@Generated
@ThreadSafe
@Immutable
public class Extension
implements Serializable,
InputLocationTracker {
    final String groupId;
    final String artifactId;
    final String version;
    final Map<Object, InputLocation> locations;

    Extension(String groupId, String artifactId, String version, Map<Object, InputLocation> locations) {
        this.groupId = groupId;
        this.artifactId = artifactId;
        this.version = version;
        this.locations = ImmutableCollections.copy(locations);
    }

    public String getGroupId() {
        return this.groupId;
    }

    public String getArtifactId() {
        return this.artifactId;
    }

    public String getVersion() {
        return this.version;
    }

    @Override
    public InputLocation getLocation(Object key) {
        return this.locations != null ? this.locations.get(key) : null;
    }

    @Nonnull
    public Builder with() {
        return Extension.newBuilder(this);
    }

    @Nonnull
    public Extension withGroupId(String groupId) {
        return Extension.newBuilder(this, true).groupId(groupId).build();
    }

    @Nonnull
    public Extension withArtifactId(String artifactId) {
        return Extension.newBuilder(this, true).artifactId(artifactId).build();
    }

    @Nonnull
    public Extension withVersion(String version) {
        return Extension.newBuilder(this, true).version(version).build();
    }

    @Nonnull
    public static Extension newInstance() {
        return Extension.newInstance(true);
    }

    @Nonnull
    public static Extension newInstance(boolean withDefaults) {
        return Extension.newBuilder(withDefaults).build();
    }

    @Nonnull
    public static Builder newBuilder() {
        return Extension.newBuilder(true);
    }

    @Nonnull
    public static Builder newBuilder(boolean withDefaults) {
        return new Builder(withDefaults);
    }

    @Nonnull
    public static Builder newBuilder(Extension from) {
        return Extension.newBuilder(from, false);
    }

    @Nonnull
    public static Builder newBuilder(Extension from, boolean forceCopy) {
        return new Builder(from, forceCopy);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Extension)) {
            return false;
        }
        Extension e = (Extension)o;
        if (!Extension.equal(e.getArtifactId(), this.getArtifactId())) {
            return false;
        }
        if (!Extension.equal(e.getGroupId(), this.getGroupId())) {
            return false;
        }
        return Extension.equal(e.getVersion(), this.getVersion());
    }

    private static <T> boolean equal(T obj1, T obj2) {
        return obj1 != null ? obj1.equals(obj2) : obj2 == null;
    }

    public int hashCode() {
        int result = 17;
        result = 37 * result + (this.getArtifactId() != null ? this.getArtifactId().hashCode() : 0);
        result = 37 * result + (this.getGroupId() != null ? this.getGroupId().hashCode() : 0);
        result = 37 * result + (this.getVersion() != null ? this.getVersion().hashCode() : 0);
        return result;
    }

    @NotThreadSafe
    public static class Builder {
        Extension base;
        String groupId;
        String artifactId;
        String version;
        Map<Object, InputLocation> locations;

        Builder(boolean withDefaults) {
            if (withDefaults) {
                // empty if block
            }
        }

        Builder(Extension base, boolean forceCopy) {
            if (forceCopy) {
                this.groupId = base.groupId;
                this.artifactId = base.artifactId;
                this.version = base.version;
                this.locations = base.locations;
            } else {
                this.base = base;
            }
        }

        @Nonnull
        public Builder groupId(String groupId) {
            this.groupId = groupId;
            return this;
        }

        @Nonnull
        public Builder artifactId(String artifactId) {
            this.artifactId = artifactId;
            return this;
        }

        @Nonnull
        public Builder version(String version) {
            this.version = version;
            return this;
        }

        @Nonnull
        public Builder location(Object key, InputLocation location) {
            if (location != null) {
                if (!(this.locations instanceof HashMap)) {
                    this.locations = this.locations != null ? new HashMap<Object, InputLocation>(this.locations) : new HashMap();
                }
                this.locations.put(key, location);
            }
            return this;
        }

        @Nonnull
        public Extension build() {
            if (!(this.base == null || this.groupId != null && this.groupId != this.base.groupId || this.artifactId != null && this.artifactId != this.base.artifactId || this.version != null && this.version != this.base.version)) {
                return this.base;
            }
            Map<Object, InputLocation> locations = null;
            Object location = null;
            Object groupIdLocation = null;
            Object artifactIdLocation = null;
            Object versionLocation = null;
            if (this.locations != null) {
                locations = this.locations;
            }
            return new Extension(this.groupId != null ? this.groupId : (this.base != null ? this.base.groupId : null), this.artifactId != null ? this.artifactId : (this.base != null ? this.base.artifactId : null), this.version != null ? this.version : (this.base != null ? this.base.version : null), locations != null ? locations : (this.base != null ? this.base.locations : null));
        }
    }
}

