/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.api;

import java.nio.file.Path;
import java.util.List;
import java.util.Optional;
import org.apache.maven.api.Artifact;
import org.apache.maven.api.DependencyCoordinate;
import org.apache.maven.api.RemoteRepository;
import org.apache.maven.api.annotations.Experimental;
import org.apache.maven.api.annotations.Nonnull;
import org.apache.maven.api.model.Build;
import org.apache.maven.api.model.Model;

@Experimental
public interface Project {
    @Nonnull
    public String getGroupId();

    @Nonnull
    public String getArtifactId();

    @Nonnull
    public String getVersion();

    @Nonnull
    public String getPackaging();

    @Nonnull
    public Artifact getArtifact();

    @Nonnull
    public Model getModel();

    @Nonnull
    default public Build getBuild() {
        Build build = this.getModel().getBuild();
        return build != null ? build : Build.newInstance();
    }

    @Nonnull
    public Optional<Path> getPomPath();

    @Nonnull
    default public Optional<Path> getBasedir() {
        return this.getPomPath().map(Path::getParent);
    }

    @Nonnull
    public List<DependencyCoordinate> getDependencies();

    @Nonnull
    public List<DependencyCoordinate> getManagedDependencies();

    @Nonnull
    default public String getId() {
        return this.getModel().getId();
    }

    public boolean isExecutionRoot();

    @Nonnull
    public Optional<Project> getParent();

    @Nonnull
    public List<RemoteRepository> getRemoteProjectRepositories();

    @Nonnull
    public List<RemoteRepository> getRemotePluginRepositories();
}

