/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.internal.impl;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.Objects;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.maven.api.RemoteRepository;
import org.apache.maven.api.Session;
import org.apache.maven.api.services.Transport;
import org.apache.maven.api.services.TransportProvider;
import org.apache.maven.api.services.TransportProviderException;
import org.apache.maven.internal.impl.DefaultRemoteRepository;
import org.apache.maven.internal.impl.DefaultSession;
import org.apache.maven.internal.impl.DefaultTransport;
import org.eclipse.aether.spi.connector.transport.TransporterProvider;
import org.eclipse.aether.transfer.NoTransporterException;

@Named
@Singleton
public class DefaultTransportProvider
implements TransportProvider {
    private final TransporterProvider transporterProvider;

    @Inject
    public DefaultTransportProvider(TransporterProvider transporterProvider) {
        this.transporterProvider = Objects.requireNonNull(transporterProvider);
    }

    public Transport transport(Session session, RemoteRepository repository) {
        try {
            URI baseURI = new URI(repository.getUrl());
            return new DefaultTransport(baseURI, this.transporterProvider.newTransporter(((DefaultSession)session).getSession(), ((DefaultRemoteRepository)repository).getRepository()));
        }
        catch (URISyntaxException e) {
            throw new TransportProviderException("Remote repository URL invalid", (Throwable)e);
        }
        catch (NoTransporterException e) {
            throw new TransportProviderException("Unsupported remote repository", (Throwable)e);
        }
    }
}

