/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.internal.impl;

import java.util.Collection;
import java.util.stream.Collectors;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.maven.api.DependencyCoordinate;
import org.apache.maven.api.Exclusion;
import org.apache.maven.api.annotations.Nonnull;
import org.apache.maven.api.services.DependencyCoordinateFactory;
import org.apache.maven.api.services.DependencyCoordinateFactoryRequest;
import org.apache.maven.internal.impl.DefaultDependencyCoordinate;
import org.apache.maven.internal.impl.DefaultSession;
import org.apache.maven.internal.impl.Utils;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.artifact.ArtifactType;
import org.eclipse.aether.artifact.DefaultArtifact;
import org.eclipse.aether.graph.Dependency;

@Named
@Singleton
public class DefaultDependencyCoordinateFactory
implements DependencyCoordinateFactory {
    @Nonnull
    public DependencyCoordinate create(@Nonnull DependencyCoordinateFactoryRequest request) {
        Utils.nonNull(request, "request can not be null");
        DefaultSession session = Utils.cast(DefaultSession.class, request.getSession(), "request.session should be a " + DefaultSession.class);
        ArtifactType type = null;
        if (request.getType() != null) {
            type = session.getSession().getArtifactTypeRegistry().get(request.getType());
        }
        return new DefaultDependencyCoordinate(session, new Dependency((Artifact)new DefaultArtifact(request.getGroupId(), request.getArtifactId(), request.getClassifier(), request.getExtension(), request.getVersion(), type), request.getScope(), Boolean.valueOf(request.isOptional()), (Collection)request.getExclusions().stream().map(this::toExclusion).collect(Collectors.toList())));
    }

    private org.eclipse.aether.graph.Exclusion toExclusion(Exclusion exclusion) {
        return new org.eclipse.aether.graph.Exclusion(exclusion.getGroupId(), exclusion.getArtifactId(), "*", "*");
    }
}

