/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.graph;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.maven.MavenExecutionException;
import org.apache.maven.ProjectCycleException;
import org.apache.maven.artifact.ArtifactUtils;
import org.apache.maven.execution.BuildResumptionDataRepository;
import org.apache.maven.execution.MavenExecutionRequest;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.execution.ProjectActivation;
import org.apache.maven.execution.ProjectDependencyGraph;
import org.apache.maven.graph.DefaultProjectDependencyGraph;
import org.apache.maven.graph.FilteredProjectDependencyGraph;
import org.apache.maven.graph.GraphBuilder;
import org.apache.maven.graph.ProjectSelector;
import org.apache.maven.model.Plugin;
import org.apache.maven.model.building.DefaultModelProblem;
import org.apache.maven.model.building.Result;
import org.apache.maven.project.DuplicateProjectException;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.ProjectBuildingException;
import org.apache.maven.project.collector.MultiModuleCollectionStrategy;
import org.apache.maven.project.collector.PomlessCollectionStrategy;
import org.apache.maven.project.collector.RequestPomCollectionStrategy;
import org.codehaus.plexus.util.StringUtils;
import org.codehaus.plexus.util.dag.CycleDetectedException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named(value="graphBuilder")
@Singleton
public class DefaultGraphBuilder
implements GraphBuilder {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultGraphBuilder.class);
    private final BuildResumptionDataRepository buildResumptionDataRepository;
    private final PomlessCollectionStrategy pomlessCollectionStrategy;
    private final MultiModuleCollectionStrategy multiModuleCollectionStrategy;
    private final RequestPomCollectionStrategy requestPomCollectionStrategy;
    private final ProjectSelector projectSelector;

    @Deprecated
    public DefaultGraphBuilder() {
        this(null, null, null, null);
    }

    @Inject
    public DefaultGraphBuilder(BuildResumptionDataRepository buildResumptionDataRepository, PomlessCollectionStrategy pomlessCollectionStrategy, MultiModuleCollectionStrategy multiModuleCollectionStrategy, RequestPomCollectionStrategy requestPomCollectionStrategy) {
        this.buildResumptionDataRepository = buildResumptionDataRepository;
        this.pomlessCollectionStrategy = pomlessCollectionStrategy;
        this.multiModuleCollectionStrategy = multiModuleCollectionStrategy;
        this.requestPomCollectionStrategy = requestPomCollectionStrategy;
        this.projectSelector = new ProjectSelector();
    }

    public Result<ProjectDependencyGraph> build(MavenSession session) {
        try {
            Result<ProjectDependencyGraph> result = this.sessionDependencyGraph(session);
            if (result == null) {
                List<MavenProject> projects = this.getProjectsForMavenReactor(session);
                this.validateProjects(projects, session.getRequest());
                this.enrichRequestFromResumptionData(projects, session.getRequest());
                result = this.reactorDependencyGraph(session, projects);
            }
            return result;
        }
        catch (MavenExecutionException | DuplicateProjectException | ProjectBuildingException e) {
            return Result.error(Collections.singletonList(new DefaultModelProblem(null, null, null, null, 0, 0, e)));
        }
        catch (CycleDetectedException e) {
            String message = "The projects in the reactor contain a cyclic reference: " + e.getMessage();
            ProjectCycleException error = new ProjectCycleException(message, e);
            return Result.error(Collections.singletonList(new DefaultModelProblem(null, null, null, null, 0, 0, (Exception)error)));
        }
    }

    private Result<ProjectDependencyGraph> sessionDependencyGraph(MavenSession session) throws CycleDetectedException, DuplicateProjectException {
        Result result = null;
        if (session.getProjectDependencyGraph() != null || session.getProjects() != null) {
            DefaultProjectDependencyGraph graph = new DefaultProjectDependencyGraph(session.getAllProjects(), (Collection<MavenProject>)session.getProjects());
            result = Result.success((Object)graph);
        }
        return result;
    }

    private Result<ProjectDependencyGraph> reactorDependencyGraph(MavenSession session, List<MavenProject> projects) throws CycleDetectedException, DuplicateProjectException, MavenExecutionException {
        ProjectDependencyGraph projectDependencyGraph = new DefaultProjectDependencyGraph(projects);
        List<MavenProject> activeProjects = projectDependencyGraph.getSortedProjects();
        List<MavenProject> allSortedProjects = projectDependencyGraph.getSortedProjects();
        activeProjects = this.trimProjectsToRequest(activeProjects, projectDependencyGraph, session.getRequest());
        activeProjects = this.trimSelectedProjects(activeProjects, allSortedProjects, projectDependencyGraph, session.getRequest());
        activeProjects = this.trimResumedProjects(activeProjects, projectDependencyGraph, session.getRequest());
        if ((activeProjects = this.trimExcludedProjects(activeProjects, projectDependencyGraph, session.getRequest())).size() != projectDependencyGraph.getSortedProjects().size()) {
            projectDependencyGraph = new FilteredProjectDependencyGraph(projectDependencyGraph, activeProjects);
        }
        return Result.success((Object)projectDependencyGraph);
    }

    private List<MavenProject> trimProjectsToRequest(List<MavenProject> activeProjects, ProjectDependencyGraph graph, MavenExecutionRequest request) throws MavenExecutionException {
        List<MavenProject> result = activeProjects;
        if (request.getPom() != null) {
            result = this.getProjectsInRequestScope(request, activeProjects);
            List<MavenProject> sortedProjects = graph.getSortedProjects();
            result.sort(Comparator.comparing(sortedProjects::indexOf));
            result = this.includeAlsoMakeTransitively(result, request, graph);
        }
        return result;
    }

    private List<MavenProject> trimSelectedProjects(List<MavenProject> projects, List<MavenProject> allSortedProjects, ProjectDependencyGraph graph, MavenExecutionRequest request) throws MavenExecutionException {
        List<MavenProject> result = projects;
        ProjectActivation projectActivation = request.getProjectActivation();
        Set<String> requiredSelectors = projectActivation.getRequiredActiveProjectSelectors();
        Set<String> optionalSelectors = projectActivation.getOptionalActiveProjectSelectors();
        if (!requiredSelectors.isEmpty() || !optionalSelectors.isEmpty()) {
            HashSet<MavenProject> selectedProjects = new HashSet<MavenProject>(requiredSelectors.size() + optionalSelectors.size());
            selectedProjects.addAll(this.projectSelector.getRequiredProjectsBySelectors(request, allSortedProjects, requiredSelectors));
            selectedProjects.addAll(this.projectSelector.getOptionalProjectsBySelectors(request, allSortedProjects, optionalSelectors));
            if (!selectedProjects.isEmpty()) {
                result = new ArrayList<MavenProject>(selectedProjects);
                result = this.includeAlsoMakeTransitively(result, request, graph);
                List<MavenProject> sortedProjects = graph.getSortedProjects();
                result.sort(Comparator.comparing(sortedProjects::indexOf));
            }
        }
        return result;
    }

    private List<MavenProject> trimResumedProjects(List<MavenProject> projects, ProjectDependencyGraph graph, MavenExecutionRequest request) throws MavenExecutionException {
        List<MavenProject> result = projects;
        if (StringUtils.isNotEmpty((String)request.getResumeFrom())) {
            File reactorDirectory = this.projectSelector.getBaseDirectoryFromRequest(request);
            String selector = request.getResumeFrom();
            MavenProject resumingFromProject = projects.stream().filter(project -> this.projectSelector.isMatchingProject((MavenProject)project, selector, reactorDirectory)).findFirst().orElseThrow(() -> new MavenExecutionException("Could not find project to resume reactor build from: " + selector + " vs " + this.formatProjects(projects), request.getPom()));
            int resumeFromProjectIndex = projects.indexOf(resumingFromProject);
            List<MavenProject> retainingProjects = result.subList(resumeFromProjectIndex, projects.size());
            result = this.includeAlsoMakeTransitively(retainingProjects, request, graph);
        }
        return result;
    }

    private List<MavenProject> trimExcludedProjects(List<MavenProject> projects, ProjectDependencyGraph graph, MavenExecutionRequest request) throws MavenExecutionException {
        List<MavenProject> result = projects;
        ProjectActivation projectActivation = request.getProjectActivation();
        Set<String> requiredSelectors = projectActivation.getRequiredInactiveProjectSelectors();
        Set<String> optionalSelectors = projectActivation.getOptionalInactiveProjectSelectors();
        if (!requiredSelectors.isEmpty() || !optionalSelectors.isEmpty()) {
            HashSet<MavenProject> excludedProjects = new HashSet<MavenProject>(requiredSelectors.size() + optionalSelectors.size());
            List<MavenProject> allProjects = graph.getAllProjects();
            excludedProjects.addAll(this.projectSelector.getRequiredProjectsBySelectors(request, allProjects, requiredSelectors));
            excludedProjects.addAll(this.projectSelector.getOptionalProjectsBySelectors(request, allProjects, optionalSelectors));
            result = new ArrayList<MavenProject>(projects);
            result.removeAll(excludedProjects);
            if (result.isEmpty()) {
                boolean isPlural = excludedProjects.size() > 1;
                String message = String.format("The project exclusion%s in --projects/-pl resulted in an empty reactor, please correct %s.", isPlural ? "s" : "", isPlural ? "them" : "it");
                throw new MavenExecutionException(message, request.getPom());
            }
        }
        return result;
    }

    private List<MavenProject> includeAlsoMakeTransitively(List<MavenProject> projects, MavenExecutionRequest request, ProjectDependencyGraph graph) throws MavenExecutionException {
        boolean makeDownstream;
        List<MavenProject> result = projects;
        String makeBehavior = request.getMakeBehavior();
        boolean makeBoth = "make-both".equals(makeBehavior);
        boolean makeUpstream = makeBoth || "make-upstream".equals(makeBehavior);
        boolean bl = makeDownstream = makeBoth || "make-downstream".equals(makeBehavior);
        if (StringUtils.isNotEmpty((String)makeBehavior) && !makeUpstream && !makeDownstream) {
            throw new MavenExecutionException("Invalid reactor make behavior: " + makeBehavior, request.getPom());
        }
        if (makeUpstream || makeDownstream) {
            HashSet<MavenProject> projectsSet = new HashSet<MavenProject>(projects);
            for (MavenProject project : projects) {
                if (makeUpstream) {
                    projectsSet.addAll(graph.getUpstreamProjects(project, true));
                }
                if (!makeDownstream) continue;
                projectsSet.addAll(graph.getDownstreamProjects(project, true));
            }
            result = new ArrayList<MavenProject>(projectsSet);
            List<MavenProject> sortedProjects = graph.getSortedProjects();
            result.sort(Comparator.comparing(sortedProjects::indexOf));
        }
        return result;
    }

    private void enrichRequestFromResumptionData(List<MavenProject> projects, MavenExecutionRequest request) {
        if (request.isResume()) {
            projects.stream().filter(MavenProject::isExecutionRoot).findFirst().ifPresent(rootProject -> this.buildResumptionDataRepository.applyResumptionData(request, (MavenProject)rootProject));
        }
    }

    private List<MavenProject> getProjectsInRequestScope(MavenExecutionRequest request, List<MavenProject> projects) throws MavenExecutionException {
        if (request.getPom() == null) {
            return projects;
        }
        MavenProject requestPomProject = projects.stream().filter(project -> request.getPom().equals(project.getFile())).findFirst().orElseThrow(() -> new MavenExecutionException("Could not find a project in reactor matching the request POM", request.getPom()));
        List<Object> modules = requestPomProject.getCollectedProjects() != null ? requestPomProject.getCollectedProjects() : Collections.emptyList();
        ArrayList<MavenProject> result = new ArrayList<MavenProject>(modules);
        result.add(requestPomProject);
        return result;
    }

    private String formatProjects(List<MavenProject> projects) {
        StringBuilder projectNames = new StringBuilder();
        Iterator<MavenProject> iterator = projects.iterator();
        while (iterator.hasNext()) {
            MavenProject project = iterator.next();
            projectNames.append(project.getGroupId()).append(":").append(project.getArtifactId());
            if (!iterator.hasNext()) continue;
            projectNames.append(", ");
        }
        return projectNames.toString();
    }

    private List<MavenProject> getProjectsForMavenReactor(MavenSession session) throws ProjectBuildingException {
        List<MavenProject> projects;
        MavenExecutionRequest request = session.getRequest();
        request.getProjectBuildingRequest().setRepositorySession(session.getRepositorySession());
        if (request.getPom() == null) {
            return this.pomlessCollectionStrategy.collectProjects(request);
        }
        if (!(request.getMakeBehavior() == null && request.getProjectActivation().isEmpty() || (projects = this.multiModuleCollectionStrategy.collectProjects(request)).isEmpty())) {
            return projects;
        }
        return this.requestPomCollectionStrategy.collectProjects(request);
    }

    private void validateProjects(List<MavenProject> projects, MavenExecutionRequest request) throws MavenExecutionException {
        HashMap<String, MavenProject> projectsMap = new HashMap<String, MavenProject>();
        List<MavenProject> projectsInRequestScope = this.getProjectsInRequestScope(request, projects);
        for (MavenProject p : projectsInRequestScope) {
            String projectKey = ArtifactUtils.key((String)p.getGroupId(), (String)p.getArtifactId(), (String)p.getVersion());
            projectsMap.put(projectKey, p);
        }
        for (MavenProject project : projects) {
            for (Plugin plugin : project.getBuildPlugins()) {
                String pluginKey;
                if (!plugin.isExtensions() || !projectsMap.containsKey(pluginKey = ArtifactUtils.key((String)plugin.getGroupId(), (String)plugin.getArtifactId(), (String)plugin.getVersion()))) continue;
                LOGGER.warn("'{}' uses '{}' as extension which is not possible within the same reactor build. This plugin was pulled from the local repository!", (Object)project.getName(), (Object)plugin.getKey());
            }
        }
    }
}

