/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.settings.v4;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Set;
import org.apache.maven.api.annotations.Generated;
import org.apache.maven.api.settings.Activation;
import org.apache.maven.api.settings.ActivationFile;
import org.apache.maven.api.settings.ActivationOS;
import org.apache.maven.api.settings.ActivationProperty;
import org.apache.maven.api.settings.IdentifiableBase;
import org.apache.maven.api.settings.Mirror;
import org.apache.maven.api.settings.Profile;
import org.apache.maven.api.settings.Proxy;
import org.apache.maven.api.settings.Repository;
import org.apache.maven.api.settings.RepositoryBase;
import org.apache.maven.api.settings.RepositoryPolicy;
import org.apache.maven.api.settings.Server;
import org.apache.maven.api.settings.Settings;
import org.apache.maven.api.settings.TrackableBase;
import org.apache.maven.api.xml.XmlNode;
import org.apache.maven.internal.xml.XmlNodeBuilder;
import org.codehaus.plexus.util.ReaderFactory;
import org.codehaus.plexus.util.xml.pull.EntityReplacementMap;
import org.codehaus.plexus.util.xml.pull.MXParser;
import org.codehaus.plexus.util.xml.pull.XmlPullParser;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;

@Generated
public class SettingsXpp3Reader {
    private boolean addDefaultEntities = true;
    private final ContentTransformer contentTransformer;

    public SettingsXpp3Reader() {
        this((s, f) -> s);
    }

    public SettingsXpp3Reader(ContentTransformer contentTransformer) {
        this.contentTransformer = contentTransformer;
    }

    private boolean checkFieldWithDuplicate(XmlPullParser parser, String tagName, String alias, Set<String> parsed) throws XmlPullParserException {
        if (!parser.getName().equals(tagName) && !parser.getName().equals(alias)) {
            return false;
        }
        if (!parsed.add(tagName)) {
            throw new XmlPullParserException("Duplicated tag: '" + tagName + "'", parser, null);
        }
        return true;
    }

    private void checkUnknownAttribute(XmlPullParser parser, String attribute, String tagName, boolean strict) throws XmlPullParserException, IOException {
        if (strict) {
            throw new XmlPullParserException("Unknown attribute '" + attribute + "' for tag '" + tagName + "'", parser, null);
        }
    }

    private void checkUnknownElement(XmlPullParser parser, boolean strict) throws XmlPullParserException, IOException {
        if (strict) {
            throw new XmlPullParserException("Unrecognised tag: '" + parser.getName() + "'", parser, null);
        }
        int unrecognizedTagCount = 1;
        while (unrecognizedTagCount > 0) {
            int eventType = parser.next();
            if (eventType == 2) {
                ++unrecognizedTagCount;
                continue;
            }
            if (eventType != 3) continue;
            --unrecognizedTagCount;
        }
    }

    public boolean getAddDefaultEntities() {
        return this.addDefaultEntities;
    }

    private boolean getBooleanValue(String s, String attribute, XmlPullParser parser) throws XmlPullParserException {
        return this.getBooleanValue(s, attribute, parser, null);
    }

    private boolean getBooleanValue(String s, String attribute, XmlPullParser parser, String defaultValue) throws XmlPullParserException {
        if (s != null && s.length() != 0) {
            return Boolean.valueOf(s);
        }
        if (defaultValue != null) {
            return Boolean.valueOf(defaultValue);
        }
        return false;
    }

    private byte getByteValue(String s, String attribute, XmlPullParser parser, boolean strict) throws XmlPullParserException {
        block3: {
            if (s != null) {
                try {
                    return Byte.valueOf(s);
                }
                catch (NumberFormatException nfe) {
                    if (!strict) break block3;
                    throw new XmlPullParserException("Unable to parse element '" + attribute + "', must be a byte", parser, (Throwable)nfe);
                }
            }
        }
        return 0;
    }

    private char getCharacterValue(String s, String attribute, XmlPullParser parser) throws XmlPullParserException {
        if (s != null) {
            return s.charAt(0);
        }
        return '\u0000';
    }

    private Date getDateValue(String s, String attribute, XmlPullParser parser) throws XmlPullParserException {
        return this.getDateValue(s, attribute, null, parser);
    }

    private Date getDateValue(String s, String attribute, String dateFormat, XmlPullParser parser) throws XmlPullParserException {
        if (s != null) {
            String effectiveDateFormat = dateFormat;
            if (dateFormat == null) {
                effectiveDateFormat = "yyyy-MM-dd'T'HH:mm:ss.SSS";
            }
            if ("long".equals(effectiveDateFormat)) {
                try {
                    return new Date(Long.parseLong(s));
                }
                catch (NumberFormatException e) {
                    throw new XmlPullParserException(e.getMessage(), parser, (Throwable)e);
                }
            }
            try {
                SimpleDateFormat dateParser = new SimpleDateFormat(effectiveDateFormat, Locale.US);
                return dateParser.parse(s);
            }
            catch (ParseException e) {
                throw new XmlPullParserException(e.getMessage(), parser, (Throwable)e);
            }
        }
        return null;
    }

    private double getDoubleValue(String s, String attribute, XmlPullParser parser, boolean strict) throws XmlPullParserException {
        block3: {
            if (s != null) {
                try {
                    return Double.valueOf(s);
                }
                catch (NumberFormatException nfe) {
                    if (!strict) break block3;
                    throw new XmlPullParserException("Unable to parse element '" + attribute + "', must be a floating point number", parser, (Throwable)nfe);
                }
            }
        }
        return 0.0;
    }

    private float getFloatValue(String s, String attribute, XmlPullParser parser, boolean strict) throws XmlPullParserException {
        block3: {
            if (s != null) {
                try {
                    return Float.valueOf(s).floatValue();
                }
                catch (NumberFormatException nfe) {
                    if (!strict) break block3;
                    throw new XmlPullParserException("Unable to parse element '" + attribute + "', must be a floating point number", parser, (Throwable)nfe);
                }
            }
        }
        return 0.0f;
    }

    private int getIntegerValue(String s, String attribute, XmlPullParser parser, boolean strict) throws XmlPullParserException {
        return this.getIntegerValue(s, attribute, parser, strict, 0);
    }

    private int getIntegerValue(String s, String attribute, XmlPullParser parser, boolean strict, int defaultValue) throws XmlPullParserException {
        block3: {
            if (s != null) {
                try {
                    return Integer.valueOf(s);
                }
                catch (NumberFormatException nfe) {
                    if (!strict) break block3;
                    throw new XmlPullParserException("Unable to parse element '" + attribute + "', must be an integer", parser, (Throwable)nfe);
                }
            }
        }
        return defaultValue;
    }

    private long getLongValue(String s, String attribute, XmlPullParser parser, boolean strict) throws XmlPullParserException {
        block3: {
            if (s != null) {
                try {
                    return Long.valueOf(s);
                }
                catch (NumberFormatException nfe) {
                    if (!strict) break block3;
                    throw new XmlPullParserException("Unable to parse element '" + attribute + "', must be a long integer", parser, (Throwable)nfe);
                }
            }
        }
        return 0L;
    }

    private String getRequiredAttributeValue(String s, String attribute, XmlPullParser parser, boolean strict) throws XmlPullParserException {
        if (s == null && strict) {
            throw new XmlPullParserException("Missing required value for attribute '" + attribute + "'", parser, null);
        }
        return s;
    }

    private short getShortValue(String s, String attribute, XmlPullParser parser, boolean strict) throws XmlPullParserException {
        block3: {
            if (s != null) {
                try {
                    return Short.valueOf(s);
                }
                catch (NumberFormatException nfe) {
                    if (!strict) break block3;
                    throw new XmlPullParserException("Unable to parse element '" + attribute + "', must be a short integer", parser, (Throwable)nfe);
                }
            }
        }
        return 0;
    }

    private String getTrimmedValue(String s) {
        if (s != null) {
            s = s.trim();
        }
        return s;
    }

    private String interpolatedTrimmed(String value, String context) {
        return this.getTrimmedValue(this.contentTransformer.transform(value, context));
    }

    private int nextTag(XmlPullParser parser) throws IOException, XmlPullParserException {
        int eventType = parser.next();
        if (eventType == 4) {
            eventType = parser.next();
        }
        if (eventType != 2 && eventType != 3) {
            throw new XmlPullParserException("expected START_TAG or END_TAG not " + XmlPullParser.TYPES[eventType], parser, null);
        }
        return eventType;
    }

    public Settings read(Reader reader, boolean strict) throws IOException, XmlPullParserException {
        MXParser parser = this.addDefaultEntities ? new MXParser(EntityReplacementMap.defaultEntityReplacementMap) : new MXParser();
        parser.setInput(reader);
        return this.read((XmlPullParser)parser, strict);
    }

    public Settings read(Reader reader) throws IOException, XmlPullParserException {
        return this.read(reader, true);
    }

    public Settings read(InputStream in, boolean strict) throws IOException, XmlPullParserException {
        return this.read((Reader)ReaderFactory.newXmlReader((InputStream)in), strict);
    }

    public Settings read(InputStream in) throws IOException, XmlPullParserException {
        return this.read((Reader)ReaderFactory.newXmlReader((InputStream)in));
    }

    public Settings read(XmlPullParser parser, boolean strict) throws IOException, XmlPullParserException {
        Settings settings = null;
        int eventType = parser.getEventType();
        boolean parsed = false;
        while (eventType != 1) {
            if (eventType == 2) {
                if (strict && !"settings".equals(parser.getName())) {
                    throw new XmlPullParserException("Expected root element 'settings' but found '" + parser.getName() + "'", parser, null);
                }
                if (parsed) {
                    throw new XmlPullParserException("Duplicated tag: 'settings'", parser, null);
                }
                settings = this.parseSettings(parser, strict);
                parsed = true;
            }
            eventType = parser.next();
        }
        if (parsed) {
            return settings;
        }
        throw new XmlPullParserException("Expected root element 'settings' but found no element at all: invalid XML document", parser, null);
    }

    private TrackableBase parseTrackableBase(XmlPullParser parser, boolean strict) throws IOException, XmlPullParserException {
        String tagName = parser.getName();
        TrackableBase.Builder trackableBase = TrackableBase.newBuilder((boolean)true);
        for (int i = parser.getAttributeCount() - 1; i >= 0; --i) {
            String name = parser.getAttributeName(i);
            String value = parser.getAttributeValue(i);
            if (name.indexOf(58) >= 0) continue;
            this.checkUnknownAttribute(parser, name, tagName, strict);
        }
        HashSet<String> parsed = new HashSet<String>();
        while ((strict ? parser.nextTag() : this.nextTag(parser)) == 2) {
            String childName;
            switch (childName = this.checkDuplicate(parser.getName(), parser, parsed)) {
                default: 
            }
            this.checkUnknownElement(parser, strict);
        }
        return trackableBase.build();
    }

    private IdentifiableBase parseIdentifiableBase(XmlPullParser parser, boolean strict) throws IOException, XmlPullParserException {
        String tagName = parser.getName();
        IdentifiableBase.Builder identifiableBase = IdentifiableBase.newBuilder((boolean)true);
        for (int i = parser.getAttributeCount() - 1; i >= 0; --i) {
            String name = parser.getAttributeName(i);
            String value = parser.getAttributeValue(i);
            if (name.indexOf(58) >= 0) continue;
            this.checkUnknownAttribute(parser, name, tagName, strict);
        }
        HashSet<String> parsed = new HashSet<String>();
        block7: while ((strict ? parser.nextTag() : this.nextTag(parser)) == 2) {
            String childName;
            switch (childName = this.checkDuplicate(parser.getName(), parser, parsed)) {
                case "id": {
                    identifiableBase.id(this.interpolatedTrimmed(parser.nextText(), "id"));
                    continue block7;
                }
            }
            this.checkUnknownElement(parser, strict);
        }
        return identifiableBase.build();
    }

    private Settings parseSettings(XmlPullParser parser, boolean strict) throws IOException, XmlPullParserException {
        String tagName = parser.getName();
        Settings.Builder settings = Settings.newBuilder((boolean)true);
        for (int i = parser.getAttributeCount() - 1; i >= 0; --i) {
            String name = parser.getAttributeName(i);
            String value = parser.getAttributeValue(i);
            if (name.indexOf(58) >= 0 || "xmlns".equals(name)) continue;
            this.checkUnknownAttribute(parser, name, tagName, strict);
        }
        HashSet<String> parsed = new HashSet<String>();
        block25: while ((strict ? parser.nextTag() : this.nextTag(parser)) == 2) {
            String childName;
            switch (childName = this.checkDuplicate(parser.getName(), parser, parsed)) {
                case "localRepository": {
                    settings.localRepository(this.interpolatedTrimmed(parser.nextText(), "localRepository"));
                    continue block25;
                }
                case "interactiveMode": {
                    settings.interactiveMode(this.getBooleanValue(this.interpolatedTrimmed(parser.nextText(), "interactiveMode"), "interactiveMode", parser, "true"));
                    continue block25;
                }
                case "usePluginRegistry": {
                    settings.usePluginRegistry(this.getBooleanValue(this.interpolatedTrimmed(parser.nextText(), "usePluginRegistry"), "usePluginRegistry", parser, "false"));
                    continue block25;
                }
                case "offline": {
                    settings.offline(this.getBooleanValue(this.interpolatedTrimmed(parser.nextText(), "offline"), "offline", parser, "false"));
                    continue block25;
                }
                case "proxies": {
                    ArrayList<Proxy> proxies = new ArrayList<Proxy>();
                    while (parser.nextTag() == 2) {
                        if ("proxy".equals(parser.getName())) {
                            proxies.add(this.parseProxy(parser, strict));
                            continue;
                        }
                        this.checkUnknownElement(parser, strict);
                    }
                    settings.proxies(proxies);
                    continue block25;
                }
                case "servers": {
                    ArrayList<Server> servers = new ArrayList<Server>();
                    while (parser.nextTag() == 2) {
                        if ("server".equals(parser.getName())) {
                            servers.add(this.parseServer(parser, strict));
                            continue;
                        }
                        this.checkUnknownElement(parser, strict);
                    }
                    settings.servers(servers);
                    continue block25;
                }
                case "mirrors": {
                    ArrayList<Mirror> mirrors = new ArrayList<Mirror>();
                    while (parser.nextTag() == 2) {
                        if ("mirror".equals(parser.getName())) {
                            mirrors.add(this.parseMirror(parser, strict));
                            continue;
                        }
                        this.checkUnknownElement(parser, strict);
                    }
                    settings.mirrors(mirrors);
                    continue block25;
                }
                case "profiles": {
                    ArrayList<Profile> profiles = new ArrayList<Profile>();
                    while (parser.nextTag() == 2) {
                        if ("profile".equals(parser.getName())) {
                            profiles.add(this.parseProfile(parser, strict));
                            continue;
                        }
                        this.checkUnknownElement(parser, strict);
                    }
                    settings.profiles(profiles);
                    continue block25;
                }
                case "activeProfiles": {
                    ArrayList<String> activeProfiles = new ArrayList<String>();
                    while (parser.nextTag() == 2) {
                        if ("activeProfile".equals(parser.getName())) {
                            activeProfiles.add(this.interpolatedTrimmed(parser.nextText(), "activeProfiles"));
                            continue;
                        }
                        this.checkUnknownElement(parser, strict);
                    }
                    settings.activeProfiles(activeProfiles);
                    continue block25;
                }
                case "pluginGroups": {
                    ArrayList<String> pluginGroups = new ArrayList<String>();
                    while (parser.nextTag() == 2) {
                        if ("pluginGroup".equals(parser.getName())) {
                            pluginGroups.add(this.interpolatedTrimmed(parser.nextText(), "pluginGroups"));
                            continue;
                        }
                        this.checkUnknownElement(parser, strict);
                    }
                    settings.pluginGroups(pluginGroups);
                    continue block25;
                }
            }
            this.checkUnknownElement(parser, strict);
        }
        settings.modelEncoding(parser.getInputEncoding());
        return settings.build();
    }

    private Proxy parseProxy(XmlPullParser parser, boolean strict) throws IOException, XmlPullParserException {
        String tagName = parser.getName();
        Proxy.Builder proxy = Proxy.newBuilder((boolean)true);
        for (int i = parser.getAttributeCount() - 1; i >= 0; --i) {
            String name = parser.getAttributeName(i);
            String value = parser.getAttributeValue(i);
            if (name.indexOf(58) >= 0) continue;
            this.checkUnknownAttribute(parser, name, tagName, strict);
        }
        HashSet<String> parsed = new HashSet<String>();
        block21: while ((strict ? parser.nextTag() : this.nextTag(parser)) == 2) {
            String childName;
            switch (childName = this.checkDuplicate(parser.getName(), parser, parsed)) {
                case "id": {
                    proxy.id(this.interpolatedTrimmed(parser.nextText(), "id"));
                    continue block21;
                }
                case "active": {
                    proxy.active(this.getBooleanValue(this.interpolatedTrimmed(parser.nextText(), "active"), "active", parser, "true"));
                    continue block21;
                }
                case "protocol": {
                    proxy.protocol(this.interpolatedTrimmed(parser.nextText(), "protocol"));
                    continue block21;
                }
                case "username": {
                    proxy.username(this.interpolatedTrimmed(parser.nextText(), "username"));
                    continue block21;
                }
                case "password": {
                    proxy.password(this.interpolatedTrimmed(parser.nextText(), "password"));
                    continue block21;
                }
                case "port": {
                    proxy.port(this.getIntegerValue(this.interpolatedTrimmed(parser.nextText(), "port"), "port", parser, strict, 8080));
                    continue block21;
                }
                case "host": {
                    proxy.host(this.interpolatedTrimmed(parser.nextText(), "host"));
                    continue block21;
                }
                case "nonProxyHosts": {
                    proxy.nonProxyHosts(this.interpolatedTrimmed(parser.nextText(), "nonProxyHosts"));
                    continue block21;
                }
            }
            this.checkUnknownElement(parser, strict);
        }
        return proxy.build();
    }

    private Server parseServer(XmlPullParser parser, boolean strict) throws IOException, XmlPullParserException {
        String tagName = parser.getName();
        Server.Builder server = Server.newBuilder((boolean)true);
        for (int i = parser.getAttributeCount() - 1; i >= 0; --i) {
            String name = parser.getAttributeName(i);
            String value = parser.getAttributeValue(i);
            if (name.indexOf(58) >= 0) continue;
            this.checkUnknownAttribute(parser, name, tagName, strict);
        }
        HashSet<String> parsed = new HashSet<String>();
        block21: while ((strict ? parser.nextTag() : this.nextTag(parser)) == 2) {
            String childName;
            switch (childName = this.checkDuplicate(parser.getName(), parser, parsed)) {
                case "id": {
                    server.id(this.interpolatedTrimmed(parser.nextText(), "id"));
                    continue block21;
                }
                case "username": {
                    server.username(this.interpolatedTrimmed(parser.nextText(), "username"));
                    continue block21;
                }
                case "password": {
                    server.password(this.interpolatedTrimmed(parser.nextText(), "password"));
                    continue block21;
                }
                case "privateKey": {
                    server.privateKey(this.interpolatedTrimmed(parser.nextText(), "privateKey"));
                    continue block21;
                }
                case "passphrase": {
                    server.passphrase(this.interpolatedTrimmed(parser.nextText(), "passphrase"));
                    continue block21;
                }
                case "filePermissions": {
                    server.filePermissions(this.interpolatedTrimmed(parser.nextText(), "filePermissions"));
                    continue block21;
                }
                case "directoryPermissions": {
                    server.directoryPermissions(this.interpolatedTrimmed(parser.nextText(), "directoryPermissions"));
                    continue block21;
                }
                case "configuration": {
                    server.configuration((XmlNode)XmlNodeBuilder.build((XmlPullParser)parser, (boolean)true));
                    continue block21;
                }
            }
            this.checkUnknownElement(parser, strict);
        }
        return server.build();
    }

    private Mirror parseMirror(XmlPullParser parser, boolean strict) throws IOException, XmlPullParserException {
        String tagName = parser.getName();
        Mirror.Builder mirror = Mirror.newBuilder((boolean)true);
        for (int i = parser.getAttributeCount() - 1; i >= 0; --i) {
            String name = parser.getAttributeName(i);
            String value = parser.getAttributeValue(i);
            if (name.indexOf(58) >= 0) continue;
            this.checkUnknownAttribute(parser, name, tagName, strict);
        }
        HashSet<String> parsed = new HashSet<String>();
        block19: while ((strict ? parser.nextTag() : this.nextTag(parser)) == 2) {
            String childName;
            switch (childName = this.checkDuplicate(parser.getName(), parser, parsed)) {
                case "id": {
                    mirror.id(this.interpolatedTrimmed(parser.nextText(), "id"));
                    continue block19;
                }
                case "mirrorOf": {
                    mirror.mirrorOf(this.interpolatedTrimmed(parser.nextText(), "mirrorOf"));
                    continue block19;
                }
                case "name": {
                    mirror.name(this.interpolatedTrimmed(parser.nextText(), "name"));
                    continue block19;
                }
                case "url": {
                    mirror.url(this.interpolatedTrimmed(parser.nextText(), "url"));
                    continue block19;
                }
                case "layout": {
                    mirror.layout(this.interpolatedTrimmed(parser.nextText(), "layout"));
                    continue block19;
                }
                case "mirrorOfLayouts": {
                    mirror.mirrorOfLayouts(this.interpolatedTrimmed(parser.nextText(), "mirrorOfLayouts"));
                    continue block19;
                }
                case "blocked": {
                    mirror.blocked(this.getBooleanValue(this.interpolatedTrimmed(parser.nextText(), "blocked"), "blocked", parser, "false"));
                    continue block19;
                }
            }
            this.checkUnknownElement(parser, strict);
        }
        return mirror.build();
    }

    private Profile parseProfile(XmlPullParser parser, boolean strict) throws IOException, XmlPullParserException {
        String tagName = parser.getName();
        Profile.Builder profile = Profile.newBuilder((boolean)true);
        for (int i = parser.getAttributeCount() - 1; i >= 0; --i) {
            String name = parser.getAttributeName(i);
            String value = parser.getAttributeValue(i);
            if (name.indexOf(58) >= 0) continue;
            this.checkUnknownAttribute(parser, name, tagName, strict);
        }
        HashSet<String> parsed = new HashSet<String>();
        block15: while ((strict ? parser.nextTag() : this.nextTag(parser)) == 2) {
            String childName;
            switch (childName = this.checkDuplicate(parser.getName(), parser, parsed)) {
                case "id": {
                    profile.id(this.interpolatedTrimmed(parser.nextText(), "id"));
                    continue block15;
                }
                case "activation": {
                    profile.activation(this.parseActivation(parser, strict));
                    continue block15;
                }
                case "properties": {
                    LinkedHashMap<String, String> properties = new LinkedHashMap<String, String>();
                    while (parser.nextTag() == 2) {
                        String key = parser.getName();
                        String value = parser.nextText().trim();
                        properties.put(key, value);
                    }
                    profile.properties(properties);
                    continue block15;
                }
                case "repositories": {
                    ArrayList<Repository> repositories = new ArrayList<Repository>();
                    while (parser.nextTag() == 2) {
                        if ("repository".equals(parser.getName())) {
                            repositories.add(this.parseRepository(parser, strict));
                            continue;
                        }
                        this.checkUnknownElement(parser, strict);
                    }
                    profile.repositories(repositories);
                    continue block15;
                }
                case "pluginRepositories": {
                    ArrayList<Repository> pluginRepositories = new ArrayList<Repository>();
                    while (parser.nextTag() == 2) {
                        if ("pluginRepository".equals(parser.getName())) {
                            pluginRepositories.add(this.parseRepository(parser, strict));
                            continue;
                        }
                        this.checkUnknownElement(parser, strict);
                    }
                    profile.pluginRepositories(pluginRepositories);
                    continue block15;
                }
            }
            this.checkUnknownElement(parser, strict);
        }
        return profile.build();
    }

    private Activation parseActivation(XmlPullParser parser, boolean strict) throws IOException, XmlPullParserException {
        String tagName = parser.getName();
        Activation.Builder activation = Activation.newBuilder((boolean)true);
        for (int i = parser.getAttributeCount() - 1; i >= 0; --i) {
            String name = parser.getAttributeName(i);
            String value = parser.getAttributeValue(i);
            if (name.indexOf(58) >= 0) continue;
            this.checkUnknownAttribute(parser, name, tagName, strict);
        }
        HashSet<String> parsed = new HashSet<String>();
        block15: while ((strict ? parser.nextTag() : this.nextTag(parser)) == 2) {
            String childName;
            switch (childName = this.checkDuplicate(parser.getName(), parser, parsed)) {
                case "activeByDefault": {
                    activation.activeByDefault(this.getBooleanValue(this.interpolatedTrimmed(parser.nextText(), "activeByDefault"), "activeByDefault", parser, "false"));
                    continue block15;
                }
                case "jdk": {
                    activation.jdk(this.interpolatedTrimmed(parser.nextText(), "jdk"));
                    continue block15;
                }
                case "os": {
                    activation.os(this.parseActivationOS(parser, strict));
                    continue block15;
                }
                case "property": {
                    activation.property(this.parseActivationProperty(parser, strict));
                    continue block15;
                }
                case "file": {
                    activation.file(this.parseActivationFile(parser, strict));
                    continue block15;
                }
            }
            this.checkUnknownElement(parser, strict);
        }
        return activation.build();
    }

    private RepositoryBase parseRepositoryBase(XmlPullParser parser, boolean strict) throws IOException, XmlPullParserException {
        String tagName = parser.getName();
        RepositoryBase.Builder repositoryBase = RepositoryBase.newBuilder((boolean)true);
        for (int i = parser.getAttributeCount() - 1; i >= 0; --i) {
            String name = parser.getAttributeName(i);
            String value = parser.getAttributeValue(i);
            if (name.indexOf(58) >= 0) continue;
            this.checkUnknownAttribute(parser, name, tagName, strict);
        }
        HashSet<String> parsed = new HashSet<String>();
        block13: while ((strict ? parser.nextTag() : this.nextTag(parser)) == 2) {
            String childName;
            switch (childName = this.checkDuplicate(parser.getName(), parser, parsed)) {
                case "id": {
                    repositoryBase.id(this.interpolatedTrimmed(parser.nextText(), "id"));
                    continue block13;
                }
                case "name": {
                    repositoryBase.name(this.interpolatedTrimmed(parser.nextText(), "name"));
                    continue block13;
                }
                case "url": {
                    repositoryBase.url(this.interpolatedTrimmed(parser.nextText(), "url"));
                    continue block13;
                }
                case "layout": {
                    repositoryBase.layout(this.interpolatedTrimmed(parser.nextText(), "layout"));
                    continue block13;
                }
            }
            this.checkUnknownElement(parser, strict);
        }
        return repositoryBase.build();
    }

    private Repository parseRepository(XmlPullParser parser, boolean strict) throws IOException, XmlPullParserException {
        String tagName = parser.getName();
        Repository.Builder repository = Repository.newBuilder((boolean)true);
        for (int i = parser.getAttributeCount() - 1; i >= 0; --i) {
            String name = parser.getAttributeName(i);
            String value = parser.getAttributeValue(i);
            if (name.indexOf(58) >= 0) continue;
            this.checkUnknownAttribute(parser, name, tagName, strict);
        }
        HashSet<String> parsed = new HashSet<String>();
        block17: while ((strict ? parser.nextTag() : this.nextTag(parser)) == 2) {
            String childName;
            switch (childName = this.checkDuplicate(parser.getName(), parser, parsed)) {
                case "id": {
                    repository.id(this.interpolatedTrimmed(parser.nextText(), "id"));
                    continue block17;
                }
                case "name": {
                    repository.name(this.interpolatedTrimmed(parser.nextText(), "name"));
                    continue block17;
                }
                case "url": {
                    repository.url(this.interpolatedTrimmed(parser.nextText(), "url"));
                    continue block17;
                }
                case "layout": {
                    repository.layout(this.interpolatedTrimmed(parser.nextText(), "layout"));
                    continue block17;
                }
                case "releases": {
                    repository.releases(this.parseRepositoryPolicy(parser, strict));
                    continue block17;
                }
                case "snapshots": {
                    repository.snapshots(this.parseRepositoryPolicy(parser, strict));
                    continue block17;
                }
            }
            this.checkUnknownElement(parser, strict);
        }
        return repository.build();
    }

    private RepositoryPolicy parseRepositoryPolicy(XmlPullParser parser, boolean strict) throws IOException, XmlPullParserException {
        String tagName = parser.getName();
        RepositoryPolicy.Builder repositoryPolicy = RepositoryPolicy.newBuilder((boolean)true);
        for (int i = parser.getAttributeCount() - 1; i >= 0; --i) {
            String name = parser.getAttributeName(i);
            String value = parser.getAttributeValue(i);
            if (name.indexOf(58) >= 0) continue;
            this.checkUnknownAttribute(parser, name, tagName, strict);
        }
        HashSet<String> parsed = new HashSet<String>();
        block11: while ((strict ? parser.nextTag() : this.nextTag(parser)) == 2) {
            String childName;
            switch (childName = this.checkDuplicate(parser.getName(), parser, parsed)) {
                case "enabled": {
                    repositoryPolicy.enabled(this.getBooleanValue(this.interpolatedTrimmed(parser.nextText(), "enabled"), "enabled", parser, "true"));
                    continue block11;
                }
                case "updatePolicy": {
                    repositoryPolicy.updatePolicy(this.interpolatedTrimmed(parser.nextText(), "updatePolicy"));
                    continue block11;
                }
                case "checksumPolicy": {
                    repositoryPolicy.checksumPolicy(this.interpolatedTrimmed(parser.nextText(), "checksumPolicy"));
                    continue block11;
                }
            }
            this.checkUnknownElement(parser, strict);
        }
        return repositoryPolicy.build();
    }

    private ActivationProperty parseActivationProperty(XmlPullParser parser, boolean strict) throws IOException, XmlPullParserException {
        String tagName = parser.getName();
        ActivationProperty.Builder activationProperty = ActivationProperty.newBuilder((boolean)true);
        for (int i = parser.getAttributeCount() - 1; i >= 0; --i) {
            String name = parser.getAttributeName(i);
            String value = parser.getAttributeValue(i);
            if (name.indexOf(58) >= 0) continue;
            this.checkUnknownAttribute(parser, name, tagName, strict);
        }
        HashSet<String> parsed = new HashSet<String>();
        block9: while ((strict ? parser.nextTag() : this.nextTag(parser)) == 2) {
            String childName;
            switch (childName = this.checkDuplicate(parser.getName(), parser, parsed)) {
                case "name": {
                    activationProperty.name(this.interpolatedTrimmed(parser.nextText(), "name"));
                    continue block9;
                }
                case "value": {
                    activationProperty.value(this.interpolatedTrimmed(parser.nextText(), "value"));
                    continue block9;
                }
            }
            this.checkUnknownElement(parser, strict);
        }
        return activationProperty.build();
    }

    private ActivationOS parseActivationOS(XmlPullParser parser, boolean strict) throws IOException, XmlPullParserException {
        String tagName = parser.getName();
        ActivationOS.Builder activationOS = ActivationOS.newBuilder((boolean)true);
        for (int i = parser.getAttributeCount() - 1; i >= 0; --i) {
            String name = parser.getAttributeName(i);
            String value = parser.getAttributeValue(i);
            if (name.indexOf(58) >= 0) continue;
            this.checkUnknownAttribute(parser, name, tagName, strict);
        }
        HashSet<String> parsed = new HashSet<String>();
        block13: while ((strict ? parser.nextTag() : this.nextTag(parser)) == 2) {
            String childName;
            switch (childName = this.checkDuplicate(parser.getName(), parser, parsed)) {
                case "name": {
                    activationOS.name(this.interpolatedTrimmed(parser.nextText(), "name"));
                    continue block13;
                }
                case "family": {
                    activationOS.family(this.interpolatedTrimmed(parser.nextText(), "family"));
                    continue block13;
                }
                case "arch": {
                    activationOS.arch(this.interpolatedTrimmed(parser.nextText(), "arch"));
                    continue block13;
                }
                case "version": {
                    activationOS.version(this.interpolatedTrimmed(parser.nextText(), "version"));
                    continue block13;
                }
            }
            this.checkUnknownElement(parser, strict);
        }
        return activationOS.build();
    }

    private ActivationFile parseActivationFile(XmlPullParser parser, boolean strict) throws IOException, XmlPullParserException {
        String tagName = parser.getName();
        ActivationFile.Builder activationFile = ActivationFile.newBuilder((boolean)true);
        for (int i = parser.getAttributeCount() - 1; i >= 0; --i) {
            String name = parser.getAttributeName(i);
            String value = parser.getAttributeValue(i);
            if (name.indexOf(58) >= 0) continue;
            this.checkUnknownAttribute(parser, name, tagName, strict);
        }
        HashSet<String> parsed = new HashSet<String>();
        block9: while ((strict ? parser.nextTag() : this.nextTag(parser)) == 2) {
            String childName;
            switch (childName = this.checkDuplicate(parser.getName(), parser, parsed)) {
                case "missing": {
                    activationFile.missing(this.interpolatedTrimmed(parser.nextText(), "missing"));
                    continue block9;
                }
                case "exists": {
                    activationFile.exists(this.interpolatedTrimmed(parser.nextText(), "exists"));
                    continue block9;
                }
            }
            this.checkUnknownElement(parser, strict);
        }
        return activationFile.build();
    }

    private String checkDuplicate(String tagName, XmlPullParser parser, Set<String> parsed) throws XmlPullParserException {
        return tagName;
    }

    public void setAddDefaultEntities(boolean addDefaultEntities) {
        this.addDefaultEntities = addDefaultEntities;
    }

    public static interface ContentTransformer {
        public String transform(String var1, String var2);
    }
}

