/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.api.services;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.apache.maven.api.ArtifactCoordinate;
import org.apache.maven.api.Dependency;
import org.apache.maven.api.Exclusion;
import org.apache.maven.api.Session;
import org.apache.maven.api.annotations.Experimental;
import org.apache.maven.api.annotations.Immutable;
import org.apache.maven.api.annotations.Nonnull;
import org.apache.maven.api.annotations.NotThreadSafe;
import org.apache.maven.api.services.ArtifactCoordinateFactoryRequest;
import org.apache.maven.api.services.BaseRequest;

@Experimental
@Immutable
public interface DependencyCoordinateFactoryRequest
extends ArtifactCoordinateFactoryRequest {
    public String getScope();

    public boolean isOptional();

    @Nonnull
    public Collection<Exclusion> getExclusions();

    @Nonnull
    public static DependencyCoordinateFactoryRequest build(@Nonnull Session session, String groupId, String artifactId, String version, String classifier, String extension, String type) {
        return DependencyCoordinateFactoryRequest.builder().session(BaseRequest.nonNull(session, "session cannot be null")).groupId(groupId).artifactId(artifactId).version(version).classifier(classifier).extension(extension).type(type).build();
    }

    @Nonnull
    public static DependencyCoordinateFactoryRequest build(@Nonnull Session session, @Nonnull ArtifactCoordinate coordinate) {
        return DependencyCoordinateFactoryRequest.builder().session(BaseRequest.nonNull(session, "session cannot be null")).groupId(BaseRequest.nonNull(coordinate, "coordinate cannot be null").getGroupId()).artifactId(coordinate.getArtifactId()).version(coordinate.getVersion().asString()).classifier(coordinate.getClassifier()).extension(coordinate.getExtension()).build();
    }

    @Nonnull
    public static DependencyCoordinateFactoryRequest build(@Nonnull Session session, @Nonnull Dependency dependency) {
        return DependencyCoordinateFactoryRequest.builder().session(BaseRequest.nonNull(session, "session cannot be null")).groupId(BaseRequest.nonNull(dependency, "dependency").getGroupId()).artifactId(dependency.getArtifactId()).version(dependency.getVersion().asString()).classifier(dependency.getClassifier()).extension(dependency.getExtension()).type(dependency.getType().getName()).scope(dependency.getScope().id()).optional(dependency.isOptional()).build();
    }

    @Nonnull
    public static DependencyCoordinateFactoryRequestBuilder builder() {
        return new DependencyCoordinateFactoryRequestBuilder();
    }

    @NotThreadSafe
    public static class DependencyCoordinateFactoryRequestBuilder {
        private Session session;
        private String groupId;
        private String artifactId;
        private String version;
        private String classifier;
        private String extension;
        private String type;
        private String scope;
        private boolean optional;
        private Collection<Exclusion> exclusions = Collections.emptyList();

        DependencyCoordinateFactoryRequestBuilder() {
        }

        public DependencyCoordinateFactoryRequestBuilder session(Session session) {
            this.session = session;
            return this;
        }

        public DependencyCoordinateFactoryRequestBuilder groupId(String groupId) {
            this.groupId = groupId;
            return this;
        }

        public DependencyCoordinateFactoryRequestBuilder artifactId(String artifactId) {
            this.artifactId = artifactId;
            return this;
        }

        public DependencyCoordinateFactoryRequestBuilder version(String version) {
            this.version = version;
            return this;
        }

        public DependencyCoordinateFactoryRequestBuilder classifier(String classifier) {
            this.classifier = classifier;
            return this;
        }

        public DependencyCoordinateFactoryRequestBuilder extension(String extension) {
            this.extension = extension;
            return this;
        }

        public DependencyCoordinateFactoryRequestBuilder type(String type) {
            this.type = type;
            return this;
        }

        public DependencyCoordinateFactoryRequestBuilder scope(String scope) {
            this.scope = scope;
            return this;
        }

        public DependencyCoordinateFactoryRequestBuilder optional(boolean optional) {
            this.optional = optional;
            return this;
        }

        public DependencyCoordinateFactoryRequestBuilder exclusions(Collection<Exclusion> exclusions) {
            if (exclusions != null) {
                if (this.exclusions.isEmpty()) {
                    this.exclusions = new ArrayList<Exclusion>();
                }
                this.exclusions.addAll(exclusions);
            }
            return this;
        }

        public DependencyCoordinateFactoryRequestBuilder exclusion(Exclusion exclusion) {
            if (exclusion != null) {
                if (this.exclusions.isEmpty()) {
                    this.exclusions = new ArrayList<Exclusion>();
                }
                this.exclusions.add(exclusion);
            }
            return this;
        }

        public DependencyCoordinateFactoryRequest build() {
            return new DefaultDependencyCoordinateFactoryRequest(this.session, this.groupId, this.artifactId, this.version, this.classifier, this.extension, this.type, this.scope, this.optional, this.exclusions);
        }

        private static class DefaultDependencyCoordinateFactoryRequest
        extends BaseRequest
        implements DependencyCoordinateFactoryRequest {
            private final String groupId;
            private final String artifactId;
            private final String version;
            private final String classifier;
            private final String extension;
            private final String type;
            private final String scope;
            private final boolean optional;
            private final Collection<Exclusion> exclusions;

            private DefaultDependencyCoordinateFactoryRequest(@Nonnull Session session, String groupId, String artifactId, String version, String classifier, String extension, String type, String scope, boolean optional, Collection<Exclusion> exclusions) {
                super(session);
                this.groupId = groupId;
                this.artifactId = artifactId;
                this.version = version;
                this.classifier = classifier;
                this.extension = extension;
                this.type = type;
                this.scope = scope;
                this.optional = optional;
                this.exclusions = exclusions;
            }

            @Override
            public String getGroupId() {
                return this.groupId;
            }

            @Override
            public String getArtifactId() {
                return this.artifactId;
            }

            @Override
            public String getVersion() {
                return this.version;
            }

            @Override
            public String getClassifier() {
                return this.classifier;
            }

            @Override
            public String getExtension() {
                return this.extension;
            }

            @Override
            public String getType() {
                return this.type;
            }

            @Override
            public String getScope() {
                return this.scope;
            }

            @Override
            public boolean isOptional() {
                return this.optional;
            }

            @Override
            @Nonnull
            public Collection<Exclusion> getExclusions() {
                return this.exclusions;
            }
        }
    }
}

