/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.model.transform;

import java.io.IOException;
import java.util.ArrayDeque;
import java.util.Deque;
import org.apache.maven.model.transform.pull.BufferingParser;
import org.codehaus.plexus.util.xml.pull.XmlPullParser;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;

class FastForwardFilter
extends BufferingParser {
    private final Deque<String> state = new ArrayDeque<String>();
    private int domDepth = 0;

    FastForwardFilter(XmlPullParser xmlPullParser) {
        super(xmlPullParser);
    }

    @Override
    public int next() throws XmlPullParserException, IOException {
        int event = super.next();
        this.filter();
        return event;
    }

    @Override
    public int nextToken() throws XmlPullParserException, IOException {
        int event = super.nextToken();
        this.filter();
        return event;
    }

    protected void filter() throws XmlPullParserException, IOException {
        if (this.xmlPullParser.getEventType() == 2) {
            String localName = this.xmlPullParser.getName();
            if (this.domDepth > 0) {
                ++this.domDepth;
            } else {
                String key;
                switch (key = this.state.peekLast() + '/' + localName) {
                    case "execution/configuration": 
                    case "plugin/configuration": 
                    case "plugin/goals": 
                    case "profile/reports": 
                    case "project/reports": 
                    case "reportSet/configuration": {
                        if (this.domDepth == 0) {
                            this.bypass(true);
                        }
                        ++this.domDepth;
                        break;
                    }
                }
            }
            this.state.add(localName);
        } else if (this.xmlPullParser.getEventType() == 3) {
            if (this.domDepth > 0 && --this.domDepth == 0) {
                this.bypass(false);
            }
            this.state.removeLast();
        }
    }

    @Override
    public void bypass(boolean bypass) {
        this.bypass = bypass;
    }
}

