/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.internal;

import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.maven.plugin.descriptor.MojoDescriptor;
import org.apache.maven.plugin.descriptor.Parameter;
import org.apache.maven.plugin.internal.AbstractMavenPluginDescriptorSourcedParametersValidator;
import org.apache.maven.shared.utils.logging.MessageUtils;
import org.codehaus.plexus.component.configurator.expression.ExpressionEvaluator;
import org.codehaus.plexus.configuration.PlexusConfiguration;

@Singleton
@Named
class DeprecatedPluginValidator
extends AbstractMavenPluginDescriptorSourcedParametersValidator {
    DeprecatedPluginValidator() {
    }

    @Override
    protected String getParameterLogReason(Parameter parameter) {
        return "is deprecated: " + parameter.getDeprecated();
    }

    @Override
    protected void doValidate(MojoDescriptor mojoDescriptor, PlexusConfiguration pomConfiguration, ExpressionEvaluator expressionEvaluator) {
        if (mojoDescriptor.getDeprecated() != null) {
            this.logDeprecatedMojo(mojoDescriptor);
        }
        if (mojoDescriptor.getParameters() == null) {
            return;
        }
        mojoDescriptor.getParameters().stream().filter(parameter -> parameter.getDeprecated() != null).filter(Parameter::isEditable).forEach(parameter -> this.checkParameter((Parameter)parameter, pomConfiguration, expressionEvaluator));
    }

    private void checkParameter(Parameter parameter, PlexusConfiguration pomConfiguration, ExpressionEvaluator expressionEvaluator) {
        PlexusConfiguration config = pomConfiguration.getChild(parameter.getName(), false);
        if (this.isValueSet(config, expressionEvaluator)) {
            this.logParameter(parameter);
        }
    }

    private void logDeprecatedMojo(MojoDescriptor mojoDescriptor) {
        String message = MessageUtils.buffer().warning((Object)"Goal '").warning((Object)mojoDescriptor.getGoal()).warning((Object)"' is deprecated: ").warning((Object)mojoDescriptor.getDeprecated()).toString();
        this.logger.warn(message);
    }
}

