/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.cli;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.nio.charset.StandardCharsets;
import java.util.Locale;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.cli.HelpFormatter;
import org.apache.maven.cli.CLIManager;
import org.mvndaemon.mvnd.common.Environment;
import org.mvndaemon.mvnd.common.OptionType;

public class MvndHelpFormatter {
    private static final Pattern HTML_TAGS_PATTERN = Pattern.compile("<[^>]*>");
    private static final Pattern COLUMNS_DETECTOR_PATTERN = Pattern.compile("^[ ]+[^s]");
    private static final Pattern WS_PATTERN = Pattern.compile("\\s+");

    static String toPlainText(String javadocText) {
        return HTML_TAGS_PATTERN.matcher(javadocText).replaceAll("");
    }

    public static String displayHelp(CLIManager cliManager) {
        int terminalWidth = MvndHelpFormatter.getTerminalWidth();
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try (PrintStream out = new PrintStream((OutputStream)baos, false, StandardCharsets.UTF_8.name());){
            out.println();
            PrintWriter pw = new PrintWriter(out);
            HelpFormatter formatter = new HelpFormatter();
            formatter.printHelp(pw, terminalWidth, "mvnd [options] [<goal(s)>] [<phase(s)>]", "\nOptions:", cliManager.options, 1, 3, "\n", false);
            pw.flush();
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        String mvnHelp = new String(baos.toByteArray(), StandardCharsets.UTF_8);
        Matcher m = COLUMNS_DETECTOR_PATTERN.matcher(mvnHelp);
        String indent = m.find() ? m.group() : "                                        ";
        String lineSeparator = System.lineSeparator();
        StringBuilder help = new StringBuilder(mvnHelp).append(lineSeparator).append("mvnd specific options:");
        Environment.documentedEntries().forEach(entry -> {
            Set opts;
            Environment env = (Environment)entry.getEntry();
            help.append(lineSeparator);
            int indentPos = help.length() + indent.length();
            int lineEnd = help.length() + terminalWidth;
            MvndHelpFormatter.spaces(help, 1);
            String property = env.getProperty();
            if (property != null) {
                help.append("-D").append(property);
                if (env.getType() != OptionType.VOID) {
                    help.append("=<").append(env.getType().name().toLowerCase(Locale.ROOT)).append('>');
                }
            }
            if (!(opts = env.getOptions()).isEmpty()) {
                if (property != null) {
                    help.append(';');
                }
                boolean first = true;
                for (String opt : opts) {
                    if (first) {
                        first = false;
                    } else {
                        help.append(',');
                    }
                    help.append(opt);
                }
                if (env.getType() != OptionType.VOID) {
                    help.append(" <").append(env.getType().name().toLowerCase(Locale.ROOT)).append('>');
                }
            }
            help.append(' ');
            MvndHelpFormatter.spaces(help, indentPos - help.length());
            MvndHelpFormatter.wrap(help, MvndHelpFormatter.toPlainText(entry.getJavaDoc()), terminalWidth, lineEnd, indent);
            MvndHelpFormatter.indentedLine(help, terminalWidth, "Default", env.getDefault(), indent);
            MvndHelpFormatter.indentedLine(help, terminalWidth, "Env. variable", env.getEnvironmentVariable(), indent);
        });
        help.append(lineSeparator).append(lineSeparator).append("mvnd value types:");
        OptionType.documentedEntries().forEach(entry -> {
            OptionType type = (OptionType)entry.getEntry();
            help.append(lineSeparator);
            int indentPos = help.length() + indent.length();
            int lineEnd = help.length() + terminalWidth;
            MvndHelpFormatter.spaces(help, 1);
            help.append(type.name().toLowerCase(Locale.ROOT));
            MvndHelpFormatter.spaces(help, indentPos - help.length());
            MvndHelpFormatter.wrap(help, MvndHelpFormatter.toPlainText(entry.getJavaDoc()), terminalWidth, lineEnd, indent);
        });
        return help.toString();
    }

    private static int getTerminalWidth() {
        int terminalWidth;
        try {
            terminalWidth = Environment.MVND_TERMINAL_WIDTH.asInt();
        }
        catch (Exception e) {
            terminalWidth = 80;
        }
        return terminalWidth;
    }

    private static void indentedLine(StringBuilder stringBuilder, int terminalWidth, String key, String value, String indent) {
        if (value != null) {
            int lineEnd = stringBuilder.length() + terminalWidth;
            stringBuilder.append(System.lineSeparator()).append(indent);
            MvndHelpFormatter.wrap(stringBuilder, key + ": " + value, terminalWidth, lineEnd, indent);
        }
    }

    static void wrap(StringBuilder stringBuilder, String text, int lineLength, int nextLineEnd, String indent) {
        StringTokenizer st = new StringTokenizer(text, " \t\n\r", true);
        String lastWs = null;
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            if (WS_PATTERN.matcher(token).matches()) {
                lastWs = token;
                continue;
            }
            if (stringBuilder.length() + token.length() + (lastWs != null ? lastWs.length() : 0) < nextLineEnd) {
                if (lastWs != null) {
                    stringBuilder.append(lastWs);
                }
                stringBuilder.append(token);
            } else {
                nextLineEnd = stringBuilder.length() + lineLength;
                stringBuilder.append(System.lineSeparator()).append(indent).append(token);
            }
            lastWs = null;
        }
    }

    static StringBuilder spaces(StringBuilder stringBuilder, int count) {
        for (int i = 0; i < count; ++i) {
            stringBuilder.append(' ');
        }
        return stringBuilder;
    }
}

