/*
 * Decompiled with CFR 0.152.
 */
package org.mvndaemon.mvnd.builder;

import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.lifecycle.internal.LifecycleModuleBuilder;
import org.apache.maven.lifecycle.internal.ProjectBuildList;
import org.apache.maven.lifecycle.internal.ReactorBuildStatus;
import org.apache.maven.lifecycle.internal.ReactorContext;
import org.apache.maven.lifecycle.internal.TaskSegment;
import org.apache.maven.lifecycle.internal.builder.Builder;
import org.apache.maven.project.MavenProject;
import org.mvndaemon.mvnd.builder.DependencyGraph;
import org.mvndaemon.mvnd.builder.ReactorBuildStats;
import org.mvndaemon.mvnd.builder.SmartBuilderImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
@Named(value="smart")
public class SmartBuilder
implements Builder {
    public static final String PROP_PROFILING = "smartbuilder.profiling";
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final LifecycleModuleBuilder moduleBuilder;
    private volatile SmartBuilderImpl builder;
    private volatile boolean canceled;
    private static SmartBuilder INSTANCE;

    public static SmartBuilder cancel() {
        SmartBuilder builder = INSTANCE;
        if (builder != null) {
            builder.doCancel();
        }
        return builder;
    }

    @Inject
    public SmartBuilder(LifecycleModuleBuilder moduleBuilder) {
        this.moduleBuilder = moduleBuilder;
        INSTANCE = this;
    }

    void doCancel() {
        this.canceled = true;
        SmartBuilderImpl b = this.builder;
        if (b != null) {
            b.cancel();
        }
    }

    public void doneCancel() {
        this.canceled = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void build(MavenSession session, ReactorContext reactorContext, ProjectBuildList projectBuilds, List<TaskSegment> taskSegments, ReactorBuildStatus reactorBuildStatus) throws ExecutionException, InterruptedException {
        ReactorBuildStats stats;
        session.getRepositorySession().getData().set(ReactorBuildStatus.class, (Object)reactorBuildStatus);
        DependencyGraph<MavenProject> graph = DependencyGraph.fromMaven(session);
        int degreeOfConcurrency = session.getRequest().getDegreeOfConcurrency();
        this.logger.info("Task segments : " + taskSegments.stream().map(Object::toString).collect(Collectors.joining(" ")));
        this.logger.info("Build maximum degree of concurrency is " + degreeOfConcurrency);
        this.logger.info("Total number of projects is " + session.getProjects().size());
        ArrayList<AbstractMap.SimpleEntry<TaskSegment, ReactorBuildStats>> allstats = new ArrayList<AbstractMap.SimpleEntry<TaskSegment, ReactorBuildStats>>();
        for (TaskSegment taskSegment : taskSegments) {
            Set projects = projectBuilds.getByTaskSegment(taskSegment).getProjects();
            if (this.canceled) {
                return;
            }
            this.builder = new SmartBuilderImpl(this.moduleBuilder, session, reactorContext, taskSegment, projects, graph);
            try {
                stats = this.builder.build();
                allstats.add(new AbstractMap.SimpleEntry<TaskSegment, ReactorBuildStats>(taskSegment, stats));
            }
            finally {
                this.builder = null;
            }
        }
        if (session.getResult().hasExceptions()) {
            return;
        }
        for (Map.Entry entry : allstats) {
            TaskSegment taskSegment = (TaskSegment)entry.getKey();
            stats = (ReactorBuildStats)entry.getValue();
            Set projects = projectBuilds.getByTaskSegment(taskSegment).getProjects();
            this.logger.debug("Task segment {}, number of projects {}", (Object)taskSegment, (Object)projects.size());
            long walltimeReactor = stats.walltimeTime(TimeUnit.NANOSECONDS);
            long walltimeService = stats.totalServiceTime(TimeUnit.NANOSECONDS);
            String effectiveConcurrency = String.format("%2.2f", (double)walltimeService / (double)walltimeReactor);
            this.logger.info("Segment walltime {} s, segment projects service time {} s, effective/maximum degree of concurrency {}/{}", new Object[]{TimeUnit.NANOSECONDS.toSeconds(walltimeReactor), TimeUnit.NANOSECONDS.toSeconds(walltimeService), effectiveConcurrency, degreeOfConcurrency});
            if (projects.size() <= 1 || !this.isProfiling(session)) continue;
            this.logger.info(stats.renderCriticalPath(graph));
        }
    }

    private boolean isProfiling(MavenSession session) {
        String value = session.getUserProperties().getProperty(PROP_PROFILING);
        if (value == null) {
            value = session.getSystemProperties().getProperty(PROP_PROFILING);
        }
        return Boolean.parseBoolean(value);
    }
}

