/*
 * Decompiled with CFR 0.152.
 */
package org.mvndaemon.mvnd.builder;

import java.io.BufferedWriter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.execution.ProjectDependencyGraph;
import org.apache.maven.project.MavenProject;

public class DependencyGraph<K> {
    private final List<K> projects;
    private final Map<K, List<K>> upstreams;
    private final Map<K, Set<K>> transitiveUpstreams;
    private final Map<K, List<K>> downstreams;

    public static DependencyGraph<MavenProject> fromMaven(MavenSession session) {
        Map data = session.getRequest().getData();
        DependencyGraph<MavenProject> graph = (DependencyGraph<MavenProject>)data.get(DependencyGraph.class.getName());
        if (graph == null) {
            graph = DependencyGraph.fromMaven(session.getProjectDependencyGraph());
            data.put(DependencyGraph.class.getName(), graph);
        }
        return graph;
    }

    static DependencyGraph<MavenProject> fromMaven(ProjectDependencyGraph graph) {
        List projects = graph.getSortedProjects();
        Map<MavenProject, List> upstreams = projects.stream().collect(Collectors.toMap(p -> p, p -> graph.getUpstreamProjects(p, false)));
        Map<MavenProject, List> downstreams = projects.stream().collect(Collectors.toMap(p -> p, p -> graph.getDownstreamProjects(p, false)));
        return new DependencyGraph<MavenProject>(Collections.unmodifiableList(projects), upstreams, downstreams);
    }

    public DependencyGraph(List<K> projects, Map<K, List<K>> upstreams, Map<K, List<K>> downstreams) {
        this.projects = projects;
        this.upstreams = upstreams;
        this.downstreams = downstreams;
        this.transitiveUpstreams = new HashMap<K, Set<K>>();
        projects.forEach(this::transitiveUpstreams);
    }

    DependencyGraph(List<K> projects, Map<K, List<K>> upstreams, Map<K, List<K>> downstreams, Map<K, Set<K>> transitiveUpstreams) {
        this.projects = projects;
        this.upstreams = upstreams;
        this.downstreams = downstreams;
        this.transitiveUpstreams = transitiveUpstreams;
    }

    public Stream<K> getDownstreamProjects(K project) {
        return this.downstreams.get(project).stream();
    }

    public Stream<K> getUpstreamProjects(K project) {
        return this.upstreams.get(project).stream();
    }

    public boolean isRoot(K project) {
        return this.upstreams.get(project).isEmpty();
    }

    public Stream<K> getProjects() {
        return this.projects.stream();
    }

    public int computeMaxWidth(int max, long maxTimeMillis) {
        return new DagWidth(this).getMaxWidth(max, maxTimeMillis);
    }

    public void store(Function<K, String> toString, Path path) {
        try (BufferedWriter w = Files.newBufferedWriter(path, new OpenOption[0]);){
            this.store(toString, w);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void store(Function<K, String> toString, Appendable w) {
        this.getProjects().forEach(k -> {
            try {
                w.append((CharSequence)toString.apply(k));
                w.append(" = ");
                w.append(this.getUpstreamProjects(k).map(toString).collect(Collectors.joining(",")));
                w.append(System.lineSeparator());
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        });
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        this.store((K k) -> k.toString(), sb);
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.downstreams == null ? 0 : this.downstreams.hashCode());
        result = 31 * result + (this.projects == null ? 0 : this.projects.hashCode());
        result = 31 * result + (this.upstreams == null ? 0 : this.upstreams.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DependencyGraph other = (DependencyGraph)obj;
        if (this.downstreams == null ? other.downstreams != null : !this.downstreams.equals(other.downstreams)) {
            return false;
        }
        if (this.projects == null ? other.projects != null : !this.projects.equals(other.projects)) {
            return false;
        }
        return !(this.upstreams == null ? other.upstreams != null : !this.upstreams.equals(other.upstreams));
    }

    DependencyGraph<K> reduce() {
        HashMap<K, ArrayList<K>> newUpstreams = new HashMap<K, ArrayList<K>>();
        HashMap<Object, List> newDownstreams = new HashMap<Object, List>();
        for (K node : this.projects) {
            ArrayList<Object> newNodeUpstreams;
            List<K> oldNodeUpstreams = this.upstreams.get(node);
            newDownstreams.computeIfAbsent(node, k -> new ArrayList());
            if (oldNodeUpstreams.size() == 0) {
                newNodeUpstreams = new ArrayList<K>(oldNodeUpstreams);
            } else if (oldNodeUpstreams.size() == 1) {
                newNodeUpstreams = new ArrayList<K>(oldNodeUpstreams);
                newDownstreams.computeIfAbsent(newNodeUpstreams.get(0), k -> new ArrayList()).add(node);
            } else {
                newNodeUpstreams = new ArrayList(oldNodeUpstreams.size());
                for (Object leftNode : oldNodeUpstreams) {
                    if (!oldNodeUpstreams.stream().filter(rightNode -> leftNode != rightNode).noneMatch(rightNode -> this.transitiveUpstreams.get(rightNode).contains(leftNode))) continue;
                    newNodeUpstreams.add(leftNode);
                    newDownstreams.computeIfAbsent(leftNode, k -> new ArrayList()).add(node);
                }
            }
            newUpstreams.put(node, newNodeUpstreams);
        }
        return new DependencyGraph<K>(this.projects, newUpstreams, newDownstreams, this.transitiveUpstreams);
    }

    Set<K> transitiveUpstreams(K node) {
        Set<K> result = this.transitiveUpstreams.get(node);
        if (result == null) {
            List<K> firstOrderUpstreams = this.upstreams.get(node);
            result = new HashSet<K>(firstOrderUpstreams);
            firstOrderUpstreams.stream().map(this::transitiveUpstreams).forEach(result::addAll);
            this.transitiveUpstreams.put(node, result);
        }
        return result;
    }

    static class DagWidth<K> {
        private final DependencyGraph<K> graph;

        public DagWidth(DependencyGraph<K> graph) {
            this.graph = graph.reduce();
        }

        public int getMaxWidth() {
            return this.getMaxWidth(Integer.MAX_VALUE);
        }

        public int getMaxWidth(int maxmax) {
            return this.getMaxWidth(maxmax, Long.MAX_VALUE);
        }

        public int getMaxWidth(int maxmax, long maxTimeMillis) {
            int max = 0;
            if (maxmax < ((DependencyGraph)this.graph).transitiveUpstreams.size()) {
                HashMap mapByUpstreams = new HashMap();
                ((DependencyGraph)this.graph).transitiveUpstreams.forEach((k, ups) -> mapByUpstreams.computeIfAbsent(ups, n -> new HashSet()).add(k));
                max = mapByUpstreams.values().stream().mapToInt(Set::size).max().orElse(0);
                if (max >= maxmax) {
                    return maxmax;
                }
            }
            long tmax = System.currentTimeMillis() + maxTimeMillis;
            int tries = 0;
            SubsetIterator iterator = new SubsetIterator(this.getRoots());
            while (max < maxmax && iterator.hasNext()) {
                if (++tries % 100 == 0 && System.currentTimeMillis() < tmax) {
                    return maxmax;
                }
                Object l = iterator.next();
                max = Math.max(max, l.size());
            }
            return Math.min(max, maxmax);
        }

        private List<K> getRoots() {
            return this.graph.getProjects().filter(this.graph::isRoot).collect(Collectors.toList());
        }

        List<K> ensembleWithChildrenOf(List<K> list, K node) {
            List result = Stream.concat(list.stream().filter(k -> !Objects.equals(k, node)), this.graph.getDownstreamProjects(node).filter(k -> ((Set)((DependencyGraph)this.graph).transitiveUpstreams.get(k)).stream().noneMatch(k2 -> !Objects.equals(k2, node) && list.contains(k2)))).distinct().collect(Collectors.toList());
            return result;
        }

        private class SubsetIterator
        implements Iterator<List<K>> {
            final List<List<K>> nexts = new ArrayList();
            final Set<List<K>> visited = new HashSet();

            public SubsetIterator(List<K> roots) {
                this.nexts.add(roots);
            }

            @Override
            public boolean hasNext() {
                return !this.nexts.isEmpty();
            }

            @Override
            public List<K> next() {
                List list = this.nexts.remove(0);
                list.stream().map(node -> DagWidth.this.ensembleWithChildrenOf(list, node)).filter(this.visited::add).forEach(this.nexts::add);
                return list;
            }
        }
    }
}

