/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.opencmis.inmemory.storedobj.impl;

import java.awt.AlphaComposite;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import javax.imageio.ImageIO;
import org.apache.chemistry.opencmis.commons.data.ContentStream;
import org.apache.chemistry.opencmis.commons.exceptions.CmisRuntimeException;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.ContentStreamImpl;

public class ImageThumbnailGenerator {
    private static final int DEFAULT_LENGTH = 100;
    private static final String RENDITION_MIME_TYPE = "image/jpeg";
    private InputStream image;
    private int thumbWidth;
    private int thumbHeight;

    public ImageThumbnailGenerator(InputStream imageContent) {
        this.image = imageContent;
    }

    public int getWidth() {
        return this.thumbWidth;
    }

    public int getHeight() {
        return this.thumbHeight;
    }

    public ContentStream getRendition(int width, int height) {
        try {
            byte[] thumbnail = this.scaleImage(this.image, width, height);
            ContentStreamImpl cs = new ContentStreamImpl();
            cs.setFileName("thumbnail.jpg");
            cs.setMimeType(RENDITION_MIME_TYPE);
            cs.setStream((InputStream)new ByteArrayInputStream(thumbnail));
            cs.setLength(BigInteger.valueOf(thumbnail.length));
            return cs;
        }
        catch (IOException e) {
            throw new CmisRuntimeException("Failed to generate thumbnail", (Throwable)e);
        }
    }

    private byte[] scaleImage(InputStream stream, int width, int height) throws IOException {
        BufferedImage originalImage = ImageIO.read(stream);
        BufferedImage resizedImage = width <= 0 ? this.scaleLongerSideTo(originalImage, height) : (height <= 0 ? this.scaleLongerSideTo(originalImage, width) : this.scaleImage(originalImage, width, height));
        this.thumbWidth = resizedImage.getWidth();
        this.thumbHeight = resizedImage.getHeight();
        return this.storeImageinByteArray(resizedImage);
    }

    private BufferedImage scaleLongerSideTo(BufferedImage bi, int longerSideLengthParam) throws IOException {
        int height;
        int width;
        int longerSideLength = longerSideLengthParam;
        if (longerSideLength <= 0) {
            longerSideLength = 100;
        }
        if (bi.getWidth() > bi.getHeight()) {
            width = longerSideLength;
            height = bi.getHeight() * longerSideLength / bi.getWidth();
        } else {
            height = longerSideLength;
            width = bi.getWidth() * longerSideLength / bi.getHeight();
        }
        BufferedImage resizedImage = this.scaleImage(bi, width, height);
        return resizedImage;
    }

    private BufferedImage scaleImage(BufferedImage originalImage, int width, int height) {
        BufferedImage resizedImage = new BufferedImage(width, height, originalImage.getType());
        Graphics2D g = resizedImage.createGraphics();
        g.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
        g.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g.drawImage(originalImage, 0, 0, width, height, null);
        g.dispose();
        g.setComposite(AlphaComposite.Src);
        return resizedImage;
    }

    private byte[] storeImageinByteArray(BufferedImage bi) throws IOException {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        boolean ok = ImageIO.write((RenderedImage)bi, "JPG", os);
        if (ok) {
            return os.toByteArray();
        }
        return null;
    }
}

