/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.storage;

import java.util.logging.Logger;
import org.apache.sis.internal.simple.SimpleFormat;
import org.apache.sis.internal.storage.URIDataStore;
import org.apache.sis.measure.Range;
import org.apache.sis.storage.DataStore;
import org.apache.sis.storage.DataStoreException;
import org.apache.sis.storage.ProbeResult;
import org.apache.sis.storage.StorageConnector;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.Version;
import org.apache.sis.util.logging.Logging;
import org.opengis.metadata.distribution.Format;
import org.opengis.parameter.ParameterDescriptorGroup;
import org.opengis.parameter.ParameterValueGroup;

public abstract class DataStoreProvider {
    public static final String LOCATION = "location";
    public static final String CREATE = "create";
    private volatile Logger logger;

    protected DataStoreProvider() {
    }

    public abstract String getShortName();

    public Format getFormat() {
        return new SimpleFormat(this.getShortName());
    }

    public Range<Version> getSupportedVersions() {
        return null;
    }

    public abstract ParameterDescriptorGroup getOpenParameters();

    public abstract ProbeResult probeContent(StorageConnector var1) throws DataStoreException;

    public abstract DataStore open(StorageConnector var1) throws DataStoreException;

    public DataStore open(ParameterValueGroup parameterValueGroup) throws DataStoreException {
        ArgumentChecks.ensureNonNull("parameter", parameterValueGroup);
        return this.open(URIDataStore.Provider.connector(this, parameterValueGroup));
    }

    public Logger getLogger() {
        Logger logger = this.logger;
        if (logger == null) {
            this.logger = logger = Logging.getLogger(this.getClass());
        }
        return logger;
    }
}

