/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.metadata.iso.spatial;

import java.util.Collection;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.apache.sis.metadata.TitleProperty;
import org.apache.sis.metadata.iso.spatial.AbstractGeolocationInformation;
import org.opengis.metadata.spatial.GCP;
import org.opengis.metadata.spatial.GCPCollection;
import org.opengis.metadata.spatial.GeolocationInformation;
import org.opengis.referencing.ReferenceSystem;
import org.opengis.util.InternationalString;

@TitleProperty(name="collectionName")
@XmlType(name="MI_GCPCollection_Type", propOrder={"collectionIdentification", "collectionName", "coordinateReferenceSystem", "GCPs"})
@XmlRootElement(name="MI_GCPCollection")
public class DefaultGCPCollection
extends AbstractGeolocationInformation
implements GCPCollection {
    private static final long serialVersionUID = -2757911443659529373L;
    private Integer collectionIdentification;
    private InternationalString collectionName;
    private ReferenceSystem coordinateReferenceSystem;
    private Collection<GCP> GCPs;

    public DefaultGCPCollection() {
    }

    public DefaultGCPCollection(GCPCollection gCPCollection) {
        super((GeolocationInformation)gCPCollection);
        if (gCPCollection != null) {
            this.collectionIdentification = gCPCollection.getCollectionIdentification();
            this.collectionName = gCPCollection.getCollectionName();
            this.coordinateReferenceSystem = gCPCollection.getCoordinateReferenceSystem();
            this.GCPs = this.copyCollection(gCPCollection.getGCPs(), GCP.class);
        }
    }

    public static DefaultGCPCollection castOrCopy(GCPCollection gCPCollection) {
        if (gCPCollection == null || gCPCollection instanceof DefaultGCPCollection) {
            return (DefaultGCPCollection)gCPCollection;
        }
        return new DefaultGCPCollection(gCPCollection);
    }

    @XmlElement(name="collectionIdentification", required=true)
    public Integer getCollectionIdentification() {
        return this.collectionIdentification;
    }

    public void setCollectionIdentification(Integer n) {
        this.checkWritePermission(this.collectionIdentification);
        this.collectionIdentification = n;
    }

    @XmlElement(name="collectionName", required=true)
    public InternationalString getCollectionName() {
        return this.collectionName;
    }

    public void setCollectionName(InternationalString internationalString) {
        this.checkWritePermission(this.collectionName);
        this.collectionName = internationalString;
    }

    @XmlElement(name="coordinateReferenceSystem", required=true)
    public ReferenceSystem getCoordinateReferenceSystem() {
        return this.coordinateReferenceSystem;
    }

    public void setCoordinateReferenceSystem(ReferenceSystem referenceSystem) {
        this.checkWritePermission(this.coordinateReferenceSystem);
        this.coordinateReferenceSystem = referenceSystem;
    }

    @XmlElement(name="gcp", required=true)
    public Collection<GCP> getGCPs() {
        this.GCPs = this.nonNullCollection(this.GCPs, GCP.class);
        return this.GCPs;
    }

    public void setGCPs(Collection<? extends GCP> collection) {
        this.GCPs = this.writeCollection(collection, this.GCPs, GCP.class);
    }
}

