/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.configuration.jsse;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import org.apache.cxf.common.util.SystemPropertyAction;
import org.apache.cxf.configuration.jsse.TLSParameterBase;

public class TLSClientParameters
extends TLSParameterBase {
    static final String IGNORE_CONFIGURED_HTTPS_PROTOCOLS = "https.protocols.ignore";
    static final String CONFIGURED_HTTPS_PROTOCOLS = "https.protocols";
    private boolean disableCNCheck;
    private SSLSocketFactory sslSocketFactory;
    private int sslCacheTimeout = 86400;
    private boolean useHttpsURLConnectionDefaultSslSocketFactory;
    private boolean useHttpsURLConnectionDefaultHostnameVerifier;
    private HostnameVerifier hostnameVerifier;
    private SSLContext sslContext;

    public void setHostnameVerifier(HostnameVerifier verifier) {
        this.hostnameVerifier = verifier;
    }

    public HostnameVerifier getHostnameVerifier() {
        return this.hostnameVerifier;
    }

    public void setDisableCNCheck(boolean disableCNCheck) {
        this.disableCNCheck = disableCNCheck;
    }

    public boolean isDisableCNCheck() {
        return this.disableCNCheck;
    }

    public final void setSSLSocketFactory(SSLSocketFactory factory) {
        this.sslSocketFactory = factory;
    }

    public final SSLSocketFactory getSSLSocketFactory() {
        return this.sslSocketFactory;
    }

    public int getSslCacheTimeout() {
        return this.sslCacheTimeout;
    }

    public void setSslCacheTimeout(int sslCacheTimeout) {
        this.sslCacheTimeout = sslCacheTimeout;
    }

    public boolean isUseHttpsURLConnectionDefaultSslSocketFactory() {
        return this.useHttpsURLConnectionDefaultSslSocketFactory;
    }

    public void setUseHttpsURLConnectionDefaultSslSocketFactory(boolean useHttpsURLConnectionDefaultSslSocketFactory) {
        this.useHttpsURLConnectionDefaultSslSocketFactory = useHttpsURLConnectionDefaultSslSocketFactory;
    }

    public boolean isUseHttpsURLConnectionDefaultHostnameVerifier() {
        return this.useHttpsURLConnectionDefaultHostnameVerifier;
    }

    public void setUseHttpsURLConnectionDefaultHostnameVerifier(boolean useHttpsURLConnectionDefaultHostnameVerifier) {
        this.useHttpsURLConnectionDefaultHostnameVerifier = useHttpsURLConnectionDefaultHostnameVerifier;
    }

    public int hashCode() {
        int hash;
        int n = hash = this.disableCNCheck ? 37 : 17;
        if (this.sslSocketFactory != null) {
            hash = hash * 41 + System.identityHashCode(this.sslSocketFactory);
        }
        if (this.sslContext != null) {
            hash = hash * 41 + System.identityHashCode(this.sslContext);
        }
        hash = this.hash(hash, this.useHttpsURLConnectionDefaultSslSocketFactory);
        hash = this.hash(hash, this.useHttpsURLConnectionDefaultHostnameVerifier);
        hash = this.hash(hash, this.sslCacheTimeout);
        hash = this.hash(hash, this.secureRandom);
        hash = this.hash(hash, this.protocol);
        hash = this.hash(hash, this.certAlias);
        hash = this.hash(hash, this.provider);
        for (String cs : this.ciphersuites) {
            hash = this.hash(hash, cs);
        }
        hash = this.hash(hash, this.keyManagers);
        hash = this.hash(hash, this.trustManagers);
        if (this.cipherSuiteFilters != null) {
            hash = this.hash(hash, this.cipherSuiteFilters.getInclude());
            hash = this.hash(hash, this.cipherSuiteFilters.getExclude());
        }
        if (this.certConstraints != null) {
            hash = this.hash(hash, this.certConstraints.getIssuerDNConstraints());
            hash = this.hash(hash, this.certConstraints.getSubjectDNConstraints());
        }
        return hash;
    }

    private int hash(int i, Object o) {
        if (o != null) {
            return i * 37 + o.hashCode();
        }
        return i;
    }

    private int hash(int i, Object[] os) {
        if (os == null) {
            return i;
        }
        for (Object o : os) {
            i = this.hash(i, o);
        }
        return i;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof TLSClientParameters) {
            TLSClientParameters that = (TLSClientParameters)o;
            boolean eq = this.disableCNCheck == that.disableCNCheck;
            eq &= this.sslSocketFactory == that.sslSocketFactory;
            eq &= this.sslContext == that.sslContext;
            eq &= this.useHttpsURLConnectionDefaultSslSocketFactory == that.useHttpsURLConnectionDefaultSslSocketFactory;
            eq &= this.useHttpsURLConnectionDefaultHostnameVerifier == that.useHttpsURLConnectionDefaultHostnameVerifier;
            eq &= this.sslCacheTimeout == that.sslCacheTimeout;
            eq &= this.secureRandom == that.secureRandom;
            eq &= Objects.equals(this.certAlias, that.certAlias);
            eq &= Objects.equals(this.protocol, that.protocol);
            eq &= Objects.equals(this.provider, that.provider);
            eq &= TLSClientParameters.equals(this.ciphersuites, that.ciphersuites);
            eq &= Objects.deepEquals(this.keyManagers, that.keyManagers);
            eq &= Objects.deepEquals(this.trustManagers, that.trustManagers);
            if (this.cipherSuiteFilters != null) {
                if (that.cipherSuiteFilters != null) {
                    eq &= TLSClientParameters.equals(this.cipherSuiteFilters.getExclude(), that.cipherSuiteFilters.getExclude());
                    eq &= TLSClientParameters.equals(this.cipherSuiteFilters.getInclude(), that.cipherSuiteFilters.getInclude());
                } else {
                    eq = false;
                }
            } else {
                eq &= that.cipherSuiteFilters == null;
            }
            if (this.certConstraints != null) {
                if (that.certConstraints != null) {
                    eq &= Objects.equals(this.certConstraints.getIssuerDNConstraints(), that.certConstraints.getIssuerDNConstraints());
                    eq &= Objects.equals(this.certConstraints.getSubjectDNConstraints(), that.certConstraints.getSubjectDNConstraints());
                } else {
                    eq = false;
                }
            } else {
                eq &= that.certConstraints == null;
            }
            return eq;
        }
        return false;
    }

    private static boolean equals(List<?> obj1, List<?> obj2) {
        return obj1.equals(obj2);
    }

    public SSLContext getSslContext() {
        return this.sslContext;
    }

    public void setSslContext(SSLContext sslContext) {
        this.sslContext = sslContext;
    }

    public static String[] getPreferredClientProtocols() {
        Collection<String> configured;
        if (!TLSClientParameters.shouldIgnoreConfiguredCLientProtocols() && !(configured = TLSClientParameters.getConfiguredCLientProtocols()).isEmpty()) {
            return configured.toArray(new String[0]);
        }
        return DEFAULT_HTTPS_PROTOCOLS.toArray(new String[0]);
    }

    private static Collection<String> getConfiguredCLientProtocols() {
        String protocols = SystemPropertyAction.getPropertyOrNull(CONFIGURED_HTTPS_PROTOCOLS);
        if (protocols == null || protocols.isEmpty()) {
            return Collections.emptySet();
        }
        return Arrays.stream(protocols.split(",")).map(String::trim).filter(s -> !s.isEmpty()).collect(Collectors.toCollection(LinkedHashSet::new));
    }

    private static boolean shouldIgnoreConfiguredCLientProtocols() {
        return Boolean.valueOf(SystemPropertyAction.getProperty(IGNORE_CONFIGURED_HTTPS_PROTOCOLS, "false"));
    }
}

