/*
 * Decompiled with CFR 0.152.
 */
package net.sf.ehcache.pool.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import net.sf.ehcache.pool.PoolEvictor;

public abstract class AbstractBalancedAccessEvictor<T>
implements PoolEvictor<T> {
    private static final double ALPHA = 1.0;
    private static final int SAMPLE_SIZE = 5;

    protected abstract boolean evict(T var1, int var2, long var3);

    protected abstract float hitRate(T var1);

    protected abstract float missRate(T var1);

    protected abstract long countSize(T var1);

    protected abstract long byteSize(T var1);

    @Override
    public boolean freeSpace(Collection<T> from, long bytes) {
        if (from == null || from.isEmpty()) {
            return false;
        }
        ArrayList<T> random = new ArrayList<T>(from);
        Collections.shuffle(random);
        for (int i = 0; i < random.size(); i += 5) {
            List sorted = random.subList(i, Math.min(5 + i, random.size()));
            Collections.sort(sorted, new EvictionCostComparator(this.getDesiredUnloadedSize(sorted), sorted.size() + 1));
            for (Object store : sorted) {
                long byteSize = this.byteSize(store);
                long countSize = this.countSize(store);
                int count = countSize == 0L || byteSize == 0L ? 1 : (int)Math.max(bytes * countSize / byteSize, 1L);
                if (!this.evict(store, count, bytes)) continue;
                return true;
            }
        }
        return false;
    }

    private float evictionCost(T store, long unloadedSize) {
        float hitRate = this.hitRate(store);
        float missRate = this.missRate(store);
        long countSize = this.countSize(store);
        float accessRate = hitRate + missRate;
        if (accessRate == 0.0f) {
            if (this.byteSize(store) > unloadedSize) {
                return Float.NEGATIVE_INFINITY;
            }
            return Float.POSITIVE_INFINITY;
        }
        if (hitRate == 0.0f) {
            return Float.POSITIVE_INFINITY;
        }
        float cost = hitRate / (float)countSize * AbstractBalancedAccessEvictor.hitDistributionFunction(hitRate / accessRate);
        if (Float.isNaN(cost)) {
            throw new AssertionError((Object)String.format("NaN Eviction Cost [hit:%f miss:%f size:%d]", Float.valueOf(hitRate), Float.valueOf(missRate), countSize));
        }
        return cost;
    }

    private static float hitDistributionFunction(float fillLevel) {
        return (float)Math.pow(fillLevel, -1.0);
    }

    private long getDesiredUnloadedSize(Collection<T> from) {
        long unloadedSize = 0L;
        for (T s : from) {
            unloadedSize += this.byteSize(s);
        }
        return unloadedSize / (long)from.size();
    }

    private final class EvictionCostComparator
    implements Comparator<T> {
        private final long unloadedSize;
        private final Map<T, Float> evictionCostCache;

        public EvictionCostComparator(long unloadedSize, int collectionSize) {
            this.unloadedSize = unloadedSize;
            this.evictionCostCache = new IdentityHashMap(collectionSize);
        }

        @Override
        public int compare(T s1, T s2) {
            Float f2;
            Float f1 = this.evictionCostCache.get(s1);
            if (f1 == null) {
                f1 = Float.valueOf(AbstractBalancedAccessEvictor.this.evictionCost(s1, this.unloadedSize));
                this.evictionCostCache.put(s1, f1);
            }
            if ((f2 = this.evictionCostCache.get(s2)) == null) {
                f2 = Float.valueOf(AbstractBalancedAccessEvictor.this.evictionCost(s2, this.unloadedSize));
                this.evictionCostCache.put(s2, f2);
            }
            return Float.compare(f1.floatValue(), f2.floatValue());
        }
    }
}

