/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.formats;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.nio.charset.StandardCharsets;
import opennlp.tools.cmdline.ArgumentParser;
import opennlp.tools.cmdline.CmdLineUtil;
import opennlp.tools.cmdline.StreamFactoryRegistry;
import opennlp.tools.cmdline.TerminateToolException;
import opennlp.tools.cmdline.params.BasicFormatParams;
import opennlp.tools.formats.AbstractSampleStreamFactory;
import opennlp.tools.formats.ConllXPOSSampleStream;
import opennlp.tools.postag.POSSample;
import opennlp.tools.util.InputStreamFactory;
import opennlp.tools.util.ObjectStream;

public class ConllXPOSSampleStreamFactory
extends AbstractSampleStreamFactory<POSSample> {
    public static final String CONLLX_FORMAT = "conllx";

    public static void registerFactory() {
        StreamFactoryRegistry.registerFactory(POSSample.class, CONLLX_FORMAT, new ConllXPOSSampleStreamFactory(Parameters.class));
    }

    protected <P> ConllXPOSSampleStreamFactory(Class<P> params) {
        super(params);
    }

    @Override
    public ObjectStream<POSSample> create(String[] args) {
        Parameters params = ArgumentParser.parse(args, Parameters.class);
        InputStreamFactory inFactory = CmdLineUtil.createInputStreamFactory(params.getData());
        try {
            System.setOut(new PrintStream((OutputStream)System.out, true, StandardCharsets.UTF_8.name()));
            return new ConllXPOSSampleStream(inFactory, StandardCharsets.UTF_8);
        }
        catch (UnsupportedEncodingException e) {
            throw new TerminateToolException(-1, "UTF-8 encoding is not supported: " + e.getMessage(), e);
        }
        catch (IOException e) {
            CmdLineUtil.handleCreateObjectStreamError(e);
            return null;
        }
    }

    static interface Parameters
    extends BasicFormatParams {
    }
}

