/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.util;

import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum LocaleID {
    AR(1, "ar", "ar", "Arabic", 1256, 1),
    BG(2, "bg", "bg", "Bulgarian", 1251, -1),
    CA(3, "ca", "ca", "Catalan", 1252, -1),
    ZH_HANS(4, "zh_hans", "zh-Hans", "Chinese (Simplified)", 936, -1),
    CS(5, "cs", "cs", "Czech", 1250, -1),
    DA(6, "da", "da", "Danish", 1252, -1),
    DE(7, "de", "de", "German", 1252, -1),
    EL(8, "el", "el", "Greek", 1253, -1),
    EN(9, "en", "en", "English", 1252, -1),
    ES(10, "es", "es", "Spanish", 1252, -1),
    FI(11, "fi", "fi", "Finnish", 1252, -1),
    FR(12, "fr", "fr", "French", 1252, -1),
    HE(13, "he", "he", "Hebrew", 1255, 1),
    HU(14, "hu", "hu", "Hungarian", 1250, -1),
    IS(15, "is", "is", "Icelandic", 1252, -1),
    IT(16, "it", "it", "Italian", 1252, -1),
    JA(17, "ja", "ja", "Japanese", 932, 1),
    KO(18, "ko", "ko", "Korean", 949, 1),
    NL(19, "nl", "nl", "Dutch", 1252, -1),
    NO(20, "no", "no", "Norwegian", 1252, -1),
    PL(21, "pl", "pl", "Polish", 1250, -1),
    PT(22, "pt", "pt", "Portuguese", 1252, 1),
    RM(23, "rm", "rm", "Romansh", 1252, -1),
    RO(24, "ro", "ro", "Romanian", 1250, -1),
    RU(25, "ru", "ru", "Russian", 1251, -1),
    HR(26, "hr", "hr", "Croatian", 1250, -1),
    SK(27, "sk", "sk", "Slovak", 1250, -1),
    SQ(28, "sq", "sq", "Albanian", 1250, -1),
    SV(29, "sv", "sv", "Swedish", 1252, -1),
    TH(30, "th", "th", "Thai", 874, -1),
    TR(31, "tr", "tr", "Turkish", 1254, -1),
    UR(32, "ur", "ur", "Urdu", 1256, -1),
    ID(33, "id", "id", "Indonesian", 1252, 1),
    UK(34, "uk", "uk", "Ukrainian", 1251, -1),
    BE(35, "be", "be", "Belarusian", 1251, -1),
    SL(36, "sl", "sl", "Slovenian", 1250, -1),
    ET(37, "et", "et", "Estonian", 1257, -1),
    LV(38, "lv", "lv", "Latvian", 1257, -1),
    LT(39, "lt", "lt", "Lithuanian", 1257, -1),
    TG(40, "tg", "tg", "Tajik", 1251, -1),
    FA(41, "fa", "fa", "Persian", 1256, 7),
    VI(42, "vi", "vi", "Vietnamese", 1258, -1),
    HY(43, "hy", "hy", "Armenian", 0, -1),
    AZ(44, "az", "az", "Azerbaijani", 1254, -1),
    EU(45, "eu", "eu", "Basque", 1252, -1),
    HSB(46, "hsb", "hsb", "Upper Sorbian", 1252, -1),
    MK(47, "mk", "mk", "Macedonian (FYROM)", 1251, -1),
    ST(48, "st", "st", "Southern Sotho", 0, -1),
    TS(49, "ts", "ts", "Tsonga", 0, 1),
    TN(50, "tn", "tn", "Setswana", 1252, 1),
    VE(51, "ve", "ve", "Venda", 32759, 1),
    XH(52, "xh", "xh", "isiXhosa", 1252, 1),
    ZU(53, "zu", "zu", "isiZulu", 1252, 1),
    AF(54, "af", "af", "Afrikaans", 1252, 1),
    KA(55, "ka", "ka", "Georgian", 0, -1),
    FO(56, "fo", "fo", "Faroese", 1252, -1),
    HI(57, "hi", "hi", "Hindi", 0, -1),
    MT(58, "mt", "mt", "Maltese", 0, 1),
    SE(59, "se", "se", "Sami (Northern)", 1252, -1),
    GA(60, "ga", "ga", "Irish", 1252, 1),
    YI(61, "yi", "yi", "Yiddish", 32759, -1),
    MS(62, "ms", "ms", "Malay", 1252, -1),
    KK(63, "kk", "kk", "Kazakh", 0, -1),
    KY(64, "ky", "ky", "Kyrgyz", 1251, -1),
    SW(65, "sw", "sw", "Kiswahili", 1252, 1),
    TK(66, "tk", "tk", "Turkmen", 1250, -1),
    UZ(67, "uz", "uz", "Uzbek", 1254, -1),
    TT(68, "tt", "tt", "Tatar", 1251, -1),
    BN(69, "bn", "bn", "Bangla", 0, 1),
    PA(70, "pa", "pa", "Punjabi", 0, -1),
    GU(71, "gu", "gu", "Gujarati", 0, -1),
    OR(72, "or", "or", "Odia", 0, -1),
    TA(73, "ta", "ta", "Tamil", 0, -1),
    TE(74, "te", "te", "Telugu", 0, -1),
    KN(75, "kn", "kn", "Kannada", 0, -1),
    ML(76, "ml", "ml", "Malayalam", 0, 1),
    AS(77, "as", "as", "Assamese", 0, -1),
    MR(78, "mr", "mr", "Marathi", 0, -1),
    SA(79, "sa", "sa", "Sanskrit", 0, 1),
    MN(80, "mn", "mn", "Mongolian", 1251, -1),
    BO(81, "bo", "bo", "Tibetan", 0, -1),
    CY(82, "cy", "cy", "Welsh", 1252, -1),
    KM(83, "km", "km", "Khmer", 0, 1),
    LO(84, "lo", "lo", "Lao", 0, 1),
    MY(85, "my", "my", "Burmese", 0, 1),
    GL(86, "gl", "gl", "Galician", 1252, -1),
    KOK(87, "kok", "kok", "Konkani", 0, -1),
    MNI(88, "mni", "mni", "Manipuri", 32759, -1),
    SD(89, "sd", "sd", "Sindhi", 1256, -1),
    SYR(90, "syr", "syr", "Syriac", 0, 1),
    SI(91, "si", "si", "Sinhala", 0, -1),
    CHR(92, "chr", "chr", "Cherokee", 0, 1),
    IU(93, "iu", "iu", "Inuktitut", 1252, 1),
    AM(94, "am", "am", "Amharic", 0, 1),
    TZM(95, "tzm", "tzm", "Tamazight", 1252, -1),
    KS(96, "ks", "ks", "Kashmiri", 32759, -1),
    NE(97, "ne", "ne", "Nepali", 0, 1),
    FY(98, "fy", "fy", "Frisian", 1252, -1),
    PS(99, "ps", "ps", "Pashto", 0, 7),
    FIL(100, "fil", "fil", "Filipino", 1252, 1),
    DV(101, "dv", "dv", "Divehi", 0, 1),
    BIN(102, "bin", "bin", "Edo", 32759, 1),
    FF(103, "ff", "ff", "Fulah", 1252, -1),
    HA(104, "ha", "ha", "Hausa", 1252, -1),
    IBB(105, "ibb", "ibb", "Ibibio", 32759, 1),
    YO(106, "yo", "yo", "Yoruba", 1252, -1),
    QUZ(107, "quz", "quz", "Quechua", 1252, 1),
    NSO(108, "nso", "nso", "Sesotho sa Leboa", 1252, 1),
    BA(109, "ba", "ba", "Bashkir", 1251, -1),
    LB(110, "lb", "lb", "Luxembourgish", 1252, -1),
    KL(111, "kl", "kl", "Greenlandic", 1252, -1),
    IG(112, "ig", "ig", "Igbo", 1252, -1),
    KR(113, "kr", "kr", "Kanuri", 32759, 1),
    OM(114, "om", "om", "Oromo", 0, 1),
    TI(115, "ti", "ti", "Tigrinya", 0, -1),
    GN(116, "gn", "gn", "Guarani", 1252, 1),
    HAW(117, "haw", "haw", "Hawaiian", 1252, 1),
    LA(118, "la", "la", "Latin", 32759, 1),
    SO(119, "so", "so", "Somali", 0, -1),
    II(120, "ii", "ii", "Yi", 0, -1),
    PAP(121, "pap", "pap", "Papiamento", 32759, -1),
    ARN(122, "arn", "arn", "Mapudungun", 1252, 1),
    INVALID_A(123, "invalid_a", "", "", 32759, -1),
    MOH(124, "moh", "moh", "Mohawk", 1252, 1),
    INVALID_B(125, "invalid_b", "", "", 32759, -1),
    BR(126, "br", "br", "Breton", 1252, -1),
    INVALID_C(127, "invalid_c", "", "", 1252, -1),
    UG(128, "ug", "ug", "Uyghur", 1256, -1),
    MI(129, "mi", "mi", "Maori", 0, -1),
    OC(130, "oc", "oc", "Occitan", 1252, -1),
    CO(131, "co", "co", "Corsican", 1252, -1),
    GSW(132, "gsw", "gsw", "Alsatian", 1252, -1),
    SAH(133, "sah", "sah", "Sakha", 1251, -1),
    QUT(134, "qut", "qut", "Guatemala", 1252, -1),
    RW(135, "rw", "rw", "Kinyarwanda", 1252, -1),
    WO(136, "wo", "wo", "Wolof", 1252, -1),
    INVALID_D(137, "invalid_d", "", "", 32759, -1),
    INVALID_E(138, "invalid_e", "", "", 32759, -1),
    INVALID_F(139, "invalid_f", "", "", 32759, -1),
    PRS(140, "prs", "prs", "Dari", 1256, 7),
    INVALID_G(141, "invalid_g", "", "", 32759, -1),
    INVALID_H(142, "invalid_h", "", "", 32759, -1),
    INVALID_I(143, "invalid_i", "", "", 32759, -1),
    INVALID_J(144, "invalid_j", "", "", 32759, -1),
    GD(145, "gd", "gd", "Scottish Gaelic", 1252, -1),
    KU(146, "ku", "ku", "Central Kurdish", 1256, 1),
    QUC(147, "quc", "quc", "K'iche'", 32759, -1),
    AR_SA(1025, "ar_sa", "ar-SA", "Arabic (Saudi Arabia)", 1256, 1),
    BG_BG(1026, "bg_bg", "bg-BG", "Bulgarian (Bulgaria)", 1251, -1),
    CA_ES(1027, "ca_es", "ca-ES", "Catalan (Catalan)", 1252, -1),
    ZH_TW(1028, "zh_tw", "zh-TW", "Chinese (Traditional, Taiwan)", 950, 1),
    CS_CZ(1029, "cs_cz", "cs-CZ", "Czech (Czech Republic)", 1250, -1),
    DA_DK(1030, "da_dk", "da-DK", "Danish (Denmark)", 1252, -1),
    DE_DE(1031, "de_de", "de-DE", "German (Germany)", 1252, -1),
    EL_GR(1032, "el_gr", "el-GR", "Greek (Greece)", 1253, -1),
    EN_US(1033, "en_us", "en-US", "English (United States)", 1252, 1),
    ES_ES_TRADNL(1034, "es_es_tradnl", "es-ES-tradnl", "Spanish (Spain,tradnl)", 1252, -1),
    FI_FI(1035, "fi_fi", "fi-FI", "Finnish (Finland)", 1252, -1),
    FR_FR(1036, "fr_fr", "fr-FR", "French (France)", 1252, -1),
    HE_IL(1037, "he_il", "he-IL", "Hebrew (Israel)", 1255, 1),
    HU_HU(1038, "hu_hu", "hu-HU", "Hungarian (Hungary)", 1250, -1),
    IS_IS(1039, "is_is", "is-IS", "Icelandic (Iceland)", 1252, -1),
    IT_IT(1040, "it_it", "it-IT", "Italian (Italy)", 1252, -1),
    JA_JP(1041, "ja_jp", "ja-JP", "Japanese (Japan)", 932, 1),
    KO_KR(1042, "ko_kr", "ko-KR", "Korean (Korea)", 949, 1),
    NL_NL(1043, "nl_nl", "nl-NL", "Dutch (Netherlands)", 1252, -1),
    NB_NO(1044, "nb_no", "nb-NO", "Norwegian, Bokm\u00e5l (Norway)", 1252, -1),
    PL_PL(1045, "pl_pl", "pl-PL", "Polish (Poland)", 1250, -1),
    PT_BR(1046, "pt_br", "pt-BR", "Portuguese (Brazil)", 1252, 1),
    RM_CH(1047, "rm_ch", "rm-CH", "Romansh (Switzerland)", 1252, -1),
    RO_RO(1048, "ro_ro", "ro-RO", "Romanian (Romania)", 1250, -1),
    RU_RU(1049, "ru_ru", "ru-RU", "Russian (Russia)", 1251, -1),
    HR_HR(1050, "hr_hr", "hr-HR", "Croatian (Croatia)", 1250, -1),
    SK_SK(1051, "sk_sk", "sk-SK", "Slovak (Slovakia)", 1250, -1),
    SQ_AL(1052, "sq_al", "sq-AL", "Albanian (Albania)", 1250, -1),
    SV_SE(1053, "sv_se", "sv-SE", "Swedish (Sweden)", 1252, -1),
    TH_TH(1054, "th_th", "th-TH", "Thai (Thailand)", 874, -1),
    TR_TR(1055, "tr_tr", "tr-TR", "Turkish (Turkey)", 1254, -1),
    UR_PK(1056, "ur_pk", "ur-PK", "Urdu (Islamic Republic of Pakistan)", 1256, -1),
    ID_ID(1057, "id_id", "id-ID", "Indonesian (Indonesia)", 1252, 1),
    UK_UA(1058, "uk_ua", "uk-UA", "Ukrainian (Ukraine)", 1251, -1),
    BE_BY(1059, "be_by", "be-BY", "Belarusian (Belarus)", 1251, -1),
    SL_SI(1060, "sl_si", "sl-SI", "Slovenian (Slovenia)", 1250, -1),
    ET_EE(1061, "et_ee", "et-EE", "Estonian (Estonia)", 1257, -1),
    LV_LV(1062, "lv_lv", "lv-LV", "Latvian (Latvia)", 1257, -1),
    LT_LT(1063, "lt_lt", "lt-LT", "Lithuanian (Lithuania)", 1257, -1),
    TG_CYRL_TJ(1064, "tg_cyrl_tj", "tg-Cyrl-TJ", "Tajik (Cyrillic, Tajikistan)", 1251, -1),
    FA_IR(1065, "fa_ir", "fa-IR", "Persian (Iran)", 1256, 7),
    VI_VN(1066, "vi_vn", "vi-VN", "Vietnamese (Vietnam)", 1258, -1),
    HY_AM(1067, "hy_am", "hy-AM", "Armenian (Armenia)", 0, -1),
    AZ_LATN_AZ(1068, "az_latn_az", "az-Latn-AZ", "Azerbaijani (Latin, Azerbaijan)", 1254, -1),
    EU_ES(1069, "eu_es", "eu-ES", "Basque (Basque)", 1252, -1),
    HSB_DE(1070, "hsb_de", "hsb-DE", "Upper Sorbian (Germany)", 1252, -1),
    MK_MK(1071, "mk_mk", "mk-MK", "Macedonian (Former Yugoslav Republic of Macedonia)", 1251, -1),
    ST_ZA(1072, "st_za", "st-ZA", "Southern Sotho (South Africa)", 0, -1),
    TS_ZA(1073, "ts_za", "ts-ZA", "Tsonga (South Africa)", 0, -1),
    TN_ZA(1074, "tn_za", "tn-ZA", "Setswana (South Africa)", 1252, 1),
    VE_ZA(1075, "ve_za", "ve-ZA", "Venda (South Africa)", 32759, 1),
    XH_ZA(1076, "xh_za", "xh-ZA", "isiXhosa (South Africa)", 1252, 1),
    ZU_ZA(1077, "zu_za", "zu-ZA", "isiZulu (South Africa)", 1252, 1),
    AF_ZA(1078, "af_za", "af-ZA", "Afrikaans (South Africa)", 1252, 1),
    KA_GE(1079, "ka_ge", "ka-GE", "Georgian (Georgia)", 0, -1),
    FO_FO(1080, "fo_fo", "fo-FO", "Faroese (Faroe Islands)", 1252, -1),
    HI_IN(1081, "hi_in", "hi-IN", "Hindi (India)", 0, -1),
    MT_MT(1082, "mt_mt", "mt-MT", "Maltese (Malta)", 0, 1),
    SE_NO(1083, "se_no", "se-NO", "Sami, Northern (Norway)", 1252, -1),
    YI_HEBR(1085, "yi_hebr", "yi-Hebr", "Yiddish (Hebrew)", 32759, -1),
    MS_MY(1086, "ms_my", "ms-MY", "Malay (Malaysia)", 1252, -1),
    KK_KZ(1087, "kk_kz", "kk-KZ", "Kazakh (Kazakhstan)", 0, -1),
    KY_KG(1088, "ky_kg", "ky-KG", "Kyrgyz (Kyrgyzstan)", 1251, -1),
    SW_KE(1089, "sw_ke", "sw-KE", "Kiswahili (Kenya)", 1252, 1),
    TK_TM(1090, "tk_tm", "tk-TM", "Turkmen (Turkmenistan)", 1250, -1),
    UZ_LATN_UZ(1091, "uz_latn_uz", "uz-Latn-UZ", "Uzbek (Latin, Uzbekistan)", 1254, -1),
    TT_RU(1092, "tt_ru", "tt-RU", "Tatar (Russia)", 1251, -1),
    BN_IN(1093, "bn_in", "bn-IN", "Bangla (India)", 0, -1),
    PA_IN(1094, "pa_in", "pa-IN", "Punjabi (India)", 0, -1),
    GU_IN(1095, "gu_in", "gu-IN", "Gujarati (India)", 0, -1),
    OR_IN(1096, "or_in", "or-IN", "Odia (India)", 0, -1),
    TA_IN(1097, "ta_in", "ta-IN", "Tamil (India)", 0, -1),
    TE_IN(1098, "te_in", "te-IN", "Telugu (India)", 0, -1),
    KN_IN(1099, "kn_in", "kn-IN", "Kannada (India)", 0, -1),
    ML_IN(1100, "ml_in", "ml-IN", "Malayalam (India)", 0, 1),
    AS_IN(1101, "as_in", "as-IN", "Assamese (India)", 0, -1),
    MR_IN(1102, "mr_in", "mr-IN", "Marathi (India)", 0, -1),
    SA_IN(1103, "sa_in", "sa-IN", "Sanskrit (India)", 0, 1),
    MN_MN(1104, "mn_mn", "mn-MN", "Mongolian (Cyrillic, Mongolia)", 1251, -1),
    BO_CN(1105, "bo_cn", "bo-CN", "Tibetan (PRC)", 0, -1),
    CY_GB(1106, "cy_gb", "cy-GB", "Welsh (United Kingdom)", 1252, -1),
    KM_KH(1107, "km_kh", "km-KH", "Khmer (Cambodia)", 0, 1),
    LO_LA(1108, "lo_la", "lo-LA", "Lao (Lao P.D.R.)", 0, 1),
    MY_MM(1109, "my_mm", "my-MM", "Burmese (Myanmar)", 0, 1),
    GL_ES(1110, "gl_es", "gl-ES", "Galician (Galician)", 1252, -1),
    KOK_IN(1111, "kok_in", "kok-IN", "Konkani (India)", 0, -1),
    MNI_IN(1112, "mni_in", "mni-IN", "Manipuri (India)", 32759, -1),
    SD_DEVA_IN(1113, "sd_deva_in", "sd-Deva-IN", "Sindhi (Devanagari, India)", 32759, 1),
    SYR_SY(1114, "syr_sy", "syr-SY", "Syriac (Syria)", 0, 1),
    SI_LK(1115, "si_lk", "si-LK", "Sinhala (Sri Lanka)", 0, -1),
    CHR_CHER_US(1116, "chr_cher_us", "chr-Cher-US", "Cherokee (Cherokee)", 0, 1),
    IU_CANS_CA(1117, "iu_cans_ca", "iu-Cans-CA", "Inuktitut (Syllabics, Canada)", 0, 1),
    AM_ET(1118, "am_et", "am-ET", "Amharic (Ethiopia)", 0, 1),
    TZM_ARAB_MA(1119, "tzm_arab_ma", "tzm-Arab-MA", "Central Atlas Tamazight (Arabic, Morocco)", 32759, 7),
    KS_ARAB(1120, "ks_arab", "ks-Arab", "Kashmiri (Perso-Arabic)", 32759, 1),
    NE_NP(1121, "ne_np", "ne-NP", "Nepali (Nepal)", 0, 1),
    FY_NL(1122, "fy_nl", "fy-NL", "Frisian (Netherlands)", 1252, -1),
    PS_AF(1123, "ps_af", "ps-AF", "Pashto (Afghanistan)", 0, 7),
    FIL_PH(1124, "fil_ph", "fil-PH", "Filipino (Philippines)", 1252, 1),
    DV_MV(1125, "dv_mv", "dv-MV", "Divehi (Maldives)", 0, 1),
    BIN_NG(1126, "bin_ng", "bin-NG", "Edo (Nigeria)", 32759, 1),
    FUV_NG(1127, "fuv_ng", "fuv-NG", "fuv (Nigeria)", 32759, -1),
    HA_LATN_NG(1128, "ha_latn_ng", "ha-Latn-NG", "Hausa (Latin, Nigeria)", 1252, -1),
    IBB_NG(1129, "ibb_ng", "ibb-NG", "Ibibio (Nigeria)", 32759, 1),
    YO_NG(1130, "yo_ng", "yo-NG", "Yoruba (Nigeria)", 1252, -1),
    QUZ_BO(1131, "quz_bo", "quz-BO", "Quechua (Bolivia)", 1252, 1),
    NSO_ZA(1132, "nso_za", "nso-ZA", "Sesotho sa Leboa (South Africa)", 1252, 1),
    BA_RU(1133, "ba_ru", "ba-RU", "Bashkir (Russia)", 1251, -1),
    LB_LU(1134, "lb_lu", "lb-LU", "Luxembourgish (Luxembourg)", 1252, -1),
    KL_GL(1135, "kl_gl", "kl-GL", "Greenlandic (Greenland)", 1252, -1),
    IG_NG(1136, "ig_ng", "ig-NG", "Igbo (Nigeria)", 1252, -1),
    KR_NG(1137, "kr_ng", "kr-NG", "Kanuri (Nigeria)", 32759, 1),
    OM_ET(1138, "om_et", "om-ET", "Oromo (Ethiopia)", 0, 1),
    TI_ET(1139, "ti_et", "ti-ET", "Tigrinya (Ethiopia)", 0, 1),
    GN_PY(1140, "gn_py", "gn-PY", "Guarani (Paraguay)", 1252, 1),
    HAW_US(1141, "haw_us", "haw-US", "Hawaiian (United States)", 1252, 1),
    LA_LATN(1142, "la_latn", "la-Latn", "Latin (Latin)", 32759, -1),
    SO_SO(1143, "so_so", "so-SO", "Somali (Somalia)", 0, -1),
    II_CN(1144, "ii_cn", "ii-CN", "Yi (PRC)", 0, -1),
    PAP_029(1145, "pap_029", "pap-029", "Papiamento (Caribbean)", 32759, -1),
    ARN_CL(1146, "arn_cl", "arn-CL", "Mapudungun (Chile)", 1252, 1),
    MOH_CA(1148, "moh_ca", "moh-CA", "Mohawk (Mohawk)", 1252, 1),
    BR_FR(1150, "br_fr", "br-FR", "Breton (France)", 1252, -1),
    UG_CN(1152, "ug_cn", "ug-CN", "Uyghur (PRC)", 1256, -1),
    MI_NZ(1153, "mi_nz", "mi-NZ", "Maori (New Zealand)", 0, -1),
    OC_FR(1154, "oc_fr", "oc-FR", "Occitan (France)", 1252, -1),
    CO_FR(1155, "co_fr", "co-FR", "Corsican (France)", 1252, -1),
    GSW_FR(1156, "gsw_fr", "gsw-FR", "Alsatian (France)", 1252, -1),
    SAH_RU(1157, "sah_ru", "sah-RU", "Sakha (Russia)", 1251, -1),
    QUT_GT(1158, "qut_gt", "qut-GT", "qut (Guatemala)", 1252, -1),
    RW_RW(1159, "rw_rw", "rw-RW", "Kinyarwanda (Rwanda)", 1252, -1),
    WO_SN(1160, "wo_sn", "wo-SN", "Wolof (Senegal)", 1252, -1),
    PRS_AF(1164, "prs_af", "prs-AF", "Dari (Afghanistan)", 1256, 7),
    PLT_MG(1165, "plt_mg", "plt-MG", "plt (Madagascar)", 32759, -1),
    ZH_YUE_HK(1166, "zh_yue_hk", "yue-HK", "yue (Hong Kong)", 32759, -1),
    TDD_TALE_CN(1167, "tdd_tale_cn", "tdd-Tale-CN", "tdd (Tai Le,China)", 32759, -1),
    KHB_TALU_CN(1168, "khb_talu_cn", "khb-Talu-CN", "khb (New Tai Lue,China)", 32759, -1),
    GD_GB(1169, "gd_gb", "gd-GB", "Scottish Gaelic (United Kingdom)", 1252, -1),
    KU_ARAB_IQ(1170, "ku_arab_iq", "ku-Arab-IQ", "Central Kurdish (Iraq)", 1256, 1),
    QUC_CO(1171, "quc_co", "quc-CO", "quc (Colombia)", 32759, -1),
    QPS_PLOC(1281, "qps_ploc", "qps-Ploc", "qps (Ploc)", 1250, -1),
    QPS_PLOCA(1534, "qps_ploca", "qps-ploca", "qps (ploca)", 932, -1),
    AR_IQ(2049, "ar_iq", "ar-IQ", "Arabic (Iraq)", 1256, 7),
    CA_ES_VALENCIA(2051, "ca_es_valencia", "ca-ES-valencia", "Valencian (Spain)", 1252, -1),
    ZH_CN(2052, "zh_cn", "zh-CN", "Chinese (Simplified, PRC)", 936, -1),
    DE_CH(2055, "de_ch", "de-CH", "German (Switzerland)", 1252, -1),
    EN_GB(2057, "en_gb", "en-GB", "English (United Kingdom)", 1252, -1),
    ES_MX(2058, "es_mx", "es-MX", "Spanish (Mexico)", 1252, 1),
    FR_BE(2060, "fr_be", "fr-BE", "French (Belgium)", 1252, -1),
    IT_CH(2064, "it_ch", "it-CH", "Italian (Switzerland)", 1252, -1),
    JA_PLOC_JP(2065, "ja_ploc_jp", "ja-Ploc-JP", "Japanese (Ploc,Japan)", 32759, -1),
    NL_BE(2067, "nl_be", "nl-BE", "Dutch (Belgium)", 1252, -1),
    NN_NO(2068, "nn_no", "nn-NO", "Norwegian, Nynorsk (Norway)", 1252, -1),
    PT_PT(2070, "pt_pt", "pt-PT", "Portuguese (Portugal)", 1252, 1),
    RO_MD(2072, "ro_md", "ro-MD", "Romanian (Moldova)", 0, -1),
    RU_MD(2073, "ru_md", "ru-MD", "Russian (Moldova)", 32759, -1),
    SR_LATN_CS(2074, "sr_latn_cs", "sr-Latn-CS", "Serbian (Latin,Serbia and Montenegro)", 1250, -1),
    SV_FI(2077, "sv_fi", "sv-FI", "Swedish (Finland)", 1252, -1),
    UR_IN(2080, "ur_in", "ur-IN", "Urdu (India)", 0, -1),
    INVALID_K(2087, "invalid_k", "", "", 32759, -1),
    AZ_CYRL_AZ(2092, "az_cyrl_az", "az-Cyrl-AZ", "Azerbaijani (Cyrillic, Azerbaijan)", 1251, -1),
    DSB_DE(2094, "dsb_de", "dsb-DE", "Lower Sorbian (Germany)", 1252, -1),
    TN_BW(2098, "tn_bw", "tn-BW", "Setswana (Botswana)", 1252, 1),
    SE_SE(2107, "se_se", "se-SE", "Sami, Northern (Sweden)", 1252, -1),
    GA_IE(2108, "ga_ie", "ga-IE", "Irish (Ireland)", 1252, 1),
    MS_BN(2110, "ms_bn", "ms-BN", "Malay (Brunei Darussalam)", 1252, -1),
    UZ_CYRL_UZ(2115, "uz_cyrl_uz", "uz-Cyrl-UZ", "Uzbek (Cyrillic, Uzbekistan)", 1251, -1),
    BN_BD(2117, "bn_bd", "bn-BD", "Bangla (Bangladesh)", 0, 1),
    PA_ARAB_PK(2118, "pa_arab_pk", "pa-Arab-PK", "Punjabi (Islamic Republic of Pakistan)", 1256, -1),
    TA_LK(2121, "ta_lk", "ta-LK", "Tamil (Sri Lanka)", 0, -1),
    MN_MONG_CN(2128, "mn_mong_cn", "mn-Mong-CN", "Mongolian (Traditional Mongolian, PRC)", 0, -1),
    BO_BT(2129, "bo_bt", "bo-BT", "Tibetan (Bhutan)", 32759, -1),
    SD_ARAB_PK(2137, "sd_arab_pk", "sd-Arab-PK", "Sindhi (Islamic Republic of Pakistan)", 1256, -1),
    IU_LATN_CA(2141, "iu_latn_ca", "iu-Latn-CA", "Inuktitut (Latin, Canada)", 1252, 1),
    TZM_LATN_DZ(2143, "tzm_latn_dz", "tzm-Latn-DZ", "Tamazight (Latin, Algeria)", 1252, -1),
    KS_DEVA(2144, "ks_deva", "ks-Deva", "Kashmiri (Devanagari)", 32759, -1),
    NE_IN(2145, "ne_in", "ne-IN", "Nepali (India)", 0, 1),
    FF_LATN_SN(2151, "ff_latn_sn", "ff-Latn-SN", "Fulah (Latin, Senegal)", 1252, -1),
    QUZ_EC(2155, "quz_ec", "quz-EC", "Quechua (Ecuador)", 1252, 1),
    TI_ER(2163, "ti_er", "ti-ER", "Tigrinya (Eritrea)", 0, -1),
    QPS_PLOCM(2559, "qps_plocm", "qps-plocm", "qps (plocm)", 1256, -1),
    AR_EG(3073, "ar_eg", "ar-EG", "Arabic (Egypt)", 1256, 7),
    ZH_HK(3076, "zh_hk", "zh-HK", "Chinese (Traditional, Hong Kong S.A.R.)", 950, 1),
    DE_AT(3079, "de_at", "de-AT", "German (Austria)", 1252, -1),
    EN_AU(3081, "en_au", "en-AU", "English (Australia)", 1252, -1),
    ES_ES(3082, "es_es", "es-ES", "Spanish (Spain)", 1252, -1),
    FR_CA(3084, "fr_ca", "fr-CA", "French (Canada)", 1252, 1),
    SR_CYRL_CS(3098, "sr_cyrl_cs", "sr-Cyrl-CS", "Serbian (Cyrillic,Serbia and Montenegro)", 1251, -1),
    SE_FI(3131, "se_fi", "se-FI", "Sami, Northern (Finland)", 1252, -1),
    MN_MONG_MN(3152, "mn_mong_mn", "mn-Mong-MN", "Mongolian (Traditional Mongolian, Mongolia)", 0, -1),
    DZ_BT(3153, "dz_bt", "dz-BT", "Dzongkha (Bhutan)", 0, 1),
    TMZ_MA(3167, "tmz_ma", "tmz-MA", "tmz (Morocco)", 32759, -1),
    QUZ_PE(3179, "quz_pe", "quz-PE", "Quechua (Peru)", 1252, -1),
    AR_LY(4097, "ar_ly", "ar-LY", "Arabic (Libya)", 1256, 7),
    ZH_SG(4100, "zh_sg", "zh-SG", "Chinese (Simplified, Singapore)", 936, 1),
    DE_LU(4103, "de_lu", "de-LU", "German (Luxembourg)", 1252, -1),
    EN_CA(4105, "en_ca", "en-CA", "English (Canada)", 1252, 1),
    ES_GT(4106, "es_gt", "es-GT", "Spanish (Guatemala)", 1252, 1),
    FR_CH(4108, "fr_ch", "fr-CH", "French (Switzerland)", 1252, -1),
    HR_BA(4122, "hr_ba", "hr-BA", "Croatian (Latin, Bosnia and Herzegovina)", 1250, -1),
    SMJ_NO(4155, "smj_no", "smj-NO", "Sami, Lule (Norway)", 1252, -1),
    TZM_TFNG_MA(4191, "tzm_tfng_ma", "tzm-Tfng-MA", "Central Atlas Tamazight (Tifinagh, Morocco)", 0, 7),
    AR_DZ(5121, "ar_dz", "ar-DZ", "Arabic (Algeria)", 1256, 7),
    ZH_MO(5124, "zh_mo", "zh-MO", "Chinese (Traditional, Macao S.A.R.)", 950, 1),
    DE_LI(5127, "de_li", "de-LI", "German (Liechtenstein)", 1252, -1),
    EN_NZ(5129, "en_nz", "en-NZ", "English (New Zealand)", 1252, 1),
    ES_CR(5130, "es_cr", "es-CR", "Spanish (Costa Rica)", 1252, -1),
    FR_LU(5132, "fr_lu", "fr-LU", "French (Luxembourg)", 1252, -1),
    BS_LATN_BA(5146, "bs_latn_ba", "bs-Latn-BA", "Bosnian (Latin, Bosnia and Herzegovina)", 1250, -1),
    SMJ_SE(5179, "smj_se", "smj-SE", "Sami, Lule (Sweden)", 1252, -1),
    AR_MA(6145, "ar_ma", "ar-MA", "Arabic (Morocco)", 1256, -1),
    EN_IE(6153, "en_ie", "en-IE", "English (Ireland)", 1252, 1),
    ES_PA(6154, "es_pa", "es-PA", "Spanish (Panama)", 1252, 1),
    FR_MC(6156, "fr_mc", "fr-MC", "French (Monaco)", 1252, -1),
    SR_LATN_BA(6170, "sr_latn_ba", "sr-Latn-BA", "Serbian (Latin, Bosnia and Herzegovina)", 1250, -1),
    SMA_NO(6203, "sma_no", "sma-NO", "Sami, Southern (Norway)", 1252, -1),
    AR_TN(7169, "ar_tn", "ar-TN", "Arabic (Tunisia)", 1256, -1),
    EN_ZA(7177, "en_za", "en-ZA", "English (South Africa)", 1252, 1),
    ES_DO(7178, "es_do", "es-DO", "Spanish (Dominican Republic)", 1252, 1),
    INVALID_L(7180, "invalid_l", "", "", 32759, -1),
    SR_CYRL_BA(7194, "sr_cyrl_ba", "sr-Cyrl-BA", "Serbian (Cyrillic, Bosnia and Herzegovina)", 1251, -1),
    SMA_SE(7227, "sma_se", "sma-SE", "Sami, Southern (Sweden)", 1252, -1),
    AR_OM(8193, "ar_om", "ar-OM", "Arabic (Oman)", 1256, 1),
    INVALID_M(8200, "invalid_m", "", "", 32759, -1),
    EN_JM(8201, "en_jm", "en-JM", "English (Jamaica)", 1252, 1),
    ES_VE(8202, "es_ve", "es-VE", "Spanish (Venezuela)", 1252, -1),
    FR_RE(8204, "fr_re", "fr-RE", "French (Reunion)", 0, -1),
    BS_CYRL_BA(8218, "bs_cyrl_ba", "bs-Cyrl-BA", "Bosnian (Cyrillic, Bosnia and Herzegovina)", 1251, -1),
    SMS_FI(8251, "sms_fi", "sms-FI", "Sami, Skolt (Finland)", 1252, -1),
    AR_YE(9217, "ar_ye", "ar-YE", "Arabic (Yemen)", 1256, 7),
    EN_029(9225, "en_029", "en-029", "English (Caribbean)", 1252, -1),
    ES_CO(9226, "es_co", "es-CO", "Spanish (Colombia)", 1252, 1),
    FR_CD(9228, "fr_cd", "fr-CD", "French (Congo DRC)", 0, -1),
    SR_LATN_RS(9242, "sr_latn_rs", "sr-Latn-RS", "Serbian (Latin, Serbia)", 1250, -1),
    SMN_FI(9275, "smn_fi", "smn-FI", "Sami, Inari (Finland)", 1252, -1),
    AR_SY(10241, "ar_sy", "ar-SY", "Arabic (Syria)", 1256, 7),
    EN_BZ(10249, "en_bz", "en-BZ", "English (Belize)", 1252, 1),
    ES_PE(10250, "es_pe", "es-PE", "Spanish (Peru)", 1252, 1),
    FR_SN(10252, "fr_sn", "fr-SN", "French (Senegal)", 0, -1),
    SR_CYRL_RS(10266, "sr_cyrl_rs", "sr-Cyrl-RS", "Serbian (Cyrillic, Serbia)", 1251, -1),
    AR_JO(11265, "ar_jo", "ar-JO", "Arabic (Jordan)", 1256, 7),
    EN_TT(11273, "en_tt", "en-TT", "English (Trinidad and Tobago)", 1252, 1),
    ES_AR(11274, "es_ar", "es-AR", "Spanish (Argentina)", 1252, 1),
    FR_CM(11276, "fr_cm", "fr-CM", "French (Cameroon)", 0, -1),
    SR_LATN_ME(11290, "sr_latn_me", "sr-Latn-ME", "Serbian (Latin, Montenegro)", 1250, -1),
    AR_LB(12289, "ar_lb", "ar-LB", "Arabic (Lebanon)", 1256, -1),
    EN_ZW(12297, "en_zw", "en-ZW", "English (Zimbabwe)", 1252, 1),
    ES_EC(12298, "es_ec", "es-EC", "Spanish (Ecuador)", 1252, -1),
    FR_CI(12300, "fr_ci", "fr-CI", "French (C\u00f4te d\u2019Ivoire)", 0, -1),
    SR_CYRL_ME(12314, "sr_cyrl_me", "sr-Cyrl-ME", "Serbian (Cyrillic, Montenegro)", 1251, -1),
    AR_KW(13313, "ar_kw", "ar-KW", "Arabic (Kuwait)", 1256, 7),
    EN_PH(13321, "en_ph", "en-PH", "English (Philippines)", 1252, 1),
    ES_CL(13322, "es_cl", "es-CL", "Spanish (Chile)", 1252, -1),
    FR_ML(13324, "fr_ml", "fr-ML", "French (Mali)", 0, -1),
    AR_AE(14337, "ar_ae", "ar-AE", "Arabic (U.A.E.)", 1256, 7),
    EN_ID(14345, "en_id", "en-ID", "English (Indonesia)", 32759, 1),
    ES_UY(14346, "es_uy", "es-UY", "Spanish (Uruguay)", 1252, -1),
    FR_MA(14348, "fr_ma", "fr-MA", "French (Morocco)", 0, 7),
    AR_BH(15361, "ar_bh", "ar-BH", "Arabic (Bahrain)", 1256, 7),
    EN_HK(15369, "en_hk", "en-HK", "English (Hong Kong SAR)", 0, 1),
    ES_PY(15370, "es_py", "es-PY", "Spanish (Paraguay)", 1252, 1),
    FR_HT(15372, "fr_ht", "fr-HT", "French (Haiti)", 0, -1),
    AR_QA(16385, "ar_qa", "ar-QA", "Arabic (Qatar)", 1256, 7),
    EN_IN(16393, "en_in", "en-IN", "English (India)", 1252, -1),
    ES_BO(16394, "es_bo", "es-BO", "Spanish (Bolivia)", 1252, -1),
    AR_PLOC_SA(17409, "ar_ploc_sa", "ar-Ploc-SA", "Arabic (Ploc,Saudi Arabia)", 32759, -1),
    EN_MY(17417, "en_my", "en-MY", "English (Malaysia)", 1252, 1),
    ES_SV(17418, "es_sv", "es-SV", "Spanish (El Salvador)", 1252, 1),
    AR_145(18433, "ar_145", "ar-145", "Arabic (Western Asia)", 32759, -1),
    EN_SG(18441, "en_sg", "en-SG", "English (Singapore)", 1252, 1),
    ES_HN(18442, "es_hn", "es-HN", "Spanish (Honduras)", 1252, 1),
    EN_AE(19465, "en_ae", "en-AE", "English (United Arab Emirates)", 32759, -1),
    ES_NI(19466, "es_ni", "es-NI", "Spanish (Nicaragua)", 1252, 1),
    EN_BH(20489, "en_bh", "en-BH", "English (Bahrain)", 32759, -1),
    ES_PR(20490, "es_pr", "es-PR", "Spanish (Puerto Rico)", 1252, 1),
    EN_EG(21513, "en_eg", "en-EG", "English (Egypt)", 32759, -1),
    ES_US(21514, "es_us", "es-US", "Spanish (United States)", 1252, 1),
    EN_JO(22537, "en_jo", "en-JO", "English (Jordan)", 32759, -1),
    ES_419(22538, "es_419", "es-419", "Spanish (Latin America)", 0, -1),
    EN_KW(23561, "en_kw", "en-KW", "English (Kuwait)", 32759, -1),
    ES_CU(23562, "es_cu", "es-CU", "Spanish (Cuba)", 0, -1),
    EN_TR(24585, "en_tr", "en-TR", "English (Turkey)", 32759, -1),
    EN_YE(25609, "en_ye", "en-YE", "English (Yemen)", 32759, -1),
    BS_CYRL(25626, "bs_cyrl", "bs-Cyrl", "Bosnian (Cyrillic)", 1251, -1),
    BS_LATN(26650, "bs_latn", "bs-Latn", "Bosnian (Latin)", 1250, -1),
    SR_CYRL(27674, "sr_cyrl", "sr-Cyrl", "Serbian (Cyrillic)", 1251, -1),
    SR_LATN(28698, "sr_latn", "sr-Latn", "Serbian (Latin)", 1250, -1),
    SMN(28731, "smn", "smn", "Sami (Inari)", 1252, -1),
    AZ_CYRL(29740, "az_cyrl", "az-Cyrl", "Azerbaijani (Cyrillic)", 1251, -1),
    SMS(29755, "sms", "sms", "Sami (Skolt)", 1252, -1),
    ZH(30724, "zh", "zh", "Chinese", 936, -1),
    NN(30740, "nn", "nn", "Norwegian (Nynorsk)", 1252, -1),
    BS(30746, "bs", "bs", "Bosnian", 1250, -1),
    AZ_LATN(30764, "az_latn", "az-Latn", "Azerbaijani (Latin)", 1254, -1),
    SMA(30779, "sma", "sma", "Sami (Southern)", 1252, -1),
    UZ_CYRL(30787, "uz_cyrl", "uz-Cyrl", "Uzbek (Cyrillic)", 1251, -1),
    MN_CYRL(30800, "mn_cyrl", "mn-Cyrl", "Mongolian (Cyrillic)", 1251, -1),
    IU_CANS(30813, "iu_cans", "iu-Cans", "Inuktitut (Syllabics)", 0, 1),
    TZM_TFNG(30815, "tzm_tfng", "tzm-Tfng", "Tamazight (Tifinagh)", 0, -1),
    ZH_HANT(31748, "zh_hant", "zh-Hant", "Chinese (Traditional)", 950, 1),
    NB(31764, "nb", "nb", "Norwegian (Bokm\u00e5l)", 1252, -1),
    SR(31770, "sr", "sr", "Serbian", 1250, -1),
    TG_CYRL(31784, "tg_cyrl", "tg-Cyrl", "Tajik (Cyrillic)", 1251, -1),
    DSB(31790, "dsb", "dsb", "Lower Sorbian", 1252, -1),
    SMJ(31803, "smj", "smj", "Sami (Lule)", 1252, -1),
    UZ_LATN(31811, "uz_latn", "uz-Latn", "Uzbek (Latin)", 1254, -1),
    PA_ARAB(31814, "pa_arab", "pa-Arab", "Punjabi (Arabic)", 1256, -1),
    MN_MONG(31824, "mn_mong", "mn-Mong", "Mongolian (Traditional Mongolian)", 0, -1),
    SD_ARAB(31833, "sd_arab", "sd-Arab", "Sindhi (Arabic)", 1256, -1),
    CHR_CHER(31836, "chr_cher", "chr-Cher", "Cherokee (Cherokee)", 0, 1),
    IU_LATN(31837, "iu_latn", "iu-Latn", "Inuktitut (Latin)", 1252, 1),
    TZM_LATN(31839, "tzm_latn", "tzm-Latn", "Tamazight (Latin)", 1252, -1),
    FF_LATN(31847, "ff_latn", "ff-Latn", "Fulah (Latin)", 1252, -1),
    HA_LATN(31848, "ha_latn", "ha-Latn", "Hausa (Latin)", 1252, -1),
    KU_ARAB(31890, "ku_arab", "ku-Arab", "Central Kurdish (Arabic)", 1256, -1),
    INVALID_N(62190, "invalid_n", "", "", 0, -1),
    INVALID_O(61166, "invalid_o", "", "", 0, -1);

    private final int lcid;
    private final String windowsId;
    private final String languageTag;
    private final String description;
    private final int defaultCodepage;
    private final int firstWeekday;
    private static final Map<String, LocaleID> languageTagLookup;
    private static final Map<Integer, LocaleID> lcidLookup;

    private LocaleID(int lcid, String windowsId, String languageTag, String description, int defaultCodepage, int firstWeekday) {
        this.lcid = lcid;
        this.windowsId = windowsId;
        this.languageTag = languageTag;
        this.description = description;
        this.defaultCodepage = defaultCodepage;
        this.firstWeekday = firstWeekday == -1 ? 2 : firstWeekday;
    }

    public int getLcid() {
        return this.lcid;
    }

    public String getWindowsId() {
        return this.windowsId;
    }

    public String getLanguageTag() {
        return this.languageTag;
    }

    public String getDescription() {
        return this.description;
    }

    public int getDefaultCodepage() {
        return this.defaultCodepage;
    }

    public int getFirstWeekday() {
        return this.firstWeekday;
    }

    private boolean isValid() {
        return !this.languageTag.isEmpty();
    }

    public static LocaleID lookupByLanguageTag(String languageTag) {
        return languageTagLookup.get(languageTag);
    }

    public static LocaleID lookupByLcid(int lcid) {
        return lcidLookup.get(lcid);
    }

    static {
        languageTagLookup = Stream.of(LocaleID.values()).filter(LocaleID::isValid).collect(Collectors.toMap(LocaleID::getLanguageTag, Function.identity()));
        lcidLookup = Stream.of(LocaleID.values()).collect(Collectors.toMap(LocaleID::getLcid, Function.identity()));
    }
}

