/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing.operation;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.measure.IncommensurableException;
import javax.measure.Unit;
import javax.measure.quantity.Time;
import org.apache.sis.internal.metadata.AxisDirections;
import org.apache.sis.internal.referencing.CoordinateOperations;
import org.apache.sis.internal.referencing.ReferencingUtilities;
import org.apache.sis.internal.referencing.Resources;
import org.apache.sis.internal.referencing.provider.Affine;
import org.apache.sis.internal.referencing.provider.DatumShiftMethod;
import org.apache.sis.internal.referencing.provider.GeocentricAffine;
import org.apache.sis.internal.referencing.provider.GeocentricToGeographic;
import org.apache.sis.internal.referencing.provider.Geographic2Dto3D;
import org.apache.sis.internal.referencing.provider.Geographic3Dto2D;
import org.apache.sis.internal.referencing.provider.GeographicToGeocentric;
import org.apache.sis.measure.Units;
import org.apache.sis.metadata.iso.citation.Citations;
import org.apache.sis.metadata.iso.extent.Extents;
import org.apache.sis.parameter.TensorParameters;
import org.apache.sis.referencing.CRS;
import org.apache.sis.referencing.CommonCRS;
import org.apache.sis.referencing.IdentifiedObjects;
import org.apache.sis.referencing.NamedIdentifier;
import org.apache.sis.referencing.cs.CoordinateSystems;
import org.apache.sis.referencing.datum.DefaultGeodeticDatum;
import org.apache.sis.referencing.operation.CRSPair;
import org.apache.sis.referencing.operation.CompoundCRSBuilder;
import org.apache.sis.referencing.operation.CoordinateOperationContext;
import org.apache.sis.referencing.operation.CoordinateOperationRegistry;
import org.apache.sis.referencing.operation.DefaultOperationMethod;
import org.apache.sis.referencing.operation.DefaultPassThroughOperation;
import org.apache.sis.referencing.operation.MathTransformContext;
import org.apache.sis.referencing.operation.SubOperationInfo;
import org.apache.sis.referencing.operation.SubTypes;
import org.apache.sis.referencing.operation.matrix.Matrices;
import org.apache.sis.referencing.operation.matrix.MatrixSIS;
import org.apache.sis.referencing.operation.transform.DefaultMathTransformFactory;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.Utilities;
import org.apache.sis.util.resources.Vocabulary;
import org.opengis.metadata.Identifier;
import org.opengis.metadata.extent.GeographicBoundingBox;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.referencing.IdentifiedObject;
import org.opengis.referencing.ReferenceIdentifier;
import org.opengis.referencing.crs.CompoundCRS;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.crs.GeneralDerivedCRS;
import org.opengis.referencing.crs.GeodeticCRS;
import org.opengis.referencing.crs.GeographicCRS;
import org.opengis.referencing.crs.SingleCRS;
import org.opengis.referencing.crs.TemporalCRS;
import org.opengis.referencing.crs.VerticalCRS;
import org.opengis.referencing.cs.AxisDirection;
import org.opengis.referencing.cs.CartesianCS;
import org.opengis.referencing.cs.CoordinateSystem;
import org.opengis.referencing.cs.CoordinateSystemAxis;
import org.opengis.referencing.cs.EllipsoidalCS;
import org.opengis.referencing.cs.TimeCS;
import org.opengis.referencing.cs.VerticalCS;
import org.opengis.referencing.datum.GeodeticDatum;
import org.opengis.referencing.datum.TemporalDatum;
import org.opengis.referencing.datum.VerticalDatum;
import org.opengis.referencing.operation.ConcatenatedOperation;
import org.opengis.referencing.operation.Conversion;
import org.opengis.referencing.operation.CoordinateOperation;
import org.opengis.referencing.operation.CoordinateOperationAuthorityFactory;
import org.opengis.referencing.operation.CoordinateOperationFactory;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.Matrix;
import org.opengis.referencing.operation.NoninvertibleTransformException;
import org.opengis.referencing.operation.OperationMethod;
import org.opengis.referencing.operation.OperationNotFoundException;
import org.opengis.referencing.operation.SingleOperation;
import org.opengis.referencing.operation.Transformation;
import org.opengis.util.FactoryException;

public class CoordinateOperationFinder
extends CoordinateOperationRegistry {
    private final Map<Identifier, Object> identifierOfStepCRS = new HashMap<Identifier, Object>(8);
    private final Map<CRSPair, Boolean> previousSearches = new HashMap<CRSPair, Boolean>(8);
    private final boolean useCache;

    public CoordinateOperationFinder(CoordinateOperationAuthorityFactory coordinateOperationAuthorityFactory, CoordinateOperationFactory coordinateOperationFactory, CoordinateOperationContext coordinateOperationContext) throws FactoryException {
        super(coordinateOperationAuthorityFactory, coordinateOperationFactory, coordinateOperationContext);
        this.useCache = coordinateOperationContext == null && coordinateOperationFactory == this.factorySIS;
    }

    @Override
    public CoordinateOperation createOperation(CoordinateReferenceSystem coordinateReferenceSystem, CoordinateReferenceSystem coordinateReferenceSystem2) throws OperationNotFoundException, FactoryException {
        CoordinateOperation coordinateOperation;
        CoordinateOperation coordinateOperation2;
        ArgumentChecks.ensureNonNull("sourceCRS", coordinateReferenceSystem);
        ArgumentChecks.ensureNonNull("targetCRS", coordinateReferenceSystem2);
        if (Utilities.equalsIgnoreMetadata(coordinateReferenceSystem, coordinateReferenceSystem2)) {
            try {
                return this.createFromAffineTransform(AXIS_CHANGES, coordinateReferenceSystem, coordinateReferenceSystem2, CoordinateSystems.swapAndScaleAxes(coordinateReferenceSystem.getCoordinateSystem(), coordinateReferenceSystem2.getCoordinateSystem()));
            }
            catch (IllegalArgumentException | IncommensurableException exception) {
                throw new FactoryException(Resources.format((short)5, new CRSPair(coordinateReferenceSystem, coordinateReferenceSystem2)), (Throwable)exception);
            }
        }
        CRSPair cRSPair = new CRSPair(coordinateReferenceSystem, coordinateReferenceSystem2);
        if (this.useCache && !this.previousSearches.isEmpty() && (coordinateOperation2 = this.factorySIS.cache.peek(cRSPair)) != null) {
            return coordinateOperation2;
        }
        if (this.previousSearches.put(cRSPair, Boolean.TRUE) != null) {
            throw new FactoryException(Resources.format((short)62, CoordinateOperation.class, cRSPair));
        }
        for (CoordinateOperation coordinateOperation3 : this.factorySIS.getSpecializedFactories()) {
            for (CoordinateOperation coordinateOperation4 : coordinateOperation3.findOperations(coordinateReferenceSystem, coordinateReferenceSystem2)) {
                if (!this.filter(coordinateOperation4)) continue;
                return coordinateOperation4;
            }
        }
        coordinateOperation2 = Extents.getGeographicBoundingBox(this.areaOfInterest);
        if (coordinateOperation2 == null) {
            coordinateOperation2 = Extents.intersection(CRS.getGeographicBoundingBox(coordinateReferenceSystem), CRS.getGeographicBoundingBox(coordinateReferenceSystem2));
            this.areaOfInterest = CoordinateOperationContext.setGeographicBoundingBox(this.areaOfInterest, (GeographicBoundingBox)coordinateOperation2);
        }
        if (this.registry != null && (coordinateOperation = super.createOperation(coordinateReferenceSystem, coordinateReferenceSystem2)) != null) {
            return coordinateOperation;
        }
        if (coordinateReferenceSystem instanceof GeneralDerivedCRS) {
            GeneralDerivedCRS generalDerivedCRS = (GeneralDerivedCRS)coordinateReferenceSystem;
            if (coordinateReferenceSystem2 instanceof GeneralDerivedCRS) {
                return this.createOperationStep(generalDerivedCRS, (GeneralDerivedCRS)coordinateReferenceSystem2);
            }
            if (coordinateReferenceSystem2 instanceof SingleCRS) {
                return this.createOperationStep(generalDerivedCRS, (SingleCRS)coordinateReferenceSystem2);
            }
        }
        if (coordinateReferenceSystem2 instanceof GeneralDerivedCRS) {
            GeneralDerivedCRS generalDerivedCRS = (GeneralDerivedCRS)coordinateReferenceSystem2;
            if (coordinateReferenceSystem instanceof SingleCRS) {
                return this.createOperationStep((SingleCRS)coordinateReferenceSystem, generalDerivedCRS);
            }
        }
        if (coordinateReferenceSystem instanceof GeodeticCRS) {
            GeodeticCRS geodeticCRS = (GeodeticCRS)coordinateReferenceSystem;
            if (coordinateReferenceSystem2 instanceof GeodeticCRS) {
                return this.createOperationStep(geodeticCRS, (GeodeticCRS)coordinateReferenceSystem2);
            }
            if (coordinateReferenceSystem2 instanceof VerticalCRS) {
                return this.createOperationStep(geodeticCRS, (VerticalCRS)coordinateReferenceSystem2);
            }
        }
        if (coordinateReferenceSystem instanceof VerticalCRS) {
            VerticalCRS verticalCRS = (VerticalCRS)coordinateReferenceSystem;
            if (coordinateReferenceSystem2 instanceof VerticalCRS) {
                return this.createOperationStep(verticalCRS, (VerticalCRS)coordinateReferenceSystem2);
            }
        }
        if (coordinateReferenceSystem instanceof TemporalCRS) {
            TemporalCRS temporalCRS = (TemporalCRS)coordinateReferenceSystem;
            if (coordinateReferenceSystem2 instanceof TemporalCRS) {
                return this.createOperationStep(temporalCRS, (TemporalCRS)coordinateReferenceSystem2);
            }
        }
        if (coordinateReferenceSystem instanceof CompoundCRS || coordinateReferenceSystem2 instanceof CompoundCRS) {
            return this.createOperationStep(coordinateReferenceSystem, CRS.getSingleComponents(coordinateReferenceSystem), coordinateReferenceSystem2, CRS.getSingleComponents(coordinateReferenceSystem2));
        }
        throw new OperationNotFoundException(CoordinateOperationFinder.notFoundMessage((IdentifiedObject)coordinateReferenceSystem, (IdentifiedObject)coordinateReferenceSystem2));
    }

    protected CoordinateOperation createOperationStep(SingleCRS singleCRS, GeneralDerivedCRS generalDerivedCRS) throws FactoryException {
        CoordinateOperation coordinateOperation = this.createOperation((CoordinateReferenceSystem)singleCRS, generalDerivedCRS.getBaseCRS());
        Conversion conversion = generalDerivedCRS.getConversionFromBase();
        return this.concatenate(coordinateOperation, (CoordinateOperation)conversion);
    }

    protected CoordinateOperation createOperationStep(GeneralDerivedCRS generalDerivedCRS, SingleCRS singleCRS) throws FactoryException {
        CoordinateOperation coordinateOperation;
        CoordinateOperation coordinateOperation2 = this.createOperation(generalDerivedCRS.getBaseCRS(), (CoordinateReferenceSystem)singleCRS);
        try {
            coordinateOperation = this.inverse((SingleOperation)generalDerivedCRS.getConversionFromBase());
        }
        catch (OperationNotFoundException operationNotFoundException) {
            throw operationNotFoundException;
        }
        catch (NoninvertibleTransformException | FactoryException throwable) {
            throw new OperationNotFoundException(CoordinateOperationFinder.canNotInvert(generalDerivedCRS), throwable);
        }
        return this.concatenate(coordinateOperation, coordinateOperation2);
    }

    protected CoordinateOperation createOperationStep(GeneralDerivedCRS generalDerivedCRS, GeneralDerivedCRS generalDerivedCRS2) throws FactoryException {
        CoordinateOperation coordinateOperation;
        CoordinateOperation coordinateOperation2 = this.createOperation(generalDerivedCRS.getBaseCRS(), generalDerivedCRS2.getBaseCRS());
        Conversion conversion = generalDerivedCRS2.getConversionFromBase();
        try {
            coordinateOperation = this.inverse((SingleOperation)generalDerivedCRS.getConversionFromBase());
        }
        catch (OperationNotFoundException operationNotFoundException) {
            throw operationNotFoundException;
        }
        catch (NoninvertibleTransformException | FactoryException throwable) {
            throw new OperationNotFoundException(CoordinateOperationFinder.canNotInvert(generalDerivedCRS), throwable);
        }
        return this.concatenate(coordinateOperation, coordinateOperation2, (CoordinateOperation)conversion);
    }

    protected CoordinateOperation createOperationStep(GeodeticCRS geodeticCRS, GeodeticCRS geodeticCRS2) throws FactoryException {
        OperationMethod operationMethod;
        ParameterValueGroup parameterValueGroup;
        DatumShiftMethod datumShiftMethod;
        Identifier identifier;
        GeodeticDatum geodeticDatum = geodeticCRS.getDatum();
        GeodeticDatum geodeticDatum2 = geodeticCRS2.getDatum();
        Matrix matrix = null;
        DefaultMathTransformFactory.Context context = ReferencingUtilities.createTransformContext((CoordinateReferenceSystem)geodeticCRS, (CoordinateReferenceSystem)geodeticCRS2, new MathTransformContext(geodeticDatum, geodeticDatum2));
        boolean bl = false;
        CoordinateSystem coordinateSystem = context.getSourceCS();
        CoordinateSystem coordinateSystem2 = context.getTargetCS();
        if (Utilities.equalsIgnoreMetadata(geodeticDatum, geodeticDatum2)) {
            boolean bl2;
            bl = coordinateSystem instanceof EllipsoidalCS && coordinateSystem2 instanceof CartesianCS;
            boolean bl3 = bl2 = coordinateSystem instanceof CartesianCS && coordinateSystem2 instanceof EllipsoidalCS;
            identifier = bl2 ^ bl ? GEOCENTRIC_CONVERSION : AXIS_CHANGES;
        } else {
            identifier = ELLIPSOID_CHANGE;
            if (geodeticDatum instanceof DefaultGeodeticDatum && (matrix = ((DefaultGeodeticDatum)geodeticDatum).getPositionVectorTransformation(geodeticDatum2, this.areaOfInterest)) != null) {
                identifier = DATUM_SHIFT;
            }
        }
        DefaultMathTransformFactory defaultMathTransformFactory = this.factorySIS.getDefaultMathTransformFactory();
        MathTransform mathTransform = null;
        MathTransform mathTransform2 = null;
        if (identifier == DATUM_SHIFT || identifier == ELLIPSOID_CHANGE) {
            datumShiftMethod = DatumShiftMethod.forAccuracy(this.desiredAccuracy);
            parameterValueGroup = GeocentricAffine.createParameters(coordinateSystem, coordinateSystem2, matrix, datumShiftMethod);
            if (parameterValueGroup == null) {
                parameterValueGroup = matrix != null ? TensorParameters.WKT1.createValueGroup(CoordinateOperationFinder.properties("Affine"), matrix) : Affine.identity(3);
                operationMethod = CommonCRS.WGS84.geocentric().getCoordinateSystem();
                mathTransform = defaultMathTransformFactory.createCoordinateSystemChange(coordinateSystem, (CoordinateSystem)operationMethod, geodeticDatum.getEllipsoid());
                mathTransform2 = defaultMathTransformFactory.createCoordinateSystemChange((CoordinateSystem)operationMethod, coordinateSystem2, geodeticDatum2.getEllipsoid());
                context.setSource((CoordinateSystem)operationMethod);
                context.setTarget((CoordinateSystem)operationMethod);
            }
        } else if (identifier == GEOCENTRIC_CONVERSION) {
            parameterValueGroup = (bl ? GeographicToGeocentric.PARAMETERS : GeocentricToGeographic.PARAMETERS).createValue();
        } else {
            int n = coordinateSystem.getDimension();
            int n2 = coordinateSystem2.getDimension();
            if ((n & 0xFFFFFFFE) == 2 && (n ^ n2) == 1 && coordinateSystem instanceof EllipsoidalCS && coordinateSystem2 instanceof EllipsoidalCS) {
                parameterValueGroup = (n == 2 ? Geographic2Dto3D.PARAMETERS : Geographic3Dto2D.PARAMETERS).createValue();
            } else {
                parameterValueGroup = Affine.identity(n2);
                mathTransform = defaultMathTransformFactory.createCoordinateSystemChange(coordinateSystem, coordinateSystem2, (coordinateSystem instanceof EllipsoidalCS ? geodeticDatum : geodeticDatum2).getEllipsoid());
                context.setSource(coordinateSystem2);
            }
        }
        datumShiftMethod = defaultMathTransformFactory.createParameterizedTransform(parameterValueGroup, context);
        operationMethod = defaultMathTransformFactory.getLastMethodUsed();
        if (mathTransform != null) {
            datumShiftMethod = defaultMathTransformFactory.createConcatenatedTransform(mathTransform, (MathTransform)datumShiftMethod);
            if (mathTransform2 != null) {
                datumShiftMethod = defaultMathTransformFactory.createConcatenatedTransform((MathTransform)datumShiftMethod, mathTransform2);
            }
        }
        return this.createFromMathTransform(CoordinateOperationFinder.properties(identifier), (CoordinateReferenceSystem)geodeticCRS, (CoordinateReferenceSystem)geodeticCRS2, (MathTransform)datumShiftMethod, operationMethod, parameterValueGroup, null);
    }

    protected CoordinateOperation createOperationStep(GeodeticCRS geodeticCRS, VerticalCRS verticalCRS) throws FactoryException {
        boolean bl;
        int n;
        CoordinateSystemAxis coordinateSystemAxis;
        EllipsoidalCS ellipsoidalCS;
        CoordinateOperation coordinateOperation = null;
        CoordinateOperation coordinateOperation2 = null;
        GeodeticCRS geodeticCRS2 = geodeticCRS;
        CoordinateSystem coordinateSystem = geodeticCRS2.getCoordinateSystem();
        if (!(coordinateSystem instanceof EllipsoidalCS) && !Utilities.equalsIgnoreMetadata(coordinateSystem, ellipsoidalCS = CommonCRS.WGS84.geographic3D().getCoordinateSystem())) {
            coordinateSystemAxis = this.factorySIS.getCRSFactory().createGeographicCRS(this.derivedFrom((IdentifiedObject)geodeticCRS), geodeticCRS.getDatum(), ellipsoidalCS);
            coordinateOperation = this.createOperation((CoordinateReferenceSystem)geodeticCRS, (CoordinateReferenceSystem)this.toAuthorityDefinition(GeographicCRS.class, coordinateSystemAxis));
            geodeticCRS2 = coordinateOperation.getTargetCRS();
            coordinateSystem = geodeticCRS2.getCoordinateSystem();
        }
        if ((n = AxisDirections.indexOfColinear(coordinateSystem, AxisDirection.UP)) < 0) {
            throw new OperationNotFoundException(CoordinateOperationFinder.notFoundMessage((IdentifiedObject)geodeticCRS, (IdentifiedObject)verticalCRS));
        }
        coordinateSystemAxis = coordinateSystem.getAxis(n);
        VerticalCRS verticalCRS2 = verticalCRS;
        VerticalCS verticalCS = verticalCRS2.getCoordinateSystem();
        if (Utilities.equalsIgnoreMetadata(verticalCS.getAxis(0), coordinateSystemAxis)) {
            bl = ReferencingUtilities.isEllipsoidalHeight(verticalCRS2.getDatum());
        } else {
            verticalCRS2 = CommonCRS.Vertical.ELLIPSOIDAL.crs();
            verticalCS = verticalCRS2.getCoordinateSystem();
            bl = Utilities.equalsIgnoreMetadata(verticalCS.getAxis(0), coordinateSystemAxis);
            if (!bl) {
                verticalCS = this.toAuthorityDefinition(VerticalCS.class, this.factorySIS.getCSFactory().createVerticalCS(this.derivedFrom((IdentifiedObject)verticalCS), coordinateSystemAxis));
            }
        }
        if (!bl) {
            verticalCRS2 = this.toAuthorityDefinition(VerticalCRS.class, this.factorySIS.getCRSFactory().createVerticalCRS(this.derivedFrom((IdentifiedObject)verticalCRS2), CommonCRS.Vertical.ELLIPSOIDAL.datum(), verticalCS));
        }
        if (verticalCRS2 != verticalCRS) {
            coordinateOperation2 = this.createOperation((CoordinateReferenceSystem)verticalCRS2, (CoordinateReferenceSystem)verticalCRS);
            verticalCRS2 = (VerticalCRS)coordinateOperation2.getSourceCRS();
            verticalCS = verticalCRS2.getCoordinateSystem();
        }
        int n2 = coordinateSystem.getDimension();
        int n3 = verticalCS.getDimension();
        MatrixSIS matrixSIS = Matrices.createZero(n3 + 1, n2 + 1);
        matrixSIS.setElement(0, n, 1.0);
        matrixSIS.setElement(n3, n2, 1.0);
        CoordinateOperation coordinateOperation3 = this.createFromAffineTransform(AXIS_CHANGES, (CoordinateReferenceSystem)geodeticCRS2, (CoordinateReferenceSystem)verticalCRS2, matrixSIS);
        return this.concatenate(coordinateOperation, coordinateOperation3, coordinateOperation2);
    }

    protected CoordinateOperation createOperationStep(VerticalCRS verticalCRS, VerticalCRS verticalCRS2) throws FactoryException {
        Matrix matrix;
        VerticalDatum verticalDatum;
        VerticalDatum verticalDatum2 = verticalCRS.getDatum();
        if (!Utilities.equalsIgnoreMetadata(verticalDatum2, verticalDatum = verticalCRS2.getDatum())) {
            throw new OperationNotFoundException(CoordinateOperationFinder.notFoundMessage((IdentifiedObject)verticalDatum2, (IdentifiedObject)verticalDatum));
        }
        VerticalCS verticalCS = verticalCRS.getCoordinateSystem();
        VerticalCS verticalCS2 = verticalCRS2.getCoordinateSystem();
        try {
            matrix = CoordinateSystems.swapAndScaleAxes((CoordinateSystem)verticalCS, (CoordinateSystem)verticalCS2);
        }
        catch (IllegalArgumentException | IncommensurableException exception) {
            throw new OperationNotFoundException(CoordinateOperationFinder.notFoundMessage((IdentifiedObject)verticalCRS, (IdentifiedObject)verticalCRS2), (Throwable)exception);
        }
        return this.createFromAffineTransform(AXIS_CHANGES, (CoordinateReferenceSystem)verticalCRS, (CoordinateReferenceSystem)verticalCRS2, matrix);
    }

    protected CoordinateOperation createOperationStep(TemporalCRS temporalCRS, TemporalCRS temporalCRS2) throws FactoryException {
        Matrix matrix;
        TemporalDatum temporalDatum = temporalCRS.getDatum();
        TemporalDatum temporalDatum2 = temporalCRS2.getDatum();
        TimeCS timeCS = temporalCRS.getCoordinateSystem();
        TimeCS timeCS2 = temporalCRS2.getCoordinateSystem();
        Unit<Time> unit = timeCS2.getAxis(0).getUnit().asType(Time.class);
        double d = temporalDatum.getOrigin().getTime() - temporalDatum2.getOrigin().getTime();
        d = Units.MILLISECOND.getConverterTo(unit).convert(d);
        try {
            matrix = CoordinateSystems.swapAndScaleAxes((CoordinateSystem)timeCS, (CoordinateSystem)timeCS2);
        }
        catch (IllegalArgumentException | IncommensurableException exception) {
            throw new OperationNotFoundException(CoordinateOperationFinder.notFoundMessage((IdentifiedObject)temporalCRS, (IdentifiedObject)temporalCRS2), (Throwable)exception);
        }
        int n = matrix.getNumCol() - 1;
        double d2 = matrix.getElement(0, n);
        matrix.setElement(0, n, d2 + d);
        return this.createFromAffineTransform(AXIS_CHANGES, (CoordinateReferenceSystem)temporalCRS, (CoordinateReferenceSystem)temporalCRS2, matrix);
    }

    protected CoordinateOperation createOperationStep(CoordinateReferenceSystem coordinateReferenceSystem, List<? extends SingleCRS> list, CoordinateReferenceSystem coordinateReferenceSystem2, List<? extends SingleCRS> list2) throws FactoryException {
        CoordinateOperation coordinateOperation;
        CoordinateReferenceSystem coordinateReferenceSystem3;
        int n;
        Matrix matrix = new SubOperationInfo[list2.size()];
        boolean[] blArray = new boolean[list.size()];
        CoordinateReferenceSystem[] coordinateReferenceSystemArray = new CoordinateReferenceSystem[((SubOperationInfo[])matrix).length];
        for (n = 0; n < ((SubOperationInfo[])matrix).length; ++n) {
            matrix[n] = SubOperationInfo.create(this, blArray, list, list2.get(n));
            if (matrix[n] == null) {
                throw new OperationNotFoundException(CoordinateOperationFinder.notFoundMessage((IdentifiedObject)coordinateReferenceSystem, (IdentifiedObject)coordinateReferenceSystem2));
            }
            coordinateReferenceSystemArray[n] = matrix[n].operation.getSourceCRS();
        }
        n = 0;
        for (SubOperationInfo subOperationInfo : matrix) {
            n += subOperationInfo.endAtDimension - subOperationInfo.startAtDimension;
        }
        Matrix matrix2 = SubOperationInfo.sourceToSelected(coordinateReferenceSystem.getCoordinateSystem().getDimension(), n, (SubOperationInfo[])matrix);
        if (matrix2.isIdentity()) {
            coordinateReferenceSystem3 = coordinateReferenceSystem;
            coordinateOperation = null;
        } else {
            coordinateReferenceSystem3 = coordinateReferenceSystemArray.length == 1 ? coordinateReferenceSystemArray[0] : (CoordinateReferenceSystem)this.toAuthorityDefinition(CoordinateReferenceSystem.class, this.factorySIS.getCRSFactory().createCompoundCRS(this.derivedFrom((IdentifiedObject)coordinateReferenceSystem), coordinateReferenceSystemArray));
            coordinateOperation = this.createFromAffineTransform(AXIS_CHANGES, coordinateReferenceSystem, coordinateReferenceSystem3, matrix2);
        }
        int n2 = 0;
        int n3 = SubOperationInfo.startOfIdentity((SubOperationInfo[])matrix);
        for (int i = 0; i < coordinateReferenceSystemArray.length; ++i) {
            CoordinateReferenceSystem coordinateReferenceSystem4 = coordinateReferenceSystemArray[i];
            CoordinateReferenceSystem coordinateReferenceSystem5 = (CoordinateReferenceSystem)list2.get(i);
            CoordinateOperation coordinateOperation2 = matrix[i].operation;
            MathTransform mathTransform = coordinateOperation2.getMathTransform();
            coordinateReferenceSystemArray[i] = coordinateReferenceSystem5;
            CoordinateReferenceSystem coordinateReferenceSystem6 = i >= n3 ? coordinateReferenceSystem2 : (mathTransform.isIdentity() ? coordinateReferenceSystem3 : (coordinateReferenceSystemArray.length == 1 ? coordinateReferenceSystem5 : this.toAuthorityDefinition(CoordinateReferenceSystem.class, new CompoundCRSBuilder(this.factory, this.factorySIS).createCompoundCRS(this.derivedFrom((IdentifiedObject)coordinateReferenceSystem5), coordinateReferenceSystemArray))));
            int n4 = coordinateReferenceSystem4.getCoordinateSystem().getDimension();
            int n5 = n2;
            if (n5 != 0 || (n2 += n4) != n) {
                Map<String, ?> map = IdentifiedObjects.getProperties((IdentifiedObject)coordinateOperation2, new String[0]);
                SingleOperation singleOperation = SubTypes.isSingleOperation(coordinateOperation2) ? (SingleOperation)coordinateOperation2 : this.factorySIS.createSingleOperation(map, coordinateOperation2.getSourceCRS(), coordinateOperation2.getTargetCRS(), null, new DefaultOperationMethod(mathTransform), mathTransform);
                coordinateOperation2 = new DefaultPassThroughOperation(map, coordinateReferenceSystem3, coordinateReferenceSystem6, singleOperation, n5, n - n2);
            }
            coordinateOperation = this.concatenate(coordinateOperation, coordinateOperation2);
            coordinateReferenceSystem3 = coordinateReferenceSystem6;
            n2 -= (n4 -= coordinateReferenceSystem5.getCoordinateSystem().getDimension());
            n -= n4;
        }
        return coordinateOperation;
    }

    private CoordinateOperation createFromAffineTransform(Identifier identifier, CoordinateReferenceSystem coordinateReferenceSystem, CoordinateReferenceSystem coordinateReferenceSystem2, Matrix matrix) throws FactoryException {
        MathTransform mathTransform = this.factorySIS.getMathTransformFactory().createAffineTransform(matrix);
        return this.createFromMathTransform(CoordinateOperationFinder.properties(identifier), coordinateReferenceSystem, coordinateReferenceSystem2, mathTransform, null, null, null);
    }

    private CoordinateOperation concatenate(CoordinateOperation coordinateOperation, CoordinateOperation coordinateOperation2) throws FactoryException {
        Object object;
        if (CoordinateOperationFinder.isIdentity(coordinateOperation)) {
            return coordinateOperation2;
        }
        if (CoordinateOperationFinder.isIdentity(coordinateOperation2)) {
            return coordinateOperation;
        }
        MathTransform mathTransform = coordinateOperation.getMathTransform();
        MathTransform mathTransform2 = coordinateOperation2.getMathTransform();
        CoordinateReferenceSystem coordinateReferenceSystem = coordinateOperation.getSourceCRS();
        CoordinateReferenceSystem coordinateReferenceSystem2 = coordinateOperation2.getTargetCRS();
        CoordinateOperation coordinateOperation3 = null;
        boolean bl = CoordinateOperationFinder.canHide((Identifier)coordinateOperation.getName());
        boolean bl2 = CoordinateOperationFinder.canHide((Identifier)coordinateOperation2.getName());
        if (bl && bl2 && CoordinateOperationFinder.isAffine(coordinateOperation) && CoordinateOperationFinder.isAffine(coordinateOperation2)) {
            coordinateOperation3 = coordinateOperation2;
            if (coordinateOperation3.getName() == IDENTITY && coordinateOperation.getName() != IDENTITY) {
                coordinateOperation3 = coordinateOperation;
            }
        } else {
            if (bl && mathTransform.getSourceDimensions() == mathTransform.getTargetDimensions()) {
                coordinateOperation3 = coordinateOperation2;
            }
            if (bl2 && mathTransform2.getSourceDimensions() == mathTransform2.getTargetDimensions()) {
                coordinateOperation3 = coordinateOperation;
            }
        }
        if (SubTypes.isSingleOperation(coordinateOperation3)) {
            object = (SingleOperation)coordinateOperation3;
            MathTransform mathTransform3 = this.factorySIS.getMathTransformFactory().createConcatenatedTransform(mathTransform, mathTransform2);
            coordinateOperation3 = this.createFromMathTransform(new HashMap<String, Object>(IdentifiedObjects.getProperties((IdentifiedObject)coordinateOperation3, new String[0])), coordinateReferenceSystem, coordinateReferenceSystem2, mathTransform3, object.getMethod(), object.getParameterValues(), coordinateOperation3 instanceof Transformation ? Transformation.class : (coordinateOperation3 instanceof Conversion ? Conversion.class : SingleOperation.class));
        } else {
            coordinateOperation3 = this.factory.createConcatenatedOperation(CoordinateOperationFinder.defaultName(coordinateReferenceSystem, coordinateReferenceSystem2), new CoordinateOperation[]{coordinateOperation, coordinateOperation2});
        }
        if (coordinateOperation3 instanceof ConcatenatedOperation && coordinateOperation3.getMathTransform().isIdentity()) {
            object = null;
            for (CoordinateOperation coordinateOperation4 : ((ConcatenatedOperation)coordinateOperation3).getOperations()) {
                if (!(coordinateOperation4 instanceof Transformation)) continue;
                object = Transformation.class;
                break;
            }
            coordinateOperation3 = this.createFromMathTransform(new HashMap<String, Object>(IdentifiedObjects.getProperties((IdentifiedObject)coordinateOperation3, new String[0])), coordinateOperation3.getSourceCRS(), coordinateOperation3.getTargetCRS(), coordinateOperation3.getMathTransform(), null, null, (Class<? extends CoordinateOperation>)object);
        }
        return coordinateOperation3;
    }

    private CoordinateOperation concatenate(CoordinateOperation coordinateOperation, CoordinateOperation coordinateOperation2, CoordinateOperation coordinateOperation3) throws FactoryException {
        if (CoordinateOperationFinder.isIdentity(coordinateOperation)) {
            return this.concatenate(coordinateOperation2, coordinateOperation3);
        }
        if (CoordinateOperationFinder.isIdentity(coordinateOperation2)) {
            return this.concatenate(coordinateOperation, coordinateOperation3);
        }
        if (CoordinateOperationFinder.isIdentity(coordinateOperation3)) {
            return this.concatenate(coordinateOperation, coordinateOperation2);
        }
        if (CoordinateOperationFinder.canHide((Identifier)coordinateOperation.getName())) {
            return this.concatenate(this.concatenate(coordinateOperation, coordinateOperation2), coordinateOperation3);
        }
        if (CoordinateOperationFinder.canHide((Identifier)coordinateOperation3.getName())) {
            return this.concatenate(coordinateOperation, this.concatenate(coordinateOperation2, coordinateOperation3));
        }
        Map<String, ?> map = CoordinateOperationFinder.defaultName(coordinateOperation.getSourceCRS(), coordinateOperation3.getTargetCRS());
        return this.factory.createConcatenatedOperation(map, new CoordinateOperation[]{coordinateOperation, coordinateOperation2, coordinateOperation3});
    }

    private static boolean isAffine(CoordinateOperation coordinateOperation) {
        return coordinateOperation instanceof SingleOperation && IdentifiedObjects.isHeuristicMatchForName((IdentifiedObject)((SingleOperation)coordinateOperation).getMethod(), "Affine");
    }

    private static boolean isIdentity(CoordinateOperation coordinateOperation) {
        if (coordinateOperation == null) {
            return true;
        }
        if (coordinateOperation instanceof Conversion && coordinateOperation.getMathTransform().isIdentity()) {
            return CoordinateOperations.wrapAroundChanges(coordinateOperation).isEmpty();
        }
        return false;
    }

    private static boolean canHide(Identifier identifier) {
        return identifier == AXIS_CHANGES || identifier == IDENTITY;
    }

    private static Map<String, ?> properties(String string) {
        return Collections.singletonMap("name", string);
    }

    private Map<String, ?> derivedFrom(IdentifiedObject identifiedObject) {
        ReferenceIdentifier referenceIdentifier = identifiedObject.getName();
        Object object = this.identifierOfStepCRS.get(referenceIdentifier);
        if (object instanceof Identifier) {
            referenceIdentifier = (Identifier)object;
            object = this.identifierOfStepCRS.get(referenceIdentifier);
        }
        int n = object != null ? (Integer)object + 1 : 1;
        NamedIdentifier namedIdentifier = new NamedIdentifier(Citations.SIS, referenceIdentifier.getCode() + " (step " + n + ')');
        this.identifierOfStepCRS.put((Identifier)namedIdentifier, referenceIdentifier);
        this.identifierOfStepCRS.put((Identifier)referenceIdentifier, n);
        HashMap<String, NamedIdentifier> hashMap = new HashMap<String, NamedIdentifier>(4);
        hashMap.put("name", namedIdentifier);
        hashMap.put("remarks", (NamedIdentifier)Vocabulary.formatInternational((short)30, (Object)CRSPair.label(identifiedObject)));
        return hashMap;
    }

    private static Map<String, ?> defaultName(CoordinateReferenceSystem coordinateReferenceSystem, CoordinateReferenceSystem coordinateReferenceSystem2) {
        return CoordinateOperationFinder.properties(new CRSPair(coordinateReferenceSystem, coordinateReferenceSystem2).toString());
    }

    private static String notFoundMessage(IdentifiedObject identifiedObject, IdentifiedObject identifiedObject2) {
        return Resources.format((short)13, CRSPair.label(identifiedObject), CRSPair.label(identifiedObject2));
    }

    private static String canNotInvert(GeneralDerivedCRS generalDerivedCRS) {
        return Resources.format((short)52, generalDerivedCRS.getConversionFromBase().getName().getCode());
    }
}

