/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing.crs;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.apache.sis.internal.jaxb.referencing.SC_CRS;
import org.apache.sis.internal.referencing.ReferencingUtilities;
import org.apache.sis.internal.referencing.Resources;
import org.apache.sis.internal.referencing.WKTUtilities;
import org.apache.sis.internal.util.UnmodifiableArrayList;
import org.apache.sis.io.wkt.Convention;
import org.apache.sis.io.wkt.Formatter;
import org.apache.sis.referencing.IdentifiedObjects;
import org.apache.sis.referencing.crs.AbstractCRS;
import org.apache.sis.referencing.crs.ParametricCRS;
import org.apache.sis.referencing.crs.SubTypes;
import org.apache.sis.referencing.cs.AxesConvention;
import org.apache.sis.referencing.cs.DefaultCompoundCS;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.ComparisonMode;
import org.apache.sis.util.Utilities;
import org.apache.sis.util.collection.CheckedContainer;
import org.apache.sis.util.collection.Containers;
import org.apache.sis.util.resources.Errors;
import org.opengis.referencing.crs.CompoundCRS;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.crs.EngineeringCRS;
import org.opengis.referencing.crs.GeodeticCRS;
import org.opengis.referencing.crs.ProjectedCRS;
import org.opengis.referencing.crs.SingleCRS;
import org.opengis.referencing.crs.TemporalCRS;
import org.opengis.referencing.crs.VerticalCRS;
import org.opengis.referencing.cs.CoordinateSystem;
import org.opengis.referencing.datum.Datum;

@XmlType(name="CompoundCRSType")
@XmlRootElement(name="CompoundCRS")
public class DefaultCompoundCRS
extends AbstractCRS
implements CompoundCRS {
    private static final long serialVersionUID = -2656710314586929287L;
    private List<? extends CoordinateReferenceSystem> components;
    private transient List<SingleCRS> singles;

    public DefaultCompoundCRS(Map<String, ?> map, CoordinateReferenceSystem ... coordinateReferenceSystemArray) {
        super(map, DefaultCompoundCRS.createCoordinateSystem(map, coordinateReferenceSystemArray));
        this.setComponents(Arrays.asList(coordinateReferenceSystemArray));
        if (this.singles != this.components) {
            DefaultCompoundCRS.verify(map, (CoordinateReferenceSystem[])this.singles.toArray(new SingleCRS[this.singles.size()]));
        }
    }

    private static void verify(Map<String, ?> map, CoordinateReferenceSystem[] coordinateReferenceSystemArray) {
        boolean bl = false;
        int n = 0;
        boolean bl2 = false;
        for (CoordinateReferenceSystem coordinateReferenceSystem : coordinateReferenceSystemArray) {
            int n2;
            if (coordinateReferenceSystem instanceof GeodeticCRS) {
                n2 = 1;
            } else if (coordinateReferenceSystem instanceof ProjectedCRS) {
                n = 1;
                n2 = 1;
            } else {
                if (!(coordinateReferenceSystem instanceof VerticalCRS)) continue;
                bl2 = ReferencingUtilities.isEllipsoidalHeight(((VerticalCRS)coordinateReferenceSystem).getDatum());
                n2 = 2;
            }
            if (bl != (bl |= n2)) continue;
            throw new IllegalArgumentException(Resources.forProperties(map).getString((short)76, n2));
        }
        if (bl2 && bl & true) {
            throw new IllegalArgumentException(Resources.forProperties(map).getString((short)77, n));
        }
    }

    private static CoordinateSystem createCoordinateSystem(Map<String, ?> map, CoordinateReferenceSystem[] coordinateReferenceSystemArray) {
        ArgumentChecks.ensureNonNull("components", coordinateReferenceSystemArray);
        DefaultCompoundCRS.verify(map, coordinateReferenceSystemArray);
        if (coordinateReferenceSystemArray.length < 2) {
            throw new IllegalArgumentException(Errors.getResources(map).getString((short)127, 2, coordinateReferenceSystemArray.length));
        }
        CoordinateSystem[] coordinateSystemArray = new CoordinateSystem[coordinateReferenceSystemArray.length];
        for (int i = 0; i < coordinateReferenceSystemArray.length; ++i) {
            CoordinateReferenceSystem coordinateReferenceSystem = coordinateReferenceSystemArray[i];
            ArgumentChecks.ensureNonNullElement("components", i, coordinateReferenceSystem);
            coordinateSystemArray[i] = coordinateReferenceSystem.getCoordinateSystem();
        }
        return new DefaultCompoundCS(coordinateSystemArray);
    }

    protected DefaultCompoundCRS(CompoundCRS compoundCRS) {
        super((CoordinateReferenceSystem)compoundCRS);
        if (compoundCRS instanceof DefaultCompoundCRS) {
            DefaultCompoundCRS defaultCompoundCRS = (DefaultCompoundCRS)compoundCRS;
            this.components = defaultCompoundCRS.components;
            this.singles = defaultCompoundCRS.singles;
        } else {
            this.setComponents(compoundCRS.getComponents());
        }
    }

    public static DefaultCompoundCRS castOrCopy(CompoundCRS compoundCRS) {
        return compoundCRS == null || compoundCRS instanceof DefaultCompoundCRS ? (DefaultCompoundCRS)compoundCRS : new DefaultCompoundCRS(compoundCRS);
    }

    public Class<? extends CompoundCRS> getInterface() {
        return CompoundCRS.class;
    }

    @Override
    final Datum getDatum() {
        return null;
    }

    public List<CoordinateReferenceSystem> getComponents() {
        return this.components;
    }

    private void setComponents(List<? extends CoordinateReferenceSystem> list) {
        this.components = this.setSingleComponents(list) ? this.singles : UnmodifiableArrayList.wrap(list.toArray(new CoordinateReferenceSystem[list.size()]));
    }

    public List<SingleCRS> getSingleComponents() {
        return this.singles;
    }

    private boolean setSingleComponents(List<? extends CoordinateReferenceSystem> list) {
        ArrayList arrayList = new ArrayList(list.size());
        boolean bl = ReferencingUtilities.getSingleComponents(list, arrayList);
        this.singles = UnmodifiableArrayList.wrap(arrayList.toArray(new SingleCRS[arrayList.size()]));
        return bl;
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        Class clazz;
        objectInputStream.defaultReadObject();
        List<? extends CoordinateReferenceSystem> list = this.components;
        if (list instanceof CheckedContainer && (clazz = ((CheckedContainer)((Object)list)).getElementType()) == SingleCRS.class) {
            this.singles = list;
            return;
        }
        this.setSingleComponents(list);
    }

    static boolean isStandardCompliant(List<? extends CoordinateReferenceSystem> list) {
        if (Containers.isNullOrEmpty(list)) {
            return false;
        }
        int n = 0;
        block9: for (CoordinateReferenceSystem coordinateReferenceSystem : list) {
            switch (n) {
                case 0: {
                    if (coordinateReferenceSystem instanceof GeodeticCRS || coordinateReferenceSystem instanceof ProjectedCRS || coordinateReferenceSystem instanceof EngineeringCRS) {
                        switch (coordinateReferenceSystem.getCoordinateSystem().getDimension()) {
                            case 2: {
                                n = 1;
                                continue block9;
                            }
                            case 3: {
                                n = 2;
                                continue block9;
                            }
                        }
                    }
                    return false;
                }
                case 1: {
                    if (coordinateReferenceSystem instanceof VerticalCRS || coordinateReferenceSystem instanceof ParametricCRS) {
                        n = 2;
                        continue block9;
                    }
                }
                case 2: {
                    if (!(coordinateReferenceSystem instanceof TemporalCRS)) break;
                    n = 3;
                    continue block9;
                }
            }
            return false;
        }
        return true;
    }

    @Override
    public synchronized DefaultCompoundCRS forConvention(AxesConvention axesConvention) {
        ArgumentChecks.ensureNonNull("convention", axesConvention);
        DefaultCompoundCRS defaultCompoundCRS = (DefaultCompoundCRS)this.getCached(axesConvention);
        if (defaultCompoundCRS == null) {
            defaultCompoundCRS = this;
            boolean bl = false;
            boolean bl2 = axesConvention.ordinal() <= AxesConvention.CONVENTIONALLY_ORIENTED.ordinal();
            List<SingleCRS> list = bl2 ? this.singles : this.components;
            CoordinateReferenceSystem[] coordinateReferenceSystemArray = new CoordinateReferenceSystem[list.size()];
            for (int i = 0; i < coordinateReferenceSystemArray.length; ++i) {
                CoordinateReferenceSystem coordinateReferenceSystem = (CoordinateReferenceSystem)list.get(i);
                AbstractCRS abstractCRS = DefaultCompoundCRS.castOrCopy(coordinateReferenceSystem);
                if (abstractCRS != (abstractCRS = abstractCRS.forConvention(axesConvention))) {
                    coordinateReferenceSystem = abstractCRS;
                    bl = true;
                }
                coordinateReferenceSystemArray[i] = coordinateReferenceSystem;
            }
            if (bl) {
                if (bl2) {
                    Arrays.sort(coordinateReferenceSystemArray, SubTypes.BY_TYPE);
                }
                defaultCompoundCRS = new DefaultCompoundCRS(IdentifiedObjects.getProperties(this, "identifiers"), coordinateReferenceSystemArray);
            }
            defaultCompoundCRS = (DefaultCompoundCRS)this.setCached(axesConvention, defaultCompoundCRS);
        }
        return defaultCompoundCRS;
    }

    @Override
    final AbstractCRS createSameType(Map<String, ?> map, CoordinateSystem coordinateSystem) {
        throw new AssertionError();
    }

    @Override
    public boolean equals(Object object, ComparisonMode comparisonMode) {
        if (object == this) {
            return true;
        }
        if (super.equals(object, comparisonMode)) {
            switch (comparisonMode) {
                case STRICT: {
                    return this.components.equals(((DefaultCompoundCRS)object).components);
                }
            }
            return Utilities.deepEquals(this.getComponents(), ((CompoundCRS)object).getComponents(), comparisonMode);
        }
        return false;
    }

    @Override
    protected long computeHashCode() {
        return super.computeHashCode() + (long)(31 * this.components.hashCode());
    }

    @Override
    protected String formatTo(Formatter formatter) {
        boolean bl;
        List<CoordinateReferenceSystem> list;
        boolean bl2;
        WKTUtilities.appendName(this, formatter, null);
        Convention convention = formatter.getConvention();
        boolean bl3 = bl2 = convention.majorVersion() == 1;
        if (bl2 || convention == Convention.INTERNAL) {
            list = this.getComponents();
            bl = true;
        } else {
            list = this.getSingleComponents();
            bl = DefaultCompoundCRS.isStandardCompliant(list);
        }
        for (CoordinateReferenceSystem coordinateReferenceSystem : list) {
            formatter.newLine();
            formatter.append(WKTUtilities.toFormattable(coordinateReferenceSystem));
        }
        formatter.newLine();
        if (!bl) {
            formatter.setInvalidWKT(this, null);
        }
        return bl2 ? "Compd_CS" : "CompoundCRS";
    }

    private DefaultCompoundCRS() {
        this.components = Collections.emptyList();
        this.singles = Collections.emptyList();
    }

    @XmlJavaTypeAdapter(value=SC_CRS.class)
    @XmlElement(name="componentReferenceSystem", required=true)
    private CoordinateReferenceSystem[] getXMLComponents() {
        List<SingleCRS> list = this.getSingleComponents();
        return list.toArray(new CoordinateReferenceSystem[list.size()]);
    }

    private void setXMLComponents(CoordinateReferenceSystem[] coordinateReferenceSystemArray) {
        this.components = this.setSingleComponents(Arrays.asList(coordinateReferenceSystemArray)) ? this.singles : UnmodifiableArrayList.wrap(coordinateReferenceSystemArray);
        this.setCoordinateSystem("coordinateSystem", DefaultCompoundCRS.createCoordinateSystem(null, coordinateReferenceSystemArray));
    }
}

