/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.jaxb.gmd;

import javax.xml.bind.annotation.adapters.XmlAdapter;
import org.apache.sis.internal.jaxb.Context;
import org.apache.sis.internal.jaxb.gmd.CodeListUID;
import org.apache.sis.util.iso.Types;
import org.opengis.util.CodeList;

public abstract class CodeListAdapter<ValueType extends CodeListAdapter<ValueType, BoundType>, BoundType extends CodeList<BoundType>>
extends XmlAdapter<ValueType, BoundType> {
    protected CodeListUID identifier;

    protected CodeListAdapter() {
    }

    protected CodeListAdapter(CodeListUID codeListUID) {
        this.identifier = codeListUID;
    }

    protected abstract ValueType wrap(CodeListUID var1);

    protected abstract Class<BoundType> getCodeListClass();

    public final BoundType unmarshal(ValueType ValueType) {
        return ValueType != null ? (BoundType)Types.forCodeName(this.getCodeListClass(), ((CodeListAdapter)((Object)ValueType)).identifier.toString(), true) : null;
    }

    public final ValueType marshal(BoundType BoundType) {
        CodeListUID codeListUID;
        if (BoundType == null) {
            return null;
        }
        if (this.isEnum()) {
            codeListUID = new CodeListUID();
            codeListUID.value = Types.getCodeName(BoundType);
        } else {
            codeListUID = new CodeListUID(Context.current(), (CodeList<?>)BoundType);
        }
        return this.wrap(codeListUID);
    }

    protected boolean isEnum() {
        return false;
    }

    public abstract CodeListUID getElement();
}

