/*
 * Decompiled with CFR 0.152.
 */
package org.apache.manifoldcf.authorities.authorities.activedirectory;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.naming.AuthenticationException;
import javax.naming.CommunicationException;
import javax.naming.NameNotFoundException;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import javax.naming.ldap.InitialLdapContext;
import javax.naming.ldap.LdapContext;
import org.apache.manifoldcf.authorities.authorities.BaseAuthorityConnector;
import org.apache.manifoldcf.authorities.authorities.activedirectory.Messages;
import org.apache.manifoldcf.authorities.interfaces.AuthorizationResponse;
import org.apache.manifoldcf.authorities.system.Logging;
import org.apache.manifoldcf.authorities.system.ManifoldCF;
import org.apache.manifoldcf.core.cachemanager.BaseDescription;
import org.apache.manifoldcf.core.interfaces.CacheManagerFactory;
import org.apache.manifoldcf.core.interfaces.ConfigNode;
import org.apache.manifoldcf.core.interfaces.ConfigParams;
import org.apache.manifoldcf.core.interfaces.ConfigurationNode;
import org.apache.manifoldcf.core.interfaces.ICacheCreateHandle;
import org.apache.manifoldcf.core.interfaces.ICacheDescription;
import org.apache.manifoldcf.core.interfaces.ICacheHandle;
import org.apache.manifoldcf.core.interfaces.ICacheManager;
import org.apache.manifoldcf.core.interfaces.IHTTPOutput;
import org.apache.manifoldcf.core.interfaces.IPasswordMapperActivity;
import org.apache.manifoldcf.core.interfaces.IPostParameters;
import org.apache.manifoldcf.core.interfaces.IThreadContext;
import org.apache.manifoldcf.core.interfaces.ManifoldCFException;
import org.apache.manifoldcf.core.interfaces.StringSet;

public class ActiveDirectoryAuthority
extends BaseAuthorityConnector {
    public static final String _rcsid = "@(#)$Id: ActiveDirectoryAuthority.java 988245 2010-08-23 18:39:35Z kwright $";
    private List<DCRule> dCRules = null;
    private Map<String, DCConnectionParameters> dCConnectionParameters = null;
    private boolean hasSessionParameters = false;
    private String cacheLifetime = null;
    private String cacheLRUsize = null;
    private long responseLifetime = 60000L;
    private int LRUsize = 1000;
    private String ldapConnectionTimeout = null;
    private Map<String, DCSessionInfo> sessionInfo = null;
    private ICacheManager cacheManager = null;
    private static final long expirationInterval = 300000L;
    protected static StringSet emptyStringSet = new StringSet();

    public void setThreadContext(IThreadContext tc) throws ManifoldCFException {
        super.setThreadContext(tc);
        this.cacheManager = CacheManagerFactory.make((IThreadContext)tc);
    }

    public void clearThreadContext() {
        super.clearThreadContext();
        this.cacheManager = null;
    }

    public void connect(ConfigParams configParams) {
        super.connect(configParams);
        this.sessionInfo = new HashMap<String, DCSessionInfo>();
        this.dCRules = new ArrayList<DCRule>();
        this.dCConnectionParameters = new HashMap<String, DCConnectionParameters>();
        String domainControllerName = this.params.getParameter("Domain controller");
        String userName = this.params.getParameter("User name");
        String password = this.params.getObfuscatedParameter("Password");
        String authentication = this.params.getParameter("Authentication");
        String userACLsUsername = this.params.getParameter("UserACLs username attribute");
        if (domainControllerName != null) {
            this.dCConnectionParameters.put(domainControllerName, new DCConnectionParameters(userName, password, authentication, userACLsUsername));
            this.dCRules.add(new DCRule("", domainControllerName));
        } else {
            int i = 0;
            while (i < this.params.getChildCount()) {
                ConfigNode cn;
                if (!(cn = this.params.getChild(i++)).getType().equals("domaincontroller")) continue;
                String dcName = cn.getAttributeValue("domaincontroller");
                this.dCConnectionParameters.put(dcName, new DCConnectionParameters(cn.getAttributeValue("username"), ActiveDirectoryAuthority.deobfuscate(cn.getAttributeValue("password")), cn.getAttributeValue("authentication"), cn.getAttributeValue("useraclsusername")));
                this.dCRules.add(new DCRule(cn.getAttributeValue("suffix"), dcName));
            }
        }
        this.ldapConnectionTimeout = this.params.getParameter("LDAP connection timeout");
        if (this.ldapConnectionTimeout == null) {
            this.ldapConnectionTimeout = "60000";
        }
        this.cacheLifetime = this.params.getParameter("Cache lifetime");
        if (this.cacheLifetime == null) {
            this.cacheLifetime = "1";
        }
        this.cacheLRUsize = this.params.getParameter("Cache LRU size");
        if (this.cacheLRUsize == null) {
            this.cacheLRUsize = "1000";
        }
    }

    protected static String deobfuscate(String input) {
        if (input == null) {
            return null;
        }
        try {
            return ManifoldCF.deobfuscate((String)input);
        }
        catch (ManifoldCFException e) {
            return "";
        }
    }

    public String check() throws ManifoldCFException {
        this.getSessionParameters();
        for (Map.Entry<String, DCSessionInfo> sessionEntry : this.sessionInfo.entrySet()) {
            sessionEntry.getValue().closeConnection();
        }
        for (String domainController : this.dCConnectionParameters.keySet()) {
            this.createDCSession(domainController);
        }
        return super.check();
    }

    protected LdapContext createDCSession(String domainController) throws ManifoldCFException {
        this.getSessionParameters();
        DCConnectionParameters parms = this.dCConnectionParameters.get(domainController);
        DCSessionInfo session = this.sessionInfo.get(domainController);
        if (session == null) {
            session = new DCSessionInfo();
            this.sessionInfo.put(domainController, session);
        }
        return session.getSession(domainController, parms, this.ldapConnectionTimeout);
    }

    public void poll() throws ManifoldCFException {
        long currentTime = System.currentTimeMillis();
        for (Map.Entry<String, DCSessionInfo> sessionEntry : this.sessionInfo.entrySet()) {
            sessionEntry.getValue().closeIfExpired(currentTime);
        }
        super.poll();
    }

    public boolean isConnected() {
        for (Map.Entry<String, DCSessionInfo> sessionEntry : this.sessionInfo.entrySet()) {
            if (!sessionEntry.getValue().isOpen()) continue;
            return true;
        }
        return false;
    }

    public void disconnect() throws ManifoldCFException {
        this.hasSessionParameters = false;
        for (Map.Entry<String, DCSessionInfo> sessionEntry : this.sessionInfo.entrySet()) {
            sessionEntry.getValue().closeConnection();
        }
        this.sessionInfo = null;
        this.cacheLifetime = null;
        this.cacheLRUsize = null;
        this.ldapConnectionTimeout = null;
        super.disconnect();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AuthorizationResponse getAuthorizationResponse(String userName) throws ManifoldCFException {
        this.getSessionParameters();
        AuthorizationResponseDescription objectDescription = new AuthorizationResponseDescription(userName, this.dCConnectionParameters, this.dCRules, this.responseLifetime, this.LRUsize);
        ICacheHandle ch = this.cacheManager.enterCache(new ICacheDescription[]{objectDescription}, null, null);
        try {
            AuthorizationResponse response;
            ICacheCreateHandle createHandle;
            block8: {
                AuthorizationResponse authorizationResponse;
                createHandle = this.cacheManager.enterCreateSection(ch);
                try {
                    response = (AuthorizationResponse)this.cacheManager.lookupObject(createHandle, (ICacheDescription)objectDescription);
                    if (response == null) break block8;
                    authorizationResponse = response;
                }
                catch (Throwable throwable) {
                    this.cacheManager.leaveCreateSection(createHandle);
                    throw throwable;
                }
                this.cacheManager.leaveCreateSection(createHandle);
                return authorizationResponse;
            }
            response = this.getAuthorizationResponseUncached(userName);
            this.cacheManager.saveObject(createHandle, (ICacheDescription)objectDescription, (Object)response);
            AuthorizationResponse authorizationResponse = response;
            this.cacheManager.leaveCreateSection(createHandle);
            return authorizationResponse;
        }
        finally {
            this.cacheManager.leaveCache(ch);
        }
    }

    protected AuthorizationResponse getAuthorizationResponseUncached(String userName) throws ManifoldCFException {
        int index = userName.indexOf("@");
        if (index == -1) {
            throw new ManifoldCFException("Username is in unexpected form (no @): '" + userName + "'");
        }
        String userPart = userName.substring(0, index);
        String domainPart = userName.substring(index + 1);
        String domainController = null;
        for (DCRule rule : this.dCRules) {
            String suffix = rule.getSuffix();
            if (suffix.length() != 0 && (!domainPart.toLowerCase(Locale.ROOT).endsWith(suffix.toLowerCase(Locale.ROOT)) || suffix.length() != domainPart.length() && domainPart.charAt(domainPart.length() - suffix.length() - 1) != '.')) continue;
            domainController = rule.getDomainControllerName();
            break;
        }
        if (domainController == null) {
            Logging.authorityConnectors.info((Object)("User not found: " + userName));
            return RESPONSE_USERNOTFOUND;
        }
        DCConnectionParameters dcParams = this.dCConnectionParameters.get(domainController);
        if (dcParams == null) {
            Logging.authorityConnectors.info((Object)("User not found: " + userName));
            return RESPONSE_USERNOTFOUND;
        }
        String userACLsUsername = dcParams.getUserACLsUsername();
        if (userACLsUsername != null && userACLsUsername.equals("userPrincipalName")) {
            userPart = userName;
        }
        StringBuilder domainsb = new StringBuilder();
        int j = 0;
        while (true) {
            int k;
            if (j > 0) {
                domainsb.append(",");
            }
            if ((k = domainPart.indexOf(".", j)) == -1) break;
            domainsb.append("DC=").append(ActiveDirectoryAuthority.ldapEscape(domainPart.substring(j, k)));
            j = k + 1;
        }
        domainsb.append("DC=").append(ActiveDirectoryAuthority.ldapEscape(domainPart.substring(j)));
        try {
            LdapContext ctx = this.createDCSession(domainController);
            String searchBase = this.getDistinguishedName(ctx, userPart, domainsb.toString(), userACLsUsername);
            if (searchBase == null) {
                Logging.authorityConnectors.info((Object)("User not found: " + userName));
                return RESPONSE_USERNOTFOUND;
            }
            String searchFilter = "(objectClass=user)";
            SearchControls searchCtls = new SearchControls();
            searchCtls.setSearchScope(0);
            String[] returnedAtts = new String[]{"tokenGroups", "objectSid"};
            searchCtls.setReturningAttributes(returnedAtts);
            NamingEnumeration<SearchResult> answer = ctx.search(searchBase, searchFilter, searchCtls);
            ArrayList<String> theGroups = new ArrayList<String>();
            while (answer.hasMoreElements()) {
                SearchResult sr = answer.next();
                Attributes attrs = sr.getAttributes();
                if (attrs == null) continue;
                try {
                    NamingEnumeration<? extends Attribute> ae = attrs.getAll();
                    while (ae.hasMore()) {
                        Attribute attr = ae.next();
                        NamingEnumeration<?> e = attr.getAll();
                        while (e.hasMore()) {
                            theGroups.add(ActiveDirectoryAuthority.sid2String((byte[])e.next()));
                        }
                    }
                }
                catch (NamingException e) {
                    Logging.authorityConnectors.error((Object)("Naming exception: " + e.getMessage()), (Throwable)e);
                    throw new ManifoldCFException(e.getMessage(), (Throwable)e);
                }
            }
            if (theGroups.size() == 0) {
                Logging.authorityConnectors.info((Object)("User not found: " + userName));
                return RESPONSE_USERNOTFOUND;
            }
            theGroups.add("S-1-1-0");
            String[] tokens = new String[theGroups.size()];
            for (int k = 0; k < tokens.length; ++k) {
                tokens[k] = (String)theGroups.get(k);
            }
            return new AuthorizationResponse(tokens, 0);
        }
        catch (NameNotFoundException e) {
            Logging.authorityConnectors.error((Object)("User not found: " + userName + " Exception: " + e.getMessage()), (Throwable)e);
            return RESPONSE_USERNOTFOUND;
        }
        catch (NamingException e) {
            Logging.authorityConnectors.error((Object)("Response Unreachable: " + e.getMessage()), (Throwable)e);
            return RESPONSE_UNREACHABLE;
        }
    }

    public AuthorizationResponse getDefaultAuthorizationResponse(String userName) {
        return RESPONSE_UNREACHABLE;
    }

    public void outputConfigurationHeader(IThreadContext threadContext, IHTTPOutput out, Locale locale, ConfigParams parameters, List<String> tabsArray) throws ManifoldCFException, IOException {
        tabsArray.add(Messages.getString(locale, "ActiveDirectoryAuthority.DomainController"));
        tabsArray.add(Messages.getString(locale, "ActiveDirectoryAuthority.Cache"));
        Messages.outputResourceWithVelocity(out, locale, "editConfiguration.js", null);
    }

    public void outputConfigurationBody(IThreadContext threadContext, IHTTPOutput out, Locale locale, ConfigParams parameters, String tabName) throws ManifoldCFException, IOException {
        HashMap<String, Object> velocityContext = new HashMap<String, Object>();
        velocityContext.put("TabName", tabName);
        ActiveDirectoryAuthority.fillInDomainControllerTab(velocityContext, (IPasswordMapperActivity)out, parameters);
        ActiveDirectoryAuthority.fillInCacheTab(velocityContext, (IPasswordMapperActivity)out, parameters);
        Messages.outputResourceWithVelocity(out, locale, "editConfiguration_DomainController.html", velocityContext);
        Messages.outputResourceWithVelocity(out, locale, "editConfiguration_Cache.html", velocityContext);
    }

    protected static void fillInDomainControllerTab(Map<String, Object> velocityContext, IPasswordMapperActivity mapper, ConfigParams parameters) {
        String domainControllerName = parameters.getParameter("Domain controller");
        String userName = parameters.getParameter("User name");
        String password = parameters.getObfuscatedParameter("Password");
        String authentication = parameters.getParameter("Authentication");
        String userACLsUsername = parameters.getParameter("UserACLs username attribute");
        ArrayList<Map<String, String>> domainControllers = new ArrayList<Map<String, String>>();
        if (domainControllerName != null) {
            domainControllers.add(ActiveDirectoryAuthority.createDomainControllerMap(mapper, "", domainControllerName, userName, password, authentication, userACLsUsername));
        } else {
            int i = 0;
            while (i < parameters.getChildCount()) {
                ConfigNode cn;
                if (!(cn = parameters.getChild(i++)).getType().equals("domaincontroller")) continue;
                String dcSuffix = cn.getAttributeValue("suffix");
                String dcDomainController = cn.getAttributeValue("domaincontroller");
                String dcUserName = cn.getAttributeValue("username");
                String dcPassword = ActiveDirectoryAuthority.deobfuscate(cn.getAttributeValue("password"));
                String dcAuthentication = cn.getAttributeValue("authentication");
                String dcUserACLsUsername = cn.getAttributeValue("useraclsusername");
                domainControllers.add(ActiveDirectoryAuthority.createDomainControllerMap(mapper, dcSuffix, dcDomainController, dcUserName, dcPassword, dcAuthentication, dcUserACLsUsername));
            }
        }
        velocityContext.put("DOMAINCONTROLLERS", domainControllers);
        String ldapConnectionTimeout = parameters.getParameter("LDAP connection timeout");
        if (ldapConnectionTimeout == null) {
            ldapConnectionTimeout = "60000";
        }
        velocityContext.put("LDAPCONNECTIONTIMEOUT", ldapConnectionTimeout);
    }

    protected static Map<String, String> createDomainControllerMap(IPasswordMapperActivity mapper, String suffix, String domainControllerName, String userName, String password, String authentication, String userACLsUsername) {
        HashMap<String, String> defaultMap = new HashMap<String, String>();
        if (suffix != null) {
            defaultMap.put("SUFFIX", suffix);
        }
        if (domainControllerName != null) {
            defaultMap.put("DOMAINCONTROLLER", domainControllerName);
        }
        if (userName != null) {
            defaultMap.put("USERNAME", userName);
        }
        if (password != null) {
            defaultMap.put("PASSWORD", mapper.mapPasswordToKey(password));
        }
        if (authentication != null) {
            defaultMap.put("AUTHENTICATION", authentication);
        }
        if (userACLsUsername != null) {
            defaultMap.put("USERACLsUSERNAME", userACLsUsername);
        }
        return defaultMap;
    }

    protected static void fillInCacheTab(Map<String, Object> velocityContext, IPasswordMapperActivity mapper, ConfigParams parameters) {
        String cacheLifetime = parameters.getParameter("Cache lifetime");
        if (cacheLifetime == null) {
            cacheLifetime = "1";
        }
        velocityContext.put("CACHELIFETIME", cacheLifetime);
        String cacheLRUsize = parameters.getParameter("Cache LRU size");
        if (cacheLRUsize == null) {
            cacheLRUsize = "1000";
        }
        velocityContext.put("CACHELRUSIZE", cacheLRUsize);
    }

    public String processConfigurationPost(IThreadContext threadContext, IPostParameters variableContext, Locale locale, ConfigParams parameters) throws ManifoldCFException {
        String cacheLRUsize;
        String cacheLifetime;
        String ldapConnectionTimeout;
        String x = variableContext.getParameter("dcrecord_count");
        if (x != null) {
            String op;
            parameters.setParameter("Domain controller", null);
            parameters.setParameter("User name", null);
            parameters.setParameter("Password", null);
            parameters.setParameter("Authentication", null);
            parameters.setParameter("UserACLs username attribute", null);
            int i = 0;
            while (i < parameters.getChildCount()) {
                ConfigNode cn = parameters.getChild(i);
                if (cn.getType().equals("domaincontroller")) {
                    parameters.removeChild(i);
                    continue;
                }
                ++i;
            }
            int count = Integer.parseInt(x);
            HashSet<String> seenDomains = new HashSet<String>();
            for (i = 0; i < count; ++i) {
                op = variableContext.getParameter("dcrecord_op_" + i);
                if (op != null && op.equals("Insert")) {
                    ActiveDirectoryAuthority.addDomainController(seenDomains, parameters, variableContext.getParameter("dcrecord_suffix"), variableContext.getParameter("dcrecord_domaincontrollername"), variableContext.getParameter("dcrecord_username"), variableContext.mapKeyToPassword(variableContext.getParameter("dcrecord_password")), variableContext.getParameter("dcrecord_authentication"), variableContext.getParameter("dcrecord_userACLsUsername"));
                }
                if (op != null && op.equals("Delete")) continue;
                ActiveDirectoryAuthority.addDomainController(seenDomains, parameters, variableContext.getParameter("dcrecord_suffix_" + i), variableContext.getParameter("dcrecord_domaincontrollername_" + i), variableContext.getParameter("dcrecord_username_" + i), variableContext.mapKeyToPassword(variableContext.getParameter("dcrecord_password_" + i)), variableContext.getParameter("dcrecord_authentication_" + i), variableContext.getParameter("dcrecord_userACLsUsername_" + i));
            }
            op = variableContext.getParameter("dcrecord_op");
            if (op != null && op.equals("Add")) {
                ActiveDirectoryAuthority.addDomainController(seenDomains, parameters, variableContext.getParameter("dcrecord_suffix"), variableContext.getParameter("dcrecord_domaincontrollername"), variableContext.getParameter("dcrecord_username"), variableContext.getParameter("dcrecord_password"), variableContext.getParameter("dcrecord_authentication"), variableContext.getParameter("dcrecord_userACLsUsername"));
            }
        }
        if ((ldapConnectionTimeout = variableContext.getParameter("ldapconnectiontimeout")) != null) {
            parameters.setParameter("LDAP connection timeout", ldapConnectionTimeout);
        }
        if ((cacheLifetime = variableContext.getParameter("cachelifetime")) != null) {
            parameters.setParameter("Cache lifetime", cacheLifetime);
        }
        if ((cacheLRUsize = variableContext.getParameter("cachelrusize")) != null) {
            parameters.setParameter("Cache LRU size", cacheLRUsize);
        }
        return null;
    }

    protected static void addDomainController(Set<String> seenDomains, ConfigParams parameters, String suffix, String domainControllerName, String userName, String password, String authentication, String userACLsUsername) throws ManifoldCFException {
        if (!seenDomains.contains(domainControllerName)) {
            ConfigNode cn = new ConfigNode("domaincontroller");
            cn.setAttribute("suffix", suffix);
            cn.setAttribute("domaincontroller", domainControllerName);
            cn.setAttribute("username", userName);
            cn.setAttribute("password", ManifoldCF.obfuscate((String)password));
            cn.setAttribute("authentication", authentication);
            cn.setAttribute("useraclsusername", userACLsUsername);
            parameters.addChild(parameters.getChildCount(), (ConfigurationNode)cn);
            seenDomains.add(domainControllerName);
        }
    }

    public void viewConfiguration(IThreadContext threadContext, IHTTPOutput out, Locale locale, ConfigParams parameters) throws ManifoldCFException, IOException {
        HashMap<String, Object> velocityContext = new HashMap<String, Object>();
        ActiveDirectoryAuthority.fillInDomainControllerTab(velocityContext, (IPasswordMapperActivity)out, parameters);
        ActiveDirectoryAuthority.fillInCacheTab(velocityContext, (IPasswordMapperActivity)out, parameters);
        Messages.outputResourceWithVelocity(out, locale, "viewConfiguration.html", velocityContext);
    }

    protected void getSessionParameters() throws ManifoldCFException {
        if (!this.hasSessionParameters) {
            try {
                this.responseLifetime = Long.parseLong(this.cacheLifetime) * 60L * 1000L;
                this.LRUsize = Integer.parseInt(this.cacheLRUsize);
            }
            catch (NumberFormatException e) {
                Logging.authorityConnectors.error((Object)("Cache lifetime or Cache LRU size must be an integer: " + e.getMessage()), (Throwable)e);
                throw new ManifoldCFException("Cache lifetime or Cache LRU size must be an integer: " + e.getMessage(), (Throwable)e);
            }
            this.hasSessionParameters = true;
        }
    }

    protected String getDistinguishedName(LdapContext ctx, String userName, String searchBase, String userACLsUsername) throws ManifoldCFException {
        String[] returnedAtts = new String[]{"distinguishedName"};
        String searchFilter = "(&(objectClass=user)(" + userACLsUsername + "=" + userName + "))";
        SearchControls searchCtls = new SearchControls();
        searchCtls.setReturningAttributes(returnedAtts);
        searchCtls.setSearchScope(2);
        searchCtls.setReturningAttributes(returnedAtts);
        try {
            NamingEnumeration<SearchResult> answer = ctx.search(searchBase, searchFilter, searchCtls);
            while (answer.hasMoreElements()) {
                SearchResult sr = answer.next();
                Attributes attrs = sr.getAttributes();
                if (attrs == null) continue;
                String dn = attrs.get("distinguishedName").get().toString();
                return dn;
            }
            return null;
        }
        catch (NamingException e) {
            Logging.authorityConnectors.error((Object)("Naming exception: " + e.getMessage()), (Throwable)e);
            throw new ManifoldCFException(e.getMessage(), (Throwable)e);
        }
    }

    protected static String ldapEscape(String input) {
        int oldIndex;
        StringBuilder sb = new StringBuilder();
        int index = 0;
        while (true) {
            if ((index = input.indexOf(",", oldIndex = ++index)) == -1) break;
            sb.append(input.substring(oldIndex, index)).append("\\,");
        }
        sb.append(input.substring(oldIndex));
        return sb.toString();
    }

    protected static String sid2String(byte[] SID) {
        StringBuilder strSID = new StringBuilder("S");
        long version = SID[0];
        strSID.append("-").append(Long.toString(version));
        long authority = SID[4];
        for (int i = 0; i < 4; ++i) {
            authority <<= 8;
            authority += (long)(SID[4 + i] & 0xFF);
        }
        strSID.append("-").append(Long.toString(authority));
        long count = SID[2];
        count <<= 8;
        count += (long)(SID[1] & 0xFF);
        int j = 0;
        while ((long)j < count) {
            long rid = SID[11 + j * 4] & 0xFF;
            for (int k = 1; k < 4; ++k) {
                rid <<= 8;
                rid += (long)(SID[11 - k + j * 4] & 0xFF);
            }
            strSID.append("-").append(Long.toString(rid));
            ++j;
        }
        return strSID.toString();
    }

    protected static class AuthorizationResponseDescription
    extends BaseDescription {
        protected String userName;
        protected Map<String, DCConnectionParameters> dcConnectionParams;
        protected List<DCRule> dcRules;
        protected long responseLifetime;
        protected long expirationTime = -1L;

        public AuthorizationResponseDescription(String userName, Map<String, DCConnectionParameters> dcConnectionParams, List<DCRule> dcRules, long responseLifetime, int LRUsize) {
            super("ActiveDirectoryAuthority", LRUsize);
            this.userName = userName;
            this.dcConnectionParams = dcConnectionParams;
            this.dcRules = dcRules;
            this.responseLifetime = responseLifetime;
        }

        public StringSet getObjectKeys() {
            return emptyStringSet;
        }

        public String getCriticalSectionName() {
            StringBuilder sb = new StringBuilder(((Object)((Object)this)).getClass().getName());
            sb.append("-").append(this.userName);
            for (DCRule rule : this.dcRules) {
                sb.append("-").append(rule.getSuffix());
                String domainController = rule.getDomainControllerName();
                DCConnectionParameters params = this.dcConnectionParams.get(domainController);
                sb.append("-").append(domainController).append("-").append(params.getUserName()).append("-").append(params.getPassword());
            }
            return sb.toString();
        }

        public long getObjectExpirationTime(long currentTime) {
            if (this.expirationTime == -1L) {
                this.expirationTime = currentTime + this.responseLifetime;
            }
            return this.expirationTime;
        }

        public int hashCode() {
            int rval = this.userName.hashCode();
            for (DCRule rule : this.dcRules) {
                String domainController = rule.getDomainControllerName();
                DCConnectionParameters params = this.dcConnectionParams.get(domainController);
                rval += rule.getSuffix().hashCode() + domainController.hashCode() + params.getUserName().hashCode() + params.getPassword().hashCode();
            }
            return rval;
        }

        public boolean equals(Object o) {
            if (!(o instanceof AuthorizationResponseDescription)) {
                return false;
            }
            AuthorizationResponseDescription ard = (AuthorizationResponseDescription)((Object)o);
            if (!ard.userName.equals(this.userName)) {
                return false;
            }
            if (ard.dcRules.size() != this.dcRules.size()) {
                return false;
            }
            for (int i = 0; i < this.dcRules.size(); ++i) {
                DCRule rule = this.dcRules.get(i);
                DCRule ardRule = ard.dcRules.get(i);
                if (!rule.getSuffix().equals(ardRule.getSuffix()) || !rule.getDomainControllerName().equals(ardRule.getDomainControllerName())) {
                    return false;
                }
                String domainController = rule.getDomainControllerName();
                DCConnectionParameters params = this.dcConnectionParams.get(domainController);
                DCConnectionParameters ardParams = ard.dcConnectionParams.get(domainController);
                if (params.getUserName().equals(ardParams.getUserName()) && params.getPassword().equals(ardParams.getPassword())) continue;
                return false;
            }
            return true;
        }
    }

    protected static class DCConnectionParameters {
        private String userName;
        private String password;
        private String authentication;
        private String userACLsUsername;

        public DCConnectionParameters(String userName, String password, String authentication, String userACLsUsername) {
            this.userName = userName;
            this.password = password;
            this.authentication = authentication;
            this.userACLsUsername = userACLsUsername;
        }

        public String getUserName() {
            return this.userName;
        }

        public String getPassword() {
            return this.password;
        }

        public String getAuthentication() {
            return this.authentication;
        }

        public String getUserACLsUsername() {
            return this.userACLsUsername;
        }
    }

    protected static class DCRule {
        private String suffix;
        private String domainControllerName;

        public DCRule(String suffix, String domainControllerName) {
            this.suffix = suffix;
            this.domainControllerName = domainControllerName;
        }

        public String getSuffix() {
            return this.suffix;
        }

        public String getDomainControllerName() {
            return this.domainControllerName;
        }
    }

    protected static class DCSessionInfo {
        private LdapContext ctx = null;
        private long expiration = -1L;

        public LdapContext getSession(String domainControllerName, DCConnectionParameters params, String ldapConnectionTimeout) throws ManifoldCFException {
            String authentication = params.getAuthentication();
            String userName = params.getUserName();
            String password = params.getPassword();
            while (true) {
                if (this.ctx == null) {
                    String ldapURL = "ldap://" + domainControllerName + ":389";
                    Hashtable<String, String> env = new Hashtable<String, String>();
                    env.put("java.naming.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory");
                    env.put("java.naming.security.authentication", authentication);
                    env.put("java.naming.security.principal", userName);
                    env.put("java.naming.security.credentials", password);
                    env.put("java.naming.provider.url", ldapURL);
                    env.put("java.naming.ldap.attributes.binary", "tokenGroups objectSid");
                    env.put("com.sun.jndi.ldap.connect.timeout", ldapConnectionTimeout);
                    try {
                        Logging.authorityConnectors.info((Object)("LDAP Context environment properties: " + this.printLdapContextEnvironment(env)));
                        this.ctx = new InitialLdapContext(env, null);
                        break;
                    }
                    catch (AuthenticationException e) {
                        Logging.authorityConnectors.error((Object)("Authentication problem authenticating admin user '" + userName + "': " + e.getMessage()), (Throwable)e);
                        throw new ManifoldCFException("Authentication problem authenticating admin user '" + userName + "': " + e.getMessage(), (Throwable)e);
                    }
                    catch (CommunicationException e) {
                        Logging.authorityConnectors.error((Object)("Couldn't communicate with domain controller '" + domainControllerName + "': " + e.getMessage()), (Throwable)e);
                        throw new ManifoldCFException("Couldn't communicate with domain controller '" + domainControllerName + "': " + e.getMessage(), (Throwable)e);
                    }
                    catch (NamingException e) {
                        Logging.authorityConnectors.error((Object)("Naming exception: " + e.getMessage()), (Throwable)e);
                        throw new ManifoldCFException(e.getMessage(), (Throwable)e);
                    }
                }
                try {
                    this.ctx.reconnect(null);
                    break;
                }
                catch (AuthenticationException e) {
                    Logging.authorityConnectors.error((Object)("Authentication exception: " + e.getMessage() + ", explanation: " + e.getExplanation()), (Throwable)e);
                }
                catch (CommunicationException e) {
                    Logging.authorityConnectors.error((Object)("Communication exception: " + e.getMessage() + ", explanation: " + e.getExplanation()), (Throwable)e);
                }
                catch (NamingException e) {
                    Logging.authorityConnectors.error((Object)("Naming exception: " + e.getMessage() + ", explanation: " + e.getExplanation()), (Throwable)e);
                }
                this.closeConnection();
            }
            this.expiration = System.currentTimeMillis() + 300000L;
            return this.ctx;
        }

        protected void closeConnection() {
            if (this.ctx != null) {
                try {
                    this.ctx.close();
                }
                catch (NamingException namingException) {
                    // empty catch block
                }
                this.ctx = null;
                this.expiration = -1L;
            }
        }

        protected void closeIfExpired(long currentTime) {
            if (this.expiration != -1L && currentTime > this.expiration) {
                this.closeConnection();
            }
        }

        protected boolean isOpen() {
            return this.ctx != null;
        }

        private String printLdapContextEnvironment(Hashtable env) {
            Hashtable<String, String> copyEnv = new Hashtable<String, String>(env);
            if (copyEnv.containsKey("java.naming.security.credentials")) {
                copyEnv.put("java.naming.security.credentials", "********");
            }
            return Arrays.toString(copyEnv.entrySet().toArray());
        }
    }
}

