/*
 * Decompiled with CFR 0.152.
 */
package org.apache.manifoldcf.crawler.system;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.manifoldcf.agents.interfaces.DocumentIngestStatus;
import org.apache.manifoldcf.agents.interfaces.DocumentIngestStatusSet;
import org.apache.manifoldcf.agents.interfaces.IIncrementalIngester;
import org.apache.manifoldcf.agents.interfaces.IOutputActivity;
import org.apache.manifoldcf.agents.interfaces.IOutputCheckActivity;
import org.apache.manifoldcf.agents.interfaces.IOutputConnectionManager;
import org.apache.manifoldcf.agents.interfaces.IOutputRemoveActivity;
import org.apache.manifoldcf.agents.interfaces.IPipelineConnections;
import org.apache.manifoldcf.agents.interfaces.IPipelineSpecification;
import org.apache.manifoldcf.agents.interfaces.IPipelineSpecificationBasic;
import org.apache.manifoldcf.agents.interfaces.IPipelineSpecificationWithVersions;
import org.apache.manifoldcf.agents.interfaces.ITransformationConnectionManager;
import org.apache.manifoldcf.agents.interfaces.IncrementalIngesterFactory;
import org.apache.manifoldcf.agents.interfaces.OutputConnectionManagerFactory;
import org.apache.manifoldcf.agents.interfaces.RepositoryDocument;
import org.apache.manifoldcf.agents.interfaces.ServiceInterruption;
import org.apache.manifoldcf.agents.interfaces.TransformationConnectionManagerFactory;
import org.apache.manifoldcf.core.interfaces.CharacterInput;
import org.apache.manifoldcf.core.interfaces.IThreadContext;
import org.apache.manifoldcf.core.interfaces.ManifoldCFException;
import org.apache.manifoldcf.core.interfaces.Specification;
import org.apache.manifoldcf.core.interfaces.ThreadContextFactory;
import org.apache.manifoldcf.core.util.URLEncoder;
import org.apache.manifoldcf.crawler.interfaces.BinManagerFactory;
import org.apache.manifoldcf.crawler.interfaces.DocumentDescription;
import org.apache.manifoldcf.crawler.interfaces.IBinManager;
import org.apache.manifoldcf.crawler.interfaces.IExistingVersions;
import org.apache.manifoldcf.crawler.interfaces.IJobDescription;
import org.apache.manifoldcf.crawler.interfaces.IJobManager;
import org.apache.manifoldcf.crawler.interfaces.IPriorityCalculator;
import org.apache.manifoldcf.crawler.interfaces.IProcessActivity;
import org.apache.manifoldcf.crawler.interfaces.IRepositoryConnection;
import org.apache.manifoldcf.crawler.interfaces.IRepositoryConnectionManager;
import org.apache.manifoldcf.crawler.interfaces.IRepositoryConnector;
import org.apache.manifoldcf.crawler.interfaces.IRepositoryConnectorPool;
import org.apache.manifoldcf.crawler.interfaces.IReprioritizationTracker;
import org.apache.manifoldcf.crawler.interfaces.JobManagerFactory;
import org.apache.manifoldcf.crawler.interfaces.QueueTracker;
import org.apache.manifoldcf.crawler.interfaces.RepositoryConnectionManagerFactory;
import org.apache.manifoldcf.crawler.interfaces.RepositoryConnectorFactory;
import org.apache.manifoldcf.crawler.interfaces.RepositoryConnectorPoolFactory;
import org.apache.manifoldcf.crawler.interfaces.ReprioritizationTrackerFactory;
import org.apache.manifoldcf.crawler.system.DocumentQueue;
import org.apache.manifoldcf.crawler.system.Logging;
import org.apache.manifoldcf.crawler.system.ManifoldCF;
import org.apache.manifoldcf.crawler.system.PipelineConnections;
import org.apache.manifoldcf.crawler.system.PipelineSpecification;
import org.apache.manifoldcf.crawler.system.PipelineSpecificationBasic;
import org.apache.manifoldcf.crawler.system.PipelineSpecificationWithVersions;
import org.apache.manifoldcf.crawler.system.PriorityCalculator;
import org.apache.manifoldcf.crawler.system.QueuedDocument;
import org.apache.manifoldcf.crawler.system.QueuedDocumentSet;
import org.apache.manifoldcf.crawler.system.WorkerResetManager;

public class WorkerThread
extends Thread {
    public static final String _rcsid = "@(#)$Id: WorkerThread.java 988245 2010-08-23 18:39:35Z kwright $";
    protected final String id;
    protected final DocumentQueue documentQueue;
    protected final WorkerResetManager resetManager;
    protected final QueueTracker queueTracker;
    protected final String processID;
    protected static final int MAX_ADDS_IN_TRANSACTION = 20;

    public WorkerThread(String id, DocumentQueue documentQueue, WorkerResetManager resetManager, QueueTracker queueTracker, String processID) throws ManifoldCFException {
        this.id = id;
        this.documentQueue = documentQueue;
        this.resetManager = resetManager;
        this.queueTracker = queueTracker;
        this.processID = processID;
        this.setName("Worker thread '" + id + "'");
        this.setDaemon(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void run() {
        this.resetManager.registerMe();
        try {
            IThreadContext threadContext = ThreadContextFactory.make();
            IIncrementalIngester ingester = IncrementalIngesterFactory.make((IThreadContext)threadContext);
            IJobManager jobManager = JobManagerFactory.make(threadContext);
            IBinManager binManager = BinManagerFactory.make(threadContext);
            IRepositoryConnectionManager connMgr = RepositoryConnectionManagerFactory.make(threadContext);
            ITransformationConnectionManager transformationConnectionManager = TransformationConnectionManagerFactory.make((IThreadContext)threadContext);
            IOutputConnectionManager outputConnectionManager = OutputConnectionManagerFactory.make((IThreadContext)threadContext);
            IReprioritizationTracker rt = ReprioritizationTrackerFactory.make(threadContext);
            IRepositoryConnectorPool repositoryConnectorPool = RepositoryConnectorPoolFactory.make(threadContext);
            ArrayList<QueuedDocument> finishList = new ArrayList<QueuedDocument>();
            ArrayList<QueuedDocument> deleteList = new ArrayList<QueuedDocument>();
            ArrayList<QueuedDocument> hopcountremoveList = new ArrayList<QueuedDocument>();
            ArrayList<QueuedDocument> rescanList = new ArrayList<QueuedDocument>();
            ArrayList<String> ingesterCheckList = new ArrayList<String>();
            ManifoldCFException abortOnFail = null;
            while (true) {
                try {
                    QueuedDocumentSet qds;
                    while (true) {
                        if (Thread.currentThread().isInterrupted()) {
                            throw new ManifoldCFException("Interrupted", 2);
                        }
                        this.resetManager.waitForReset(threadContext);
                        qds = this.documentQueue.getDocument(this.queueTracker);
                        if (qds == null) continue;
                        if (Thread.currentThread().isInterrupted()) {
                            throw new ManifoldCFException("Interrupted", 2);
                        }
                        IJobDescription job = qds.getJobDescription();
                        Long jobID = job.getID();
                        if (!jobManager.checkJobActive(jobID)) continue;
                        if (Logging.threads.isDebugEnabled()) {
                            StringBuilder sb = new StringBuilder();
                            for (int z = 0; z < qds.getCount(); ++z) {
                                sb.append(qds.getDocument(z).getDocumentDescription().getID()).append(" ");
                            }
                            Logging.threads.debug((Object)("Worker thread processing documents: " + sb));
                        }
                        PipelineConnections pipelineConnections = new PipelineConnections(new PipelineSpecificationBasic(job), transformationConnectionManager, outputConnectionManager);
                        String lastIndexedOutputConnectionName = ingester.getLastIndexedOutputConnectionName((IPipelineSpecificationBasic)pipelineConnections);
                        String connectionName = job.getConnectionName();
                        Specification spec = job.getSpecification();
                        int jobType = job.getType();
                        IRepositoryConnection connection = qds.getConnection();
                        OutputActivity ingestLogger = new OutputActivity(connectionName, connMgr);
                        ArrayList<QueuedDocument> activeDocuments = new ArrayList<QueuedDocument>(qds.getCount());
                        for (int i = 0; i < qds.getCount(); ++i) {
                            QueuedDocument qd = qds.getDocument(i);
                            activeDocuments.add(qd);
                        }
                        finishList.clear();
                        deleteList.clear();
                        ingesterCheckList.clear();
                        hopcountremoveList.clear();
                        rescanList.clear();
                        abortOnFail = null;
                        long processingStartTime = System.currentTimeMillis();
                        qds.beginProcessing(this.queueTracker);
                        try {
                            long currentTime = System.currentTimeMillis();
                            if (Logging.threads.isDebugEnabled()) {
                                Logging.threads.debug((Object)("Worker thread starting document count is " + Integer.toString(activeDocuments.size())));
                            }
                            String[] legalLinkTypes = null;
                            if (activeDocuments.size() > 0 && (legalLinkTypes = RepositoryConnectorFactory.getRelationshipTypes(threadContext, connection.getClassName())) == null) {
                                if (Logging.threads.isDebugEnabled()) {
                                    Logging.threads.debug((Object)(" Moving " + WorkerThread.makeListString(activeDocuments) + " to rescanList"));
                                }
                                WorkerThread.moveList(activeDocuments, rescanList);
                            }
                            if (Logging.threads.isDebugEnabled()) {
                                Logging.threads.debug((Object)("Post-relationship document count is " + Integer.toString(activeDocuments.size())));
                            }
                            if (legalLinkTypes != null && activeDocuments.size() > 0) {
                                String[] currentDocIDHashArray = new String[activeDocuments.size()];
                                for (int i = 0; i < currentDocIDHashArray.length; ++i) {
                                    currentDocIDHashArray[i] = ((QueuedDocument)activeDocuments.get(i)).getDocumentDescription().getDocumentIdentifierHash();
                                }
                                Map filterMap = job.getHopCountFilters();
                                Iterator filterIter = filterMap.keySet().iterator();
                                boolean[] overallResults = new boolean[currentDocIDHashArray.length];
                                for (int i = 0; i < overallResults.length; ++i) {
                                    overallResults[i] = true;
                                }
                                while (filterIter.hasNext()) {
                                    String linkType = (String)filterIter.next();
                                    int maxHop = (int)((Long)filterMap.get(linkType)).longValue();
                                    boolean[] results = jobManager.findHopCounts(job.getID(), legalLinkTypes, currentDocIDHashArray, linkType, maxHop, job.getHopcountMode());
                                    for (int i = 0; i < results.length; ++i) {
                                        overallResults[i] = overallResults[i] && results[i];
                                    }
                                }
                                ArrayList newActiveSet = new ArrayList(activeDocuments.size());
                                for (int i = 0; i < overallResults.length; ++i) {
                                    if (!overallResults[i]) {
                                        if (Logging.threads.isDebugEnabled()) {
                                            Logging.threads.debug((Object)(" Adding " + ((QueuedDocument)activeDocuments.get(i)).getDocumentDescription().getID() + " to hopcountremovelist"));
                                        }
                                        hopcountremoveList.add((QueuedDocument)activeDocuments.get(i));
                                        continue;
                                    }
                                    newActiveSet.add(activeDocuments.get(i));
                                }
                                activeDocuments = newActiveSet;
                            }
                            if (Logging.threads.isDebugEnabled()) {
                                Logging.threads.debug((Object)(" Post-hopcount pruned document count is " + Integer.toString(activeDocuments.size())));
                            }
                            IRepositoryConnector connector = null;
                            if ((activeDocuments.size() > 0 || hopcountremoveList.size() > 0) && (connector = repositoryConnectorPool.grab(connection)) == null) {
                                if (Logging.threads.isDebugEnabled()) {
                                    Logging.threads.debug((Object)(" Moving " + WorkerThread.makeListString(activeDocuments) + " to rescanList"));
                                }
                                WorkerThread.moveList(activeDocuments, rescanList);
                                if (Logging.threads.isDebugEnabled()) {
                                    Logging.threads.debug((Object)(" Moving " + WorkerThread.makeListString(hopcountremoveList) + " to rescanList"));
                                }
                                WorkerThread.moveList(hopcountremoveList, rescanList);
                            }
                            if (connector != null) {
                                try {
                                    PipelineSpecification pipelineSpecification;
                                    if (Thread.currentThread().isInterrupted()) {
                                        throw new ManifoldCFException("Interrupted", 2);
                                    }
                                    try {
                                        pipelineSpecification = new PipelineSpecification(pipelineConnections, job, ingester);
                                    }
                                    catch (ServiceInterruption e) {
                                        if (!e.jobInactiveAbort()) {
                                            Logging.jobs.warn((Object)("Service interruption reported for job " + job.getID() + " connection '" + job.getConnectionName() + "': " + e.getMessage()));
                                        }
                                        ArrayList<QueuedDocument> requeueList = new ArrayList<QueuedDocument>();
                                        for (QueuedDocument qd : activeDocuments) {
                                            DocumentDescription dd = qd.getDocumentDescription();
                                            if (!e.jobInactiveAbort() && (dd.getFailTime() != -1L && dd.getFailTime() < e.getRetryTime() || dd.getFailRetryCount() == 0)) {
                                                if (e.isAbortOnFail()) {
                                                    rescanList.add(qd);
                                                    abortOnFail = new ManifoldCFException("Repeated service interruptions - failure processing document" + (e.getCause() != null ? ": " + e.getCause().getMessage() : ""), e.getCause());
                                                    continue;
                                                }
                                                if (Logging.threads.isDebugEnabled()) {
                                                    Logging.threads.debug((Object)(" Adding " + qd.getDocumentDescription().getID() + " to requeueList because of output service interruption"));
                                                }
                                                requeueList.add(qd);
                                                continue;
                                            }
                                            if (Logging.threads.isDebugEnabled()) {
                                                Logging.threads.debug((Object)(" Adding " + qd.getDocumentDescription().getID() + " to requeueList because of output service interruption"));
                                            }
                                            requeueList.add(qd);
                                        }
                                        WorkerThread.requeueDocuments(jobManager, requeueList, e.getRetryTime(), e.getFailTime(), e.getFailRetryCount());
                                        Logging.threads.debug((Object)" Clearing active documents list due to output service interruption");
                                        activeDocuments.clear();
                                        pipelineSpecification = null;
                                    }
                                    if (activeDocuments.size() > 0) {
                                        ExistingVersions existingVersions = new ExistingVersions(lastIndexedOutputConnectionName, activeDocuments);
                                        String aclAuthority = connection.getACLAuthority();
                                        if (aclAuthority == null) {
                                            aclAuthority = "";
                                        }
                                        boolean isDefaultAuthority = aclAuthority.length() == 0;
                                        HashMap<String, QueuedDocument> previousDocuments = new HashMap<String, QueuedDocument>();
                                        String[] documentIDs = new String[activeDocuments.size()];
                                        int k = 0;
                                        for (QueuedDocument qd : activeDocuments) {
                                            previousDocuments.put(qd.getDocumentDescription().getDocumentIdentifierHash(), qd);
                                            documentIDs[k++] = qd.getDocumentDescription().getDocumentIdentifier();
                                        }
                                        ProcessActivity activity = new ProcessActivity(job.getID(), this.processID, rt, jobManager, ingester, connectionName, pipelineSpecification, previousDocuments, currentTime, job.getExpiration(), job.getInterval(), job.getMaxInterval(), job.getHopcountMode(), connection, connector, connMgr, legalLinkTypes, ingestLogger);
                                        try {
                                            ServiceInterruption serviceInterruption;
                                            block125: {
                                                if (Logging.threads.isDebugEnabled()) {
                                                    Logging.threads.debug((Object)("Worker thread about to process " + WorkerThread.makeListString(activeDocuments)));
                                                }
                                                serviceInterruption = null;
                                                try {
                                                    connector.processDocuments(documentIDs, existingVersions, job.getSpecification(), activity, jobType, isDefaultAuthority);
                                                    for (QueuedDocument queuedDocument : activeDocuments) {
                                                        String documentIdentifier = queuedDocument.getDocumentDescription().getDocumentIdentifier();
                                                        if (activity.wasDocumentAborted(documentIdentifier) || activity.wasDocumentDeleted(documentIdentifier)) continue;
                                                        String documentIdentifierHash = queuedDocument.getDocumentDescription().getDocumentIdentifierHash();
                                                        DocumentIngestStatusSet set = queuedDocument.getLastIngestedStatus(ingester.getFirstIndexedOutputConnectionName((IPipelineSpecificationBasic)pipelineConnections));
                                                        if (set == null) continue;
                                                        Iterator componentHashes = set.componentIterator();
                                                        while (componentHashes.hasNext()) {
                                                            String componentHash = (String)componentHashes.next();
                                                            if (activity.wasDocumentComponentTouched(documentIdentifier, componentHash)) continue;
                                                            ingester.documentRemove((IPipelineConnections)pipelineConnections, connectionName, documentIdentifierHash, componentHash, (IOutputRemoveActivity)ingestLogger);
                                                        }
                                                    }
                                                }
                                                catch (ServiceInterruption e) {
                                                    serviceInterruption = e;
                                                    if (e.jobInactiveAbort()) break block125;
                                                    Logging.jobs.warn((Object)("Service interruption reported for job " + job.getID() + " connection '" + job.getConnectionName() + "': " + e.getMessage()));
                                                }
                                            }
                                            activity.flush();
                                            if (Logging.threads.isDebugEnabled()) {
                                                Logging.threads.debug((Object)("Worker thread done processing " + Integer.toString(documentIDs.length) + " documents"));
                                            }
                                            ArrayList<QueuedDocument> requeueList = new ArrayList<QueuedDocument>();
                                            for (QueuedDocument qd : activeDocuments) {
                                                if (activity.wasDocumentAborted(qd.getDocumentDescription().getDocumentIdentifier())) {
                                                    if (Logging.threads.isDebugEnabled()) {
                                                        Logging.threads.debug((Object)(" Adding " + qd.getDocumentDescription().getID() + " to finishList"));
                                                    }
                                                    finishList.add(qd);
                                                } else if (activity.wasDocumentDeleted(qd.getDocumentDescription().getDocumentIdentifier())) {
                                                    if (Logging.threads.isDebugEnabled()) {
                                                        Logging.threads.debug((Object)(" Adding " + qd.getDocumentDescription().getID() + " to deleteList"));
                                                    }
                                                    deleteList.add(qd);
                                                } else if (serviceInterruption != null) {
                                                    DocumentDescription dd = qd.getDocumentDescription();
                                                    if (!serviceInterruption.jobInactiveAbort() && (dd.getFailTime() != -1L && dd.getFailTime() < serviceInterruption.getRetryTime() || dd.getFailRetryCount() == 0)) {
                                                        if (serviceInterruption.isAbortOnFail()) {
                                                            abortOnFail = new ManifoldCFException("Repeated service interruptions - failure processing document" + (serviceInterruption.getCause() != null ? ": " + serviceInterruption.getCause().getMessage() : ""), serviceInterruption.getCause());
                                                            if (Logging.threads.isDebugEnabled()) {
                                                                Logging.threads.debug((Object)(" Adding " + qd.getDocumentDescription().getID() + " to rescanList due to service interruption"));
                                                            }
                                                            rescanList.add(qd);
                                                        } else {
                                                            if (Logging.threads.isDebugEnabled()) {
                                                                Logging.threads.debug((Object)(" Adding " + qd.getDocumentDescription().getID() + " to deleteList due to service interruption"));
                                                            }
                                                            deleteList.add(qd);
                                                        }
                                                    } else {
                                                        if (Logging.threads.isDebugEnabled()) {
                                                            Logging.threads.debug((Object)(" Adding " + qd.getDocumentDescription().getID() + " to requeueList"));
                                                        }
                                                        requeueList.add(qd);
                                                    }
                                                } else {
                                                    if (Logging.threads.isDebugEnabled()) {
                                                        Logging.threads.debug((Object)(" Adding " + qd.getDocumentDescription().getID() + " to finishList"));
                                                    }
                                                    finishList.add(qd);
                                                }
                                                if (activity.wasDocumentTouched(qd.getDocumentDescription().getDocumentIdentifier())) continue;
                                                if (Logging.threads.isDebugEnabled()) {
                                                    Logging.threads.debug((Object)(" Adding " + qd.getDocumentDescription().getID() + " to ingesterCheckList"));
                                                }
                                                ingesterCheckList.add(qd.getDocumentDescription().getDocumentIdentifierHash());
                                            }
                                            if (serviceInterruption != null) {
                                                if (Logging.threads.isDebugEnabled()) {
                                                    Logging.threads.debug((Object)("Requeuing documents " + WorkerThread.makeListString(requeueList)));
                                                }
                                                WorkerThread.requeueDocuments(jobManager, requeueList, serviceInterruption.getRetryTime(), serviceInterruption.getFailTime(), serviceInterruption.getFailRetryCount());
                                            }
                                            if (ingesterCheckList.size() > 0) {
                                                String[] stringArray = new String[ingesterCheckList.size()];
                                                String[] checkIDs = new String[ingesterCheckList.size()];
                                                for (int i = 0; i < checkIDs.length; ++i) {
                                                    stringArray[i] = connectionName;
                                                    checkIDs[i] = (String)ingesterCheckList.get(i);
                                                }
                                                ingester.documentCheckMultiple((IPipelineSpecificationBasic)pipelineConnections, stringArray, checkIDs, currentTime);
                                            }
                                            if (finishList.size() > 0) {
                                                if (Logging.threads.isDebugEnabled()) {
                                                    Logging.threads.debug((Object)("Finishing documents " + WorkerThread.makeListString(finishList)));
                                                }
                                                String[] stringArray = new String[finishList.size()];
                                                k = 0;
                                                for (QueuedDocument qd : finishList) {
                                                    stringArray[k++] = qd.getDocumentDescription().getDocumentIdentifierHash();
                                                }
                                                DocumentDescription[] requeueCandidates = jobManager.finishDocuments(job.getID(), legalLinkTypes, stringArray, job.getHopcountMode());
                                                if (Logging.threads.isDebugEnabled()) {
                                                    Logging.threads.debug((Object)(" Requeueing documents due to carrydown " + WorkerThread.makeListString(requeueCandidates)));
                                                }
                                                ManifoldCF.requeueDocumentsDueToCarrydown(jobManager, requeueCandidates, connector, connection, rt, currentTime);
                                                switch (job.getType()) {
                                                    case 0: {
                                                        DocumentDescription dd;
                                                        String[] timeIDClasses = new String[finishList.size()];
                                                        String[] timeIDHashes = new String[finishList.size()];
                                                        for (int i = 0; i < timeIDHashes.length; ++i) {
                                                            QueuedDocument qd = (QueuedDocument)finishList.get(i);
                                                            dd = qd.getDocumentDescription();
                                                            String documentIDHash = dd.getDocumentIdentifierHash();
                                                            timeIDClasses[i] = connectionName;
                                                            timeIDHashes[i] = documentIDHash;
                                                        }
                                                        Object timeArray = ingester.getDocumentUpdateIntervalMultiple((IPipelineSpecificationBasic)pipelineConnections, timeIDClasses, timeIDHashes);
                                                        Long[] recheckTimeArray = new Long[((Object)timeArray).length];
                                                        int[] actionArray = new int[((Object)timeArray).length];
                                                        DocumentDescription[] recrawlDocs = new DocumentDescription[finishList.size()];
                                                        for (int i = 0; i < finishList.size(); ++i) {
                                                            QueuedDocument qd = (QueuedDocument)finishList.get(i);
                                                            recrawlDocs[i] = qd.getDocumentDescription();
                                                            String documentID = recrawlDocs[i].getDocumentIdentifier();
                                                            boolean wasAborted = activity.wasDocumentAborted(documentID);
                                                            if (wasAborted) {
                                                                if (Logging.scheduling.isDebugEnabled()) {
                                                                    Logging.scheduling.debug((Object)("Document '" + documentID + "' will be RESCANNED as soon as prerequisites are met"));
                                                                }
                                                                actionArray[i] = 0;
                                                                recheckTimeArray[i] = new Long(0L);
                                                                continue;
                                                            }
                                                            Object timeAmt = timeArray[i];
                                                            Long recrawlTime = activity.calculateDocumentRescheduleTime(currentTime, (long)timeAmt, documentID);
                                                            Long expireTime = activity.calculateDocumentExpireTime(currentTime, documentID);
                                                            if (expireTime == null || recrawlTime != null && recrawlTime < expireTime) {
                                                                if (Logging.scheduling.isDebugEnabled()) {
                                                                    Logging.scheduling.debug((Object)("Document '" + documentID + "' will be RESCANNED at " + recrawlTime.toString()));
                                                                }
                                                                recheckTimeArray[i] = recrawlTime;
                                                                actionArray[i] = 0;
                                                                continue;
                                                            }
                                                            if (recrawlTime == null || expireTime != null && recrawlTime > expireTime) {
                                                                if (Logging.scheduling.isDebugEnabled()) {
                                                                    Logging.scheduling.debug((Object)("Document '" + documentID + "' will be REMOVED at " + expireTime.toString()));
                                                                }
                                                                recheckTimeArray[i] = expireTime;
                                                                actionArray[i] = 1;
                                                                continue;
                                                            }
                                                            if (Logging.scheduling.isDebugEnabled() && recrawlTime != null) {
                                                                Logging.scheduling.debug((Object)("Document '" + documentID + "' will be RESCANNED at " + recrawlTime.toString()));
                                                            }
                                                            recheckTimeArray[i] = recrawlTime;
                                                            actionArray[i] = 0;
                                                        }
                                                        if (Logging.threads.isDebugEnabled()) {
                                                            Logging.threads.debug((Object)(" Requeuing " + WorkerThread.makeListString(recrawlDocs)));
                                                        }
                                                        jobManager.requeueDocumentMultiple(recrawlDocs, recheckTimeArray, actionArray);
                                                        break;
                                                    }
                                                    case 1: {
                                                        DocumentDescription[] docDescriptions;
                                                        int[] actionArray;
                                                        Long[] recheckTimeArray;
                                                        DocumentDescription dd;
                                                        ArrayList<DocumentDescription> completedList = new ArrayList<DocumentDescription>();
                                                        ArrayList<DocumentDescription> abortedList = new ArrayList<DocumentDescription>();
                                                        for (QueuedDocument qd : finishList) {
                                                            dd = qd.getDocumentDescription();
                                                            if (activity.wasDocumentAborted(dd.getDocumentIdentifier())) {
                                                                abortedList.add(dd);
                                                                continue;
                                                            }
                                                            completedList.add(dd);
                                                        }
                                                        if (abortedList.size() > 0) {
                                                            docDescriptions = new DocumentDescription[abortedList.size()];
                                                            recheckTimeArray = new Long[docDescriptions.length];
                                                            actionArray = new int[docDescriptions.length];
                                                            for (int i = 0; i < docDescriptions.length; ++i) {
                                                                docDescriptions[i] = (DocumentDescription)abortedList.get(i);
                                                                recheckTimeArray[i] = new Long(0L);
                                                                actionArray[i] = 0;
                                                            }
                                                            if (Logging.threads.isDebugEnabled()) {
                                                                Logging.threads.debug((Object)(" Requeuing " + WorkerThread.makeListString(docDescriptions)));
                                                            }
                                                            jobManager.requeueDocumentMultiple(docDescriptions, recheckTimeArray, actionArray);
                                                        }
                                                        if (completedList.size() <= 0) break;
                                                        docDescriptions = new DocumentDescription[completedList.size()];
                                                        for (int i = 0; i < docDescriptions.length; ++i) {
                                                            docDescriptions[i] = (DocumentDescription)completedList.get(i);
                                                        }
                                                        if (Logging.threads.isDebugEnabled()) {
                                                            Logging.threads.debug((Object)(" Marking completed " + WorkerThread.makeListString(docDescriptions)));
                                                        }
                                                        jobManager.markDocumentCompletedMultiple(docDescriptions);
                                                        break;
                                                    }
                                                    default: {
                                                        throw new ManifoldCFException("Unexpected value for job type: '" + Integer.toString(job.getType()) + "'");
                                                    }
                                                }
                                                for (QueuedDocument qd : finishList) {
                                                    qd.setProcessed();
                                                }
                                            }
                                        }
                                        finally {
                                            activity.discard();
                                        }
                                        long elapsedTime = System.currentTimeMillis() - processingStartTime;
                                        if (Logging.scheduling.isDebugEnabled()) {
                                            Logging.scheduling.debug((Object)("Worker thread for connection " + connectionName + " took " + new Long(elapsedTime).toString() + "ms to handle " + Integer.toString(qds.getCount()) + " documents"));
                                        }
                                        this.queueTracker.noteConnectionPerformance(qds.getCount(), connectionName, elapsedTime);
                                    }
                                    if (Logging.threads.isDebugEnabled()) {
                                        Logging.threads.debug((Object)("Deleting " + WorkerThread.makeListString(deleteList)));
                                    }
                                    WorkerThread.processDeleteLists(pipelineConnections, connector, connection, jobManager, deleteList, ingester, job.getID(), legalLinkTypes, ingestLogger, job.getHopcountMode(), rt, currentTime);
                                    if (Logging.threads.isDebugEnabled()) {
                                        Logging.threads.debug((Object)("Hopcount removal " + WorkerThread.makeListString(hopcountremoveList)));
                                    }
                                    WorkerThread.processHopcountRemovalLists(pipelineConnections, connector, connection, jobManager, hopcountremoveList, ingester, job.getID(), legalLinkTypes, ingestLogger, job.getHopcountMode(), rt, currentTime);
                                }
                                finally {
                                    repositoryConnectorPool.release(connection, connector);
                                }
                            }
                            if (Logging.threads.isDebugEnabled()) {
                                Logging.threads.debug((Object)("Rescanning documents " + WorkerThread.makeListString(rescanList)));
                            }
                            for (QueuedDocument qd : rescanList) {
                                jobManager.resetDocument(qd.getDocumentDescription(), 0L, 0, -1L, -1);
                                qd.setProcessed();
                            }
                        }
                        finally {
                            qds.endProcessing(this.queueTracker);
                        }
                        if (abortOnFail != null) throw abortOnFail;
                        continue;
                        break;
                    }
                    catch (ManifoldCFException e) {
                        if (e.getErrorCode() == 2) {
                        }
                        if (e.getErrorCode() == 4) {
                            throw e;
                        }
                        if (jobManager.errorAbort(qds.getJobDescription().getID(), e.getMessage())) {
                            Logging.threads.error((Object)("Exception tossed: " + e.getMessage()), (Throwable)e);
                        }
                    }
                    finally {
                        for (int i = 0; i < qds.getCount(); ++i) {
                            QueuedDocument qd = qds.getDocument(i);
                            if (qd.wasProcessed()) continue;
                            jobManager.resetDocument(qd.getDocumentDescription(), 0L, 0, -1L, -1);
                        }
                        return;
                    }
                }
                catch (ManifoldCFException e) {
                    if (e.getErrorCode() == 2) return;
                    if (e.getErrorCode() == 4) {
                        this.resetManager.noteEvent();
                        Logging.threads.error((Object)("Worker thread aborting and restarting due to database connection reset: " + e.getMessage()), (Throwable)e);
                        try {
                            ManifoldCF.sleep((long)10000L);
                            continue;
                        }
                        catch (InterruptedException se) {
                            return;
                        }
                    }
                    Logging.threads.error((Object)("Exception tossed: " + e.getMessage()), (Throwable)e);
                    continue;
                }
                catch (InterruptedException e) {
                    return;
                }
                catch (OutOfMemoryError e) {
                    System.err.println("agents process ran out of memory - shutting down");
                    e.printStackTrace(System.err);
                    ManifoldCF.systemExit((int)-200);
                    continue;
                }
                catch (Throwable e) {
                    Logging.threads.fatal((Object)("Error tossed: " + e.getMessage()), e);
                    continue;
                }
                break;
            }
        }
        catch (Throwable e) {
            System.err.println("agents process could not start - shutting down");
            Logging.threads.fatal((Object)("WorkerThread " + this.id + " initialization error tossed: " + e.getMessage()), e);
            ManifoldCF.systemExit((int)-300);
        }
    }

    protected static boolean compareArrays(String[] array1, String[] array2) {
        if (array1.length != array2.length) {
            return false;
        }
        for (int i = 0; i < array1.length; ++i) {
            if (array1[i].equals(array2[i])) continue;
            return false;
        }
        return true;
    }

    protected static String makeListString(List<QueuedDocument> sourceList) {
        StringBuilder sb = new StringBuilder("{");
        for (QueuedDocument qd : sourceList) {
            sb.append(qd.getDocumentDescription().getID()).append(" ");
        }
        sb.append("}");
        return sb.toString();
    }

    protected static String makeListString(DocumentDescription[] sourceList) {
        StringBuilder sb = new StringBuilder("{");
        for (DocumentDescription dd : sourceList) {
            sb.append(dd.getID()).append(" ");
        }
        sb.append("}");
        return sb.toString();
    }

    protected static void moveList(List<QueuedDocument> sourceList, List<QueuedDocument> targetList) {
        for (int i = 0; i < sourceList.size(); ++i) {
            targetList.add(sourceList.get(i));
        }
        sourceList.clear();
    }

    protected static void processHopcountRemovalLists(IPipelineConnections pipelineConnections, IRepositoryConnector connector, IRepositoryConnection connection, IJobManager jobManager, List<QueuedDocument> hopcountremoveList, IIncrementalIngester ingester, Long jobID, String[] legalLinkTypes, OutputActivity ingestLogger, int hopcountMethod, IReprioritizationTracker rt, long currentTime) throws ManifoldCFException {
        hopcountremoveList = WorkerThread.removeFromIndex(pipelineConnections, connection.getName(), jobManager, hopcountremoveList, ingester, ingestLogger);
        WorkerThread.processJobQueueHopcountRemovals(hopcountremoveList, connector, connection, jobManager, jobID, legalLinkTypes, hopcountMethod, rt, currentTime);
    }

    protected static void processDeleteLists(IPipelineConnections pipelineConnections, IRepositoryConnector connector, IRepositoryConnection connection, IJobManager jobManager, List<QueuedDocument> deleteList, IIncrementalIngester ingester, Long jobID, String[] legalLinkTypes, OutputActivity ingestLogger, int hopcountMethod, IReprioritizationTracker rt, long currentTime) throws ManifoldCFException {
        deleteList = WorkerThread.removeFromIndex(pipelineConnections, connection.getName(), jobManager, deleteList, ingester, ingestLogger);
        WorkerThread.processJobQueueDeletions(deleteList, connector, connection, jobManager, jobID, legalLinkTypes, hopcountMethod, rt, currentTime);
    }

    protected static List<QueuedDocument> removeFromIndex(IPipelineConnections pipelineConnections, String connectionName, IJobManager jobManager, List<QueuedDocument> deleteList, IIncrementalIngester ingester, OutputActivity ingestLogger) throws ManifoldCFException {
        ArrayList<String> ingesterDeleteList = new ArrayList<String>(deleteList.size());
        for (int i = 0; i < deleteList.size(); ++i) {
            QueuedDocument qd = deleteList.get(i);
            if (!qd.anyLastIngestedRecords()) continue;
            ingesterDeleteList.add(qd.getDocumentDescription().getDocumentIdentifierHash());
        }
        if (ingesterDeleteList.size() > 0) {
            String[] deleteClasses = new String[ingesterDeleteList.size()];
            String[] deleteIDs = new String[ingesterDeleteList.size()];
            for (int i = 0; i < ingesterDeleteList.size(); ++i) {
                deleteClasses[i] = connectionName;
                deleteIDs[i] = (String)ingesterDeleteList.get(i);
            }
            try {
                ingester.documentDeleteMultiple(pipelineConnections, deleteClasses, deleteIDs, (IOutputRemoveActivity)ingestLogger);
            }
            catch (ServiceInterruption e) {
                int j;
                ArrayList<QueuedDocument> newDeleteList = new ArrayList<QueuedDocument>();
                ArrayList<QueuedDocument> newRequeueList = new ArrayList<QueuedDocument>();
                HashSet<String> ingesterSet = new HashSet<String>();
                for (j = 0; j < ingesterDeleteList.size(); ++j) {
                    String id = (String)ingesterDeleteList.get(j);
                    ingesterSet.add(id);
                }
                for (j = 0; j < deleteList.size(); ++j) {
                    QueuedDocument qd = deleteList.get(j);
                    DocumentDescription dd = qd.getDocumentDescription();
                    String documentIdentifierHash = dd.getDocumentIdentifierHash();
                    if (ingesterSet.contains(documentIdentifierHash)) {
                        newRequeueList.add(qd);
                        continue;
                    }
                    newDeleteList.add(qd);
                }
                WorkerThread.requeueDocuments(jobManager, newRequeueList, e.getRetryTime(), e.getFailTime(), e.getFailRetryCount());
                deleteList = newDeleteList;
            }
        }
        return deleteList;
    }

    protected static void processJobQueueDeletions(List<QueuedDocument> jobmanagerDeleteList, IRepositoryConnector connector, IRepositoryConnection connection, IJobManager jobManager, Long jobID, String[] legalLinkTypes, int hopcountMethod, IReprioritizationTracker rt, long currentTime) throws ManifoldCFException {
        if (jobmanagerDeleteList.size() > 0) {
            DocumentDescription[] deleteDescriptions = new DocumentDescription[jobmanagerDeleteList.size()];
            for (int i = 0; i < deleteDescriptions.length; ++i) {
                QueuedDocument qd = jobmanagerDeleteList.get(i);
                deleteDescriptions[i] = qd.getDocumentDescription();
            }
            DocumentDescription[] requeueCandidates = jobManager.markDocumentDeletedMultiple(jobID, legalLinkTypes, deleteDescriptions, hopcountMethod);
            ManifoldCF.requeueDocumentsDueToCarrydown(jobManager, requeueCandidates, connector, connection, rt, currentTime);
            for (int i = 0; i < jobmanagerDeleteList.size(); ++i) {
                QueuedDocument qd = jobmanagerDeleteList.get(i);
                qd.setProcessed();
            }
        }
    }

    protected static void processJobQueueHopcountRemovals(List<QueuedDocument> jobmanagerRemovalList, IRepositoryConnector connector, IRepositoryConnection connection, IJobManager jobManager, Long jobID, String[] legalLinkTypes, int hopcountMethod, IReprioritizationTracker rt, long currentTime) throws ManifoldCFException {
        if (jobmanagerRemovalList.size() > 0) {
            DocumentDescription[] removalDescriptions = new DocumentDescription[jobmanagerRemovalList.size()];
            for (int i = 0; i < removalDescriptions.length; ++i) {
                QueuedDocument qd = jobmanagerRemovalList.get(i);
                removalDescriptions[i] = qd.getDocumentDescription();
            }
            DocumentDescription[] requeueCandidates = jobManager.markDocumentHopcountRemovalMultiple(jobID, legalLinkTypes, removalDescriptions, hopcountMethod);
            ManifoldCF.requeueDocumentsDueToCarrydown(jobManager, requeueCandidates, connector, connection, rt, currentTime);
            for (QueuedDocument qd : jobmanagerRemovalList) {
                qd.setProcessed();
            }
        }
    }

    protected static void requeueDocuments(IJobManager jobManager, List<QueuedDocument> requeueList, long retryTime, long failTime, int failCount) throws ManifoldCFException {
        if (requeueList.size() > 0) {
            DocumentDescription[] requeueDocs = new DocumentDescription[requeueList.size()];
            for (int i = 0; i < requeueDocs.length; ++i) {
                DocumentDescription dd;
                QueuedDocument qd = requeueList.get(i);
                requeueDocs[i] = dd = qd.getDocumentDescription();
            }
            jobManager.resetDocumentMultiple(requeueDocs, retryTime, 0, failTime, failCount);
            for (QueuedDocument qd : requeueList) {
                qd.setProcessed();
            }
        }
    }

    protected static String computeComponentIDHash(String componentIdentifier) throws ManifoldCFException {
        if (componentIdentifier != null) {
            return ManifoldCF.hash((String)componentIdentifier);
        }
        return null;
    }

    protected static class OutputActivity
    extends CheckActivity
    implements IOutputActivity {
        protected final String connectionName;
        protected final IRepositoryConnectionManager connMgr;

        public OutputActivity(String connectionName, IRepositoryConnectionManager connMgr) {
            this.connectionName = connectionName;
            this.connMgr = connMgr;
        }

        public void recordActivity(Long startTime, String activityType, Long dataSize, String entityURI, String resultCode, String resultDescription) throws ManifoldCFException {
            this.connMgr.recordHistory(this.connectionName, startTime, activityType, dataSize, entityURI, resultCode, resultDescription, null);
        }

        public String qualifyAccessToken(String authorityNameString, String accessToken) throws ManifoldCFException {
            if (authorityNameString == null) {
                return URLEncoder.encode((String)accessToken);
            }
            return URLEncoder.encode((String)authorityNameString) + ":" + URLEncoder.encode((String)accessToken);
        }

        public int sendDocument(String documentURI, RepositoryDocument document) throws ManifoldCFException, ServiceInterruption, IOException {
            return 1;
        }

        public void noDocument() throws ManifoldCFException, ServiceInterruption {
        }
    }

    protected static class ExistingVersions
    implements IExistingVersions {
        protected final Map<String, QueuedDocument> map;
        protected final String lastOutputConnectionName;

        public ExistingVersions(String lastOutputConnectionName, List<QueuedDocument> list) {
            this.lastOutputConnectionName = lastOutputConnectionName;
            this.map = new HashMap<String, QueuedDocument>();
            for (QueuedDocument qd : list) {
                this.map.put(qd.getDocumentDescription().getDocumentIdentifier(), qd);
            }
        }

        @Override
        public String getIndexedVersionString(String documentIdentifier) throws ManifoldCFException {
            return this.getIndexedVersionString(documentIdentifier, null);
        }

        @Override
        public String getIndexedVersionString(String documentIdentifier, String componentIdentifier) throws ManifoldCFException {
            QueuedDocument qd = this.map.get(documentIdentifier);
            DocumentIngestStatusSet status = qd.getLastIngestedStatus(this.lastOutputConnectionName);
            if (status == null) {
                return null;
            }
            String componentIdentifierHash = componentIdentifier == null ? null : ManifoldCF.hash((String)componentIdentifier);
            DocumentIngestStatus s = status.getComponent(componentIdentifierHash);
            if (s == null) {
                return null;
            }
            return s.getDocumentVersion();
        }
    }

    protected static class CheckActivity
    implements IOutputCheckActivity {
        public boolean checkDateIndexable(Date date) throws ManifoldCFException, ServiceInterruption {
            return false;
        }

        public boolean checkMimeTypeIndexable(String mimeType) throws ManifoldCFException, ServiceInterruption {
            return false;
        }

        public boolean checkDocumentIndexable(File localFile) throws ManifoldCFException, ServiceInterruption {
            return false;
        }

        public boolean checkLengthIndexable(long length) throws ManifoldCFException, ServiceInterruption {
            return false;
        }

        public boolean checkURLIndexable(String url) throws ManifoldCFException, ServiceInterruption {
            return false;
        }
    }

    protected static class DocumentToProcess {
        protected QueuedDocument document;
        protected boolean scanOnly;

        public DocumentToProcess(QueuedDocument document, boolean scanOnly) {
            this.document = document;
            this.scanOnly = scanOnly;
        }

        public QueuedDocument getDocument() {
            return this.document;
        }

        public boolean getScanOnly() {
            return this.scanOnly;
        }
    }

    protected static class DocumentReference {
        protected String localIdentifierHash;
        protected String localIdentifier;
        protected DocumentBin db;
        protected HashMap data = new HashMap();
        protected HashMap prereqEvents = new HashMap();

        public DocumentReference(String localIdentifierHash, String localIdentifier, DocumentBin db) {
            this.localIdentifierHash = localIdentifierHash;
            this.localIdentifier = localIdentifier;
            this.db = db;
        }

        public void discard() throws ManifoldCFException {
            for (String dataName : this.data.keySet()) {
                ArrayList list = (ArrayList)this.data.get(dataName);
                int i = 0;
                while (i < list.size()) {
                    Object o;
                    if (!((o = list.get(i++)) instanceof CharacterInput)) continue;
                    ((CharacterInput)o).discard();
                }
            }
        }

        public void addData(String[] dataNames, Object[][] dataValues) {
            if (dataNames == null || dataValues == null) {
                return;
            }
            for (int i = 0; i < dataNames.length; ++i) {
                this.addData(dataNames[i], dataValues[i]);
            }
        }

        public void addData(String dataName, Object[] dataValues) {
            if (dataName == null || dataValues == null) {
                return;
            }
            int i = 0;
            while (i < dataValues.length) {
                this.addData(dataName, dataValues[i++]);
            }
        }

        public void addData(String dataName, Object dataValue) {
            if (dataName == null) {
                return;
            }
            ArrayList<Object> valueMap = (ArrayList<Object>)this.data.get(dataName);
            if (valueMap == null) {
                valueMap = new ArrayList<Object>();
                this.data.put(dataName, valueMap);
            }
            valueMap.add(dataValue);
        }

        public void addPrerequisiteEvents(String[] eventNames) {
            if (eventNames == null) {
                return;
            }
            int i = 0;
            while (i < eventNames.length) {
                this.addPrerequisiteEvent(eventNames[i++]);
            }
        }

        public void addPrerequisiteEvent(String eventName) {
            this.prereqEvents.put(eventName, eventName);
        }

        public DocumentBin getKey() {
            return this.db;
        }

        public String getLocalIdentifierHash() {
            return this.localIdentifierHash;
        }

        public String getLocalIdentifier() {
            return this.localIdentifier;
        }

        public String[] getPrerequisiteEventNames() {
            String[] rval = new String[this.prereqEvents.size()];
            int i = 0;
            Iterator iter = this.prereqEvents.keySet().iterator();
            while (iter.hasNext()) {
                rval[i++] = (String)iter.next();
            }
            return rval;
        }

        public String[] getDataNames() {
            String[] rval = new String[this.data.size()];
            int i = 0;
            for (String dataName : this.data.keySet()) {
                rval[i++] = dataName;
            }
            return rval;
        }

        public Object[][] getDataValues() {
            Object[][] rval = new Object[this.data.size()][];
            int i = 0;
            for (String dataName : this.data.keySet()) {
                ArrayList values = (ArrayList)this.data.get(dataName);
                Object[] valueArray = new Object[values.size()];
                rval[i] = valueArray;
                for (int j = 0; j < valueArray.length; ++j) {
                    valueArray[j] = values.get(j);
                }
                ++i;
            }
            return rval;
        }

        public boolean equals(Object o) {
            if (!(o instanceof DocumentReference)) {
                return false;
            }
            DocumentReference other = (DocumentReference)o;
            if (!other.localIdentifierHash.equals(this.localIdentifierHash)) {
                return false;
            }
            return other.db.equals(this.db);
        }

        public int hashCode() {
            return this.localIdentifierHash.hashCode() + this.db.hashCode();
        }
    }

    protected static class DocumentBin {
        protected String linkType;
        protected String parentIdentifierHash;

        public DocumentBin(String parentIdentifierHash, String linkType) {
            this.parentIdentifierHash = parentIdentifierHash;
            this.linkType = linkType;
        }

        public String getParentIdentifierHash() {
            return this.parentIdentifierHash;
        }

        public String getLinkType() {
            return this.linkType;
        }

        public int hashCode() {
            return (this.linkType == null ? 0 : this.linkType.hashCode()) + (this.parentIdentifierHash == null ? 0 : this.parentIdentifierHash.hashCode());
        }

        public boolean equals(Object o) {
            if (!(o instanceof DocumentBin)) {
                return false;
            }
            DocumentBin db = (DocumentBin)o;
            if (this.linkType == null || db.linkType == null ? this.linkType != db.linkType : !this.linkType.equals(db.linkType)) {
                return false;
            }
            return !(this.parentIdentifierHash == null || db.parentIdentifierHash == null ? this.parentIdentifierHash != db.parentIdentifierHash : !this.parentIdentifierHash.equals(db.parentIdentifierHash));
        }
    }

    protected static class ProcessActivity
    implements IProcessActivity {
        protected final Long jobID;
        protected final String processID;
        protected final IJobManager jobManager;
        protected final IIncrementalIngester ingester;
        protected final String connectionName;
        protected final IPipelineSpecification pipelineSpecification;
        protected final Map<String, QueuedDocument> previousDocuments;
        protected final long currentTime;
        protected final Long expireInterval;
        protected final Long recrawlInterval;
        protected final Long maxInterval;
        protected final int hopcountMode;
        protected final IRepositoryConnection connection;
        protected final IRepositoryConnector connector;
        protected final IRepositoryConnectionManager connMgr;
        protected final String[] legalLinkTypes;
        protected final OutputActivity ingestLogger;
        protected final IReprioritizationTracker rt;
        protected final Map<DocumentReference, DocumentReference> referenceList = new HashMap<DocumentReference, DocumentReference>();
        protected final Map<String, Long> lowerRescheduleBounds = new HashMap<String, Long>();
        protected final Map<String, Long> upperRescheduleBounds = new HashMap<String, Long>();
        protected final Map<String, Long> lowerExpireBounds = new HashMap<String, Long>();
        protected final Map<String, Long> upperExpireBounds = new HashMap<String, Long>();
        protected final Map<String, Long> originationTimes = new HashMap<String, Long>();
        protected final Set<String> abortSet = new HashSet<String>();
        protected final Set<String> touchedSet = new HashSet<String>();
        protected final Set<String> documentDeletedSet = new HashSet<String>();
        protected final Set<String> allComponentsSet = new HashSet<String>();
        protected final Map<String, Set<String>> touchedComponentSet = new HashMap<String, Set<String>>();
        protected final Set<String> touchedPrimarySet = new HashSet<String>();

        public ProcessActivity(Long jobID, String processID, IReprioritizationTracker rt, IJobManager jobManager, IIncrementalIngester ingester, String connectionName, IPipelineSpecification pipelineSpecification, Map<String, QueuedDocument> previousDocuments, long currentTime, Long expireInterval, Long recrawlInterval, Long maxInterval, int hopcountMode, IRepositoryConnection connection, IRepositoryConnector connector, IRepositoryConnectionManager connMgr, String[] legalLinkTypes, OutputActivity ingestLogger) {
            this.jobID = jobID;
            this.processID = processID;
            this.rt = rt;
            this.jobManager = jobManager;
            this.ingester = ingester;
            this.connectionName = connectionName;
            this.pipelineSpecification = pipelineSpecification;
            this.previousDocuments = previousDocuments;
            this.currentTime = currentTime;
            this.expireInterval = expireInterval;
            this.recrawlInterval = recrawlInterval;
            this.maxInterval = maxInterval;
            this.hopcountMode = hopcountMode;
            this.connection = connection;
            this.connector = connector;
            this.connMgr = connMgr;
            this.legalLinkTypes = legalLinkTypes;
            this.ingestLogger = ingestLogger;
        }

        public void discard() throws ManifoldCFException {
            for (DocumentReference dr : this.referenceList.keySet()) {
                dr.discard();
            }
            this.referenceList.clear();
        }

        public boolean wasDocumentTouched(String documentIdentifier) {
            return this.touchedSet.contains(documentIdentifier);
        }

        public boolean wasDocumentComponentTouched(String documentIdentifier, String componentIdentifierHash) {
            if (this.allComponentsSet.contains(documentIdentifier)) {
                return true;
            }
            Set<String> components = this.touchedComponentSet.get(documentIdentifier);
            if (components == null) {
                return false;
            }
            return components.contains(componentIdentifierHash);
        }

        public boolean wasDocumentDeleted(String documentIdentifier) {
            return this.documentDeletedSet.contains(documentIdentifier);
        }

        public boolean wasDocumentAborted(String documentIdentifier) {
            return this.abortSet.contains(documentIdentifier);
        }

        @Override
        public boolean checkDocumentNeedsReindexing(String documentIdentifier, String newVersionString) throws ManifoldCFException {
            return this.checkDocumentNeedsReindexing(documentIdentifier, null, newVersionString);
        }

        @Override
        public boolean checkDocumentNeedsReindexing(String documentIdentifier, String componentIdentifier, String newVersionString) throws ManifoldCFException {
            String documentIdentifierHash = ManifoldCF.hash((String)documentIdentifier);
            String componentIdentifierHash = WorkerThread.computeComponentIDHash(componentIdentifier);
            IPipelineSpecificationWithVersions spec = this.computePipelineSpecificationWithVersions(documentIdentifierHash, componentIdentifierHash, documentIdentifier);
            return this.ingester.checkFetchDocument(spec, newVersionString, this.connection.getACLAuthority());
        }

        @Override
        public void addDocumentReference(String localIdentifier, String parentIdentifier, String relationshipType, String[] dataNames, Object[][] dataValues, Long originationTime, String[] prereqEventNames) throws ManifoldCFException {
            Object[][] savedDataValues;
            DocumentReference dr;
            DocumentReference existingDr;
            long currentTime;
            long expireTime;
            String localIdentifierHash = ManifoldCF.hash((String)localIdentifier);
            String parentIdentifierHash = null;
            if (parentIdentifier != null && parentIdentifier.length() > 0) {
                parentIdentifierHash = ManifoldCF.hash((String)parentIdentifier);
            }
            if (Logging.threads.isDebugEnabled()) {
                Logging.threads.debug((Object)("Adding document reference, from " + (parentIdentifier == null ? "no parent" : "'" + parentIdentifier + "'") + " to '" + localIdentifier + "', relationship type " + (relationshipType == null ? "null" : "'" + relationshipType + "'") + ", with " + (dataNames == null ? "no" : Integer.toString(dataNames.length)) + " data types, origination time=" + (originationTime == null ? "unknown" : originationTime.toString())));
            }
            if (this.expireInterval != null && (expireTime = originationTime == null ? currentTime + this.expireInterval : originationTime + this.expireInterval) <= (currentTime = System.currentTimeMillis())) {
                if (Logging.threads.isDebugEnabled()) {
                    Logging.threads.debug((Object)("Not adding document reference for '" + localIdentifier + "', since it has already expired"));
                }
                return;
            }
            if (this.referenceList.size() == 20) {
                this.processDocumentReferences();
            }
            if ((existingDr = this.referenceList.get(dr = new DocumentReference(localIdentifierHash, localIdentifier, new DocumentBin(parentIdentifierHash, relationshipType)))) == null) {
                this.referenceList.put(dr, dr);
                existingDr = dr;
            }
            if (dataValues != null) {
                savedDataValues = new Object[dataValues.length][];
                for (int q = 0; q < savedDataValues.length; ++q) {
                    Object[] innerArray = dataValues[q];
                    if (innerArray != null) {
                        savedDataValues[q] = new Object[innerArray.length];
                        for (int z = 0; z < innerArray.length; ++z) {
                            Object innerValue = innerArray[z];
                            if (innerValue != null) {
                                if (innerValue instanceof CharacterInput) {
                                    savedDataValues[q][z] = ((CharacterInput)innerValue).transfer();
                                    continue;
                                }
                                savedDataValues[q][z] = innerValue;
                                continue;
                            }
                            savedDataValues[q][z] = null;
                        }
                        continue;
                    }
                    savedDataValues[q] = null;
                }
            } else {
                savedDataValues = null;
            }
            existingDr.addData(dataNames, savedDataValues);
            existingDr.addPrerequisiteEvents(prereqEventNames);
        }

        @Override
        public void addDocumentReference(String localIdentifier, String parentIdentifier, String relationshipType, String[] dataNames, Object[][] dataValues, Long originationTime) throws ManifoldCFException {
            this.addDocumentReference(localIdentifier, parentIdentifier, relationshipType, dataNames, dataValues, originationTime, null);
        }

        @Override
        public void addDocumentReference(String localIdentifier, String parentIdentifier, String relationshipType, String[] dataNames, Object[][] dataValues) throws ManifoldCFException {
            this.addDocumentReference(localIdentifier, parentIdentifier, relationshipType, dataNames, dataValues, null);
        }

        @Override
        public void addDocumentReference(String localIdentifier, String parentIdentifier, String relationshipType) throws ManifoldCFException {
            this.addDocumentReference(localIdentifier, parentIdentifier, relationshipType, null, null);
        }

        @Override
        public void addDocumentReference(String localIdentifier) throws ManifoldCFException {
            this.addDocumentReference(localIdentifier, null, null, null, null);
        }

        @Override
        public String[] retrieveParentData(String localIdentifier, String dataName) throws ManifoldCFException {
            return this.jobManager.retrieveParentData(this.jobID, ManifoldCF.hash((String)localIdentifier), dataName);
        }

        @Override
        public CharacterInput[] retrieveParentDataAsFiles(String localIdentifier, String dataName) throws ManifoldCFException {
            return this.jobManager.retrieveParentDataAsFiles(this.jobID, ManifoldCF.hash((String)localIdentifier), dataName);
        }

        @Override
        public void recordDocument(String documentIdentifier, String version) throws ManifoldCFException {
            this.recordDocument(documentIdentifier, null, version);
        }

        @Override
        public void recordDocument(String documentIdentifier, String componentIdentifier, String version) throws ManifoldCFException {
            String documentIdentifierHash = ManifoldCF.hash((String)documentIdentifier);
            String componentIdentifierHash = WorkerThread.computeComponentIDHash(componentIdentifier);
            this.checkMultipleDispositions(documentIdentifier, componentIdentifier, componentIdentifierHash);
            this.ingester.documentRecord((IPipelineSpecificationBasic)this.pipelineSpecification, this.connectionName, documentIdentifierHash, componentIdentifierHash, version, this.currentTime);
            this.touchedSet.add(documentIdentifier);
            this.touchComponentSet(documentIdentifier, componentIdentifierHash);
        }

        @Override
        public void ingestDocumentWithException(String documentIdentifier, String version, String documentURI, RepositoryDocument data) throws ManifoldCFException, ServiceInterruption, IOException {
            this.ingestDocumentWithException(documentIdentifier, null, version, documentURI, data);
        }

        @Override
        public void ingestDocumentWithException(String documentIdentifier, String componentIdentifier, String version, String documentURI, RepositoryDocument data) throws ManifoldCFException, ServiceInterruption, IOException {
            String documentIdentifierHash = ManifoldCF.hash((String)documentIdentifier);
            String componentIdentifierHash = WorkerThread.computeComponentIDHash(componentIdentifier);
            this.checkMultipleDispositions(documentIdentifier, componentIdentifier, componentIdentifierHash);
            this.ingester.documentIngest(this.computePipelineSpecificationWithVersions(documentIdentifierHash, componentIdentifierHash, documentIdentifier), this.connectionName, documentIdentifierHash, componentIdentifierHash, version, this.connection.getACLAuthority(), data, this.currentTime, documentURI, (IOutputActivity)this.ingestLogger);
            this.touchedSet.add(documentIdentifier);
            this.touchComponentSet(documentIdentifier, componentIdentifierHash);
        }

        @Override
        public void noDocument(String documentIdentifier, String version) throws ManifoldCFException, ServiceInterruption {
            this.noDocument(documentIdentifier, null, version);
        }

        @Override
        public void noDocument(String documentIdentifier, String componentIdentifier, String version) throws ManifoldCFException, ServiceInterruption {
            String documentIdentifierHash = ManifoldCF.hash((String)documentIdentifier);
            String componentIdentifierHash = WorkerThread.computeComponentIDHash(componentIdentifier);
            this.checkMultipleDispositions(documentIdentifier, componentIdentifier, componentIdentifierHash);
            this.ingester.documentNoData(this.computePipelineSpecificationWithVersions(documentIdentifierHash, componentIdentifierHash, documentIdentifier), this.connectionName, documentIdentifierHash, componentIdentifierHash, version, this.connection.getACLAuthority(), this.currentTime, (IOutputActivity)this.ingestLogger);
            this.touchedSet.add(documentIdentifier);
            this.touchComponentSet(documentIdentifier, componentIdentifierHash);
        }

        @Override
        public void removeDocument(String documentIdentifier) throws ManifoldCFException, ServiceInterruption {
            this.checkMultipleDispositions(documentIdentifier, null, null);
            String documentIdentifierHash = ManifoldCF.hash((String)documentIdentifier);
            this.ingester.documentRemove((IPipelineConnections)this.pipelineSpecification, this.connectionName, documentIdentifierHash, null, (IOutputRemoveActivity)this.ingestLogger);
            this.touchedSet.add(documentIdentifier);
            this.touchComponentSet(documentIdentifier, null);
        }

        @Override
        public void retainDocument(String documentIdentifier, String componentIdentifier) throws ManifoldCFException {
            String componentIdentifierHash = WorkerThread.computeComponentIDHash(componentIdentifier);
            this.checkMultipleDispositions(documentIdentifier, componentIdentifier, componentIdentifierHash);
            this.touchComponentSet(documentIdentifier, componentIdentifierHash);
        }

        @Override
        public void retainAllComponentDocument(String documentIdentifier) throws ManifoldCFException {
            this.checkAllComponentsMultipleDispositions(documentIdentifier);
            this.touchAllComponentsSet(documentIdentifier);
        }

        @Override
        public void deleteDocument(String documentIdentifier) throws ManifoldCFException {
            this.documentDeletedSet.add(documentIdentifier);
        }

        @Override
        public void setDocumentScheduleBounds(String localIdentifier, Long lowerRecrawlBoundTime, Long upperRecrawlBoundTime, Long lowerExpireBoundTime, Long upperExpireBoundTime) throws ManifoldCFException {
            if (lowerRecrawlBoundTime != null) {
                this.lowerRescheduleBounds.put(localIdentifier, lowerRecrawlBoundTime);
            } else {
                this.lowerRescheduleBounds.remove(localIdentifier);
            }
            if (upperRecrawlBoundTime != null) {
                this.upperRescheduleBounds.put(localIdentifier, upperRecrawlBoundTime);
            } else {
                this.upperRescheduleBounds.remove(localIdentifier);
            }
            if (lowerExpireBoundTime != null) {
                this.lowerExpireBounds.put(localIdentifier, lowerExpireBoundTime);
            } else {
                this.lowerExpireBounds.remove(localIdentifier);
            }
            if (upperExpireBoundTime != null) {
                this.upperExpireBounds.put(localIdentifier, upperExpireBoundTime);
            } else {
                this.upperExpireBounds.remove(localIdentifier);
            }
        }

        @Override
        public void setDocumentOriginationTime(String localIdentifier, Long originationTime) throws ManifoldCFException {
            if (originationTime == null) {
                this.originationTimes.remove(localIdentifier);
            } else {
                this.originationTimes.put(localIdentifier, originationTime);
            }
        }

        public Long getDocumentRescheduleLowerBoundTime(String localIdentifier) {
            return this.lowerRescheduleBounds.get(localIdentifier);
        }

        public Long getDocumentRescheduleUpperBoundTime(String localIdentifier) {
            return this.upperRescheduleBounds.get(localIdentifier);
        }

        public Long getDocumentExpirationLowerBoundTime(String localIdentifier) {
            return this.lowerExpireBounds.get(localIdentifier);
        }

        public Long getDocumentExpirationUpperBoundTime(String localIdentifier) {
            return this.upperExpireBounds.get(localIdentifier);
        }

        public Long getDocumentOriginationTime(String localIdentifier) {
            return this.originationTimes.get(localIdentifier);
        }

        public Long calculateDocumentRescheduleTime(long currentTime, long timeAmt, String localIdentifier) {
            Long upperBound;
            Long lowerBound;
            Long recrawlTime = null;
            if (this.recrawlInterval != null) {
                long actualInterval = this.recrawlInterval + timeAmt;
                if (this.maxInterval != null && actualInterval > this.maxInterval) {
                    actualInterval = this.maxInterval;
                }
                recrawlTime = new Long(currentTime + actualInterval);
            }
            if (Logging.scheduling.isDebugEnabled()) {
                Logging.scheduling.debug((Object)("Default rescan time for document '" + localIdentifier + "' is " + (recrawlTime == null ? "NEVER" : recrawlTime.toString())));
            }
            if ((lowerBound = this.getDocumentRescheduleLowerBoundTime(localIdentifier)) != null && (recrawlTime == null || recrawlTime < lowerBound)) {
                recrawlTime = lowerBound;
                if (Logging.scheduling.isDebugEnabled()) {
                    Logging.scheduling.debug((Object)(" Rescan time overridden for document '" + localIdentifier + "' due to lower bound; new value is " + recrawlTime.toString()));
                }
            }
            if ((upperBound = this.getDocumentRescheduleUpperBoundTime(localIdentifier)) != null && (recrawlTime == null || recrawlTime > upperBound)) {
                recrawlTime = upperBound;
                if (Logging.scheduling.isDebugEnabled()) {
                    Logging.scheduling.debug((Object)(" Rescan time overridden for document '" + localIdentifier + "' due to upper bound; new value is " + recrawlTime.toString()));
                }
            }
            return recrawlTime;
        }

        public Long calculateDocumentExpireTime(long currentTime, String localIdentifier) {
            Long upperBound;
            Long lowerBound;
            Long originationTime = this.getDocumentOriginationTime(localIdentifier);
            if (originationTime == null) {
                originationTime = new Long(currentTime);
            }
            Long expireTime = null;
            if (this.expireInterval != null) {
                expireTime = new Long(originationTime + this.expireInterval);
            }
            if ((lowerBound = this.getDocumentExpirationLowerBoundTime(localIdentifier)) != null && (expireTime == null || expireTime < lowerBound)) {
                expireTime = lowerBound;
            }
            if ((upperBound = this.getDocumentExpirationUpperBoundTime(localIdentifier)) != null && (expireTime == null || expireTime > upperBound)) {
                expireTime = upperBound;
            }
            return expireTime;
        }

        public void resetTimes() {
            this.lowerRescheduleBounds.clear();
            this.upperRescheduleBounds.clear();
            this.lowerExpireBounds.clear();
            this.upperExpireBounds.clear();
        }

        @Override
        public void recordActivity(Long startTime, String activityType, Long dataSize, String entityIdentifier, String resultCode, String resultDescription, String[] childIdentifiers) throws ManifoldCFException {
            this.connMgr.recordHistory(this.connection.getName(), startTime, activityType, dataSize, entityIdentifier, resultCode, resultDescription, childIdentifiers);
        }

        public void flush() throws ManifoldCFException {
            this.processDocumentReferences();
        }

        protected void processDocumentReferences() throws ManifoldCFException {
            if (this.referenceList.size() == 0) {
                return;
            }
            HashMap<DocumentBin, ArrayList<DocumentReference>> linkBins = new HashMap<DocumentBin, ArrayList<DocumentReference>>();
            for (DocumentReference dr : this.referenceList.keySet()) {
                DocumentBin key = dr.getKey();
                ArrayList<DocumentReference> set = (ArrayList<DocumentReference>)linkBins.get(key);
                if (set == null) {
                    set = new ArrayList<DocumentReference>();
                    linkBins.put(key, set);
                }
                set.add(dr);
            }
            for (DocumentBin db : linkBins.keySet()) {
                List set = (List)linkBins.get(db);
                String[] docidHashes = new String[set.size()];
                String[] docids = new String[set.size()];
                IPriorityCalculator[] priorities = new IPriorityCalculator[set.size()];
                String[][] dataNames = new String[docids.length][];
                Object[][][] dataValues = new Object[docids.length][][];
                String[][] eventNames = new String[docids.length][];
                long currentTime = System.currentTimeMillis();
                double currentMinimumDepth = this.rt.getMinimumDepth();
                this.rt.clearPreloadRequests();
                for (int j = 0; j < docidHashes.length; ++j) {
                    DocumentReference dr = (DocumentReference)set.get(j);
                    docidHashes[j] = dr.getLocalIdentifierHash();
                    docids[j] = dr.getLocalIdentifier();
                    dataNames[j] = dr.getDataNames();
                    dataValues[j] = dr.getDataValues();
                    eventNames[j] = dr.getPrerequisiteEventNames();
                    String[] bins = ManifoldCF.calculateBins(this.connector, dr.getLocalIdentifier());
                    PriorityCalculator p = new PriorityCalculator(this.rt, currentMinimumDepth, this.connection, bins, dr.getLocalIdentifier());
                    priorities[j] = p;
                    p.makePreloadRequest();
                }
                this.rt.preloadBinValues();
                this.jobManager.addDocuments(this.processID, this.jobID, this.legalLinkTypes, docidHashes, docids, db.getParentIdentifierHash(), db.getLinkType(), this.hopcountMode, dataNames, dataValues, priorities, eventNames);
                this.rt.clearPreloadedValues();
            }
            this.discard();
        }

        @Override
        public void checkJobStillActive() throws ManifoldCFException, ServiceInterruption {
            if (!this.jobManager.checkJobActive(this.jobID)) {
                throw new ServiceInterruption("Job no longer active", System.currentTimeMillis());
            }
        }

        @Override
        public boolean beginEventSequence(String eventName) throws ManifoldCFException {
            return this.jobManager.beginEventSequence(this.processID, eventName);
        }

        @Override
        public void completeEventSequence(String eventName) throws ManifoldCFException {
            this.jobManager.completeEventSequence(eventName);
        }

        @Override
        public void retryDocumentProcessing(String localIdentifier) throws ManifoldCFException {
            this.abortSet.add(localIdentifier);
        }

        @Override
        public boolean checkDateIndexable(Date date) throws ManifoldCFException, ServiceInterruption {
            return this.ingester.checkDateIndexable(this.pipelineSpecification, date, (IOutputCheckActivity)this.ingestLogger);
        }

        @Override
        public boolean checkMimeTypeIndexable(String mimeType) throws ManifoldCFException, ServiceInterruption {
            return this.ingester.checkMimeTypeIndexable(this.pipelineSpecification, mimeType, (IOutputCheckActivity)this.ingestLogger);
        }

        @Override
        public boolean checkDocumentIndexable(File localFile) throws ManifoldCFException, ServiceInterruption {
            return this.ingester.checkDocumentIndexable(this.pipelineSpecification, localFile, (IOutputCheckActivity)this.ingestLogger);
        }

        @Override
        public boolean checkLengthIndexable(long length) throws ManifoldCFException, ServiceInterruption {
            return this.ingester.checkLengthIndexable(this.pipelineSpecification, length, (IOutputCheckActivity)this.ingestLogger);
        }

        @Override
        public boolean checkURLIndexable(String url) throws ManifoldCFException, ServiceInterruption {
            return this.ingester.checkURLIndexable(this.pipelineSpecification, url, (IOutputCheckActivity)this.ingestLogger);
        }

        @Override
        public String createGlobalString(String simpleString) {
            return ManifoldCF.createGlobalString(simpleString);
        }

        @Override
        public String createConnectionSpecificString(String simpleString) {
            return ManifoldCF.createConnectionSpecificString(this.connection.getName(), simpleString);
        }

        @Override
        public String createJobSpecificString(String simpleString) {
            return ManifoldCF.createJobSpecificString(this.jobID, simpleString);
        }

        protected void checkAllComponentsMultipleDispositions(String documentIdentifier) {
            if (this.abortSet.contains(documentIdentifier)) {
                throw new IllegalStateException("Multiple document dispositions not allowed: Abort cannot be combined with component disposition; document '" + documentIdentifier + "'");
            }
            if (this.documentDeletedSet.contains(documentIdentifier)) {
                throw new IllegalStateException("Multiple document dispositions not allowed: Document delete cannot be combined with component disposition; document '" + documentIdentifier + "'");
            }
            Set<String> components = this.touchedComponentSet.get(documentIdentifier);
            if (components != null && components.size() > 0) {
                throw new IllegalStateException("Multiple document dispositions not allowed: Retain all components cannot be combined with individual component disposition; document '" + documentIdentifier + "'");
            }
        }

        protected void checkMultipleDispositions(String documentIdentifier, String componentIdentifier, String componentIdentifierHash) {
            if (this.abortSet.contains(documentIdentifier)) {
                throw new IllegalStateException("Multiple document dispositions not allowed: Abort cannot be combined with component disposition; document '" + documentIdentifier + "'");
            }
            if (this.documentDeletedSet.contains(documentIdentifier)) {
                throw new IllegalStateException("Multiple document dispositions not allowed: Document delete cannot be combined with component disposition; document '" + documentIdentifier + "'");
            }
            if (componentIdentifierHash == null) {
                if (this.touchedPrimarySet.contains(documentIdentifier)) {
                    throw new IllegalStateException("Multiple document primary component dispositions not allowed: document '" + documentIdentifier + "'");
                }
            } else {
                if (this.allComponentsSet.contains(documentIdentifier)) {
                    throw new IllegalStateException("Multiple document component dispositions not allowed: document '" + documentIdentifier + "', component '" + componentIdentifier + "'");
                }
                Set<String> components = this.touchedComponentSet.get(documentIdentifier);
                if (components != null && components.contains(componentIdentifierHash)) {
                    throw new IllegalStateException("Multiple document component dispositions not allowed: document '" + documentIdentifier + "', component '" + componentIdentifier + "'");
                }
            }
        }

        protected void touchAllComponentsSet(String documentIdentifier) {
            this.allComponentsSet.add(documentIdentifier);
        }

        protected void touchComponentSet(String documentIdentifier, String componentIdentifierHash) {
            if (componentIdentifierHash == null) {
                this.touchedPrimarySet.add(documentIdentifier);
                return;
            }
            Set<String> components = this.touchedComponentSet.get(documentIdentifier);
            if (components == null) {
                components = new HashSet<String>();
                this.touchedComponentSet.put(documentIdentifier, components);
            }
            components.add(componentIdentifierHash);
        }

        protected IPipelineSpecificationWithVersions computePipelineSpecificationWithVersions(String documentIdentifierHash, String componentIdentifierHash, String documentIdentifier) {
            QueuedDocument qd = this.previousDocuments.get(documentIdentifierHash);
            if (qd == null) {
                throw new IllegalArgumentException("Unrecognized document identifier: '" + documentIdentifier + "'");
            }
            return new PipelineSpecificationWithVersions(this.pipelineSpecification, qd, componentIdentifierHash);
        }
    }
}

