/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing.factory;

import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import org.apache.sis.referencing.IdentifiedObjects;
import org.apache.sis.referencing.factory.AuthorityFactoryProxy;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.ComparisonMode;
import org.apache.sis.util.Utilities;
import org.apache.sis.util.collection.BackingStoreException;
import org.apache.sis.util.logging.Logging;
import org.opengis.metadata.Identifier;
import org.opengis.referencing.AuthorityFactory;
import org.opengis.referencing.IdentifiedObject;
import org.opengis.referencing.NoSuchAuthorityCodeException;
import org.opengis.util.FactoryException;
import org.opengis.util.GenericName;

public class IdentifiedObjectFinder {
    static final ComparisonMode COMPARISON_MODE = ComparisonMode.APPROXIMATIVE;
    protected final AuthorityFactory factory;
    private transient AuthorityFactoryProxy<?> proxy;
    private IdentifiedObjectFinder wrapper;
    private Domain domain = Domain.VALID_DATASET;
    private boolean ignoreAxes;
    boolean ignoreIdentifiers;

    protected IdentifiedObjectFinder(AuthorityFactory authorityFactory) {
        ArgumentChecks.ensureNonNull("factory", authorityFactory);
        this.factory = authorityFactory;
    }

    final void setWrapper(IdentifiedObjectFinder identifiedObjectFinder) {
        this.wrapper = identifiedObjectFinder;
        this.setSearchDomain(identifiedObjectFinder.domain);
        this.setIgnoringAxes(identifiedObjectFinder.ignoreAxes);
    }

    public Domain getSearchDomain() {
        return this.domain;
    }

    public void setSearchDomain(Domain domain) {
        ArgumentChecks.ensureNonNull("domain", (Object)domain);
        this.domain = domain;
    }

    public boolean isIgnoringAxes() {
        return this.ignoreAxes;
    }

    public void setIgnoringAxes(boolean bl) {
        this.ignoreAxes = bl;
    }

    private boolean match(IdentifiedObject identifiedObject, IdentifiedObject identifiedObject2) {
        return Utilities.deepEquals(identifiedObject, identifiedObject2, this.ignoreAxes ? ComparisonMode.ALLOW_VARIANT : COMPARISON_MODE);
    }

    Set<IdentifiedObject> getFromCache(IdentifiedObject identifiedObject) {
        return this.wrapper != null ? this.wrapper.getFromCache(identifiedObject) : null;
    }

    Set<IdentifiedObject> cache(IdentifiedObject identifiedObject, Set<IdentifiedObject> set) {
        if (this.wrapper != null) {
            set = this.wrapper.cache(identifiedObject, set);
        }
        return set;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<IdentifiedObject> find(IdentifiedObject identifiedObject) throws FactoryException {
        ArgumentChecks.ensureNonNull("object", identifiedObject);
        Set<IdentifiedObject> set = this.getFromCache(identifiedObject);
        if (set == null) {
            AuthorityFactoryProxy<?> authorityFactoryProxy = this.proxy;
            this.proxy = AuthorityFactoryProxy.getInstance(identifiedObject.getClass());
            try {
                Object object;
                if (!this.ignoreIdentifiers && !this.ignoreAxes) {
                    object = this.createFromIdentifiers(identifiedObject);
                    if (object != null) {
                        Set<IdentifiedObject> set2 = Collections.singleton(object);
                        return set2;
                    }
                    object = this.createFromNames(identifiedObject);
                    if (object != null) {
                        Set<IdentifiedObject> set3 = Collections.singleton(object);
                        return set3;
                    }
                }
                if (this.domain == Domain.DECLARATION) {
                    object = Collections.emptySet();
                    return object;
                }
                set = this.createFromCodes(identifiedObject);
            }
            finally {
                this.proxy = authorityFactoryProxy;
            }
            set = this.cache(identifiedObject, set);
        }
        return set;
    }

    public IdentifiedObject findSingleton(IdentifiedObject identifiedObject) throws FactoryException {
        IdentifiedObject identifiedObject2 = null;
        boolean bl = false;
        boolean bl2 = false;
        try {
            for (IdentifiedObject identifiedObject3 : this.find(identifiedObject)) {
                boolean bl3;
                boolean bl4 = bl3 = !this.ignoreAxes || Utilities.deepEquals(identifiedObject3, identifiedObject, COMPARISON_MODE);
                if (identifiedObject2 != null) {
                    bl2 = true;
                    if (bl && bl3) {
                        return null;
                    }
                }
                identifiedObject2 = identifiedObject3;
                bl = bl3;
            }
        }
        catch (BackingStoreException backingStoreException) {
            throw backingStoreException.unwrapOrRethrow(FactoryException.class);
        }
        return bl || !bl2 ? identifiedObject2 : null;
    }

    private IdentifiedObject createFromIdentifiers(IdentifiedObject identifiedObject) throws FactoryException {
        for (Identifier identifier : identifiedObject.getIdentifiers()) {
            IdentifiedObject identifiedObject2;
            String string = IdentifiedObjects.toString(identifier);
            if (string.indexOf(58) < 0) continue;
            try {
                identifiedObject2 = this.create(string);
            }
            catch (NoSuchAuthorityCodeException noSuchAuthorityCodeException) {
                IdentifiedObjectFinder.exceptionOccurred((FactoryException)((Object)noSuchAuthorityCodeException));
                continue;
            }
            if (!this.match(identifiedObject2, identifiedObject)) continue;
            return identifiedObject2;
        }
        return null;
    }

    private IdentifiedObject createFromNames(IdentifiedObject identifiedObject) throws FactoryException {
        IdentifiedObject identifiedObject2;
        String string = identifiedObject.getName().getCode();
        try {
            identifiedObject2 = this.create(string);
        }
        catch (FactoryException factoryException) {
            IdentifiedObjectFinder.exceptionOccurred(factoryException);
            identifiedObject2 = null;
        }
        if (this.match(identifiedObject2, identifiedObject)) {
            return identifiedObject2;
        }
        for (GenericName genericName : identifiedObject.getAlias()) {
            string = genericName.toString();
            try {
                identifiedObject2 = this.create(string);
            }
            catch (FactoryException factoryException) {
                IdentifiedObjectFinder.exceptionOccurred(factoryException);
                continue;
            }
            if (!this.match(identifiedObject2, identifiedObject)) continue;
            return identifiedObject2;
        }
        return null;
    }

    Set<IdentifiedObject> createFromCodes(IdentifiedObject identifiedObject) throws FactoryException {
        LinkedHashSet<IdentifiedObject> linkedHashSet = new LinkedHashSet<IdentifiedObject>();
        for (String string : this.getCodeCandidates(identifiedObject)) {
            IdentifiedObject identifiedObject2;
            try {
                identifiedObject2 = this.create(string);
            }
            catch (FactoryException factoryException) {
                IdentifiedObjectFinder.exceptionOccurred(factoryException);
                continue;
            }
            if (!this.match(identifiedObject2, identifiedObject)) continue;
            linkedHashSet.add(identifiedObject2);
        }
        return linkedHashSet;
    }

    private IdentifiedObject create(String string) throws FactoryException {
        return (IdentifiedObject)this.proxy.createFromAPI(this.factory, string);
    }

    protected Set<String> getCodeCandidates(IdentifiedObject identifiedObject) throws FactoryException {
        return this.factory.getAuthorityCodes(this.proxy.type.asSubclass(IdentifiedObject.class));
    }

    private static void exceptionOccurred(FactoryException factoryException) {
        LogRecord logRecord = new LogRecord(Level.FINER, factoryException.getMessage());
        logRecord.setLoggerName("org.apache.sis.referencing.factory");
        Logging.log(IdentifiedObjectFinder.class, "find", logRecord);
    }

    public static enum Domain {
        DECLARATION,
        VALID_DATASET,
        ALL_DATASET;

    }
}

