/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing;

import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import org.apache.sis.internal.referencing.Fallback;
import org.apache.sis.internal.referencing.Resources;
import org.apache.sis.internal.referencing.provider.TransverseMercator;
import org.apache.sis.metadata.iso.citation.Citations;
import org.apache.sis.metadata.iso.citation.DefaultCitation;
import org.apache.sis.referencing.CommonCRS;
import org.apache.sis.referencing.factory.GeodeticAuthorityFactory;
import org.apache.sis.util.CharSequences;
import org.apache.sis.util.resources.Vocabulary;
import org.opengis.metadata.citation.Citation;
import org.opengis.referencing.IdentifiedObject;
import org.opengis.referencing.NoSuchAuthorityCodeException;
import org.opengis.referencing.crs.CRSAuthorityFactory;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.crs.GeocentricCRS;
import org.opengis.referencing.crs.GeographicCRS;
import org.opengis.referencing.crs.ProjectedCRS;
import org.opengis.referencing.crs.VerticalCRS;
import org.opengis.referencing.datum.Datum;
import org.opengis.referencing.datum.DatumAuthorityFactory;
import org.opengis.referencing.datum.Ellipsoid;
import org.opengis.referencing.datum.GeodeticDatum;
import org.opengis.referencing.datum.PrimeMeridian;
import org.opengis.referencing.datum.VerticalDatum;

@Fallback
final class EPSGFactoryFallback
extends GeodeticAuthorityFactory
implements CRSAuthorityFactory,
DatumAuthorityFactory {
    static final boolean FORCE_HARDCODED = false;
    static final EPSGFactoryFallback INSTANCE = new EPSGFactoryFallback();
    private static final int CRS = 1;
    private static final int DATUM = 2;
    private static final int ELLIPSOID = 4;
    private static final int PRIME_MERIDIAN = 8;
    private static final String AUTHORITY = "EPSG-subset";
    private Citation authority;

    private EPSGFactoryFallback() {
    }

    @Override
    public synchronized Citation getAuthority() {
        if (this.authority == null) {
            DefaultCitation defaultCitation = new DefaultCitation(Citations.EPSG);
            defaultCitation.setTitle(Vocabulary.formatInternational((short)95, (Object)defaultCitation.getTitle()));
            this.authority = defaultCitation;
        }
        return this.authority;
    }

    @Override
    public Set<String> getCodeSpaces() {
        return Collections.singleton("EPSG");
    }

    public Set<String> getAuthorityCodes(Class<? extends IdentifiedObject> clazz) {
        boolean bl = clazz.isAssignableFrom(PrimeMeridian.class);
        boolean bl2 = clazz.isAssignableFrom(Ellipsoid.class);
        boolean bl3 = clazz.isAssignableFrom(GeodeticDatum.class);
        boolean bl4 = clazz.isAssignableFrom(GeographicCRS.class);
        boolean bl5 = clazz.isAssignableFrom(GeocentricCRS.class);
        boolean bl6 = clazz.isAssignableFrom(ProjectedCRS.class);
        LinkedHashSet<String> linkedHashSet = new LinkedHashSet<String>();
        if (bl) {
            linkedHashSet.add("8901");
        }
        for (CommonCRS commonCRS : CommonCRS.values()) {
            if (bl2) {
                EPSGFactoryFallback.add(linkedHashSet, commonCRS.ellipsoid);
            }
            if (bl3) {
                EPSGFactoryFallback.add(linkedHashSet, commonCRS.datum);
            }
            if (bl5) {
                EPSGFactoryFallback.add(linkedHashSet, commonCRS.geocentric);
            }
            if (bl4) {
                EPSGFactoryFallback.add(linkedHashSet, commonCRS.geographic);
                EPSGFactoryFallback.add(linkedHashSet, commonCRS.geo3D);
            }
            if (!bl6) continue;
            EPSGFactoryFallback.add(linkedHashSet, commonCRS.northUPS);
            EPSGFactoryFallback.add(linkedHashSet, commonCRS.southUPS);
            if (commonCRS.northUTM == 0 && commonCRS.southUTM == 0) continue;
            for (int i = (int)commonCRS.firstZone; i <= commonCRS.lastZone; ++i) {
                if (commonCRS.northUTM != 0) {
                    linkedHashSet.add(Integer.toString(commonCRS.northUTM + i));
                }
                if (commonCRS.southUTM == 0) continue;
                linkedHashSet.add(Integer.toString(commonCRS.southUTM + i));
            }
        }
        boolean bl7 = clazz.isAssignableFrom(VerticalCRS.class);
        int n = clazz.isAssignableFrom(VerticalDatum.class) ? 1 : 0;
        if (bl7 || n != 0) {
            for (CommonCRS.Vertical vertical : CommonCRS.Vertical.values()) {
                if (!vertical.isEPSG) continue;
                if (bl7) {
                    linkedHashSet.add(Integer.toString(vertical.crs));
                }
                if (n == 0) continue;
                linkedHashSet.add(Integer.toString(vertical.datum));
            }
        }
        return linkedHashSet;
    }

    private static void add(Set<String> set, int n) {
        if (n != 0) {
            set.add(Integer.toString(n));
        }
    }

    @Override
    public PrimeMeridian createPrimeMeridian(String string) throws NoSuchAuthorityCodeException {
        return (PrimeMeridian)this.predefined(string, 8);
    }

    @Override
    public Ellipsoid createEllipsoid(String string) throws NoSuchAuthorityCodeException {
        return (Ellipsoid)this.predefined(string, 4);
    }

    @Override
    public Datum createDatum(String string) throws NoSuchAuthorityCodeException {
        return (Datum)this.predefined(string, 2);
    }

    @Override
    public CoordinateReferenceSystem createCoordinateReferenceSystem(String string) throws NoSuchAuthorityCodeException {
        return (CoordinateReferenceSystem)this.predefined(string, 1);
    }

    @Override
    public IdentifiedObject createObject(String string) throws NoSuchAuthorityCodeException {
        return this.predefined(string, -1);
    }

    private IdentifiedObject predefined(String string, int n) throws NoSuchAuthorityCodeException {
        try {
            string = CharSequences.trimWhitespaces(string, string.lastIndexOf(58) + 1, string.length()).toString();
            int n2 = Integer.parseInt(string);
            if ((n & 8) != 0 && n2 == 8901) {
                return CommonCRS.WGS84.primeMeridian();
            }
            for (CommonCRS enum_ : CommonCRS.values()) {
                double d;
                int n3;
                if ((n & 4) != 0 && n2 == enum_.ellipsoid) {
                    return enum_.ellipsoid();
                }
                if ((n & 2) != 0 && n2 == enum_.datum) {
                    return enum_.datum();
                }
                if ((n & 1) == 0) continue;
                if (n2 == enum_.geographic) {
                    return enum_.geographic();
                }
                if (n2 == enum_.geocentric) {
                    return enum_.geocentric();
                }
                if (n2 == enum_.geo3D) {
                    return enum_.geographic3D();
                }
                if (enum_.northUTM != 0 && (n3 = n2 - enum_.northUTM) >= enum_.firstZone && n3 <= enum_.lastZone) {
                    d = 1.0;
                } else if (enum_.southUTM != 0 && (n3 = n2 - enum_.southUTM) >= enum_.firstZone && n3 <= enum_.lastZone) {
                    d = -1.0;
                } else if (n2 == enum_.northUPS) {
                    d = 90.0;
                    n3 = 30;
                } else {
                    if (n2 != enum_.southUPS) continue;
                    d = -90.0;
                    n3 = 30;
                }
                return enum_.universal(d, TransverseMercator.Zoner.UTM.centralMeridian(n3));
            }
            if ((n & 3) != 0) {
                for (Enum enum_ : CommonCRS.Vertical.values()) {
                    if (!((CommonCRS.Vertical)enum_).isEPSG) continue;
                    if ((n & 2) != 0 && ((CommonCRS.Vertical)enum_).datum == n2) {
                        return ((CommonCRS.Vertical)enum_).datum();
                    }
                    if ((n & 1) == 0 || ((CommonCRS.Vertical)enum_).crs != n2) continue;
                    return ((CommonCRS.Vertical)enum_).crs();
                }
            }
        }
        catch (NumberFormatException numberFormatException) {
            NoSuchAuthorityCodeException noSuchAuthorityCodeException = new NoSuchAuthorityCodeException(Resources.format((short)49, "EPSG", EPSGFactoryFallback.toClass(n), string), AUTHORITY, string);
            noSuchAuthorityCodeException.initCause((Throwable)numberFormatException);
            throw noSuchAuthorityCodeException;
        }
        throw new NoSuchAuthorityCodeException(Resources.format((short)48, "EPSG", EPSGFactoryFallback.toClass(n), string, "http://sis.apache.org/epsg.html"), AUTHORITY, string);
    }

    private static Class<?> toClass(int n) {
        switch (n) {
            case 1: {
                return CoordinateReferenceSystem.class;
            }
            case 2: {
                return Datum.class;
            }
            case 4: {
                return Ellipsoid.class;
            }
            case 8: {
                return PrimeMeridian.class;
            }
        }
        return IdentifiedObject.class;
    }
}

