/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing.operation.transform;

import java.util.Arrays;
import org.apache.sis.internal.referencing.ExtendedPrecisionMatrix;
import org.apache.sis.referencing.operation.matrix.Matrices;
import org.apache.sis.referencing.operation.matrix.MatrixSIS;
import org.apache.sis.referencing.operation.transform.AbstractLinearTransform;
import org.apache.sis.referencing.operation.transform.IterationStrategy;
import org.apache.sis.referencing.operation.transform.LinearTransform;
import org.apache.sis.referencing.operation.transform.ScaleTransform;
import org.apache.sis.util.ArgumentChecks;
import org.opengis.geometry.DirectPosition;
import org.opengis.referencing.operation.Matrix;

class ProjectiveTransform
extends AbstractLinearTransform
implements ExtendedPrecisionMatrix {
    private static final long serialVersionUID = -2104496465933824935L;
    private final int numRow;
    private final int numCol;
    private final double[] elt;

    protected ProjectiveTransform(Matrix matrix) {
        this.numRow = matrix.getNumRow();
        this.numCol = matrix.getNumCol();
        if (matrix instanceof ExtendedPrecisionMatrix) {
            this.elt = ((ExtendedPrecisionMatrix)matrix).getExtendedElements();
            assert (this.elt.length % (this.numRow * this.numCol) == 0);
        } else {
            this.elt = new double[this.numRow * this.numCol];
            int n = 0;
            for (int i = 0; i < this.numRow; ++i) {
                for (int j = 0; j < this.numCol; ++j) {
                    this.elt[n++] = matrix.getElement(i, j);
                }
            }
        }
    }

    final LinearTransform optimize() {
        if (this.numCol < this.numRow) {
            return this;
        }
        int n = (this.numRow - 1) * this.numCol;
        int n2 = 0;
        while (n2 != this.numCol) {
            if (this.elt[n + n2] == (double)(++n2 == this.numCol ? 1 : 0)) continue;
            return this;
        }
        for (n2 = 0; n2 < n; ++n2) {
            if (this.elt[n2] == 0.0 || n2 / this.numCol == n2 % this.numCol) continue;
            return this;
        }
        return new ScaleTransform(this.numRow, this.numCol, this.elt);
    }

    @Override
    public final int getSourceDimensions() {
        return this.numCol - 1;
    }

    @Override
    public final int getTargetDimensions() {
        return this.numRow - 1;
    }

    @Override
    public final int getNumRow() {
        return this.numRow;
    }

    @Override
    public final int getNumCol() {
        return this.numCol;
    }

    @Override
    public final double[] getExtendedElements() {
        return (double[])this.elt.clone();
    }

    public final double getElement(int n, int n2) {
        ArgumentChecks.ensureBetween("row", 0, this.numRow - 1, n);
        ArgumentChecks.ensureBetween("column", 0, this.numCol - 1, n2);
        return this.elt[n * this.numCol + n2];
    }

    @Override
    public final boolean isIdentity() {
        if (this.numRow != this.numCol) {
            return false;
        }
        int n = 0;
        for (int i = 0; i < this.numRow; ++i) {
            for (int j = 0; j < this.numCol; ++j) {
                if (this.elt[n++] == (double)(j == i ? 1 : 0)) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public final Matrix transform(double[] dArray, int n, double[] dArray2, int n2, boolean bl) {
        this.transform(dArray, n, dArray2, n2, 1);
        return bl ? this.derivative(null) : null;
    }

    @Override
    public final void transform(double[] dArray, int n, double[] dArray2, int n2, int n3) {
        int n4;
        int n5;
        int n6 = n5 = this.numCol - 1;
        int n7 = n4 = this.numRow - 1;
        if (dArray == dArray2) {
            switch (IterationStrategy.suggest(n, n5, n2, n4, n3)) {
                case ASCENDING: {
                    break;
                }
                case DESCENDING: {
                    n += (n3 - 1) * n5;
                    n2 += (n3 - 1) * n4;
                    n6 = -n6;
                    n7 = -n7;
                    break;
                }
                default: {
                    dArray = Arrays.copyOfRange(dArray, n, n + n3 * n5);
                    n = 0;
                }
            }
        }
        double[] dArray3 = new double[this.numRow];
        while (--n3 >= 0) {
            int n8 = 0;
            for (int i = 0; i < this.numRow; ++i) {
                double d = this.elt[n8 + n5];
                for (int j = 0; j < n5; ++j) {
                    double d2;
                    if ((d2 = this.elt[n8++]) == 0.0) continue;
                    d += dArray[n + j] * d2;
                }
                dArray3[i] = d;
                ++n8;
            }
            double d = dArray3[n4];
            for (int i = 0; i < n4; ++i) {
                dArray2[n2 + i] = dArray3[i] / d;
            }
            n += n6;
            n2 += n7;
        }
    }

    @Override
    public final void transform(float[] fArray, int n, float[] fArray2, int n2, int n3) {
        int n4;
        int n5;
        int n6 = n5 = this.numCol - 1;
        int n7 = n4 = this.numRow - 1;
        if (fArray == fArray2) {
            switch (IterationStrategy.suggest(n, n5, n2, n4, n3)) {
                case ASCENDING: {
                    break;
                }
                case DESCENDING: {
                    n += (n3 - 1) * n5;
                    n2 += (n3 - 1) * n4;
                    n6 = -n6;
                    n7 = -n7;
                    break;
                }
                default: {
                    fArray = Arrays.copyOfRange(fArray, n, n + n3 * n5);
                    n = 0;
                }
            }
        }
        double[] dArray = new double[this.numRow];
        while (--n3 >= 0) {
            int n8 = 0;
            for (int i = 0; i < this.numRow; ++i) {
                double d = this.elt[n8 + n5];
                for (int j = 0; j < n5; ++j) {
                    double d2;
                    if ((d2 = this.elt[n8++]) == 0.0) continue;
                    d += (double)fArray[n + j] * d2;
                }
                dArray[i] = d;
                ++n8;
            }
            double d = dArray[n4];
            for (int i = 0; i < n4; ++i) {
                fArray2[n2 + i] = (float)(dArray[i] / d);
            }
            n += n6;
            n2 += n7;
        }
    }

    @Override
    public final void transform(double[] dArray, int n, float[] fArray, int n2, int n3) {
        int n4 = this.numCol - 1;
        int n5 = this.numRow - 1;
        double[] dArray2 = new double[this.numRow];
        while (--n3 >= 0) {
            int n6 = 0;
            for (int i = 0; i < this.numRow; ++i) {
                double d = this.elt[n6 + n4];
                for (int j = 0; j < n4; ++j) {
                    double d2;
                    if ((d2 = this.elt[n6++]) == 0.0) continue;
                    d += dArray[n + j] * d2;
                }
                dArray2[i] = d;
                ++n6;
            }
            double d = dArray2[n5];
            for (int i = 0; i < n5; ++i) {
                fArray[n2++] = (float)(dArray2[i] / d);
            }
            n += n4;
        }
    }

    @Override
    public final void transform(float[] fArray, int n, double[] dArray, int n2, int n3) {
        int n4 = this.numCol - 1;
        int n5 = this.numRow - 1;
        double[] dArray2 = new double[this.numRow];
        while (--n3 >= 0) {
            int n6 = 0;
            for (int i = 0; i < this.numRow; ++i) {
                double d = this.elt[n6 + n4];
                for (int j = 0; j < n4; ++j) {
                    double d2;
                    if ((d2 = this.elt[n6++]) == 0.0) continue;
                    d += (double)fArray[n + j] * d2;
                }
                dArray2[i] = d;
                ++n6;
            }
            double d = dArray2[n5];
            for (int i = 0; i < n5; ++i) {
                dArray[n2++] = dArray2[i] / d;
            }
            n += n4;
        }
    }

    @Override
    public final Matrix derivative(DirectPosition directPosition) {
        int n = this.numCol - 1;
        int n2 = this.numRow - 1;
        MatrixSIS matrixSIS = Matrices.createZero(n2, n);
        int n3 = 0;
        for (int i = 0; i < n2; ++i) {
            for (int j = 0; j < n; ++j) {
                matrixSIS.setElement(i, j, this.elt[n3++]);
            }
            ++n3;
        }
        return matrixSIS;
    }

    @Override
    protected int computeHashCode() {
        return Arrays.hashCode(this.elt) + 31 * super.computeHashCode();
    }

    @Override
    protected boolean equalsSameClass(Object object) {
        ProjectiveTransform projectiveTransform = (ProjectiveTransform)object;
        return this.numRow == projectiveTransform.numRow && this.numCol == projectiveTransform.numCol && Arrays.equals(this.elt, projectiveTransform.elt);
    }
}

