/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing.operation;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import javax.measure.IncommensurableException;
import org.apache.sis.internal.jdk8.JDK8;
import org.apache.sis.internal.jdk8.Predicate;
import org.apache.sis.internal.referencing.CoordinateOperations;
import org.apache.sis.internal.referencing.DeferredCoordinateOperation;
import org.apache.sis.internal.referencing.PositionalAccuracyConstant;
import org.apache.sis.internal.referencing.ReferencingUtilities;
import org.apache.sis.internal.referencing.Resources;
import org.apache.sis.internal.referencing.provider.Affine;
import org.apache.sis.internal.system.Semaphores;
import org.apache.sis.metadata.iso.citation.Citations;
import org.apache.sis.metadata.iso.extent.Extents;
import org.apache.sis.referencing.AbstractIdentifiedObject;
import org.apache.sis.referencing.CRS;
import org.apache.sis.referencing.CommonCRS;
import org.apache.sis.referencing.IdentifiedObjects;
import org.apache.sis.referencing.NamedIdentifier;
import org.apache.sis.referencing.cs.CoordinateSystems;
import org.apache.sis.referencing.factory.GeodeticAuthorityFactory;
import org.apache.sis.referencing.factory.IdentifiedObjectFinder;
import org.apache.sis.referencing.factory.InvalidGeodeticParameterException;
import org.apache.sis.referencing.factory.MissingFactoryResourceException;
import org.apache.sis.referencing.factory.NoSuchAuthorityFactoryException;
import org.apache.sis.referencing.operation.AbstractCoordinateOperation;
import org.apache.sis.referencing.operation.CRSPair;
import org.apache.sis.referencing.operation.CompoundCRSBuilder;
import org.apache.sis.referencing.operation.CoordinateOperationContext;
import org.apache.sis.referencing.operation.CoordinateOperationFinder;
import org.apache.sis.referencing.operation.DefaultCoordinateOperationFactory;
import org.apache.sis.referencing.operation.DefaultOperationMethod;
import org.apache.sis.referencing.operation.InverseOperationMethod;
import org.apache.sis.referencing.operation.SubTypes;
import org.apache.sis.referencing.operation.matrix.Matrices;
import org.apache.sis.referencing.operation.transform.DefaultMathTransformFactory;
import org.apache.sis.referencing.operation.transform.MathTransforms;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.Classes;
import org.apache.sis.util.ComparisonMode;
import org.apache.sis.util.Deprecable;
import org.apache.sis.util.Utilities;
import org.apache.sis.util.collection.BackingStoreException;
import org.apache.sis.util.collection.Containers;
import org.apache.sis.util.logging.Logging;
import org.apache.sis.util.resources.Vocabulary;
import org.opengis.metadata.Identifier;
import org.opengis.metadata.extent.Extent;
import org.opengis.metadata.quality.PositionalAccuracy;
import org.opengis.parameter.ParameterDescriptorGroup;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.referencing.IdentifiedObject;
import org.opengis.referencing.NoSuchAuthorityCodeException;
import org.opengis.referencing.ReferenceIdentifier;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.crs.GeodeticCRS;
import org.opengis.referencing.crs.SingleCRS;
import org.opengis.referencing.cs.EllipsoidalCS;
import org.opengis.referencing.operation.ConcatenatedOperation;
import org.opengis.referencing.operation.Conversion;
import org.opengis.referencing.operation.CoordinateOperation;
import org.opengis.referencing.operation.CoordinateOperationAuthorityFactory;
import org.opengis.referencing.operation.CoordinateOperationFactory;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.MathTransformFactory;
import org.opengis.referencing.operation.Matrix;
import org.opengis.referencing.operation.NoninvertibleTransformException;
import org.opengis.referencing.operation.OperationMethod;
import org.opengis.referencing.operation.SingleOperation;
import org.opengis.referencing.operation.Transformation;
import org.opengis.util.FactoryException;
import org.opengis.util.NoSuchIdentifierException;

class CoordinateOperationRegistry {
    static final Identifier IDENTITY = CoordinateOperationRegistry.createIdentifier((short)48);
    static final Identifier AXIS_CHANGES = CoordinateOperationRegistry.createIdentifier((short)8);
    static final Identifier ELLIPSOID_CHANGE = CoordinateOperationRegistry.createIdentifier((short)40);
    static final Identifier DATUM_SHIFT = CoordinateOperationRegistry.createIdentifier((short)26);
    static final Identifier GEOCENTRIC_CONVERSION = CoordinateOperationRegistry.createIdentifier((short)43);
    private static final Identifier INVERSE_OPERATION = CoordinateOperationRegistry.createIdentifier((short)53);
    private final IdentifiedObjectFinder codeFinder;
    protected final CoordinateOperationAuthorityFactory registry;
    protected final CoordinateOperationFactory factory;
    final DefaultCoordinateOperationFactory factorySIS;
    protected Extent areaOfInterest;
    protected double desiredAccuracy;
    private Predicate<CoordinateOperation> filter;

    private static Identifier createIdentifier(short s) {
        return new NamedIdentifier(Citations.SIS, (CharSequence)Vocabulary.formatInternational(s));
    }

    CoordinateOperationRegistry(CoordinateOperationAuthorityFactory coordinateOperationAuthorityFactory, CoordinateOperationFactory coordinateOperationFactory, CoordinateOperationContext coordinateOperationContext) throws FactoryException {
        ArgumentChecks.ensureNonNull("factory", coordinateOperationFactory);
        this.registry = coordinateOperationAuthorityFactory;
        this.factory = coordinateOperationFactory;
        this.factorySIS = coordinateOperationFactory instanceof DefaultCoordinateOperationFactory ? (DefaultCoordinateOperationFactory)coordinateOperationFactory : CoordinateOperations.factory();
        IdentifiedObjectFinder identifiedObjectFinder = null;
        if (coordinateOperationAuthorityFactory != null) {
            if (coordinateOperationAuthorityFactory instanceof GeodeticAuthorityFactory) {
                identifiedObjectFinder = ((GeodeticAuthorityFactory)coordinateOperationAuthorityFactory).newIdentifiedObjectFinder();
            } else {
                try {
                    identifiedObjectFinder = IdentifiedObjects.newFinder(org.apache.sis.internal.util.Citations.getIdentifier(coordinateOperationAuthorityFactory.getAuthority(), false));
                }
                catch (NoSuchAuthorityFactoryException noSuchAuthorityFactoryException) {
                    Logging.recoverableException(Logging.getLogger("org.apache.sis.referencing.operation"), CoordinateOperationRegistry.class, "<init>", (Throwable)((Object)noSuchAuthorityFactoryException));
                }
            }
            if (identifiedObjectFinder != null) {
                identifiedObjectFinder.setIgnoringAxes(true);
            }
        }
        this.codeFinder = identifiedObjectFinder;
        if (coordinateOperationContext != null) {
            this.areaOfInterest = coordinateOperationContext.getAreaOfInterest();
            this.desiredAccuracy = coordinateOperationContext.getDesiredAccuracy();
            this.filter = coordinateOperationContext.getOperationFilter();
        }
    }

    final <T extends IdentifiedObject> T toAuthorityDefinition(Class<T> clazz, T t) throws FactoryException {
        if (this.codeFinder != null) {
            this.codeFinder.setIgnoringAxes(false);
            IdentifiedObject identifiedObject = this.codeFinder.findSingleton(t);
            this.codeFinder.setIgnoringAxes(true);
            if (Utilities.equalsIgnoreMetadata(t, identifiedObject)) {
                return (T)((IdentifiedObject)clazz.cast(identifiedObject));
            }
        }
        return t;
    }

    private List<String> findCode(CoordinateReferenceSystem coordinateReferenceSystem) throws FactoryException {
        ArrayList<String> arrayList = new ArrayList<String>();
        if (this.codeFinder != null) {
            for (IdentifiedObject identifiedObject : this.codeFinder.find((IdentifiedObject)coordinateReferenceSystem)) {
                Identifier identifier = IdentifiedObjects.getIdentifier(identifiedObject, this.registry.getAuthority());
                if (identifier == null) continue;
                String string = identifier.getCode();
                if (Utilities.deepEquals(identifiedObject, coordinateReferenceSystem, ComparisonMode.APPROXIMATIVE)) {
                    arrayList.add(0, string);
                    continue;
                }
                arrayList.add(string);
            }
        }
        return arrayList;
    }

    public CoordinateOperation createOperation(CoordinateReferenceSystem coordinateReferenceSystem, CoordinateReferenceSystem coordinateReferenceSystem2) throws FactoryException {
        CoordinateReferenceSystem coordinateReferenceSystem3 = coordinateReferenceSystem;
        CoordinateReferenceSystem coordinateReferenceSystem4 = coordinateReferenceSystem2;
        int n = 0;
        while (true) {
            block15: {
                switch (n) {
                    case 0: {
                        break;
                    }
                    case 1: {
                        coordinateReferenceSystem4 = CRS.getHorizontalComponent(coordinateReferenceSystem2);
                        if (coordinateReferenceSystem4 != coordinateReferenceSystem2) break;
                        break block15;
                    }
                    case 2: {
                        coordinateReferenceSystem3 = CRS.getHorizontalComponent(coordinateReferenceSystem);
                        if (coordinateReferenceSystem3 != coordinateReferenceSystem) break;
                        break block15;
                    }
                    case 3: {
                        if (coordinateReferenceSystem3 != coordinateReferenceSystem && coordinateReferenceSystem4 != coordinateReferenceSystem2) {
                            coordinateReferenceSystem4 = coordinateReferenceSystem2;
                            break;
                        }
                        break block15;
                    }
                    default: {
                        return null;
                    }
                }
                if (coordinateReferenceSystem3 != null && coordinateReferenceSystem4 != null) {
                    try {
                        CoordinateOperation coordinateOperation = this.search(coordinateReferenceSystem3, coordinateReferenceSystem4);
                        if (coordinateOperation == null) break block15;
                        if (n != 0) {
                            coordinateOperation = this.propagateVertical(coordinateReferenceSystem, coordinateReferenceSystem3 != coordinateReferenceSystem, coordinateReferenceSystem2, coordinateReferenceSystem4 != coordinateReferenceSystem2, coordinateOperation);
                            if (coordinateOperation == null) break block15;
                            coordinateOperation = this.complete(coordinateOperation, coordinateReferenceSystem, coordinateReferenceSystem2);
                        }
                        return coordinateOperation;
                    }
                    catch (IllegalArgumentException | IncommensurableException exception) {
                        String string = Resources.format((short)5, new CRSPair(coordinateReferenceSystem, coordinateReferenceSystem2));
                        String string2 = exception.getLocalizedMessage();
                        if (string2 != null) {
                            string = string + ' ' + string2;
                        }
                        throw new FactoryException(string, (Throwable)exception);
                    }
                }
            }
            ++n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private CoordinateOperation search(CoordinateReferenceSystem coordinateReferenceSystem, CoordinateReferenceSystem coordinateReferenceSystem2) throws IllegalArgumentException, IncommensurableException, FactoryException {
        List<String> list = this.findCode(coordinateReferenceSystem);
        if (list.isEmpty()) {
            return null;
        }
        List<String> list2 = this.findCode(coordinateReferenceSystem2);
        if (list2.isEmpty()) {
            return null;
        }
        Collection collection = null;
        boolean bl = false;
        block15: for (String string : list) {
            for (String string2 : list2) {
                if (string.equals(string2)) {
                    return null;
                }
                boolean bl2 = Semaphores.queryAndSet(2);
                try {
                    try {
                        collection = this.registry.createFromCoordinateReferenceSystemCodes(string, string2);
                        bl = Containers.isNullOrEmpty(collection);
                        if (!bl || !Containers.isNullOrEmpty(collection = this.registry.createFromCoordinateReferenceSystemCodes(string2, string))) continue block15;
                    }
                    finally {
                        if (bl2) continue;
                        Semaphores.clear(2);
                    }
                }
                catch (MissingFactoryResourceException | NoSuchAuthorityCodeException object) {
                    CoordinateOperationRegistry.log(null, (Exception)object);
                }
            }
        }
        if (collection == null) {
            return null;
        }
        while (true) {
            CoordinateOperation coordinateOperation;
            block28: {
                boolean bl3;
                coordinateOperation = null;
                double d = 0.0;
                double d2 = Double.POSITIVE_INFINITY;
                boolean bl4 = false;
                Iterator iterator = collection.iterator();
                while (true) {
                    boolean bl5;
                    CoordinateOperation coordinateOperation2;
                    bl3 = Semaphores.queryAndSet(2);
                    try {
                        try {
                            if (!iterator.hasNext()) break;
                            coordinateOperation2 = (CoordinateOperation)iterator.next();
                        }
                        finally {
                            if (!bl3) {
                                Semaphores.clear(2);
                            }
                        }
                    }
                    catch (BackingStoreException backingStoreException) {
                        throw backingStoreException.unwrapOrRethrow(FactoryException.class);
                    }
                    if (coordinateOperation2 == null) continue;
                    boolean bl6 = bl5 = coordinateOperation2 instanceof Deprecable && ((Deprecable)coordinateOperation2).isDeprecated();
                    if (bl5 && bl4) break;
                    double d3 = Extents.area(Extents.intersection(Extents.getGeographicBoundingBox(this.areaOfInterest), Extents.getGeographicBoundingBox(coordinateOperation2.getDomainOfValidity())));
                    if (coordinateOperation != null && !(d3 >= d)) continue;
                    double d4 = CRS.getLinearAccuracy(coordinateOperation2);
                    if (coordinateOperation != null && d3 == d && !(d4 < d2)) continue;
                    coordinateOperation = coordinateOperation2;
                    if (!Double.isNaN(d3)) {
                        d = d3;
                    }
                    d2 = Double.isNaN(d4) ? Double.POSITIVE_INFINITY : d4;
                    bl4 = !bl5;
                }
                if (coordinateOperation == null) return coordinateOperation;
                CoordinateOperation coordinateOperation3 = coordinateOperation;
                try {
                    if (coordinateOperation instanceof DeferredCoordinateOperation) {
                        coordinateOperation = ((DeferredCoordinateOperation)coordinateOperation).create();
                    }
                    if (coordinateOperation instanceof SingleOperation && coordinateOperation.getMathTransform() == null && (coordinateOperation = this.fromDefiningConversion((SingleOperation)coordinateOperation, bl ? coordinateReferenceSystem2 : coordinateReferenceSystem, bl ? coordinateReferenceSystem : coordinateReferenceSystem2)) == null) {
                        return null;
                    }
                    if (!bl) break block28;
                    coordinateOperation = this.inverse(coordinateOperation);
                }
                catch (MissingFactoryResourceException | NoninvertibleTransformException object) {
                    try {
                        bl3 = collection.remove(coordinateOperation3);
                    }
                    catch (UnsupportedOperationException unsupportedOperationException) {
                        collection = new ArrayList(collection);
                        bl3 = collection.remove(coordinateOperation3);
                    }
                    if (!bl3) throw object instanceof FactoryException ? (FactoryException)((Object)object) : new FactoryException((Throwable)object);
                    CoordinateOperationRegistry.log(null, (Exception)object);
                    continue;
                }
            }
            if (this.filter(coordinateOperation = this.complete(coordinateOperation, coordinateReferenceSystem, coordinateReferenceSystem2))) return coordinateOperation;
        }
    }

    final boolean filter(CoordinateOperation coordinateOperation) {
        return this.filter == null || this.filter.test(coordinateOperation);
    }

    final CoordinateOperation inverse(SingleOperation singleOperation) throws NoninvertibleTransformException, FactoryException {
        CoordinateReferenceSystem coordinateReferenceSystem = singleOperation.getSourceCRS();
        CoordinateReferenceSystem coordinateReferenceSystem2 = singleOperation.getTargetCRS();
        MathTransform mathTransform = singleOperation.getMathTransform().inverse();
        OperationMethod operationMethod = InverseOperationMethod.create(singleOperation.getMethod());
        Map<String, Object> map = CoordinateOperationRegistry.properties(INVERSE_OPERATION);
        InverseOperationMethod.properties(singleOperation, map);
        Class<Transformation> clazz = null;
        if (singleOperation instanceof Transformation) {
            clazz = Transformation.class;
        } else if (singleOperation instanceof Conversion) {
            clazz = Conversion.class;
        }
        return this.createFromMathTransform(map, coordinateReferenceSystem2, coordinateReferenceSystem, mathTransform, operationMethod, null, clazz);
    }

    private CoordinateOperation inverse(CoordinateOperation coordinateOperation) throws NoninvertibleTransformException, FactoryException {
        if (SubTypes.isSingleOperation(coordinateOperation)) {
            return this.inverse((SingleOperation)coordinateOperation);
        }
        if (coordinateOperation instanceof ConcatenatedOperation) {
            List list = ((ConcatenatedOperation)coordinateOperation).getOperations();
            CoordinateOperation[] coordinateOperationArray = new CoordinateOperation[list.size()];
            int n = 0;
            while (n < coordinateOperationArray.length) {
                CoordinateOperation coordinateOperation2 = this.inverse((CoordinateOperation)list.get(n));
                if (coordinateOperation2 == null) {
                    return null;
                }
                coordinateOperationArray[coordinateOperationArray.length - ++n] = coordinateOperation2;
            }
            return this.factory.createConcatenatedOperation(CoordinateOperationRegistry.properties(INVERSE_OPERATION), coordinateOperationArray);
        }
        return null;
    }

    private CoordinateOperation complete(CoordinateOperation coordinateOperation, CoordinateReferenceSystem coordinateReferenceSystem, CoordinateReferenceSystem coordinateReferenceSystem2) throws IllegalArgumentException, IncommensurableException, FactoryException {
        CoordinateReferenceSystem coordinateReferenceSystem3 = coordinateOperation.getSourceCRS();
        CoordinateReferenceSystem coordinateReferenceSystem4 = coordinateOperation.getTargetCRS();
        MathTransformFactory mathTransformFactory = this.factorySIS.getMathTransformFactory();
        MathTransform mathTransform = CoordinateOperationRegistry.swapAndScaleAxes(coordinateReferenceSystem, coordinateReferenceSystem3, mathTransformFactory);
        MathTransform mathTransform2 = CoordinateOperationRegistry.swapAndScaleAxes(coordinateReferenceSystem4, coordinateReferenceSystem2, mathTransformFactory);
        if (mathTransform != null) {
            coordinateReferenceSystem3 = coordinateReferenceSystem;
        }
        if (mathTransform2 != null) {
            coordinateReferenceSystem4 = coordinateReferenceSystem2;
        }
        return this.transform(coordinateReferenceSystem3, mathTransform, coordinateOperation, mathTransform2, coordinateReferenceSystem4, mathTransformFactory);
    }

    private static MathTransform swapAndScaleAxes(CoordinateReferenceSystem coordinateReferenceSystem, CoordinateReferenceSystem coordinateReferenceSystem2, MathTransformFactory mathTransformFactory) throws IllegalArgumentException, IncommensurableException, FactoryException {
        assert (ReferencingUtilities.getDimension(coordinateReferenceSystem) != ReferencingUtilities.getDimension(coordinateReferenceSystem2) || Utilities.deepEquals(coordinateReferenceSystem, coordinateReferenceSystem2, ComparisonMode.ALLOW_VARIANT));
        Matrix matrix = CoordinateSystems.swapAndScaleAxes(coordinateReferenceSystem.getCoordinateSystem(), coordinateReferenceSystem2.getCoordinateSystem());
        return matrix.isIdentity() ? null : mathTransformFactory.createAffineTransform(matrix);
    }

    private CoordinateOperation transform(CoordinateReferenceSystem coordinateReferenceSystem, MathTransform mathTransform, CoordinateOperation coordinateOperation, MathTransform mathTransform2, CoordinateReferenceSystem coordinateReferenceSystem2, MathTransformFactory mathTransformFactory) throws IllegalArgumentException, FactoryException {
        Object object;
        if ((mathTransform == null || mathTransform.isIdentity()) && (mathTransform2 == null || mathTransform2.isIdentity())) {
            return coordinateOperation;
        }
        if (coordinateOperation instanceof ConcatenatedOperation) {
            object = ((ConcatenatedOperation)coordinateOperation).getOperations();
            CoordinateOperation[] coordinateOperationArray = object.toArray(new CoordinateOperation[object.size()]);
            switch (coordinateOperationArray.length) {
                case 0: {
                    break;
                }
                case 1: {
                    coordinateOperation = coordinateOperationArray[0];
                    break;
                }
                default: {
                    int n = coordinateOperationArray.length - 1;
                    CoordinateOperation coordinateOperation2 = coordinateOperationArray[0];
                    CoordinateOperation coordinateOperation3 = coordinateOperationArray[n];
                    coordinateOperationArray[0] = this.transform(coordinateReferenceSystem, mathTransform, coordinateOperation2, null, coordinateOperation2.getTargetCRS(), mathTransformFactory);
                    coordinateOperationArray[n] = this.transform(coordinateOperation3.getSourceCRS(), null, coordinateOperation3, mathTransform2, coordinateReferenceSystem2, mathTransformFactory);
                    return this.factory.createConcatenatedOperation(CoordinateOperationRegistry.derivedFrom((IdentifiedObject)coordinateOperation), coordinateOperationArray);
                }
            }
        }
        object = coordinateOperation.getMathTransform();
        if (mathTransform != null) {
            object = mathTransformFactory.createConcatenatedTransform(mathTransform, (MathTransform)object);
        }
        if (mathTransform2 != null) {
            object = mathTransformFactory.createConcatenatedTransform((MathTransform)object, mathTransform2);
        }
        assert (!object.equals(coordinateOperation.getMathTransform())) : object;
        return this.recreate(coordinateOperation, coordinateReferenceSystem, coordinateReferenceSystem2, (MathTransform)object, null);
    }

    private CoordinateOperation recreate(CoordinateOperation coordinateOperation, CoordinateReferenceSystem coordinateReferenceSystem, CoordinateReferenceSystem coordinateReferenceSystem2, MathTransform mathTransform, OperationMethod operationMethod) throws IllegalArgumentException, FactoryException {
        CoordinateReferenceSystem coordinateReferenceSystem3 = coordinateOperation.getSourceCRS();
        if (Utilities.equalsApproximatively(coordinateReferenceSystem, coordinateReferenceSystem3)) {
            coordinateReferenceSystem = coordinateReferenceSystem3;
        }
        if (Utilities.equalsApproximatively(coordinateReferenceSystem2, coordinateReferenceSystem3 = coordinateOperation.getTargetCRS())) {
            coordinateReferenceSystem2 = coordinateReferenceSystem3;
        }
        HashMap hashMap = new HashMap(CoordinateOperationRegistry.derivedFrom((IdentifiedObject)coordinateOperation));
        Class<Object> clazz = coordinateOperation instanceof AbstractIdentifiedObject ? ((AbstractIdentifiedObject)coordinateOperation).getInterface() : Classes.getLeafInterfaces(coordinateOperation.getClass(), CoordinateOperation.class)[0];
        hashMap.put("operationType", clazz);
        if (SubTypes.isSingleOperation(coordinateOperation)) {
            SingleOperation singleOperation = (SingleOperation)coordinateOperation;
            hashMap.put("parameters", singleOperation.getParameterValues());
            if (operationMethod == null) {
                int n = mathTransform.getSourceDimensions();
                int n2 = mathTransform.getTargetDimensions();
                operationMethod = singleOperation.getMethod();
                try {
                    operationMethod = DefaultOperationMethod.redimension(operationMethod, n, n2);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    try {
                        operationMethod = this.factorySIS.getOperationMethod(operationMethod.getName().getCode());
                        operationMethod = DefaultOperationMethod.redimension(operationMethod, n, n2);
                    }
                    catch (IllegalArgumentException | NoSuchIdentifierException throwable) {
                        illegalArgumentException.addSuppressed(throwable);
                        throw illegalArgumentException;
                    }
                }
            }
        }
        return this.factorySIS.createSingleOperation(hashMap, coordinateReferenceSystem, coordinateReferenceSystem2, AbstractCoordinateOperation.getInterpolationCRS(coordinateOperation), operationMethod, mathTransform);
    }

    private CoordinateOperation fromDefiningConversion(SingleOperation singleOperation, CoordinateReferenceSystem coordinateReferenceSystem, CoordinateReferenceSystem coordinateReferenceSystem2) throws FactoryException {
        ParameterValueGroup parameterValueGroup = singleOperation.getParameterValues();
        if (parameterValueGroup != null) {
            MathTransformFactory mathTransformFactory;
            CoordinateReferenceSystem coordinateReferenceSystem3 = singleOperation.getSourceCRS();
            if (Utilities.equalsApproximatively(coordinateReferenceSystem, coordinateReferenceSystem3)) {
                coordinateReferenceSystem = coordinateReferenceSystem3;
            }
            if (Utilities.equalsApproximatively(coordinateReferenceSystem2, coordinateReferenceSystem3 = singleOperation.getTargetCRS())) {
                coordinateReferenceSystem2 = coordinateReferenceSystem3;
            }
            if ((mathTransformFactory = this.factorySIS.getMathTransformFactory()) instanceof DefaultMathTransformFactory) {
                MathTransform mathTransform = ((DefaultMathTransformFactory)mathTransformFactory).createParameterizedTransform(parameterValueGroup, ReferencingUtilities.createTransformContext(coordinateReferenceSystem, coordinateReferenceSystem2, null));
                return this.factorySIS.createSingleOperation(IdentifiedObjects.getProperties((IdentifiedObject)singleOperation, new String[0]), coordinateReferenceSystem, coordinateReferenceSystem2, null, singleOperation.getMethod(), mathTransform);
            }
        } else {
            CoordinateOperationRegistry.log(Resources.forLocale(null).getLogRecord(Level.WARNING, (short)74, IdentifiedObjects.getIdentifierOrName((IdentifiedObject)singleOperation)), null);
        }
        return null;
    }

    private CoordinateOperation propagateVertical(CoordinateReferenceSystem coordinateReferenceSystem, boolean bl, CoordinateReferenceSystem coordinateReferenceSystem2, boolean bl2, CoordinateOperation coordinateOperation) throws IllegalArgumentException, FactoryException {
        ArrayList<CoordinateOperation> arrayList = new ArrayList<CoordinateOperation>();
        if (coordinateOperation instanceof ConcatenatedOperation) {
            arrayList.addAll(((ConcatenatedOperation)coordinateOperation).getOperations());
        } else {
            arrayList.add(coordinateOperation);
        }
        if (bl && !this.propagateVertical(coordinateReferenceSystem, coordinateReferenceSystem2, arrayList.listIterator(), true) || bl2 && !this.propagateVertical(coordinateReferenceSystem, coordinateReferenceSystem2, arrayList.listIterator(arrayList.size()), false)) {
            return null;
        }
        switch (arrayList.size()) {
            case 0: {
                return null;
            }
            case 1: {
                return (CoordinateOperation)arrayList.get(0);
            }
        }
        return this.factory.createConcatenatedOperation(CoordinateOperationRegistry.derivedFrom((IdentifiedObject)coordinateOperation), arrayList.toArray(new CoordinateOperation[arrayList.size()]));
    }

    private boolean propagateVertical(CoordinateReferenceSystem coordinateReferenceSystem, CoordinateReferenceSystem coordinateReferenceSystem2, ListIterator<CoordinateOperation> listIterator, boolean bl) throws IllegalArgumentException, FactoryException {
        CoordinateReferenceSystem coordinateReferenceSystem3;
        CoordinateOperation coordinateOperation;
        CoordinateReferenceSystem coordinateReferenceSystem4;
        while ((bl ? listIterator.hasNext() : listIterator.hasPrevious()) && (coordinateReferenceSystem4 = (coordinateOperation = bl ? listIterator.next() : listIterator.previous()).getSourceCRS()) instanceof GeodeticCRS && (coordinateReferenceSystem3 = coordinateOperation.getTargetCRS()) instanceof GeodeticCRS && coordinateReferenceSystem4.getCoordinateSystem() instanceof EllipsoidalCS && coordinateReferenceSystem3.getCoordinateSystem() instanceof EllipsoidalCS) {
            boolean bl2;
            Matrix matrix = MathTransforms.getMatrix(coordinateOperation.getMathTransform());
            if (matrix == null) {
                MathTransform mathTransform;
                MathTransformFactory mathTransformFactory;
                if (!SubTypes.isSingleOperation(coordinateOperation) || !((mathTransformFactory = this.factorySIS.getMathTransformFactory()) instanceof DefaultMathTransformFactory)) break;
                if (bl) {
                    coordinateReferenceSystem4 = this.toGeodetic3D(coordinateReferenceSystem4, coordinateReferenceSystem);
                } else {
                    coordinateReferenceSystem3 = this.toGeodetic3D(coordinateReferenceSystem3, coordinateReferenceSystem2);
                }
                try {
                    mathTransform = ((DefaultMathTransformFactory)mathTransformFactory).createParameterizedTransform(((SingleOperation)coordinateOperation).getParameterValues(), ReferencingUtilities.createTransformContext(coordinateReferenceSystem4, coordinateReferenceSystem3, null));
                }
                catch (InvalidGeodeticParameterException invalidGeodeticParameterException) {
                    CoordinateOperationRegistry.log(null, (Exception)((Object)invalidGeodeticParameterException));
                    break;
                }
                listIterator.set(this.recreate(coordinateOperation, coordinateReferenceSystem4, coordinateReferenceSystem3, mathTransform, mathTransformFactory.getLastMethodUsed()));
                return true;
            }
            int n = matrix.getNumRow();
            int n2 = matrix.getNumCol();
            boolean bl3 = bl2 = n2 == 3 && n == 3;
            if (!bl2 && !(bl ? n2 == 3 && n == 4 : n2 == 4 && n == 3)) break;
            if ((matrix = Matrices.resizeAffine(matrix, 4, 4)).isIdentity()) {
                listIterator.remove();
            } else {
                MathTransform mathTransform = this.factorySIS.getMathTransformFactory().createAffineTransform(matrix);
                listIterator.set(this.recreate(coordinateOperation, this.toGeodetic3D(coordinateReferenceSystem4, coordinateReferenceSystem), this.toGeodetic3D(coordinateReferenceSystem3, coordinateReferenceSystem2), mathTransform, null));
            }
            if (bl2) continue;
            return true;
        }
        return false;
    }

    private CoordinateReferenceSystem toGeodetic3D(CoordinateReferenceSystem coordinateReferenceSystem, CoordinateReferenceSystem coordinateReferenceSystem2) throws FactoryException {
        assert (coordinateReferenceSystem instanceof GeodeticCRS && coordinateReferenceSystem.getCoordinateSystem() instanceof EllipsoidalCS) : coordinateReferenceSystem;
        if (coordinateReferenceSystem.getCoordinateSystem().getDimension() != 2) {
            return coordinateReferenceSystem;
        }
        if (coordinateReferenceSystem.getClass() == coordinateReferenceSystem2.getClass() && coordinateReferenceSystem2.getCoordinateSystem().getDimension() == 3 && Utilities.equalsIgnoreMetadata(((SingleCRS)coordinateReferenceSystem).getDatum(), ((SingleCRS)coordinateReferenceSystem2).getDatum())) {
            return coordinateReferenceSystem2;
        }
        return this.toAuthorityDefinition(CoordinateReferenceSystem.class, new CompoundCRSBuilder(this.factory, this.factorySIS).createCompoundCRS(CoordinateOperationRegistry.derivedFrom((IdentifiedObject)coordinateReferenceSystem), new CoordinateReferenceSystem[]{coordinateReferenceSystem, CommonCRS.Vertical.ELLIPSOIDAL.crs()}));
    }

    private static Map<String, ?> derivedFrom(IdentifiedObject identifiedObject) {
        return IdentifiedObjects.getProperties(identifiedObject, "identifiers");
    }

    static Map<String, Object> properties(Identifier identifier) {
        HashMap<String, Object> hashMap = new HashMap<String, Object>(4);
        hashMap.put("name", identifier);
        if (identifier == DATUM_SHIFT || identifier == ELLIPSOID_CHANGE) {
            hashMap.put("coordinateOperationAccuracy", new PositionalAccuracy[]{identifier == DATUM_SHIFT ? PositionalAccuracyConstant.DATUM_SHIFT_APPLIED : PositionalAccuracyConstant.DATUM_SHIFT_OMITTED});
        }
        return hashMap;
    }

    final CoordinateOperation createFromMathTransform(Map<String, Object> map, CoordinateReferenceSystem coordinateReferenceSystem, CoordinateReferenceSystem coordinateReferenceSystem2, MathTransform mathTransform, OperationMethod operationMethod, ParameterValueGroup parameterValueGroup, Class<? extends CoordinateOperation> clazz) throws FactoryException {
        CoordinateOperation coordinateOperation;
        if (mathTransform instanceof CoordinateOperation && Objects.equals((coordinateOperation = (CoordinateOperation)mathTransform).getSourceCRS(), coordinateReferenceSystem) && Objects.equals(coordinateOperation.getTargetCRS(), coordinateReferenceSystem2) && Objects.equals(coordinateOperation.getMathTransform(), mathTransform) && (operationMethod == null || !(coordinateOperation instanceof SingleOperation) || Objects.equals(((SingleOperation)coordinateOperation).getMethod(), operationMethod))) {
            return coordinateOperation;
        }
        if (clazz == null) {
            Class clazz2 = clazz = map.containsKey("coordinateOperationAccuracy") ? Transformation.class : Conversion.class;
        }
        if (operationMethod == null) {
            coordinateOperation = MathTransforms.getMatrix(mathTransform);
            if (coordinateOperation != null) {
                operationMethod = Affine.getProvider(mathTransform.getSourceDimensions(), mathTransform.getTargetDimensions(), Matrices.isAffine((Matrix)coordinateOperation));
            } else {
                ParameterDescriptorGroup parameterDescriptorGroup = AbstractCoordinateOperation.getParameterDescriptors(mathTransform);
                if (parameterDescriptorGroup != null) {
                    ReferenceIdentifier referenceIdentifier = parameterDescriptorGroup.getName();
                    if (referenceIdentifier != null) {
                        operationMethod = this.factorySIS.getOperationMethod(referenceIdentifier.getCode());
                    }
                    if (operationMethod == null) {
                        operationMethod = this.factorySIS.createOperationMethod(map, coordinateReferenceSystem.getCoordinateSystem().getDimension(), coordinateReferenceSystem2.getCoordinateSystem().getDimension(), parameterDescriptorGroup);
                    }
                }
            }
        }
        if (parameterValueGroup != null) {
            map.put("parameters", parameterValueGroup);
        }
        map.put("operationType", clazz);
        if (Conversion.class.isAssignableFrom(clazz) && mathTransform.isIdentity()) {
            JDK8.replace(map, "name", AXIS_CHANGES, IDENTITY);
        }
        return this.factorySIS.createSingleOperation(map, coordinateReferenceSystem, coordinateReferenceSystem2, null, operationMethod, mathTransform);
    }

    private static void log(LogRecord logRecord, Exception exception) {
        if (logRecord == null) {
            logRecord = new LogRecord(Level.WARNING, exception.getLocalizedMessage());
        }
        logRecord.setLoggerName("org.apache.sis.referencing.operation");
        if (exception instanceof NoninvertibleTransformException) {
            logRecord.setThrown(exception);
        }
        Logging.log(CoordinateOperationFinder.class, "createOperation", logRecord);
    }
}

