/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing.operation.transform;

import java.io.Serializable;
import org.apache.sis.internal.util.Numerics;
import org.apache.sis.math.MathFunctions;
import org.apache.sis.referencing.operation.transform.AbstractMathTransform1D;
import org.apache.sis.referencing.operation.transform.ConcatenatedTransformDirect1D;
import org.apache.sis.referencing.operation.transform.ExponentialTransform1D;
import org.apache.sis.referencing.operation.transform.LinearTransform1D;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.ComparisonMode;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.MathTransform1D;
import org.opengis.referencing.operation.MathTransformFactory;
import org.opengis.util.FactoryException;

class LogarithmicTransform1D
extends AbstractMathTransform1D
implements Serializable {
    private static final long serialVersionUID = 1535101265352133948L;
    private static final LogarithmicTransform1D NATURAL = new LogarithmicTransform1D();
    private MathTransform1D inverse;

    LogarithmicTransform1D() {
    }

    public static MathTransform1D create(double d, double d2) {
        ArgumentChecks.ensureStrictlyPositive("base", d);
        if (d == 10.0) {
            return Base10.create(d2);
        }
        return NATURAL.concatenate(1.0 / Math.log(d), d2);
    }

    static MathTransform1D create(ExponentialTransform1D exponentialTransform1D) {
        if (exponentialTransform1D.base == 10.0) {
            return Base10.create(-Math.log10(exponentialTransform1D.scale));
        }
        return NATURAL.concatenate(1.0 / exponentialTransform1D.lnBase, -Math.log(exponentialTransform1D.scale) / exponentialTransform1D.lnBase);
    }

    private MathTransform1D concatenate(double d, double d2) {
        LinearTransform1D linearTransform1D = LinearTransform1D.create(d, d2);
        return (MathTransform1D)(linearTransform1D.isIdentity() ? this : new ConcatenatedTransformDirect1D(this, linearTransform1D));
    }

    @Override
    protected MathTransform tryConcatenate(boolean bl, MathTransform mathTransform, MathTransformFactory mathTransformFactory) throws FactoryException {
        if (mathTransform instanceof LinearTransform1D) {
            LinearTransform1D linearTransform1D = (LinearTransform1D)mathTransform;
            if (bl) {
                if (linearTransform1D.offset == 0.0 && linearTransform1D.scale > 0.0) {
                    return LogarithmicTransform1D.create(this.base(), this.transform(linearTransform1D.scale));
                }
            } else {
                double d = this.pow(1.0 / linearTransform1D.scale);
                if (!Double.isNaN(d)) {
                    return LogarithmicTransform1D.create(d, linearTransform1D.transform(this.offset()));
                }
            }
        } else if (mathTransform instanceof ExponentialTransform1D) {
            return ((ExponentialTransform1D)mathTransform).concatenateLog(this, !bl);
        }
        return super.tryConcatenate(bl, mathTransform, mathTransformFactory);
    }

    @Override
    public synchronized MathTransform1D inverse() {
        if (this.inverse == null) {
            this.inverse = new ExponentialTransform1D(this);
        }
        return this.inverse;
    }

    double base() {
        return Math.E;
    }

    double lnBase() {
        return 1.0;
    }

    double offset() {
        return 0.0;
    }

    @Override
    public double derivative(double d) {
        return 1.0 / d;
    }

    double pow(double d) {
        return Math.exp(d);
    }

    double log(double d) {
        return Math.log(d);
    }

    @Override
    public double transform(double d) {
        return Math.log(d);
    }

    @Override
    public void transform(double[] dArray, int n, double[] dArray2, int n2, int n3) {
        if (dArray != dArray2 || n >= n2) {
            while (--n3 >= 0) {
                dArray2[n2++] = Math.log(dArray[n++]);
            }
        } else {
            n += n3;
            n2 += n3;
            while (--n3 >= 0) {
                dArray2[--n2] = Math.log(dArray[--n]);
            }
        }
    }

    @Override
    public void transform(float[] fArray, int n, float[] fArray2, int n2, int n3) {
        if (fArray != fArray2 || n >= n2) {
            while (--n3 >= 0) {
                fArray2[n2++] = (float)Math.log(fArray[n++]);
            }
        } else {
            n += n3;
            n2 += n3;
            while (--n3 >= 0) {
                fArray2[--n2] = (float)Math.log(fArray[--n]);
            }
        }
    }

    @Override
    public void transform(double[] dArray, int n, float[] fArray, int n2, int n3) {
        while (--n3 >= 0) {
            fArray[n2++] = (float)Math.log(dArray[n++]);
        }
    }

    @Override
    public void transform(float[] fArray, int n, double[] dArray, int n2, int n3) {
        while (--n3 >= 0) {
            dArray[n2++] = Math.log(fArray[n++]);
        }
    }

    static final class Base10
    extends LogarithmicTransform1D {
        private static final long serialVersionUID = -5435804027536647558L;
        private static final double LOG_10 = 2.302585092994046;
        static final Base10 INSTANCE = new Base10(0.0);
        private final double offset;

        private Base10(double d) {
            this.offset = d;
        }

        public static Base10 create(double d) {
            return d == 0.0 ? INSTANCE : new Base10(d);
        }

        @Override
        double base() {
            return 10.0;
        }

        @Override
        double lnBase() {
            return 2.302585092994046;
        }

        @Override
        double offset() {
            return this.offset;
        }

        @Override
        public double derivative(double d) {
            return 0.43429448190325176 / d;
        }

        @Override
        double pow(double d) {
            return MathFunctions.pow10(d);
        }

        @Override
        double log(double d) {
            return Math.log10(d);
        }

        @Override
        public double transform(double d) {
            return Math.log10(d) + this.offset;
        }

        @Override
        public void transform(double[] dArray, int n, double[] dArray2, int n2, int n3) {
            if (dArray != dArray2 || n >= n2) {
                while (--n3 >= 0) {
                    dArray2[n2++] = Math.log10(dArray[n++]) + this.offset;
                }
            } else {
                n += n3;
                n2 += n3;
                while (--n3 >= 0) {
                    dArray2[--n2] = Math.log10(dArray[--n]) + this.offset;
                }
            }
        }

        @Override
        public void transform(float[] fArray, int n, float[] fArray2, int n2, int n3) {
            if (fArray != fArray2 || n >= n2) {
                while (--n3 >= 0) {
                    fArray2[n2++] = (float)(Math.log10(fArray[n++]) + this.offset);
                }
            } else {
                n += n3;
                n2 += n3;
                while (--n3 >= 0) {
                    fArray2[--n2] = (float)(Math.log10(fArray[--n]) + this.offset);
                }
            }
        }

        @Override
        public void transform(double[] dArray, int n, float[] fArray, int n2, int n3) {
            while (--n3 >= 0) {
                fArray[n2++] = (float)(Math.log10(dArray[n++]) + this.offset);
            }
        }

        @Override
        public void transform(float[] fArray, int n, double[] dArray, int n2, int n3) {
            while (--n3 >= 0) {
                dArray[n2++] = Math.log10(fArray[n++]) + this.offset;
            }
        }

        @Override
        protected int computeHashCode() {
            return Numerics.hashCode(Double.doubleToLongBits(this.offset)) ^ super.computeHashCode();
        }

        @Override
        public boolean equals(Object object, ComparisonMode comparisonMode) {
            if (object == this) {
                return true;
            }
            if (super.equals(object, comparisonMode)) {
                return Numerics.equals(this.offset, ((Base10)object).offset);
            }
            return false;
        }
    }
}

