/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.math.set;

import java.util.Arrays;
import org.apache.mahout.math.function.ByteProcedure;
import org.apache.mahout.math.list.ByteArrayList;
import org.apache.mahout.math.map.HashFunctions;
import org.apache.mahout.math.set.AbstractByteSet;

public class OpenByteHashSet
extends AbstractByteSet {
    protected static final byte FREE = 0;
    protected static final byte FULL = 1;
    protected static final byte REMOVED = 2;
    protected static final byte NO_KEY_VALUE = 0;
    private byte[] table;
    private byte[] state;
    private int freeEntries;

    public OpenByteHashSet() {
        this(277);
    }

    public OpenByteHashSet(int initialCapacity) {
        this(initialCapacity, 0.2, 0.5);
    }

    public OpenByteHashSet(int initialCapacity, double minLoadFactor, double maxLoadFactor) {
        this.setUp(initialCapacity, minLoadFactor, maxLoadFactor);
    }

    @Override
    public void clear() {
        Arrays.fill(this.state, (byte)0);
        this.distinct = 0;
        this.freeEntries = this.table.length;
        this.trimToSize();
    }

    @Override
    public Object clone() {
        OpenByteHashSet copy = (OpenByteHashSet)super.clone();
        copy.table = (byte[])copy.table.clone();
        copy.state = (byte[])copy.state.clone();
        return copy;
    }

    @Override
    public boolean contains(byte key) {
        return this.indexOfKey(key) >= 0;
    }

    @Override
    public void ensureCapacity(int minCapacity) {
        if (this.table.length < minCapacity) {
            int newCapacity = this.nextPrime(minCapacity);
            this.rehash(newCapacity);
        }
    }

    @Override
    public boolean forEachKey(ByteProcedure procedure) {
        int i = this.table.length;
        while (i-- > 0) {
            if (this.state[i] != 1 || procedure.apply(this.table[i])) continue;
            return false;
        }
        return true;
    }

    protected int indexOfInsertion(byte key) {
        int length = this.table.length;
        int hash = HashFunctions.hash(key) & Integer.MAX_VALUE;
        int i = hash % length;
        int decrement = hash % (length - 2);
        if (decrement == 0) {
            decrement = 1;
        }
        while (this.state[i] == 1 && this.table[i] != key) {
            if ((i -= decrement) >= 0) continue;
            i += length;
        }
        if (this.state[i] == 2) {
            int j = i;
            while (this.state[i] != 0 && (this.state[i] == 2 || this.table[i] != key)) {
                if ((i -= decrement) >= 0) continue;
                i += length;
            }
            if (this.state[i] == 0) {
                i = j;
            }
        }
        if (this.state[i] == 1) {
            return -i - 1;
        }
        return i;
    }

    protected int indexOfKey(byte key) {
        int length = this.table.length;
        int hash = HashFunctions.hash(key) & Integer.MAX_VALUE;
        int i = hash % length;
        int decrement = hash % (length - 2);
        if (decrement == 0) {
            decrement = 1;
        }
        while (this.state[i] != 0 && (this.state[i] == 2 || this.table[i] != key)) {
            if ((i -= decrement) >= 0) continue;
            i += length;
        }
        if (this.state[i] == 0) {
            return -1;
        }
        return i;
    }

    @Override
    public void keys(ByteArrayList list) {
        list.setSize(this.distinct);
        byte[] elements = list.elements();
        int j = 0;
        int i = this.table.length;
        while (i-- > 0) {
            if (this.state[i] != 1) continue;
            elements[j++] = this.table[i];
        }
    }

    @Override
    public boolean add(byte key) {
        int i = this.indexOfInsertion(key);
        if (i < 0) {
            return false;
        }
        if (this.distinct > this.highWaterMark) {
            int newCapacity = this.chooseGrowCapacity(this.distinct + 1, this.minLoadFactor, this.maxLoadFactor);
            this.rehash(newCapacity);
            return this.add(key);
        }
        this.table[i] = key;
        if (this.state[i] == 0) {
            --this.freeEntries;
        }
        this.state[i] = 1;
        ++this.distinct;
        if (this.freeEntries < 1) {
            int newCapacity = this.chooseGrowCapacity(this.distinct + 1, this.minLoadFactor, this.maxLoadFactor);
            this.rehash(newCapacity);
        }
        return true;
    }

    protected void rehash(int newCapacity) {
        int oldCapacity = this.table.length;
        byte[] oldTable = this.table;
        byte[] oldState = this.state;
        this.table = new byte[newCapacity];
        this.state = new byte[newCapacity];
        this.lowWaterMark = this.chooseLowWaterMark(newCapacity, this.minLoadFactor);
        this.highWaterMark = this.chooseHighWaterMark(newCapacity, this.maxLoadFactor);
        this.freeEntries = newCapacity - this.distinct;
        int i = oldCapacity;
        while (i-- > 0) {
            if (oldState[i] != 1) continue;
            byte element = oldTable[i];
            int index = this.indexOfInsertion(element);
            this.table[index] = element;
            this.state[index] = 1;
        }
    }

    @Override
    public boolean remove(byte key) {
        int i = this.indexOfKey(key);
        if (i < 0) {
            return false;
        }
        this.state[i] = 2;
        --this.distinct;
        if (this.distinct < this.lowWaterMark) {
            int newCapacity = this.chooseShrinkCapacity(this.distinct, this.minLoadFactor, this.maxLoadFactor);
            this.rehash(newCapacity);
        }
        return true;
    }

    @Override
    protected final void setUp(int initialCapacity, double minLoadFactor, double maxLoadFactor) {
        int capacity = initialCapacity;
        super.setUp(capacity, minLoadFactor, maxLoadFactor);
        capacity = this.nextPrime(capacity);
        if (capacity == 0) {
            capacity = 1;
        }
        this.table = new byte[capacity];
        this.state = new byte[capacity];
        this.minLoadFactor = minLoadFactor;
        this.maxLoadFactor = capacity == Integer.MAX_VALUE ? 1.0 : maxLoadFactor;
        this.distinct = 0;
        this.freeEntries = capacity;
        this.lowWaterMark = 0;
        this.highWaterMark = this.chooseHighWaterMark(capacity, this.maxLoadFactor);
    }

    @Override
    public void trimToSize() {
        int newCapacity = this.nextPrime((int)(1.0 + 1.2 * (double)this.size()));
        if (this.table.length > newCapacity) {
            this.rehash(newCapacity);
        }
    }

    protected void getInternalFactors(int[] capacity, double[] minLoadFactor, double[] maxLoadFactor) {
        capacity[0] = this.table.length;
        minLoadFactor[0] = this.minLoadFactor;
        maxLoadFactor[0] = this.maxLoadFactor;
    }
}

