/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.drivers;

import org.apache.mahout.common.HDFSPathSearch;
import org.apache.mahout.drivers.ItemSimilarityDriver$;
import org.apache.mahout.drivers.MahoutSparkDriver;
import org.apache.mahout.drivers.MahoutSparkOptionParser;
import org.apache.mahout.math.cf.SimilarityAnalysis$;
import org.apache.mahout.math.indexeddataset.IndexedDataset;
import org.apache.mahout.math.indexeddataset.Schema;
import org.apache.mahout.math.indexeddataset.package$;
import scala.Array$;
import scala.Function1;
import scala.Function2;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.HashMap;
import scala.collection.immutable.HashMap$;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.Either;
import scopt.Read$;

public final class ItemSimilarityDriver$
extends MahoutSparkDriver {
    public static final ItemSimilarityDriver$ MODULE$;
    private final HashMap<String, Object> org$apache$mahout$drivers$ItemSimilarityDriver$$ItemSimilarityOptions;
    private Schema writeSchema;
    private Schema readSchema1;
    private Schema readSchema2;

    static {
        new ItemSimilarityDriver$();
    }

    public final HashMap<String, Object> org$apache$mahout$drivers$ItemSimilarityDriver$$ItemSimilarityOptions() {
        return this.org$apache$mahout$drivers$ItemSimilarityDriver$$ItemSimilarityOptions;
    }

    private Schema writeSchema() {
        return this.writeSchema;
    }

    private void writeSchema_$eq(Schema x$1) {
        this.writeSchema = x$1;
    }

    private Schema readSchema1() {
        return this.readSchema1;
    }

    private void readSchema1_$eq(Schema x$1) {
        this.readSchema1 = x$1;
    }

    private Schema readSchema2() {
        return this.readSchema2;
    }

    private void readSchema2_$eq(Schema x$1) {
        this.readSchema2 = x$1;
    }

    public void main(String[] args) {
        this.parser_$eq(new MahoutSparkOptionParser(){
            {
                this.head((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"spark-itemsimilarity", "Mahout"}));
                this.parseIOOptions(2);
                this.opts_$eq(this.opts().$plus$plus(ItemSimilarityDriver$.MODULE$.org$apache$mahout$drivers$ItemSimilarityDriver$$ItemSimilarityOptions()));
                this.note("\nAlgorithm control options:");
                this.opt("maxPrefs", Read$.MODULE$.intRead()).abbr("mppu").action((Function2)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Map<String, Object> apply(int x, Map<String, Object> options) {
                        return options.$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"maxPrefs"), (Object)BoxesRunTime.boxToInteger((int)x)));
                    }
                }).text(new StringBuilder().append((Object)"Max number of preferences to consider per user (optional). Default: ").append(ItemSimilarityDriver$.MODULE$.org$apache$mahout$drivers$ItemSimilarityDriver$$ItemSimilarityOptions().apply((Object)"maxPrefs")).toString()).validate((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anon.1 $outer;

                    public final Either<String, BoxedUnit> apply(int x) {
                        return x > 0 ? this.$outer.success() : this.$outer.failure("Option --maxPrefs must be > 0");
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                });
                this.opt('m', "maxSimilaritiesPerItem", Read$.MODULE$.intRead()).action((Function2)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Map<String, Object> apply(int x, Map<String, Object> options) {
                        return options.$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"maxSimilaritiesPerItem"), (Object)BoxesRunTime.boxToInteger((int)x)));
                    }
                }).text(new StringBuilder().append((Object)"Limit the number of similarities per item to this number (optional). Default: ").append(ItemSimilarityDriver$.MODULE$.org$apache$mahout$drivers$ItemSimilarityDriver$$ItemSimilarityOptions().apply((Object)"maxSimilaritiesPerItem")).toString()).validate((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anon.1 $outer;

                    public final Either<String, BoxedUnit> apply(int x) {
                        return x > 0 ? this.$outer.success() : this.$outer.failure("Option --maxSimilaritiesPerItem must be > 0");
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                });
                this.note("\nNote: Only the Log Likelihood Ratio (LLR) is supported as a similarity measure.");
                this.parseElementInputSchemaOptions();
                this.parseFileDiscoveryOptions();
                this.parseIndexedDatasetFormatOptions(this.parseIndexedDatasetFormatOptions$default$1());
                this.parseSparkOptions(ItemSimilarityDriver$.MODULE$.sparkConf());
                this.parseGenericOptions();
                this.help("help").abbr("h").text("prints this usage text\n");
            }
        });
        this.parser().parse((Seq)Predef$.MODULE$.wrapRefArray((Object[])args), (Object)this.parser().opts()).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final void apply(Map<String, Object> opts) {
                ItemSimilarityDriver$.MODULE$.parser().opts_$eq(opts);
                ItemSimilarityDriver$.MODULE$.process();
            }
        });
    }

    @Override
    public void start() {
        super.start();
        this.readSchema1_$eq(new Schema((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"delim"), (Object)((String)this.parser().opts().apply((Object)"inDelim"))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"filter"), (Object)((String)this.parser().opts().apply((Object)"filter1"))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"rowIDColumn"), (Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)this.parser().opts().apply((Object)"rowIDColumn")))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"columnIDPosition"), (Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)this.parser().opts().apply((Object)"itemIDColumn")))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"filterColumn"), (Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)this.parser().opts().apply((Object)"filterColumn"))))})));
        if (BoxesRunTime.unboxToInt((Object)this.parser().opts().apply((Object)"filterColumn")) != -1 && (String)this.parser().opts().apply((Object)"filter2") != null || (String)this.parser().opts().apply((Object)"input2") != null && !((String)this.parser().opts().apply((Object)"input2")).isEmpty()) {
            this.readSchema2_$eq((Schema)new Schema(this.readSchema1()).$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"filter"), (Object)((String)this.parser().opts().apply((Object)"filter2")))));
        }
        this.writeSchema_$eq(new Schema((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"rowKeyDelim"), (Object)((String)this.parser().opts().apply((Object)"rowKeyDelim"))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"columnIdStrengthDelim"), (Object)((String)this.parser().opts().apply((Object)"columnIdStrengthDelim"))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"omitScore"), (Object)BoxesRunTime.boxToBoolean((boolean)BoxesRunTime.unboxToBoolean((Object)this.parser().opts().apply((Object)"omitStrength")))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"elementDelim"), (Object)((String)this.parser().opts().apply((Object)"elementDelim")))})));
    }

    private IndexedDataset[] readIndexedDatasets() {
        IndexedDataset[] indexedDatasetArray;
        String inFiles2;
        String inFiles = new HDFSPathSearch((String)this.parser().opts().apply((Object)"input"), (String)this.parser().opts().apply((Object)"filenamePattern"), BoxesRunTime.unboxToBoolean((Object)this.parser().opts().apply((Object)"recursive"))).uris();
        String string = inFiles2 = this.parser().opts().apply((Object)"input2") == null || ((String)this.parser().opts().apply((Object)"input2")).isEmpty() ? "" : new HDFSPathSearch((String)this.parser().opts().apply((Object)"input2"), (String)this.parser().opts().apply((Object)"filenamePattern"), BoxesRunTime.unboxToBoolean((Object)this.parser().opts().apply((Object)"recursive"))).uris();
        if (inFiles.isEmpty()) {
            indexedDatasetArray = (IndexedDataset[])Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.apply(IndexedDataset.class));
        } else {
            IndexedDataset datasetB;
            IndexedDataset datasetB2;
            IndexedDataset datasetB3;
            IndexedDataset datasetA = package$.MODULE$.indexedDatasetDFSReadElements(inFiles, this.readSchema1(), package$.MODULE$.indexedDatasetDFSReadElements$default$3(), this.mc());
            if (BoxesRunTime.unboxToBoolean((Object)this.parser().opts().apply((Object)"writeAllDatasets"))) {
                datasetA.dfsWrite(new StringBuilder().append((Object)((String)this.parser().opts().apply((Object)"output"))).append((Object)"../input-datasets/primary-interactions").toString(), this.writeSchema(), this.mc());
            }
            IndexedDataset indexedDataset = inFiles2.isEmpty() ? (BoxesRunTime.unboxToInt((Object)this.parser().opts().apply((Object)"filterColumn")) != -1 && (String)this.parser().opts().apply((Object)"filter2") != null ? (datasetB3 = package$.MODULE$.indexedDatasetDFSReadElements(inFiles, this.readSchema2(), (Option)new Some((Object)datasetA.rowIDs()), this.mc())) : null) : (datasetB2 = package$.MODULE$.indexedDatasetDFSReadElements(inFiles2, this.readSchema2(), (Option)new Some((Object)datasetA.rowIDs()), this.mc()));
            IndexedDataset indexedDataset2 = datasetB = indexedDataset;
            Object var7_7 = null;
            if (!(indexedDataset2 != null ? !indexedDataset2.equals(var7_7) : var7_7 != null)) {
                indexedDatasetArray = (IndexedDataset[])((Object[])new IndexedDataset[]{datasetA});
            } else {
                IndexedDataset returnedB;
                int rowCardinality = datasetB.rowIDs().size();
                IndexedDataset returnedA = (long)rowCardinality != datasetA.matrix().nrow() ? datasetA.newRowCardinality(rowCardinality) : datasetA;
                IndexedDataset indexedDataset3 = returnedB = (long)rowCardinality != datasetB.matrix().nrow() ? datasetB.newRowCardinality(rowCardinality) : datasetB;
                if (BoxesRunTime.unboxToBoolean((Object)this.parser().opts().apply((Object)"writeAllDatasets"))) {
                    datasetB.dfsWrite(new StringBuilder().append((Object)((String)this.parser().opts().apply((Object)"output"))).append((Object)"../input-datasets/secondary-interactions").toString(), this.writeSchema(), this.mc());
                }
                indexedDatasetArray = (IndexedDataset[])((Object[])new IndexedDataset[]{returnedA, returnedB});
            }
        }
        return indexedDatasetArray;
    }

    public void process() {
        this.start();
        IndexedDataset[] indexedDatasets = this.readIndexedDatasets();
        List idss = SimilarityAnalysis$.MODULE$.cooccurrencesIDSs(indexedDatasets, BoxesRunTime.unboxToInt((Object)this.parser().opts().apply((Object)"randomSeed")), BoxesRunTime.unboxToInt((Object)this.parser().opts().apply((Object)"maxSimilaritiesPerItem")), BoxesRunTime.unboxToInt((Object)this.parser().opts().apply((Object)"maxPrefs")));
        ((IndexedDataset)idss.apply(0)).dfsWrite(new StringBuilder().append((Object)((String)this.parser().opts().apply((Object)"output"))).append((Object)"similarity-matrix").toString(), this.writeSchema(), this.mc());
        if (idss.length() > 1) {
            ((IndexedDataset)idss.apply(1)).dfsWrite(new StringBuilder().append((Object)((String)this.parser().opts().apply((Object)"output"))).append((Object)"cross-similarity-matrix").toString(), this.writeSchema(), this.mc());
        }
        this.stop();
    }

    private ItemSimilarityDriver$() {
        MODULE$ = this;
        this.org$apache$mahout$drivers$ItemSimilarityDriver$$ItemSimilarityOptions = (HashMap)HashMap$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"maxPrefs"), (Object)BoxesRunTime.boxToInteger((int)500)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"maxSimilaritiesPerItem"), (Object)BoxesRunTime.boxToInteger((int)100)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"appName"), (Object)"ItemSimilarityDriver")}));
    }
}

