/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.math.drm;

import org.apache.mahout.math.Matrix;
import org.apache.mahout.math.Vector;
import org.apache.mahout.math.drm.BCast;
import org.apache.mahout.math.drm.CacheHint$;
import org.apache.mahout.math.drm.CheckpointedDrm;
import org.apache.mahout.math.drm.CheckpointedOps;
import org.apache.mahout.math.drm.DistributedContext;
import org.apache.mahout.math.drm.DistributedEngine;
import org.apache.mahout.math.drm.DrmLike;
import org.apache.mahout.math.drm.RLikeDrmIntOps;
import org.apache.mahout.math.drm.RLikeDrmOps$;
import org.apache.mahout.math.drm.logical.OpAewUnaryFunc;
import org.apache.mahout.math.drm.logical.OpAewUnaryFunc$;
import org.apache.mahout.math.drm.package$;
import org.apache.mahout.math.scalabindings.RLikeOps$;
import scala.Function0;
import scala.Function1;
import scala.Function3;
import scala.MatchError;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.IterableView$;
import scala.collection.TraversableOnce;
import scala.collection.mutable.StringBuilder;
import scala.math.Numeric;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;

public final class package$ {
    public static final package$ MODULE$;

    static {
        new package$();
    }

    public int safeToNonNegInt(long x) {
        Predef$.MODULE$.assert(x == x << -31 >>> -31, (Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "transformation from long to Int is losing significant bits, or is a negative number";
            }
        });
        return (int)x;
    }

    public BCast<Matrix> drmBroadcast(Matrix m, DistributedContext ctx) {
        return this.ctx2engine(ctx).drmBroadcast(m, ctx);
    }

    public BCast<Vector> drmBroadcast(Vector v, DistributedContext ctx) {
        return this.ctx2engine(ctx).drmBroadcast(v, ctx);
    }

    public CheckpointedDrm<?> drmDfsRead(String path, DistributedContext ctx) {
        DistributedEngine qual$1 = this.ctx2engine(ctx);
        String x$4 = path;
        int x$5 = qual$1.drmDfsRead$default$2();
        return qual$1.drmDfsRead(x$4, x$5, ctx);
    }

    public CheckpointedDrm<Object> drmParallelize(Matrix m, int numPartitions, DistributedContext sc) {
        return this.drmParallelizeWithRowIndices(m, numPartitions, sc);
    }

    public int drmParallelize$default$2() {
        return 1;
    }

    public CheckpointedDrm<Object> drmParallelizeWithRowIndices(Matrix m, int numPartitions, DistributedContext ctx) {
        return this.ctx2engine(ctx).drmParallelizeWithRowIndices(m, numPartitions, ctx);
    }

    public int drmParallelizeWithRowIndices$default$2() {
        return 1;
    }

    public CheckpointedDrm<String> drmParallelizeWithRowLabels(Matrix m, int numPartitions, DistributedContext ctx) {
        return this.ctx2engine(ctx).drmParallelizeWithRowLabels(m, numPartitions, ctx);
    }

    public int drmParallelizeWithRowLabels$default$2() {
        return 1;
    }

    public CheckpointedDrm<Object> drmParallelizeEmpty(int nrow, int ncol, int numPartitions, DistributedContext ctx) {
        return this.ctx2engine(ctx).drmParallelizeEmpty(nrow, ncol, numPartitions, ctx);
    }

    public int drmParallelizeEmpty$default$3() {
        return 10;
    }

    public CheckpointedDrm<Object> drmParallelizeEmptyLong(long nrow, int ncol, int numPartitions, DistributedContext ctx) {
        return this.ctx2engine(ctx).drmParallelizeEmptyLong(nrow, ncol, numPartitions, ctx);
    }

    public int drmParallelizeEmptyLong$default$3() {
        return 10;
    }

    public <T> T bcast2val(BCast<T> bcast) {
        return bcast.value();
    }

    public DistributedEngine ctx2engine(DistributedContext ctx) {
        return ctx.engine();
    }

    public <K> CheckpointedOps<K> drm2drmCpOps(CheckpointedDrm<K> drm) {
        return new CheckpointedOps<K>(drm);
    }

    public <K> CheckpointedDrm<K> drm2Checkpointed(DrmLike<K> drm) {
        return drm.checkpoint(CacheHint$.MODULE$.NONE());
    }

    public <K> Matrix drm2InCore(DrmLike<K> drm) {
        return this.drm2Checkpointed(drm).collect();
    }

    public <K> Tuple2<Object, Matrix> rbind(Iterable<Tuple2<Object, Matrix>> blocks, ClassTag<K> evidence$1) {
        Tuple2 tuple2;
        Predef$.MODULE$.assert(blocks.nonEmpty(), (Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "rbind: 0 blocks passed in";
            }
        });
        if (blocks.size() == 1) {
            tuple2 = (Tuple2)blocks.head();
        } else {
            int m = BoxesRunTime.unboxToInt((Object)((TraversableOnce)blocks.view().map((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final int apply(Tuple2<Object, Matrix> x$1) {
                    return RLikeOps$.MODULE$.m2mOps((Matrix)x$1._2()).nrow();
                }
            }, IterableView$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.IntIsIntegral$.MODULE$));
            int n = RLikeOps$.MODULE$.m2mOps((Matrix)((Tuple2)blocks.head())._2()).ncol();
            Matrix coalescedBlock = ((Matrix)((Tuple2)blocks.head())._2()).like(m, n);
            Object coalescedKeys = evidence$1.newArray(m);
            IntRef row = new IntRef(0);
            blocks.view().foreach((Function1)new Serializable(coalescedBlock, coalescedKeys, row){
                public static final long serialVersionUID = 0L;
                private final Matrix coalescedBlock$1;
                private final Object coalescedKeys$1;
                private final IntRef row$1;

                public final void apply(Tuple2<Object, Matrix> elem) {
                    Matrix block = (Matrix)elem._2();
                    int rowEnd = this.row$1.elem + RLikeOps$.MODULE$.m2mOps(block).nrow();
                    RLikeOps$.MODULE$.m2mOps(RLikeOps$.MODULE$.m2mOps(this.coalescedBlock$1).apply(RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(this.row$1.elem), rowEnd), org.apache.mahout.math.scalabindings.package$.MODULE$.$colon$colon())).$colon$eq(block);
                    Predef$.MODULE$.genericArrayOps(elem._1()).copyToArray(this.coalescedKeys$1, this.row$1.elem);
                    this.row$1.elem = rowEnd;
                }
                {
                    this.coalescedBlock$1 = coalescedBlock$1;
                    this.coalescedKeys$1 = coalescedKeys$1;
                    this.row$1 = row$1;
                }
            });
            tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc(coalescedKeys), (Object)coalescedBlock);
        }
        return tuple2;
    }

    public <K> Tuple2<DrmLike<Object>, Option<DrmLike<K>>> drm2IntKeyed(DrmLike<K> drmX, boolean computeMap) {
        return drmX.context().engine().drm2IntKeyed(drmX, computeMap);
    }

    public <K> boolean drm2IntKeyed$default$2() {
        return false;
    }

    public <K> DrmLike<K> drmSampleRows(DrmLike<K> drmX, double fraction, boolean replacement) {
        return drmX.context().engine().drmSampleRows(drmX, fraction, replacement);
    }

    public <K> boolean drmSampleRows$default$3() {
        return false;
    }

    public <K> Matrix drmSampleKRows(DrmLike<K> drmX, int numSamples, boolean replacement) {
        return drmX.context().engine().drmSampleKRows(drmX, numSamples, replacement);
    }

    public <K> boolean drmSampleKRows$default$3() {
        return false;
    }

    public <K> String drmSampleToTSV(DrmLike<K> drmX, double samplePercent) {
        int drmSize = this.drm2InCore(drmX.checkpoint(drmX.checkpoint$default$1())).numRows();
        double sampleRatio = 1.0 * samplePercent / (double)100;
        int numSamples = (int)((double)drmSize * sampleRatio);
        Matrix plotMatrix = this.drmSampleKRows(drmX, numSamples, false);
        int matrixRows = plotMatrix.numRows();
        int matrixCols = plotMatrix.numCols();
        ObjectRef str = new ObjectRef((Object)"");
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), matrixRows).foreach$mVc$sp((Function1)new Serializable(plotMatrix, matrixCols, str){
            public static final long serialVersionUID = 0L;
            public final Matrix plotMatrix$1;
            public final int matrixCols$1;
            public final ObjectRef str$1;

            public final void apply(int i) {
                this.apply$mcVI$sp(i);
            }

            public void apply$mcVI$sp(int i) {
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.matrixCols$1).foreach$mVc$sp((Function1)new Serializable(this, i){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anonfun.drmSampleToTSV.1 $outer;
                    private final int i$1;

                    public final void apply(int j) {
                        this.apply$mcVI$sp(j);
                    }

                    public void apply$mcVI$sp(int j) {
                        this.$outer.str$1.elem = new StringBuilder().append((Object)((String)this.$outer.str$1.elem)).append((Object)BoxesRunTime.boxToDouble((double)RLikeOps$.MODULE$.m2mOps(this.$outer.plotMatrix$1).apply(this.i$1, j))).toString();
                        if (j <= this.$outer.matrixCols$1 - 2) {
                            this.$outer.str$1.elem = new StringBuilder().append((Object)((String)this.$outer.str$1.elem)).append((Object)BoxesRunTime.boxToCharacter((char)'\t')).toString();
                        }
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                        this.i$1 = i$1;
                    }
                });
                this.str$1.elem = new StringBuilder().append((Object)((String)this.str$1.elem)).append((Object)BoxesRunTime.boxToCharacter((char)'\n')).toString();
            }
            {
                this.plotMatrix$1 = plotMatrix$1;
                this.matrixCols$1 = matrixCols$1;
                this.str$1 = str$1;
            }
        });
        return (String)str.elem;
    }

    public <K> double drmSampleToTSV$default$2() {
        return 1.0;
    }

    public <K> DrmLike<K> dexp(DrmLike<K> drmA) {
        return new OpAewUnaryFunc<K>(drmA, (Function1<Object, Object>)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final double apply(double x) {
                return this.apply$mcDD$sp(x);
            }

            public double apply$mcDD$sp(double x) {
                return scala.math.package$.MODULE$.exp(x);
            }
        }, true);
    }

    public <K> DrmLike<K> dlog(DrmLike<K> drmA) {
        return new OpAewUnaryFunc<K>(drmA, (Function1<Object, Object>)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final double apply(double x) {
                return this.apply$mcDD$sp(x);
            }

            public double apply$mcDD$sp(double x) {
                return scala.math.package$.MODULE$.log(x);
            }
        }, true);
    }

    public <K> DrmLike<K> dabs(DrmLike<K> drmA) {
        return new OpAewUnaryFunc<K>(drmA, (Function1<Object, Object>)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final double apply(double x) {
                return this.apply$mcDD$sp(x);
            }

            public double apply$mcDD$sp(double x) {
                return scala.math.package$.MODULE$.abs(x);
            }
        }, OpAewUnaryFunc$.MODULE$.$lessinit$greater$default$3());
    }

    public <K> DrmLike<K> dsqrt(DrmLike<K> drmA) {
        return new OpAewUnaryFunc<K>(drmA, (Function1<Object, Object>)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final double apply(double x) {
                return this.apply$mcDD$sp(x);
            }

            public double apply$mcDD$sp(double x) {
                return scala.math.package$.MODULE$.sqrt(x);
            }
        }, OpAewUnaryFunc$.MODULE$.$lessinit$greater$default$3());
    }

    public <K> DrmLike<K> dsignum(DrmLike<K> drmA) {
        return new OpAewUnaryFunc<K>(drmA, (Function1<Object, Object>)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final double apply(double x) {
                return this.apply$mcDD$sp(x);
            }

            public double apply$mcDD$sp(double x) {
                return scala.math.package$.MODULE$.signum(x);
            }
        }, OpAewUnaryFunc$.MODULE$.$lessinit$greater$default$3());
    }

    public <K> Tuple2<Vector, Vector> dcolMeanVars(DrmLike<K> drmA) {
        CheckpointedDrm<K> drmAcp = drmA.checkpoint(drmA.checkpoint$default$1());
        Vector mu = this.drm2drmCpOps(drmAcp).colMeans();
        Vector vector = RLikeDrmOps$.MODULE$.drm2cpops(RLikeDrmOps$.MODULE$.drm2RLikeOps(drmAcp).$up(2.0)).colMeans();
        Vector variances = RLikeOps$.MODULE$.v2vOps(RLikeOps$.MODULE$.v2vOps(mu).$times(mu)).$minus$eq$colon(vector);
        return Predef.ArrowAssoc$.MODULE$.$u2192$extension(Predef$.MODULE$.any2ArrowAssoc((Object)mu), (Object)variances);
    }

    public <K> Tuple2<Vector, Vector> dcolMeanStdevs(DrmLike<K> drmA) {
        Tuple2<Vector, Vector> tuple2 = this.dcolMeanVars(drmA);
        if (tuple2 != null) {
            Tuple2 tuple22;
            Vector mu = (Vector)tuple2._1();
            Vector vars = (Vector)tuple2._2();
            Tuple2 tuple23 = tuple22 = new Tuple2((Object)mu, (Object)vars);
            Vector mu2 = (Vector)tuple23._1();
            Vector vars2 = (Vector)tuple23._2();
            return Predef.ArrowAssoc$.MODULE$.$u2192$extension(Predef$.MODULE$.any2ArrowAssoc((Object)mu2), (Object)RLikeOps$.MODULE$.v2vOps(vars2).$colon$colon$eq((Function1<Object, Object>)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final double apply(double x) {
                    return this.apply$mcDD$sp(x);
                }

                public double apply$mcDD$sp(double x) {
                    return scala.math.package$.MODULE$.sqrt(x);
                }
            }));
        }
        throw new MatchError(tuple2);
    }

    public <K> Tuple2<Vector, Matrix> dcolMeanCovThin(DrmLike<K> drmA, ClassTag<K> evidence$2) {
        CheckpointedDrm<K> drmAcp = drmA.checkpoint(drmA.checkpoint$default$1());
        Vector mu = this.drm2drmCpOps(drmAcp).colMeans();
        Matrix mxCov = RLikeOps$.MODULE$.m2mOps(RLikeOps$.MODULE$.m2mOps(this.drm2Checkpointed(RLikeDrmOps$.MODULE$.drmInt2RLikeOps(RLikeDrmOps$.MODULE$.drm2RLikeOps(drmAcp).t()).$percent$times$percent(drmAcp)).collect()).$div$eq(drmAcp.nrow())).$minus$eq(mu.cross(mu));
        return Predef.ArrowAssoc$.MODULE$.$u2192$extension(Predef$.MODULE$.any2ArrowAssoc((Object)mu), (Object)mxCov);
    }

    public <K> Tuple2<Vector, DrmLike<Object>> dcolMeanCov(DrmLike<K> drmA, ClassTag<K> evidence$3) {
        DistributedContext ctx = drmA.context();
        CheckpointedDrm<K> drmAcp = drmA.checkpoint(drmA.checkpoint$default$1());
        BCast<Vector> bcastMu = this.drmBroadcast(this.drm2drmCpOps(drmAcp).colMeans(), ctx);
        RLikeDrmIntOps qual$2 = RLikeDrmOps$.MODULE$.drmInt2RLikeOps(RLikeDrmOps$.MODULE$.drmInt2RLikeOps(RLikeDrmOps$.MODULE$.drmInt2RLikeOps(RLikeDrmOps$.MODULE$.drm2RLikeOps(drmAcp).t()).$percent$times$percent(drmAcp)).$div(drmAcp.nrow()));
        int x$6 = qual$2.mapBlock$default$1();
        boolean x$7 = qual$2.mapBlock$default$2();
        Serializable x$8 = new Serializable(bcastMu){
            public static final long serialVersionUID = 0L;
            private final BCast bcastMu$1;

            public final Tuple2<int[], Matrix> apply(Tuple2<int[], Matrix> x0$1) {
                Tuple2<int[], Matrix> tuple2 = x0$1;
                if (tuple2 != null) {
                    int[] keys = (int[])tuple2._1();
                    Matrix block = (Matrix)tuple2._2();
                    Vector mu = (Vector)package$.MODULE$.bcast2val(this.bcastMu$1);
                    Tuple2 tuple22 = Predef.ArrowAssoc$.MODULE$.$u2192$extension(Predef$.MODULE$.any2ArrowAssoc((Object)keys), (Object)RLikeOps$.MODULE$.m2mOps(block).$colon$eq((Function3<Object, Object, Object, Object>)new Serializable(this, keys, mu){
                        public static final long serialVersionUID = 0L;
                        private final int[] keys$1;
                        private final Vector mu$1;

                        public final double apply(int r, int c, double v) {
                            return v - RLikeOps$.MODULE$.v2vOps(this.mu$1).apply(this.keys$1[r]) * RLikeOps$.MODULE$.v2vOps(this.mu$1).apply(c);
                        }
                        {
                            this.keys$1 = keys$1;
                            this.mu$1 = mu$1;
                        }
                    }));
                    return tuple22;
                }
                throw new MatchError(tuple2);
            }
            {
                this.bcastMu$1 = bcastMu$1;
            }
        };
        DrmLike drmSigma = qual$2.mapBlock(x$6, x$7, (Function1<Tuple2<Object, Matrix>, Tuple2<Object, Matrix>>)x$8, ClassTag$.MODULE$.Int());
        return Predef.ArrowAssoc$.MODULE$.$u2192$extension(Predef$.MODULE$.any2ArrowAssoc((Object)this.bcast2val(bcastMu)), drmSigma);
    }

    public DrmLike<Object> dsqDist(DrmLike<Object> drmX) {
        DistributedContext ctx = drmX.context();
        CheckpointedDrm<Object> drmXcp = drmX.checkpoint(drmX.checkpoint$default$1());
        Vector s = RLikeDrmOps$.MODULE$.drmInt2RLikeOps(RLikeDrmOps$.MODULE$.drmInt2RLikeOps(drmXcp).$up(2.0)).rowSums();
        BCast<Vector> sBcast = this.drmBroadcast(s, ctx);
        RLikeDrmIntOps qual$3 = RLikeDrmOps$.MODULE$.drmInt2RLikeOps(RLikeDrmOps$.MODULE$.drmInt2RLikeOps(drmXcp).$percent$times$percent(RLikeDrmOps$.MODULE$.drmInt2RLikeOps(drmXcp).t()));
        int x$9 = qual$3.mapBlock$default$1();
        boolean x$10 = qual$3.mapBlock$default$2();
        Serializable x$11 = new Serializable(sBcast){
            public static final long serialVersionUID = 0L;
            private final BCast sBcast$1;

            public final Tuple2<int[], Matrix> apply(Tuple2<int[], Matrix> x0$2) {
                Tuple2<int[], Matrix> tuple2 = x0$2;
                if (tuple2 != null) {
                    int[] keys = (int[])tuple2._1();
                    Matrix block = (Matrix)tuple2._2();
                    Vector s = (Vector)package$.MODULE$.bcast2val(this.sBcast$1);
                    RLikeOps$.MODULE$.m2mOps(block).$colon$eq((Function3<Object, Object, Object, Object>)new Serializable(this, keys, s){
                        public static final long serialVersionUID = 0L;
                        private final int[] keys$2;
                        private final Vector s$1;

                        public final double apply(int r, int c, double x) {
                            return RLikeOps$.MODULE$.v2vOps(this.s$1).apply(this.keys$2[r]) + RLikeOps$.MODULE$.v2vOps(this.s$1).apply(c) - (double)2 * x;
                        }
                        {
                            this.keys$2 = keys$2;
                            this.s$1 = s$1;
                        }
                    });
                    Tuple2 tuple22 = Predef.ArrowAssoc$.MODULE$.$u2192$extension(Predef$.MODULE$.any2ArrowAssoc((Object)keys), (Object)block);
                    return tuple22;
                }
                throw new MatchError(tuple2);
            }
            {
                this.sBcast$1 = sBcast$1;
            }
        };
        return qual$3.mapBlock(x$9, x$10, (Function1<Tuple2<Object, Matrix>, Tuple2<Object, Matrix>>)x$11, ClassTag$.MODULE$.Int());
    }

    public DrmLike<Object> dsqDist(DrmLike<Object> drmX, DrmLike<Object> drmY) {
        DistributedContext ctx = drmX.context();
        CheckpointedDrm<Object> drmXcp = drmX.checkpoint(drmX.checkpoint$default$1());
        CheckpointedDrm<Object> drmYcp = drmY.checkpoint(drmY.checkpoint$default$1());
        BCast<Vector> sBcast = this.drmBroadcast(RLikeDrmOps$.MODULE$.drmInt2RLikeOps(RLikeDrmOps$.MODULE$.drmInt2RLikeOps(drmXcp).$up(2.0)).rowSums(), ctx);
        BCast<Vector> tBcast = this.drmBroadcast(RLikeDrmOps$.MODULE$.drmInt2RLikeOps(RLikeDrmOps$.MODULE$.drmInt2RLikeOps(drmYcp).$up(2.0)).rowSums(), ctx);
        RLikeDrmIntOps qual$4 = RLikeDrmOps$.MODULE$.drmInt2RLikeOps(RLikeDrmOps$.MODULE$.drmInt2RLikeOps(drmX).$percent$times$percent(RLikeDrmOps$.MODULE$.drmInt2RLikeOps(drmY).t()));
        int x$12 = qual$4.mapBlock$default$1();
        boolean x$13 = qual$4.mapBlock$default$2();
        Serializable x$14 = new Serializable(sBcast, tBcast){
            public static final long serialVersionUID = 0L;
            private final BCast sBcast$2;
            private final BCast tBcast$1;

            public final Tuple2<int[], Matrix> apply(Tuple2<int[], Matrix> x0$3) {
                Tuple2<int[], Matrix> tuple2 = x0$3;
                if (tuple2 != null) {
                    int[] keys = (int[])tuple2._1();
                    Matrix block = (Matrix)tuple2._2();
                    Vector s = (Vector)package$.MODULE$.bcast2val(this.sBcast$2);
                    Vector t = (Vector)package$.MODULE$.bcast2val(this.tBcast$1);
                    RLikeOps$.MODULE$.m2mOps(block).$colon$eq((Function3<Object, Object, Object, Object>)new Serializable(this, keys, s, t){
                        public static final long serialVersionUID = 0L;
                        private final int[] keys$3;
                        private final Vector s$2;
                        private final Vector t$1;

                        public final double apply(int r, int c, double x) {
                            return RLikeOps$.MODULE$.v2vOps(this.s$2).apply(this.keys$3[r]) + RLikeOps$.MODULE$.v2vOps(this.t$1).apply(c) - (double)2 * x;
                        }
                        {
                            this.keys$3 = keys$3;
                            this.s$2 = s$2;
                            this.t$1 = t$1;
                        }
                    });
                    Tuple2 tuple22 = Predef.ArrowAssoc$.MODULE$.$u2192$extension(Predef$.MODULE$.any2ArrowAssoc((Object)keys), (Object)block);
                    return tuple22;
                }
                throw new MatchError(tuple2);
            }
            {
                this.sBcast$2 = sBcast$2;
                this.tBcast$1 = tBcast$1;
            }
        };
        return qual$4.mapBlock(x$12, x$13, (Function1<Tuple2<Object, Matrix>, Tuple2<Object, Matrix>>)x$14, ClassTag$.MODULE$.Int());
    }

    private package$() {
        MODULE$ = this;
    }
}

