/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.cf.taste.example.kddcup.track1;

import java.util.Collection;
import java.util.List;
import org.apache.mahout.cf.taste.common.Refreshable;
import org.apache.mahout.cf.taste.common.TasteException;
import org.apache.mahout.cf.taste.impl.recommender.GenericItemBasedRecommender;
import org.apache.mahout.cf.taste.impl.similarity.UncenteredCosineSimilarity;
import org.apache.mahout.cf.taste.model.DataModel;
import org.apache.mahout.cf.taste.recommender.IDRescorer;
import org.apache.mahout.cf.taste.recommender.RecommendedItem;
import org.apache.mahout.cf.taste.recommender.Recommender;
import org.apache.mahout.cf.taste.similarity.ItemSimilarity;

public final class Track1Recommender
implements Recommender {
    private final Recommender recommender;

    public Track1Recommender(DataModel dataModel) throws TasteException {
        UncenteredCosineSimilarity similarity = new UncenteredCosineSimilarity(dataModel);
        this.recommender = new GenericItemBasedRecommender(dataModel, (ItemSimilarity)similarity);
    }

    public List<RecommendedItem> recommend(long userID, int howMany) throws TasteException {
        return this.recommender.recommend(userID, howMany);
    }

    public List<RecommendedItem> recommend(long userID, int howMany, boolean includeKnownItems) throws TasteException {
        return this.recommend(userID, howMany, null, includeKnownItems);
    }

    public List<RecommendedItem> recommend(long userID, int howMany, IDRescorer rescorer) throws TasteException {
        return this.recommender.recommend(userID, howMany, rescorer, false);
    }

    public List<RecommendedItem> recommend(long userID, int howMany, IDRescorer rescorer, boolean includeKnownItems) throws TasteException {
        return this.recommender.recommend(userID, howMany, rescorer, includeKnownItems);
    }

    public float estimatePreference(long userID, long itemID) throws TasteException {
        return this.recommender.estimatePreference(userID, itemID);
    }

    public void setPreference(long userID, long itemID, float value) throws TasteException {
        this.recommender.setPreference(userID, itemID, value);
    }

    public void removePreference(long userID, long itemID) throws TasteException {
        this.recommender.removePreference(userID, itemID);
    }

    public DataModel getDataModel() {
        return this.recommender.getDataModel();
    }

    public void refresh(Collection<Refreshable> alreadyRefreshed) {
        this.recommender.refresh(alreadyRefreshed);
    }

    public String toString() {
        return "Track1Recommender[recommender:" + this.recommender + ']';
    }
}

