/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.facet.collections;

import java.util.Arrays;
import org.apache.lucene.facet.collections.IntHashSet;

public class IntArray {
    private int[] data;
    private int size;
    private boolean shouldSort;

    public IntArray() {
        this.init(true);
    }

    private void init(boolean realloc) {
        this.size = 0;
        if (realloc) {
            this.data = new int[0];
        }
        this.shouldSort = false;
    }

    public void intersect(IntHashSet set) {
        int newSize = 0;
        for (int i = 0; i < this.size; ++i) {
            if (!set.contains(this.data[i])) continue;
            this.data[newSize] = this.data[i];
            ++newSize;
        }
        this.size = newSize;
    }

    public void intersect(IntArray other) {
        this.sort();
        other.sort();
        int myIndex = 0;
        int otherIndex = 0;
        int newSize = 0;
        if (this.size > other.size) {
            while (otherIndex < other.size && myIndex < this.size) {
                while (otherIndex < other.size && other.data[otherIndex] < this.data[myIndex]) {
                    ++otherIndex;
                }
                if (otherIndex != other.size) {
                    while (myIndex < this.size && other.data[otherIndex] > this.data[myIndex]) {
                        ++myIndex;
                    }
                    if (other.data[otherIndex] != this.data[myIndex]) continue;
                    this.data[newSize++] = this.data[myIndex];
                    ++otherIndex;
                    ++myIndex;
                    continue;
                }
                break;
            }
        } else {
            while (otherIndex < other.size && myIndex < this.size) {
                while (myIndex < this.size && other.data[otherIndex] > this.data[myIndex]) {
                    ++myIndex;
                }
                if (myIndex != this.size) {
                    while (otherIndex < other.size && other.data[otherIndex] < this.data[myIndex]) {
                        ++otherIndex;
                    }
                    if (other.data[otherIndex] != this.data[myIndex]) continue;
                    this.data[newSize++] = this.data[myIndex];
                    ++otherIndex;
                    ++myIndex;
                    continue;
                }
                break;
            }
        }
        this.size = newSize;
    }

    public int size() {
        return this.size;
    }

    public void addToArray(int value) {
        if (this.size == this.data.length) {
            int[] newArray = new int[2 * this.size + 1];
            System.arraycopy(this.data, 0, newArray, 0, this.size);
            this.data = newArray;
        }
        this.data[this.size] = value;
        ++this.size;
        this.shouldSort = true;
    }

    public boolean equals(Object o) {
        if (!(o instanceof IntArray)) {
            return false;
        }
        IntArray array = (IntArray)o;
        if (array.size != this.size) {
            return false;
        }
        this.sort();
        array.sort();
        boolean equal = true;
        int i = this.size;
        while (i > 0 && equal) {
            equal = array.data[--i] == this.data[i];
        }
        return equal;
    }

    public void sort() {
        if (this.shouldSort) {
            this.shouldSort = false;
            Arrays.sort(this.data, 0, this.size);
        }
    }

    public int hashCode() {
        int hash = 0;
        for (int i = 0; i < this.size; ++i) {
            hash = this.data[i] ^ hash * 31;
        }
        return hash;
    }

    public int get(int i) {
        if (i >= this.size) {
            throw new ArrayIndexOutOfBoundsException(i);
        }
        return this.data[i];
    }

    public void set(int idx, int value) {
        if (idx >= this.size) {
            throw new ArrayIndexOutOfBoundsException(idx);
        }
        this.data[idx] = value;
    }

    public String toString() {
        String s = "(" + this.size + ") ";
        for (int i = 0; i < this.size; ++i) {
            s = s + "" + this.data[i] + ", ";
        }
        return s;
    }

    public void clear(boolean resize) {
        this.init(resize);
    }
}

