/*
 * Decompiled with CFR 0.152.
 */
package smile.swing.table;

import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.AbstractTableModel;
import smile.swing.Button;

public abstract class PageTableModel
extends AbstractTableModel {
    private int pageSize = 100;
    private int page = 0;
    private JToolBar toolbar;
    private JTextField pageSizeField = new JTextField(5);
    private JTextField pageField = new JTextField(5);
    private JLabel pageSizeLabel = new JLabel("Page Size: ");
    private JLabel totalRowCountLabel = new JLabel();
    private JLabel pageCountLabel = new JLabel();
    private String totalRowCountLabelFormat = "Total Rows: %-8d    Page:";
    private String pageCountLabelFormat = " of %d";
    private Action pageDownAction = new PageDownAction();
    private Action pageUpAction = new PageUpAction();
    private Action firstPageAction = new FirstPageAction();
    private Action lastPageAction = new LastPageAction();
    private Action gotoPageAction = new GoToPageAction();
    private Action pageSizeAction = new PageSizeAction();

    public PageTableModel() {
        this(100);
    }

    public PageTableModel(int pageSize) {
        this.pageSize = pageSize;
        this.initToolBar();
    }

    @Override
    public int getRowCount() {
        if (this.page == this.getPageCount() - 1) {
            return this.getRealRowCount() - this.pageSize * (this.getPageCount() - 1);
        }
        return Math.min(this.pageSize, this.getRealRowCount());
    }

    public abstract int getRealRowCount();

    public int getRealRow(int row) {
        return row + this.page * this.pageSize;
    }

    @Override
    public Object getValueAt(int row, int col) {
        int realRow = row + this.page * this.pageSize;
        return this.getValueAtRealRow(realRow, col);
    }

    public abstract Object getValueAtRealRow(int var1, int var2);

    public int getPage() {
        return this.page;
    }

    public boolean setPage(int p) {
        if (p >= 0 && p < this.getPageCount()) {
            this.page = p;
            this.fireTableDataChanged();
            return true;
        }
        return false;
    }

    public int getPageCount() {
        int pages = (int)Math.ceil((double)this.getRealRowCount() / (double)this.pageSize);
        if (pages == 0) {
            pages = 1;
        }
        return pages;
    }

    public int getPageSize() {
        return this.pageSize;
    }

    public void setPageSize(int s) {
        if (s <= 0) {
            throw new IllegalArgumentException("non-positive page size: " + s);
        }
        if (s == this.pageSize) {
            return;
        }
        int oldPageSize = this.pageSize;
        this.pageSize = s;
        this.page = oldPageSize * this.page / this.pageSize;
        this.fireTableDataChanged();
    }

    public boolean pageDown() {
        if (this.page < this.getPageCount() - 1) {
            ++this.page;
            this.fireTableDataChanged();
            return true;
        }
        return false;
    }

    public boolean pageUp() {
        if (this.page > 0) {
            --this.page;
            this.fireTableDataChanged();
            return true;
        }
        return false;
    }

    public JToolBar getToolbar() {
        return this.toolbar;
    }

    private void initToolBar() {
        this.toolbar = new JToolBar();
        this.toolbar.add(new Button(this.firstPageAction));
        this.toolbar.add(new Button(this.pageUpAction));
        this.toolbar.add(new Button(this.pageDownAction));
        this.toolbar.add(new Button(this.lastPageAction));
        this.toolbar.addSeparator();
        this.toolbar.add(this.pageSizeLabel);
        this.toolbar.add(this.pageSizeField);
        this.pageSizeField.setText(Integer.toString(this.getPageSize()));
        this.pageSizeField.setHorizontalAlignment(4);
        this.pageSizeField.setAction(this.pageSizeAction);
        this.pageSizeField.setMaximumSize(this.pageSizeField.getPreferredSize());
        this.toolbar.addSeparator();
        this.totalRowCountLabel.setText(String.format(this.totalRowCountLabelFormat, this.getRealRowCount()));
        this.toolbar.add(this.totalRowCountLabel);
        this.toolbar.add(this.pageField);
        this.pageField.setText(Integer.toString(this.getPage() + 1));
        this.pageField.setHorizontalAlignment(4);
        this.pageField.setAction(this.gotoPageAction);
        this.pageField.setMaximumSize(this.pageField.getPreferredSize());
        this.pageCountLabel.setText(String.format(this.pageCountLabelFormat, this.getPageCount()));
        this.toolbar.add(this.pageCountLabel);
        this.setActionEnabled();
        TableModelListener listener = new TableModelListener(){

            @Override
            public void tableChanged(TableModelEvent tme) {
                if (tme.getType() == 1 || tme.getType() == -1) {
                    if (PageTableModel.this.getPage() >= PageTableModel.this.getPageCount()) {
                        PageTableModel.this.setPage(PageTableModel.this.getPageCount() - 1);
                    }
                    PageTableModel.this.totalRowCountLabel.setText(String.format(PageTableModel.this.totalRowCountLabelFormat, PageTableModel.this.getRealRowCount()));
                    PageTableModel.this.pageField.setText(Integer.toString(PageTableModel.this.getPage() + 1));
                    PageTableModel.this.pageCountLabel.setText(String.format(PageTableModel.this.pageCountLabelFormat, PageTableModel.this.getPageCount()));
                }
            }
        };
        this.addTableModelListener(listener);
    }

    private void setActionEnabled() {
        if (this.getPage() == 0) {
            this.firstPageAction.setEnabled(false);
            this.pageUpAction.setEnabled(false);
        } else {
            this.firstPageAction.setEnabled(true);
            this.pageUpAction.setEnabled(true);
        }
        if (this.getPage() == this.getPageCount() - 1) {
            this.lastPageAction.setEnabled(false);
            this.pageDownAction.setEnabled(false);
        } else {
            this.lastPageAction.setEnabled(true);
            this.pageDownAction.setEnabled(true);
        }
        this.totalRowCountLabel.setText(String.format(this.totalRowCountLabelFormat, this.getRealRowCount()));
        this.pageField.setText(Integer.toString(this.getPage() + 1));
        this.pageCountLabel.setText(String.format(this.pageCountLabelFormat, this.getPageCount()));
    }

    class PageSizeAction
    extends AbstractAction {
        public PageSizeAction() {
            super("Page Size");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            try {
                int s = Integer.parseInt(PageTableModel.this.pageSizeField.getText());
                PageTableModel.this.setPageSize(s);
                PageTableModel.this.setActionEnabled();
            }
            catch (Exception ex) {
                Toolkit.getDefaultToolkit().beep();
            }
        }
    }

    class GoToPageAction
    extends AbstractAction {
        public GoToPageAction() {
            super("Go To Page");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            try {
                int p = Integer.parseInt(PageTableModel.this.pageField.getText()) - 1;
                if (PageTableModel.this.setPage(p)) {
                    PageTableModel.this.setActionEnabled();
                } else {
                    Toolkit.getDefaultToolkit().beep();
                }
            }
            catch (Exception ex) {
                Toolkit.getDefaultToolkit().beep();
            }
        }
    }

    class LastPageAction
    extends AbstractAction {
        public LastPageAction() {
            super("Last Page", new ImageIcon(PageTableModel.class.getResource("/smile/swing/images/navigate_end.png")));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            PageTableModel.this.setPage(PageTableModel.this.getPageCount() - 1);
            PageTableModel.this.setActionEnabled();
        }
    }

    class FirstPageAction
    extends AbstractAction {
        public FirstPageAction() {
            super("First Page", new ImageIcon(PageTableModel.class.getResource("/smile/swing/images/navigate_beginning.png")));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            PageTableModel.this.setPage(0);
            PageTableModel.this.setActionEnabled();
        }
    }

    class PageUpAction
    extends AbstractAction {
        public PageUpAction() {
            super("Previous Page", new ImageIcon(PageTableModel.class.getResource("/smile/swing/images/navigate_left.png")));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            PageTableModel.this.pageUp();
            PageTableModel.this.setActionEnabled();
        }
    }

    class PageDownAction
    extends AbstractAction {
        public PageDownAction() {
            super("Next Page", new ImageIcon(PageTableModel.class.getResource("/smile/swing/images/navigate_right.png")));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            PageTableModel.this.pageDown();
            PageTableModel.this.setActionEnabled();
        }
    }
}

