/*
 * Decompiled with CFR 0.152.
 */
package smile.swing.table;

import java.awt.Component;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.DefaultCellEditor;
import javax.swing.JFormattedTextField;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.text.DateFormatter;
import javax.swing.text.DefaultFormatterFactory;
import smile.swing.table.DoubleCellEditor;

public class DateCellEditor
extends DefaultCellEditor {
    private static final Logger LOGGER = Logger.getLogger(DoubleCellEditor.class.getName());
    public static final DateCellEditor YYYYMMDD = new DateCellEditor("yyyy-MM-dd");
    public static final DateCellEditor MMDDYY = new DateCellEditor("MM/dd/yy");
    public static final DateCellEditor YYYYMMDD_HHMMSS = new DateCellEditor("yyyy-MM-dd HH:mm:ss");
    public static final DateCellEditor YYYYMMDD_HHMM = new DateCellEditor("yyyy-MM-dd HH:mm");
    public static final DateCellEditor HHMM = new DateCellEditor("HH:mm");
    public static final DateCellEditor HHMMSS = new DateCellEditor("HH:mm:ss");
    public static final DateCellEditor ISO8601 = new DateCellEditor("yyyy-MM-dd'T'HH:mm:ss.SSSXXX");
    JFormattedTextField textField = (JFormattedTextField)this.getComponent();
    DateFormat dateFormat;

    public DateCellEditor(String format) {
        this(new SimpleDateFormat(format));
    }

    public DateCellEditor(DateFormat dateFormat) {
        super(new JFormattedTextField());
        this.dateFormat = dateFormat;
        DateFormatter dateFormatter = new DateFormatter(dateFormat);
        this.textField.setFormatterFactory(new DefaultFormatterFactory(dateFormatter));
        this.textField.setHorizontalAlignment(11);
        this.textField.setFocusLostBehavior(3);
        this.textField.getInputMap().put(KeyStroke.getKeyStroke(10, 0), "check");
        this.textField.getActionMap().put("check", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!DateCellEditor.this.textField.isEditValid()) {
                    Toolkit.getDefaultToolkit().beep();
                    DateCellEditor.this.textField.selectAll();
                } else {
                    try {
                        DateCellEditor.this.textField.commitEdit();
                        DateCellEditor.this.textField.postActionEvent();
                    }
                    catch (ParseException parseException) {
                        // empty catch block
                    }
                }
            }
        });
    }

    @Override
    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        JFormattedTextField ftf = (JFormattedTextField)super.getTableCellEditorComponent(table, value, isSelected, row, column);
        ftf.setValue(value);
        return ftf;
    }

    @Override
    public Object getCellEditorValue() {
        JFormattedTextField ftf = (JFormattedTextField)this.getComponent();
        Object o = ftf.getValue();
        if (o instanceof Date) {
            return o;
        }
        try {
            return this.dateFormat.parseObject(o.toString());
        }
        catch (ParseException ex) {
            LOGGER.log(Level.FINE, "getCellEditorValue: can't parse {0}", o);
            return null;
        }
    }

    @Override
    public boolean stopCellEditing() {
        JFormattedTextField ftf = (JFormattedTextField)this.getComponent();
        if (ftf.isEditValid()) {
            try {
                ftf.commitEdit();
            }
            catch (ParseException parseException) {}
        } else {
            Toolkit.getDefaultToolkit().beep();
            this.textField.selectAll();
            return false;
        }
        return super.stopCellEditing();
    }
}

