/*
 * Decompiled with CFR 0.152.
 */
package smile.stat.distribution;

import smile.math.Math;
import smile.math.special.Beta;
import smile.math.special.Gamma;
import smile.stat.distribution.DiscreteDistribution;

public class NegativeBinomialDistribution
extends DiscreteDistribution {
    private double r;
    private double p;

    public NegativeBinomialDistribution(double r, double p) {
        if (p <= 0.0 || p >= 1.0) {
            throw new IllegalArgumentException("Invalid p: " + p);
        }
        if (r <= 0.0) {
            throw new IllegalArgumentException("Invalid r: " + r);
        }
        this.p = p;
        this.r = r;
    }

    @Override
    public int npara() {
        return 2;
    }

    @Override
    public double mean() {
        return this.r * (1.0 - this.p) / this.p;
    }

    @Override
    public double var() {
        return this.r * (1.0 - this.p) / (this.p * this.p);
    }

    @Override
    public double sd() {
        return Math.sqrt(this.r * (1.0 - this.p)) / this.p;
    }

    @Override
    public double entropy() {
        throw new UnsupportedOperationException("Negative Binomial distribution does not support entropy()");
    }

    public String toString() {
        if (this.r == (double)((int)this.r)) {
            return String.format("Negative Binomial(%d, %.4f)", this.r, this.p);
        }
        return String.format("Negative Binomial(%.4f, %.4f)", this.r, this.p);
    }

    @Override
    public double rand() {
        return this.inverseTransformSampling();
    }

    @Override
    public double p(int k) {
        if (k < 0) {
            return 0.0;
        }
        return Gamma.gamma(this.r + (double)k) / (Math.factorial(k) * Gamma.gamma(this.r)) * Math.pow(this.p, this.r) * Math.pow(1.0 - this.p, (double)k);
    }

    @Override
    public double logp(int k) {
        if (k < 0) {
            return Double.NEGATIVE_INFINITY;
        }
        return Gamma.logGamma(this.r + (double)k) - Math.logFactorial(k) - Gamma.logGamma(this.r) + this.r * Math.log(this.p) + (double)k * Math.log(1.0 - this.p);
    }

    @Override
    public double cdf(double k) {
        if (k < 0.0) {
            return 0.0;
        }
        return Beta.regularizedIncompleteBetaFunction(this.r, k + 1.0, this.p);
    }

    @Override
    public double quantile(double p) {
        int ku;
        int kl;
        if (p < 0.0 || p > 1.0) {
            throw new IllegalArgumentException("Invalid p: " + p);
        }
        int inc = 1;
        int k = (int)this.mean();
        if (p < this.cdf(k)) {
            do {
                k = Math.max(k - inc, 0);
                inc *= 2;
            } while (p < this.cdf(k) && k > 0);
            kl = k;
            ku = k + inc / 2;
        } else {
            while (p > this.cdf(k += (inc *= 2))) {
            }
            ku = k;
            kl = k - inc / 2;
        }
        return this.quantile(p, kl, ku);
    }
}

