/*
 * Decompiled with CFR 0.152.
 */
package smile.plot;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import javax.imageio.ImageIO;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JToolBar;
import javax.swing.RepaintManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import smile.plot.PlotCanvas;
import smile.swing.FileChooser;
import smile.swing.Printer;

public class PlotPanel
extends JPanel
implements ActionListener,
Printable {
    private static final Logger logger = LoggerFactory.getLogger(PlotPanel.class);
    private static final String SAVE = "save";
    private static final String PRINT = "print";
    private JPanel contentPane;
    private JToolBar toolbar;

    public PlotPanel(PlotCanvas plot) {
        this.init();
        this.contentPane.add(plot);
        this.organize();
    }

    public PlotPanel(PlotCanvas ... plots) {
        this.init();
        for (PlotCanvas plot : plots) {
            this.contentPane.add(plot);
        }
        this.organize();
    }

    private void init() {
        this.setLayout(new BorderLayout());
        this.initToolBar();
        this.contentPane = new JPanel();
        this.contentPane.setLayout(new GridLayout(0, 1, 0, 0));
        this.contentPane.setBackground(Color.WHITE);
        this.add((Component)this.contentPane, "Center");
    }

    private void organize() {
        int m = (int)Math.sqrt(this.contentPane.getComponentCount());
        if (m <= 0) {
            m = 1;
        }
        this.contentPane.setLayout(new GridLayout(m, 0, 0, 0));
    }

    public void add(PlotCanvas plot) {
        this.contentPane.add(plot);
        this.organize();
    }

    public void remove(PlotCanvas plot) {
        this.contentPane.remove(plot);
        this.organize();
    }

    private void initToolBar() {
        this.toolbar = new JToolBar(1);
        this.toolbar.setFloatable(false);
        this.add((Component)this.toolbar, "West");
        JButton button = this.makeButton(SAVE, SAVE, "Save", "Save");
        this.toolbar.add(button);
        button = this.makeButton(PRINT, PRINT, "Print", "Print");
        this.toolbar.add(button);
    }

    private JButton makeButton(String imageName, String actionCommand, String toolTipText, String altText) {
        String imgLocation = "images/" + imageName + "16.png";
        URL imageURL = PlotCanvas.class.getResource(imgLocation);
        JButton button = new JButton();
        button.setActionCommand(actionCommand);
        button.setToolTipText(toolTipText);
        button.addActionListener(this);
        if (imageURL != null) {
            button.setIcon(new ImageIcon(imageURL, altText));
        } else {
            button.setText(altText);
            logger.error("Resource not found: {}", (Object)imgLocation);
        }
        return button;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String cmd = e.getActionCommand();
        if (SAVE.equals(cmd)) {
            try {
                this.save();
            }
            catch (IOException ex) {
                logger.error("Failed to save the screenshot", (Throwable)ex);
                JOptionPane.showMessageDialog(null, ex.getMessage(), "Error", 0);
            }
        } else if (PRINT.equals(cmd)) {
            this.print();
        }
    }

    @Override
    public int print(Graphics g, PageFormat pf, int page) throws PrinterException {
        if (page > 0) {
            return 1;
        }
        Graphics2D g2d = (Graphics2D)g;
        g2d.translate(pf.getImageableX(), pf.getImageableY());
        double scaleX = pf.getImageableWidth() / (double)this.contentPane.getWidth();
        double scaleY = pf.getImageableHeight() / (double)this.contentPane.getHeight();
        g2d.scale(scaleX, scaleY);
        RepaintManager currentManager = RepaintManager.currentManager(this);
        currentManager.setDoubleBufferingEnabled(false);
        this.contentPane.printAll(g);
        currentManager.setDoubleBufferingEnabled(true);
        return 0;
    }

    public void save() throws IOException {
        FileChooser fc = FileChooser.getInstance();
        fc.setFileFilter(FileChooser.SimpleFileFilter.getWritableImageFIlter());
        fc.setAcceptAllFileFilterUsed(false);
        fc.setSelectedFiles(new File[0]);
        int returnVal = fc.showOpenDialog(this);
        if (returnVal == 0) {
            File file = fc.getSelectedFile();
            this.save(file);
        }
    }

    public void save(File file) throws IOException {
        BufferedImage bi = new BufferedImage(this.contentPane.getWidth(), this.contentPane.getHeight(), 2);
        Graphics2D g2d = bi.createGraphics();
        this.contentPane.printAll(g2d);
        ImageIO.write((RenderedImage)bi, FileChooser.getExtension(file), file);
    }

    public void print() {
        Printer.getPrinter().print(this);
    }
}

