/*
 * Decompiled with CFR 0.152.
 */
package smile.plot;

import java.awt.Color;
import java.util.Arrays;
import smile.math.Math;
import smile.plot.Graphics;
import smile.plot.Palette;
import smile.plot.Plot;
import smile.plot.PlotCanvas;

public class Heatmap
extends Plot {
    private double[] x;
    private String[] columnLabels;
    private String[] rowLabels;
    private double[] y;
    private double[][] z;
    private double min;
    private double max;
    private double width;
    private Color[] palette;

    public Heatmap(double[][] z) {
        this(z, 16);
    }

    public Heatmap(double[][] z, int k) {
        this(z, Palette.jet(k, 1.0f));
    }

    public Heatmap(double[][] z, Color[] palette) {
        this.z = z;
        this.palette = palette;
        this.init();
    }

    public Heatmap(String[] rowLabels, String[] columnLabels, double[][] z) {
        this(rowLabels, columnLabels, z, 16);
    }

    public Heatmap(String[] rowLabels, String[] columnLabels, double[][] z, int k) {
        this(rowLabels, columnLabels, z, Palette.jet(k, 1.0f));
    }

    public Heatmap(String[] rowLabels, String[] columnLabels, double[][] z, Color[] palette) {
        this.z = z;
        this.columnLabels = columnLabels;
        this.rowLabels = rowLabels;
        this.palette = palette;
        this.init();
    }

    public Heatmap(double[] x, double[] y, double[][] z) {
        this(z, 16);
    }

    public Heatmap(double[] x, double[] y, double[][] z, int k) {
        this(x, y, z, Palette.jet(k, 1.0f));
    }

    public Heatmap(double[] x, double[] y, double[][] z, Color[] palette) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.palette = palette;
        this.init();
    }

    private void init() {
        int i;
        if (this.x == null) {
            this.x = new double[this.z[0].length];
            for (i = 0; i < this.x.length; ++i) {
                this.x[i] = (double)i + 0.5;
            }
        }
        if (this.y == null) {
            this.y = new double[this.z.length];
            for (i = 0; i < this.y.length; ++i) {
                this.y[i] = (double)(this.y.length - i) - 0.5;
            }
        }
        int n = this.z.length * this.z[0].length;
        double[] values = new double[n];
        int i2 = 0;
        double[][] dArray = this.z;
        int n2 = dArray.length;
        for (int j = 0; j < n2; ++j) {
            double[] zi;
            for (double zij : zi = dArray[j]) {
                if (Double.isNaN(zij)) continue;
                values[i2++] = zij;
            }
        }
        if (i2 > 0) {
            Arrays.sort(values, 0, i2);
            this.min = values[(int)Math.round(0.01 * (double)i2)];
            this.max = values[(int)Math.round(0.99 * (double)(i2 - 1))];
            this.width = (this.max - this.min) / (double)this.palette.length;
        }
    }

    @Override
    public String getToolTip(double[] coord) {
        if (this.rowLabels == null || this.columnLabels == null) {
            return null;
        }
        if (coord[0] < 0.0 || coord[0] > (double)this.z[0].length || coord[1] < 0.0 || coord[1] > (double)this.z.length) {
            return null;
        }
        int i = (int)coord[0];
        int j = (int)((double)this.y.length - coord[1]);
        return String.format("%s, %s", this.rowLabels[j], this.columnLabels[i]);
    }

    @Override
    public void paint(Graphics g) {
        Color c = g.getColor();
        double[] start = new double[2];
        double[] end = new double[2];
        for (int i = 0; i < this.z.length; ++i) {
            for (int j = 0; j < this.z[i].length; ++j) {
                if (Double.isNaN(this.z[i][j])) {
                    g.setColor(Color.WHITE);
                } else {
                    int k = (int)((this.z[i][j] - this.min) / this.width);
                    if (k < 0) {
                        k = 0;
                    }
                    if (k >= this.palette.length) {
                        k = this.palette.length - 1;
                    }
                    g.setColor(this.palette[k]);
                }
                start[0] = this.x[j];
                start[0] = j == 0 ? start[0] - Math.abs(this.x[j + 1] - this.x[j]) / 2.0 : start[0] - Math.abs(this.x[j] - this.x[j - 1]) / 2.0;
                start[1] = this.y[i];
                start[1] = i == 0 ? start[1] + Math.abs(this.y[i + 1] - this.y[i]) / 2.0 : start[1] + Math.abs(this.y[i] - this.y[i - 1]) / 2.0;
                end[0] = this.x[j];
                end[0] = j == this.x.length - 1 ? end[0] + Math.abs(this.x[j] - this.x[j - 1]) / 2.0 : end[0] + Math.abs(this.x[j + 1] - this.x[j]) / 2.0;
                end[1] = this.y[i];
                end[1] = i == this.y.length - 1 ? end[1] - Math.abs(this.y[i] - this.y[i - 1]) / 2.0 : end[1] - Math.abs(this.y[i + 1] - this.y[i]) / 2.0;
                g.fillRect(start, end);
            }
        }
        g.clearClip();
        double height = 0.7 / (double)this.palette.length;
        start[0] = 1.1;
        start[1] = 0.15;
        end[0] = 1.13;
        end[1] = start[1] - height;
        for (int i = 0; i < this.palette.length; ++i) {
            g.setColor(this.palette[i]);
            g.fillRectBaseRatio(start, end);
            start[1] = start[1] + height;
            end[1] = end[1] + height;
        }
        g.setColor(Color.BLACK);
        start[1] = start[1] - height;
        end[1] = 0.15 - height;
        g.drawRectBaseRatio(start, end);
        start[0] = 1.14;
        double log = Math.log10(Math.abs(this.max));
        int decimal = 1;
        if (log < 0.0) {
            decimal = (int)(-log) + 1;
        }
        g.drawTextBaseRatio(String.valueOf(Math.round(this.max, decimal)), 0.0, 1.0, start);
        start[1] = 0.15 - height;
        log = Math.log10(Math.abs(this.min));
        decimal = 1;
        if (log < 0.0) {
            decimal = (int)(-log) + 1;
        }
        g.drawTextBaseRatio(String.valueOf(Math.round(this.min, decimal)), 0.0, 0.0, start);
        g.setColor(c);
    }

    public static PlotCanvas plot(double[][] z) {
        double[] lowerBound = new double[]{0.0, 0.0};
        double[] upperBound = new double[]{z[0].length, z.length};
        PlotCanvas canvas = new PlotCanvas(lowerBound, upperBound, false);
        canvas.add(new Heatmap(z));
        canvas.getAxis(0).setFrameVisible(false);
        canvas.getAxis(0).setLabelVisible(false);
        canvas.getAxis(0).setGridVisible(false);
        canvas.getAxis(1).setFrameVisible(false);
        canvas.getAxis(1).setLabelVisible(false);
        canvas.getAxis(1).setGridVisible(false);
        return canvas;
    }

    public static PlotCanvas plot(double[][] z, Color[] palette) {
        double[] lowerBound = new double[]{0.0, 0.0};
        double[] upperBound = new double[]{z[0].length, z.length};
        PlotCanvas canvas = new PlotCanvas(lowerBound, upperBound, false);
        canvas.add(new Heatmap(z, palette));
        canvas.getAxis(0).setFrameVisible(false);
        canvas.getAxis(0).setLabelVisible(false);
        canvas.getAxis(0).setGridVisible(false);
        canvas.getAxis(1).setFrameVisible(false);
        canvas.getAxis(1).setLabelVisible(false);
        canvas.getAxis(1).setGridVisible(false);
        return canvas;
    }

    public static PlotCanvas plot(double[] x, double[] y, double[][] z) {
        double[] lowerBound = new double[]{Math.min(x), Math.min(y)};
        double[] upperBound = new double[]{Math.max(x), Math.max(y)};
        PlotCanvas canvas = new PlotCanvas(lowerBound, upperBound, false);
        canvas.add(new Heatmap(x, y, z));
        canvas.getAxis(0).setGridVisible(false);
        canvas.getAxis(1).setGridVisible(false);
        return canvas;
    }

    public static PlotCanvas plot(double[] x, double[] y, double[][] z, Color[] palette) {
        double[] lowerBound = new double[]{Math.min(x), Math.min(y)};
        double[] upperBound = new double[]{Math.max(x), Math.max(y)};
        PlotCanvas canvas = new PlotCanvas(lowerBound, upperBound, false);
        canvas.add(new Heatmap(x, y, z, palette));
        canvas.getAxis(0).setGridVisible(false);
        canvas.getAxis(1).setGridVisible(false);
        return canvas;
    }

    public static PlotCanvas plot(String[] rowLabels, String[] columnLabels, double[][] z) {
        int i;
        double[] locations;
        if (z.length != rowLabels.length || z[0].length != columnLabels.length) {
            throw new IllegalArgumentException("Data size and label size don't match.");
        }
        double[] lowerBound = new double[]{0.0, 0.0};
        double[] upperBound = new double[]{z[0].length, z.length};
        PlotCanvas canvas = new PlotCanvas(lowerBound, upperBound, false);
        canvas.add(new Heatmap(rowLabels, columnLabels, z));
        canvas.getAxis(0).setFrameVisible(false);
        canvas.getAxis(0).setGridVisible(false);
        canvas.getAxis(0).setRotation(-1.5707963267948966);
        canvas.getAxis(1).setFrameVisible(false);
        canvas.getAxis(1).setGridVisible(false);
        if (rowLabels != null) {
            locations = new double[rowLabels.length];
            for (i = 0; i < rowLabels.length; ++i) {
                locations[i] = (double)(z.length - i) - 0.5;
            }
            canvas.getAxis(1).addLabel(rowLabels, locations);
        }
        if (columnLabels != null) {
            locations = new double[columnLabels.length];
            for (i = 0; i < columnLabels.length; ++i) {
                locations[i] = (double)i + 0.5;
            }
            canvas.getAxis(0).addLabel(columnLabels, locations);
        }
        return canvas;
    }

    public static PlotCanvas plot(String[] rowLabels, String[] columnLabels, double[][] z, Color[] palette) {
        int i;
        double[] locations;
        if (z.length != rowLabels.length || z[0].length != columnLabels.length) {
            throw new IllegalArgumentException("Data size and label size don't match.");
        }
        double[] lowerBound = new double[]{0.0, 0.0};
        double[] upperBound = new double[]{z[0].length, z.length};
        PlotCanvas canvas = new PlotCanvas(lowerBound, upperBound, false);
        canvas.add(new Heatmap(rowLabels, columnLabels, z, palette));
        canvas.getAxis(0).setFrameVisible(false);
        canvas.getAxis(0).setGridVisible(false);
        canvas.getAxis(0).setRotation(-1.5707963267948966);
        canvas.getAxis(1).setFrameVisible(false);
        canvas.getAxis(1).setGridVisible(false);
        if (rowLabels != null) {
            locations = new double[rowLabels.length];
            for (i = 0; i < rowLabels.length; ++i) {
                locations[i] = (double)(z.length - i) - 0.5;
            }
            canvas.getAxis(1).addLabel(rowLabels, locations);
        }
        if (columnLabels != null) {
            locations = new double[columnLabels.length];
            for (i = 0; i < columnLabels.length; ++i) {
                locations[i] = (double)i + 0.5;
            }
            canvas.getAxis(0).addLabel(columnLabels, locations);
        }
        return canvas;
    }
}

