/*
 * Decompiled with CFR 0.152.
 */
package smile.mds;

import java.util.Arrays;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import smile.math.Math;
import smile.mds.MDS;

public class SammonMapping {
    private static final Logger logger = LoggerFactory.getLogger(SammonMapping.class);
    private double stress;
    private double[][] coordinates;

    public double getStress() {
        return this.stress;
    }

    public double[][] getCoordinates() {
        return this.coordinates;
    }

    public SammonMapping(double[][] proximity) {
        this(proximity, 2);
    }

    public SammonMapping(double[][] proximity, int k) {
        this(proximity, k, 0.2, 1.0E-4, 100);
    }

    public SammonMapping(double[][] proximity, double[][] coordinates) {
        this(proximity, coordinates, 0.2, 1.0E-4, 100);
    }

    public SammonMapping(double[][] proximity, int k, double lambda, double tol, int maxIter) {
        this(proximity, new MDS(proximity, k).getCoordinates(), lambda, tol, maxIter);
    }

    public SammonMapping(double[][] proximity, double[][] init, double lambda, double tol, int maxIter) {
        if (proximity.length != proximity[0].length) {
            throw new IllegalArgumentException("The proximity matrix is not square.");
        }
        if (proximity.length != init.length) {
            throw new IllegalArgumentException("The proximity matrix and the initial coordinates are of different size.");
        }
        if (tol <= 0.0) {
            throw new IllegalArgumentException("Invalid tolerance: " + tol);
        }
        if (maxIter <= 0) {
            throw new IllegalArgumentException("Invalid maximum number of iterations: " + maxIter);
        }
        int m = proximity.length;
        int n = proximity[0].length;
        if (m != n) {
            throw new IllegalArgumentException("The proximity matrix is not square.");
        }
        this.coordinates = Math.clone(init);
        double c = 0.0;
        for (int i = 0; i < n; ++i) {
            for (int j = i + 1; j < n; ++j) {
                c += proximity[i][j];
            }
        }
        int k = this.coordinates[0].length;
        double[][] xu = new double[n][k];
        this.stress = 0.0;
        for (int i = 0; i < n; ++i) {
            for (int j = i + 1; j < n; ++j) {
                double dij = proximity[i][j];
                if (dij == 0.0) {
                    dij = 1.0E-10;
                }
                double rij = Math.distance(this.coordinates[i], this.coordinates[j]);
                this.stress += Math.sqr(dij - rij) / dij;
            }
        }
        this.stress /= c;
        double epast = this.stress;
        double eprev = this.stress;
        logger.info(String.format("Sammon's Mapping initial stress: %.5f", this.stress));
        double[] xv = new double[k];
        double[] e1 = new double[k];
        double[] e2 = new double[k];
        for (int iter = 1; iter <= maxIter; ++iter) {
            int i;
            for (i = 0; i < n; ++i) {
                double[] ri = this.coordinates[i];
                Arrays.fill(e1, 0.0);
                Arrays.fill(e2, 0.0);
                for (int j = 0; j < n; ++j) {
                    if (i == j) continue;
                    double[] rj = this.coordinates[j];
                    double dij = proximity[i][j];
                    if (dij == 0.0) {
                        dij = 1.0E-10;
                    }
                    double rij = 0.0;
                    for (int l = 0; l < k; ++l) {
                        double xd = ri[l] - rj[l];
                        rij += xd * xd;
                        xv[l] = xd;
                    }
                    if ((rij = Math.sqrt(rij)) == 0.0) {
                        rij = 1.0E-10;
                    }
                    double dq = dij - rij;
                    double dr = dij * rij;
                    for (int l = 0; l < k; ++l) {
                        int n2 = l;
                        e1[n2] = e1[n2] + xv[l] * dq / dr;
                        int n3 = l;
                        e2[n3] = e2[n3] + (dq - xv[l] * xv[l] * (1.0 + dq / rij) / rij) / dr;
                    }
                }
                for (int l = 0; l < k; ++l) {
                    xu[i][l] = ri[l] + lambda * e1[l] / Math.abs(e2[l]);
                }
            }
            this.stress = 0.0;
            for (i = 0; i < n; ++i) {
                for (int j = i + 1; j < n; ++j) {
                    double dij = proximity[i][j];
                    if (dij == 0.0) {
                        dij = 1.0E-10;
                    }
                    double rij = Math.distance(xu[i], xu[j]);
                    this.stress += Math.sqr(dij - rij) / dij;
                }
            }
            this.stress /= c;
            if (this.stress > eprev) {
                this.stress = eprev;
                if ((lambda *= 0.2) < 0.001) {
                    logger.info(String.format("Sammon's Mapping stress after %3d iterations: %.5f", iter - 1, this.stress));
                    break;
                }
                --iter;
                continue;
            }
            if ((lambda *= 1.5) > 0.5) {
                lambda = 0.5;
            }
            eprev = this.stress;
            double[] mu = Math.colMean(xu);
            for (int i2 = 0; i2 < n; ++i2) {
                for (int j = 0; j < k; ++j) {
                    this.coordinates[i2][j] = xu[i2][j] - mu[j];
                }
            }
            if (iter % 10 != 0) continue;
            logger.info(String.format("Sammon's Mapping stress after %3d iterations: %.5f, magic = %5.3f", iter, this.stress, lambda));
            if (this.stress > epast - tol) break;
            epast = this.stress;
        }
    }
}

