/*
 * Decompiled with CFR 0.152.
 */
package smile.math.matrix;

import smile.math.Math;
import smile.math.matrix.CholeskyDecomposition;

public class QRDecomposition {
    private double[][] QR;
    private double[] Rdiagonal;
    private boolean singular;

    public QRDecomposition(double[][] A) {
        this(A, false);
    }

    public QRDecomposition(double[][] A, boolean overwrite) {
        int m = A.length;
        int n = A[0].length;
        this.Rdiagonal = new double[n];
        this.QR = A;
        if (!overwrite) {
            this.QR = new double[m][n];
            for (int i = 0; i < m; ++i) {
                System.arraycopy(A[i], 0, this.QR[i], 0, n);
            }
        }
        for (int k = 0; k < n; ++k) {
            int i;
            double nrm = 0.0;
            for (i = k; i < m; ++i) {
                nrm = Math.hypot(nrm, this.QR[i][k]);
            }
            if (nrm != 0.0) {
                if (this.QR[k][k] < 0.0) {
                    nrm = -nrm;
                }
                for (i = k; i < m; ++i) {
                    double[] dArray = this.QR[i];
                    int n2 = k;
                    dArray[n2] = dArray[n2] / nrm;
                }
                double[] dArray = this.QR[k];
                int n3 = k;
                dArray[n3] = dArray[n3] + 1.0;
                for (int j = k + 1; j < n; ++j) {
                    int i2;
                    double s = 0.0;
                    for (i2 = k; i2 < m; ++i2) {
                        s += this.QR[i2][k] * this.QR[i2][j];
                    }
                    s = -s / this.QR[k][k];
                    for (i2 = k; i2 < m; ++i2) {
                        double[] dArray2 = this.QR[i2];
                        int n4 = j;
                        dArray2[n4] = dArray2[n4] + s * this.QR[i2][k];
                    }
                }
            }
            this.Rdiagonal[k] = -nrm;
        }
        this.singular = false;
        for (int j = 0; j < this.Rdiagonal.length; ++j) {
            if (this.Rdiagonal[j] != 0.0) continue;
            this.singular = true;
            break;
        }
    }

    public boolean isFullColumnRank() {
        return !this.singular;
    }

    public boolean isSingular() {
        return this.singular;
    }

    public double[][] getH() {
        int m = this.QR.length;
        int n = this.QR[0].length;
        double[][] H = new double[m][n];
        for (int i = 0; i < m; ++i) {
            for (int j = 0; j < n; ++j) {
                H[i][j] = i >= j ? this.QR[i][j] : 0.0;
            }
        }
        return H;
    }

    public CholeskyDecomposition toCholesky() {
        int n = this.QR[0].length;
        double[][] L = new double[n][];
        for (int i = 0; i < n; ++i) {
            L[i] = new double[i + 1];
            L[i][i] = this.Rdiagonal[i];
            for (int j = 0; j < i; ++j) {
                L[i][j] = this.QR[j][i];
            }
        }
        return CholeskyDecomposition.newInstance(L);
    }

    public double[][] getR() {
        int m = this.QR.length;
        int n = this.QR[0].length;
        double[][] R = new double[m][n];
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n; ++j) {
                R[i][j] = i < j ? this.QR[i][j] : (i == j ? this.Rdiagonal[i] : 0.0);
            }
        }
        return R;
    }

    public double[][] getQ() {
        int m = this.QR.length;
        int n = this.QR[0].length;
        double[][] Q = new double[m][n];
        for (int k = n - 1; k >= 0; --k) {
            for (int i = 0; i < m; ++i) {
                Q[i][k] = 0.0;
            }
            Q[k][k] = 1.0;
            for (int j = k; j < n; ++j) {
                int i;
                if (this.QR[k][k] == 0.0) continue;
                double s = 0.0;
                for (i = k; i < m; ++i) {
                    s += this.QR[i][k] * Q[i][j];
                }
                s = -s / this.QR[k][k];
                for (i = k; i < m; ++i) {
                    double[] dArray = Q[i];
                    int n2 = j;
                    dArray[n2] = dArray[n2] + s * this.QR[i][k];
                }
            }
        }
        return Q;
    }

    public double[][] inverse() {
        double[][] I = Math.eye(this.QR[0].length, this.QR.length);
        this.solve(I);
        return I;
    }

    public void solve(double[] b) {
        if (this.QR.length != this.QR[0].length) {
            throw new UnsupportedOperationException("In-place solver supports only square matrix.");
        }
        this.solve(b, b);
    }

    public void solve(double[] b, double[] x) {
        int k;
        int m = this.QR.length;
        int n = this.QR[0].length;
        if (b.length != m) {
            throw new IllegalArgumentException(String.format("Row dimensions do not agree: A is %d x %d, but b is %d x 1", this.QR.length, this.QR[0].length, b.length));
        }
        if (x.length != n) {
            throw new IllegalArgumentException("A and x dimensions do not agree.");
        }
        if (!this.isFullColumnRank()) {
            throw new RuntimeException("Matrix is rank deficient.");
        }
        double[] y = b;
        if (b != x) {
            y = (double[])b.clone();
        }
        for (k = 0; k < n; ++k) {
            int i;
            double s = 0.0;
            for (i = k; i < m; ++i) {
                s += this.QR[i][k] * y[i];
            }
            s = -s / this.QR[k][k];
            for (i = k; i < m; ++i) {
                int n2 = i;
                y[n2] = y[n2] + s * this.QR[i][k];
            }
        }
        for (k = n - 1; k >= 0; --k) {
            x[k] = y[k] / this.Rdiagonal[k];
            for (int i = 0; i < k; ++i) {
                int n3 = i;
                y[n3] = y[n3] - x[k] * this.QR[i][k];
            }
        }
    }

    public void solve(double[][] B) {
        if (this.QR.length != this.QR[0].length) {
            throw new UnsupportedOperationException("In-place solver supports only square matrix.");
        }
        this.solve(B, B);
    }

    public void solve(double[][] B, double[][] X) {
        int j;
        int k;
        if (B.length != this.QR.length) {
            throw new IllegalArgumentException(String.format("Row dimensions do not agree: A is %d x %d, but B is %d x %d", this.QR.length, this.QR.length, B.length, B[0].length));
        }
        if (X.length != this.QR[0].length) {
            throw new IllegalArgumentException(String.format("Row dimensions do not agree: A is %d x %d, but X is %d x %d", this.QR.length, this.QR.length, X.length, X[0].length));
        }
        if (B[0].length != X[0].length) {
            throw new IllegalArgumentException(String.format("B and X column dimension do not agree: B is %d x %d, but X is %d x %d", B.length, B[0].length, X.length, X[0].length));
        }
        if (!this.isFullColumnRank()) {
            throw new RuntimeException("Matrix is rank deficient.");
        }
        if (X[0].length != B[0].length) {
            throw new IllegalArgumentException("B and X dimensions do not agree.");
        }
        int m = this.QR.length;
        int n = this.QR[0].length;
        int nx = B[0].length;
        double[][] Y = B;
        if (B != X) {
            Y = Math.clone(B);
        }
        for (k = 0; k < n; ++k) {
            for (j = 0; j < nx; ++j) {
                int i;
                double s = 0.0;
                for (i = k; i < m; ++i) {
                    s += this.QR[i][k] * Y[i][j];
                }
                s = -s / this.QR[k][k];
                for (i = k; i < m; ++i) {
                    double[] dArray = Y[i];
                    int n2 = j;
                    dArray[n2] = dArray[n2] + s * this.QR[i][k];
                }
            }
        }
        for (k = n - 1; k >= 0; --k) {
            for (j = 0; j < nx; ++j) {
                X[k][j] = Y[k][j] / this.Rdiagonal[k];
            }
            for (int i = 0; i < k; ++i) {
                for (int j2 = 0; j2 < nx; ++j2) {
                    double[] dArray = Y[i];
                    int n3 = j2;
                    dArray[n3] = dArray[n3] - X[k][j2] * this.QR[i][k];
                }
            }
        }
    }

    public void update(double[] u, double[] v) {
        int i;
        int k;
        int m = this.QR.length;
        int n = this.QR[0].length;
        if (u.length != m || v.length != n) {
            throw new IllegalArgumentException("u.length = " + u.length + " v.length = " + v.length);
        }
        for (k = m - 1; k >= 0 && u[k] == 0.0; --k) {
        }
        if (k < 0) {
            return;
        }
        for (i = k - 1; i >= 0; --i) {
            this.rotate(i, u[i], -u[i + 1]);
            u[i] = u[i] == 0.0 ? Math.abs(u[i + 1]) : (Math.abs(u[i]) > Math.abs(u[i + 1]) ? Math.abs(u[i]) * Math.sqrt(1.0 + Math.sqr(u[i + 1] / u[i])) : Math.abs(u[i + 1]) * Math.sqrt(1.0 + Math.sqr(u[i] / u[i + 1])));
        }
        this.Rdiagonal[0] = this.Rdiagonal[0] + u[0] * v[0];
        for (i = 1; i < n; ++i) {
            double[] dArray = this.QR[0];
            int n2 = i;
            dArray[n2] = dArray[n2] + u[0] * v[i];
        }
        for (i = 0; i < k; ++i) {
            this.rotate(i, this.Rdiagonal[i], -this.QR[i + 1][i]);
        }
        for (i = 0; i < n; ++i) {
            if (this.Rdiagonal[i] != 0.0) continue;
            this.singular = true;
        }
    }

    private void rotate(int i, double a, double b) {
        double w;
        double y;
        int j;
        double fact;
        double s;
        double c;
        int n = this.QR[0].length;
        if (a == 0.0) {
            c = 0.0;
            s = b >= 0.0 ? 1.0 : -1.0;
        } else if (Math.abs(a) > Math.abs(b)) {
            fact = b / a;
            c = Math.copySign(1.0 / Math.sqrt(1.0 + fact * fact), a);
            s = fact * c;
        } else {
            fact = a / b;
            s = Math.copySign(1.0 / Math.sqrt(1.0 + fact * fact), b);
            c = fact * s;
        }
        for (j = i; j < n; ++j) {
            y = i == j ? this.Rdiagonal[i] : this.QR[i][j];
            w = this.QR[i + 1][j];
            this.QR[i][j] = c * y - s * w;
            this.QR[i + 1][j] = s * y + c * w;
        }
        for (j = 0; j < n; ++j) {
            y = this.QR[i][j];
            w = this.QR[i + 1][j];
            this.QR[i][j] = c * y - s * w;
            this.QR[i + 1][j] = s * y + c * w;
        }
    }
}

