/*
 * Decompiled with CFR 0.152.
 */
package smile.math.matrix;

import java.util.Arrays;
import smile.math.Math;
import smile.math.matrix.CholeskyDecomposition;
import smile.math.matrix.EigenValueDecomposition;
import smile.math.matrix.IMatrix;
import smile.math.matrix.LUDecomposition;
import smile.math.matrix.QRDecomposition;
import smile.math.matrix.SingularValueDecomposition;
import smile.stat.distribution.GaussianDistribution;

public class Matrix
implements IMatrix {
    private double[][] A;
    private boolean symmetric = false;
    private boolean positive = false;
    private CholeskyDecomposition cholesky;
    private LUDecomposition lu;
    private QRDecomposition qr;
    private SingularValueDecomposition svd;
    private EigenValueDecomposition eigen;
    private double det;
    private int rank;

    public Matrix(double[][] A) {
        this.A = A;
    }

    public Matrix(double[][] A, boolean symmetric) {
        if (symmetric && A.length != A[0].length) {
            throw new IllegalArgumentException("A is not square");
        }
        this.A = A;
        this.symmetric = symmetric;
    }

    public Matrix(double[][] A, boolean symmetric, boolean positive) {
        if (symmetric && A.length != A[0].length) {
            throw new IllegalArgumentException("A is not square");
        }
        this.A = A;
        this.symmetric = symmetric;
        this.positive = positive;
    }

    public Matrix(int rows, int cols) {
        this.A = new double[rows][cols];
    }

    public Matrix(int rows, int cols, double value) {
        this.A = new double[rows][cols];
        for (int i = 0; i < rows; ++i) {
            Arrays.fill(this.A[i], value);
        }
    }

    public Matrix(int rows, int cols, double mu, double sigma) {
        GaussianDistribution g = new GaussianDistribution(mu, sigma);
        for (int i = 0; i < rows; ++i) {
            for (int j = 0; j < cols; ++j) {
                this.A[i][j] = g.rand();
            }
        }
    }

    public double[][] array() {
        return this.A;
    }

    public void setDiag(double[] diag) {
        for (int i = 0; i < this.ncols() && i < this.nrows() && i < diag.length; ++i) {
            this.set(i, i, diag[i]);
        }
    }

    @Override
    public int nrows() {
        return this.A.length;
    }

    @Override
    public int ncols() {
        return this.A[0].length;
    }

    @Override
    public double get(int i, int j) {
        return this.A[i][j];
    }

    @Override
    public Matrix set(int i, int j, double x) {
        this.A[i][j] = x;
        return this;
    }

    @Override
    public void ax(double[] x, double[] y) {
        Math.ax(this.A, x, y);
    }

    @Override
    public void axpy(double[] x, double[] y) {
        Math.axpy(this.A, x, y);
    }

    @Override
    public void axpy(double[] x, double[] y, double b) {
        Math.axpy(this.A, x, y, b);
    }

    @Override
    public void atx(double[] x, double[] y) {
        Math.atx(this.A, x, y);
    }

    @Override
    public void atxpy(double[] x, double[] y) {
        Math.atxpy(this.A, x, y);
    }

    @Override
    public void atxpy(double[] x, double[] y, double b) {
        Math.atxpy(this.A, x, y, b);
    }

    @Override
    public void asolve(double[] b, double[] x) {
        int m = this.A.length;
        int n = this.A[0].length;
        if (m != n) {
            throw new IllegalStateException("Matrix is not square.");
        }
        for (int i = 0; i < n; ++i) {
            x[i] = this.A[i][i] != 0.0 ? b[i] / this.A[i][i] : b[i];
        }
    }

    public Matrix add(Matrix b) {
        if (this.nrows() != b.nrows() || this.ncols() != b.ncols()) {
            throw new IllegalArgumentException("Matrix is not of same size.");
        }
        int m = this.A.length;
        int n = this.A[0].length;
        for (int i = 0; i < m; ++i) {
            for (int j = 0; j < n; ++j) {
                double[] dArray = this.A[i];
                int n2 = j;
                dArray[n2] = dArray[n2] + b.A[i][j];
            }
        }
        return this;
    }

    public Matrix scale(double x) {
        int m = this.A.length;
        int n = this.A[0].length;
        for (int i = 0; i < m; ++i) {
            int j = 0;
            while (j < n) {
                double[] dArray = this.A[i];
                int n2 = j++;
                dArray[n2] = dArray[n2] * x;
            }
        }
        return this;
    }

    public Matrix divide(double x) {
        int m = this.A.length;
        int n = this.A[0].length;
        for (int i = 0; i < m; ++i) {
            int j = 0;
            while (j < n) {
                double[] dArray = this.A[i];
                int n2 = j++;
                dArray[n2] = dArray[n2] / x;
            }
        }
        return this;
    }

    public Matrix replaceNaN(double x) {
        int m = this.A.length;
        int n = this.A[0].length;
        for (int i = 0; i < m; ++i) {
            for (int j = 0; j < n; ++j) {
                if (!Double.isNaN(this.A[i][j])) continue;
                this.A[i][j] = x;
            }
        }
        return this;
    }

    public double sum() {
        double s = 0.0;
        int m = this.A.length;
        int n = this.A[0].length;
        for (int i = 0; i < m; ++i) {
            for (int j = 0; j < n; ++j) {
                s += this.A[i][j];
            }
        }
        return s;
    }

    public Matrix transpose() {
        int m = this.A.length;
        int n = this.A[0].length;
        double[][] B = new double[n][m];
        for (int i = 0; i < m; ++i) {
            for (int j = 0; j < n; ++j) {
                B[j][i] = this.A[i][j];
            }
        }
        return new Matrix(B);
    }

    public double[][] inverse() {
        return this.solve(Math.eye(this.ncols(), this.nrows()));
    }

    public double trace() {
        int n = Math.min(this.A.length, this.A[0].length);
        double t = 0.0;
        for (int i = 0; i < n; ++i) {
            t += this.A[i][i];
        }
        return t;
    }

    public double det() {
        if (this.A.length != this.A[0].length) {
            throw new IllegalArgumentException(String.format("Matrix is not square: %d x %d", this.A.length, this.A[0].length));
        }
        if (this.symmetric && this.positive) {
            if (this.cholesky == null) {
                this.cholesky();
            }
        } else if (this.lu == null) {
            this.lu();
        }
        return this.det;
    }

    public int rank() {
        this.svd();
        return this.rank;
    }

    public double eigen(double[] v) {
        if (this.nrows() != this.ncols()) {
            throw new UnsupportedOperationException("The matrix is not square.");
        }
        return EigenValueDecomposition.eigen(this, v);
    }

    public EigenValueDecomposition eigen() {
        if (this.nrows() != this.ncols()) {
            throw new UnsupportedOperationException("The matrix is not square.");
        }
        int n = this.A.length;
        if (this.eigen == null || this.eigen.getEigenVectors().length != n) {
            int i;
            double[][] V = new double[n][n];
            for (i = 0; i < n; ++i) {
                System.arraycopy(this.A[i], 0, V[i], 0, n);
            }
            this.eigen = EigenValueDecomposition.decompose(V, this.symmetric);
            this.positive = true;
            for (i = 0; i < n; ++i) {
                if (!(this.eigen.getEigenValues()[i] <= 0.0)) continue;
                this.positive = false;
                break;
            }
        }
        return this.eigen;
    }

    public EigenValueDecomposition eigen(int k) {
        if (this.nrows() != this.ncols()) {
            throw new UnsupportedOperationException("The matrix is not square.");
        }
        if (!this.symmetric) {
            throw new UnsupportedOperationException("The current implementation of eigen value decomposition only works for symmetric matrices");
        }
        if (this.eigen == null || this.eigen.getEigenVectors().length != k) {
            this.eigen = EigenValueDecomposition.decompose(this, k);
        }
        return this.eigen;
    }

    public SingularValueDecomposition svd() {
        if (this.svd == null) {
            int m = this.A.length;
            int n = this.A[0].length;
            double[][] V = new double[m][n];
            for (int i = 0; i < m; ++i) {
                System.arraycopy(this.A[i], 0, V[i], 0, n);
            }
            this.svd = SingularValueDecomposition.decompose(V);
            this.rank = this.svd.rank();
        }
        return this.svd;
    }

    public LUDecomposition lu() {
        if (this.nrows() != this.ncols()) {
            throw new UnsupportedOperationException("The matrix is not square.");
        }
        if (this.lu == null) {
            this.lu = new LUDecomposition(this.A);
            this.det = this.lu.det();
        }
        return this.lu;
    }

    public CholeskyDecomposition cholesky() {
        if (this.nrows() != this.ncols()) {
            throw new UnsupportedOperationException("The matrix is not square.");
        }
        if (!this.symmetric || !this.positive) {
            throw new UnsupportedOperationException("The matrix is not symmetric positive definite.");
        }
        if (this.cholesky == null) {
            this.cholesky = new CholeskyDecomposition(this.A);
            this.det = this.cholesky.det();
        }
        return this.cholesky;
    }

    public QRDecomposition qr() {
        if (this.qr == null) {
            this.qr = new QRDecomposition(this.A);
        }
        return this.qr;
    }

    public double[] solve(double[] b) {
        if (this.A.length == this.A[0].length) {
            if (this.symmetric && this.positive) {
                this.cholesky().solve(b);
            } else {
                this.lu().solve(b);
            }
        } else {
            this.qr().solve(b);
        }
        return b;
    }

    public double[][] solve(double[][] B) {
        if (this.A.length == this.A[0].length) {
            if (this.symmetric && this.positive) {
                this.cholesky().solve(B);
            } else {
                this.lu().solve(B);
            }
        } else {
            this.qr().solve(B);
        }
        return B;
    }

    public void improve(double[] b, double[] x) {
        int n = this.A.length;
        if (this.A.length != this.A[0].length) {
            throw new IllegalStateException("A is not square.");
        }
        if (x.length != n || b.length != n) {
            throw new IllegalArgumentException(String.format("Row dimensions do not agree: A is %d x %d, but b is %d x 1 and x is %d x 1", this.A.length, this.A[0].length, b.length, x.length));
        }
        if (this.symmetric && this.positive) {
            int i;
            double[] r = new double[n];
            for (i = 0; i < n; ++i) {
                double sdp = -b[i];
                for (int j = 0; j < n; ++j) {
                    sdp += this.A[i][j] * x[j];
                }
                r[i] = sdp;
            }
            this.cholesky.solve(r);
            for (i = 0; i < n; ++i) {
                int n2 = i;
                x[n2] = x[n2] - r[i];
            }
        } else {
            int i;
            double[] r = new double[n];
            for (i = 0; i < n; ++i) {
                double sdp = -b[i];
                for (int j = 0; j < n; ++j) {
                    sdp += this.A[i][j] * x[j];
                }
                r[i] = sdp;
            }
            this.lu.solve(r);
            for (i = 0; i < n; ++i) {
                int n3 = i;
                x[n3] = x[n3] - r[i];
            }
        }
    }
}

