/*
 * Decompiled with CFR 0.152.
 */
package smile.math.matrix;

import smile.math.Math;

public class LUDecomposition {
    private double[][] LU;
    private int pivsign;
    private int[] piv;

    public LUDecomposition(double[][] A) {
        this(A, false);
    }

    public LUDecomposition(double[][] A, boolean overwrite) {
        int i;
        int m = A.length;
        int n = A[0].length;
        this.LU = A;
        if (!overwrite) {
            this.LU = new double[m][n];
            for (i = 0; i < m; ++i) {
                System.arraycopy(A[i], 0, this.LU[i], 0, n);
            }
        }
        this.piv = new int[m];
        for (i = 0; i < m; ++i) {
            this.piv[i] = i;
        }
        this.pivsign = 1;
        double[] LUcolj = new double[m];
        for (int j = 0; j < n; ++j) {
            int i2;
            int i3;
            for (i3 = 0; i3 < m; ++i3) {
                LUcolj[i3] = this.LU[i3][j];
            }
            i3 = 0;
            while (i3 < m) {
                double[] LUrowi = this.LU[i3];
                int kmax = Math.min(i3, j);
                double s = 0.0;
                for (int k = 0; k < kmax; ++k) {
                    s += LUrowi[k] * LUcolj[k];
                }
                int n2 = i3++;
                double d = LUcolj[n2] - s;
                LUcolj[n2] = d;
                LUrowi[j] = d;
            }
            int p = j;
            for (i2 = j + 1; i2 < m; ++i2) {
                if (!(Math.abs(LUcolj[i2]) > Math.abs(LUcolj[p]))) continue;
                p = i2;
            }
            if (p != j) {
                int k;
                for (k = 0; k < n; ++k) {
                    double t = this.LU[p][k];
                    this.LU[p][k] = this.LU[j][k];
                    this.LU[j][k] = t;
                }
                k = this.piv[p];
                this.piv[p] = this.piv[j];
                this.piv[j] = k;
                this.pivsign = -this.pivsign;
            }
            if (!(j < m & this.LU[j][j] != 0.0)) continue;
            for (i2 = j + 1; i2 < m; ++i2) {
                double[] dArray = this.LU[i2];
                int n3 = j;
                dArray[n3] = dArray[n3] / this.LU[j][j];
            }
        }
    }

    public boolean isSingular() {
        int n = this.LU[0].length;
        for (int j = 0; j < n; ++j) {
            if (this.LU[j][j] != 0.0) continue;
            return true;
        }
        return false;
    }

    public double[][] getL() {
        int m = this.LU.length;
        int n = this.LU[0].length;
        double[][] L = new double[m][n];
        for (int i = 0; i < m; ++i) {
            for (int j = 0; j < n; ++j) {
                L[i][j] = i > j ? this.LU[i][j] : (i == j ? 1.0 : 0.0);
            }
        }
        return L;
    }

    public double[][] getU() {
        int m = this.LU.length;
        int n = this.LU[0].length;
        double[][] U = new double[m][n];
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n; ++j) {
                U[i][j] = i <= j ? this.LU[i][j] : 0.0;
            }
        }
        return U;
    }

    public int[] getPivot() {
        return this.piv;
    }

    public double det() {
        int m = this.LU.length;
        int n = this.LU[0].length;
        if (m != n) {
            throw new IllegalArgumentException(String.format("Matrix is not square: %d x %d", m, n));
        }
        double d = this.pivsign;
        for (int j = 0; j < n; ++j) {
            d *= this.LU[j][j];
        }
        return d;
    }

    public double[][] inverse() {
        int m = this.LU.length;
        int n = this.LU[0].length;
        if (m != n) {
            throw new IllegalArgumentException(String.format("Matrix is not square: %d x %d", m, n));
        }
        double[][] I = Math.eye(n);
        this.solve(I);
        return I;
    }

    public void solve(double[] b) {
        this.solve((double[])b.clone(), b);
    }

    public void solve(double[] b, double[] x) {
        int i;
        int k;
        int m = this.LU.length;
        int n = this.LU[0].length;
        if (m != n) {
            throw new UnsupportedOperationException("The matrix is not square.");
        }
        if (b.length != m) {
            throw new IllegalArgumentException(String.format("Row dimensions do not agree: A is %d x %d, but b is %d x 1", this.LU.length, this.LU[0].length, b.length));
        }
        if (b.length != x.length) {
            throw new IllegalArgumentException("b and x dimensions do not agree.");
        }
        if (this.isSingular()) {
            throw new RuntimeException("Matrix is singular.");
        }
        for (int i2 = 0; i2 < m; ++i2) {
            x[i2] = b[this.piv[i2]];
        }
        for (k = 0; k < n; ++k) {
            for (i = k + 1; i < n; ++i) {
                int n2 = i;
                x[n2] = x[n2] - x[k] * this.LU[i][k];
            }
        }
        for (k = n - 1; k >= 0; --k) {
            int n3 = k;
            x[n3] = x[n3] / this.LU[k][k];
            for (i = 0; i < k; ++i) {
                int n4 = i;
                x[n4] = x[n4] - x[k] * this.LU[i][k];
            }
        }
    }

    public void solve(double[][] B) {
        this.solve(B, B);
    }

    public void solve(double[][] B, double[][] X) {
        int j;
        int k;
        int i;
        int m = this.LU.length;
        int n = this.LU[0].length;
        if (B.length != m) {
            throw new IllegalArgumentException(String.format("Row dimensions do not agree: A is %d x %d, but B is %d x %d", this.LU.length, this.LU[0].length, B.length, B[0].length));
        }
        if (this.isSingular()) {
            throw new RuntimeException("Matrix is singular.");
        }
        if (X.length != B.length || X[0].length != B[0].length) {
            throw new IllegalArgumentException("B and X dimensions do not agree.");
        }
        int nx = B[0].length;
        if (X == B) {
            double[][] x = new double[m][];
            for (i = 0; i < m; ++i) {
                x[i] = B[this.piv[i]];
            }
            System.arraycopy(x, 0, X, 0, m);
        } else {
            for (int i2 = 0; i2 < m; ++i2) {
                System.arraycopy(B[this.piv[i2]], 0, X[i2], 0, nx);
            }
        }
        for (k = 0; k < n; ++k) {
            for (i = k + 1; i < n; ++i) {
                for (j = 0; j < nx; ++j) {
                    double[] dArray = X[i];
                    int n2 = j;
                    dArray[n2] = dArray[n2] - X[k][j] * this.LU[i][k];
                }
            }
        }
        for (k = n - 1; k >= 0; --k) {
            int j2 = 0;
            while (j2 < nx) {
                double[] dArray = X[k];
                int n3 = j2++;
                dArray[n3] = dArray[n3] / this.LU[k][k];
            }
            for (i = 0; i < k; ++i) {
                for (j = 0; j < nx; ++j) {
                    double[] dArray = X[i];
                    int n4 = j;
                    dArray[n4] = dArray[n4] - X[k][j] * this.LU[i][k];
                }
            }
        }
    }
}

