/*
 * Decompiled with CFR 0.152.
 */
package smile.feature;

import smile.data.Attribute;
import smile.data.NominalAttribute;

public class Nominal2SparseBinary {
    private NominalAttribute[] attributes;
    private int[] base;

    public Nominal2SparseBinary(Attribute[] attributes) {
        int p = attributes.length;
        this.attributes = new NominalAttribute[p];
        this.base = new int[p];
        for (int i = 0; i < p; ++i) {
            Attribute attribute = attributes[i];
            if (attribute instanceof NominalAttribute) {
                NominalAttribute nominal;
                this.attributes[i] = nominal = (NominalAttribute)attribute;
                if (i >= p - 1) continue;
                this.base[i + 1] = this.base[i] + nominal.size();
                continue;
            }
            throw new IllegalArgumentException("Non-nominal attribute: " + attribute);
        }
    }

    public int[] f(double[] object) {
        if (object.length != this.attributes.length) {
            throw new IllegalArgumentException(String.format("Invalide object size %d, expected %d", object.length, this.attributes.length));
        }
        int[] features = new int[this.attributes.length];
        for (int i = 0; i < features.length; ++i) {
            int f = (int)object[i];
            if (Math.floor(object[i]) != object[i] || f < 0 || f >= this.attributes[i].size()) {
                throw new IllegalArgumentException(String.format("Invalid value of attribute %s: %d", this.attributes[i].toString(), f));
            }
            features[i] = f + this.base[i];
        }
        return features;
    }
}

