/*
 * Decompiled with CFR 0.152.
 */
package smile.data.parser;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URI;
import java.text.ParseException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import smile.data.BinarySparseDataset;

public class BinarySparseDatasetParser {
    public BinarySparseDataset parse(URI uri) throws FileNotFoundException, IOException, ParseException {
        return this.parse(new File(uri));
    }

    public BinarySparseDataset parse(String name, URI uri) throws FileNotFoundException, IOException, ParseException {
        return this.parse(name, new File(uri));
    }

    public BinarySparseDataset parse(String path) throws FileNotFoundException, IOException, ParseException {
        return this.parse(new File(path));
    }

    public BinarySparseDataset parse(String name, String path) throws FileNotFoundException, IOException, ParseException {
        return this.parse(name, new File(path));
    }

    public BinarySparseDataset parse(File file) throws FileNotFoundException, IOException, ParseException {
        String name = file.getPath();
        return this.parse(name, new FileInputStream(file));
    }

    public BinarySparseDataset parse(String name, File file) throws FileNotFoundException, IOException, ParseException {
        return this.parse(name, new FileInputStream(file));
    }

    public BinarySparseDataset parse(InputStream stream) throws IOException, ParseException {
        return this.parse("Binary Sparse Dataset", stream);
    }

    public BinarySparseDataset parse(String name, InputStream stream) throws IOException, ParseException {
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(stream));){
            BinarySparseDataset sparse = new BinarySparseDataset(name);
            String line = reader.readLine();
            if (line == null) {
                throw new IOException("Empty data source.");
            }
            HashSet<Integer> items = new HashSet<Integer>();
            do {
                if ((line = line.trim()).isEmpty()) continue;
                String[] s = line.split("\\s+");
                items.clear();
                for (int i = 0; i < s.length; ++i) {
                    items.add(Integer.parseInt(s[i]));
                }
                int j = 0;
                int[] point = new int[items.size()];
                Iterator iterator = items.iterator();
                while (iterator.hasNext()) {
                    int i = (Integer)iterator.next();
                    point[j++] = i;
                }
                Arrays.sort(point);
                sparse.add(point);
                line = reader.readLine();
            } while (line != null);
            BinarySparseDataset binarySparseDataset = sparse;
            return binarySparseDataset;
        }
    }
}

