/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.cf.taste.impl.similarity;

import java.util.Collection;
import org.apache.mahout.cf.taste.common.Refreshable;
import org.apache.mahout.cf.taste.common.TasteException;
import org.apache.mahout.cf.taste.impl.common.FastIDSet;
import org.apache.mahout.cf.taste.impl.common.RefreshHelper;
import org.apache.mahout.cf.taste.impl.similarity.AbstractItemSimilarity;
import org.apache.mahout.cf.taste.model.DataModel;
import org.apache.mahout.cf.taste.similarity.PreferenceInferrer;
import org.apache.mahout.cf.taste.similarity.UserSimilarity;
import org.apache.mahout.math.stats.LogLikelihood;

public final class LogLikelihoodSimilarity
extends AbstractItemSimilarity
implements UserSimilarity {
    public LogLikelihoodSimilarity(DataModel dataModel) {
        super(dataModel);
    }

    @Override
    public void setPreferenceInferrer(PreferenceInferrer inferrer) {
        throw new UnsupportedOperationException();
    }

    @Override
    public double userSimilarity(long userID1, long userID2) throws TasteException {
        long prefs2Size;
        long intersectionSize;
        DataModel dataModel = this.getDataModel();
        FastIDSet prefs1 = dataModel.getItemIDsFromUser(userID1);
        FastIDSet prefs2 = dataModel.getItemIDsFromUser(userID2);
        long prefs1Size = prefs1.size();
        long l = intersectionSize = prefs1Size < (prefs2Size = (long)prefs2.size()) ? (long)prefs2.intersectionSize(prefs1) : (long)prefs1.intersectionSize(prefs2);
        if (intersectionSize == 0L) {
            return Double.NaN;
        }
        long numItems = dataModel.getNumItems();
        double logLikelihood = LogLikelihood.logLikelihoodRatio((long)intersectionSize, (long)(prefs2Size - intersectionSize), (long)(prefs1Size - intersectionSize), (long)(numItems - prefs1Size - prefs2Size + intersectionSize));
        return 1.0 - 1.0 / (1.0 + logLikelihood);
    }

    @Override
    public double itemSimilarity(long itemID1, long itemID2) throws TasteException {
        DataModel dataModel = this.getDataModel();
        long preferring1 = dataModel.getNumUsersWithPreferenceFor(itemID1);
        long numUsers = dataModel.getNumUsers();
        return this.doItemSimilarity(itemID1, itemID2, preferring1, numUsers);
    }

    @Override
    public double[] itemSimilarities(long itemID1, long[] itemID2s) throws TasteException {
        DataModel dataModel = this.getDataModel();
        long preferring1 = dataModel.getNumUsersWithPreferenceFor(itemID1);
        long numUsers = dataModel.getNumUsers();
        int length = itemID2s.length;
        double[] result = new double[length];
        for (int i = 0; i < length; ++i) {
            result[i] = this.doItemSimilarity(itemID1, itemID2s[i], preferring1, numUsers);
        }
        return result;
    }

    private double doItemSimilarity(long itemID1, long itemID2, long preferring1, long numUsers) throws TasteException {
        DataModel dataModel = this.getDataModel();
        long preferring1and2 = dataModel.getNumUsersWithPreferenceFor(itemID1, itemID2);
        if (preferring1and2 == 0L) {
            return Double.NaN;
        }
        long preferring2 = dataModel.getNumUsersWithPreferenceFor(itemID2);
        double logLikelihood = LogLikelihood.logLikelihoodRatio((long)preferring1and2, (long)(preferring2 - preferring1and2), (long)(preferring1 - preferring1and2), (long)(numUsers - preferring1 - preferring2 + preferring1and2));
        return 1.0 - 1.0 / (1.0 + logLikelihood);
    }

    @Override
    public void refresh(Collection<Refreshable> alreadyRefreshed) {
        alreadyRefreshed = RefreshHelper.buildRefreshed(alreadyRefreshed);
        RefreshHelper.maybeRefresh(alreadyRefreshed, this.getDataModel());
    }

    public String toString() {
        return "LogLikelihoodSimilarity[dataModel:" + this.getDataModel() + ']';
    }
}

