/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.cf.taste.impl.common;

import com.google.common.base.Preconditions;
import java.io.Serializable;
import java.util.AbstractCollection;
import java.util.AbstractSet;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import org.apache.mahout.cf.taste.impl.common.BitSet;
import org.apache.mahout.common.RandomUtils;

public final class FastMap<K, V>
implements Map<K, V>,
Serializable,
Cloneable {
    public static final int NO_MAX_SIZE = Integer.MAX_VALUE;
    private static final float DEFAULT_LOAD_FACTOR = 1.5f;
    private static final Object REMOVED = new Object();
    private K[] keys;
    private V[] values;
    private float loadFactor;
    private int numEntries;
    private int numSlotsUsed;
    private final int maxSize;
    private BitSet recentlyAccessed;
    private final boolean countingAccesses;

    public FastMap() {
        this(2, Integer.MAX_VALUE);
    }

    public FastMap(int size) {
        this(size, Integer.MAX_VALUE);
    }

    public FastMap(Map<K, V> other) {
        this(other.size());
        this.putAll(other);
    }

    public FastMap(int size, float loadFactor) {
        this(size, Integer.MAX_VALUE, loadFactor);
    }

    public FastMap(int size, int maxSize) {
        this(size, maxSize, 1.5f);
    }

    public FastMap(int size, int maxSize, float loadFactor) {
        Preconditions.checkArgument((size >= 0 ? 1 : 0) != 0, (Object)"size must be at least 0");
        Preconditions.checkArgument((loadFactor >= 1.0f ? 1 : 0) != 0, (Object)"loadFactor must be at least 1.0");
        this.loadFactor = loadFactor;
        int max = (int)(2.147483E9f / loadFactor);
        Preconditions.checkArgument((size < max ? 1 : 0) != 0, (Object)("size must be less than " + max));
        Preconditions.checkArgument((maxSize >= 1 ? 1 : 0) != 0, (Object)"maxSize must be at least 1");
        int hashSize = RandomUtils.nextTwinPrime((int)((int)(loadFactor * (float)size)));
        this.keys = new Object[hashSize];
        this.values = new Object[hashSize];
        this.maxSize = maxSize;
        this.countingAccesses = maxSize != Integer.MAX_VALUE;
        this.recentlyAccessed = this.countingAccesses ? new BitSet(hashSize) : null;
    }

    private int find(Object key) {
        int theHashCode = key.hashCode() & Integer.MAX_VALUE;
        K[] keys = this.keys;
        int hashSize = keys.length;
        int jump = 1 + theHashCode % (hashSize - 2);
        int index = theHashCode % hashSize;
        K currentKey = keys[index];
        while (currentKey != null && !key.equals(currentKey)) {
            currentKey = keys[index -= index < jump ? jump - hashSize : jump];
        }
        return index;
    }

    private int findForAdd(Object key) {
        int theHashCode = key.hashCode() & Integer.MAX_VALUE;
        K[] keys = this.keys;
        int hashSize = keys.length;
        int jump = 1 + theHashCode % (hashSize - 2);
        int index = theHashCode % hashSize;
        K currentKey = keys[index];
        while (currentKey != null && currentKey != REMOVED && key != currentKey) {
            currentKey = keys[index -= index < jump ? jump - hashSize : jump];
        }
        if (currentKey != REMOVED) {
            return index;
        }
        int addIndex = index;
        while (currentKey != null && key != currentKey) {
            currentKey = keys[index -= index < jump ? jump - hashSize : jump];
        }
        return key == currentKey ? index : addIndex;
    }

    @Override
    public V get(Object key) {
        if (key == null) {
            return null;
        }
        int index = this.find(key);
        if (this.countingAccesses) {
            this.recentlyAccessed.set(index);
        }
        return this.values[index];
    }

    @Override
    public int size() {
        return this.numEntries;
    }

    @Override
    public boolean isEmpty() {
        return this.numEntries == 0;
    }

    @Override
    public boolean containsKey(Object key) {
        return key != null && this.keys[this.find(key)] != null;
    }

    @Override
    public boolean containsValue(Object value) {
        if (value == null) {
            return false;
        }
        for (V theValue : this.values) {
            if (theValue == null || !value.equals(theValue)) continue;
            return true;
        }
        return false;
    }

    @Override
    public V put(K key, V value) {
        int index;
        Preconditions.checkNotNull(key);
        Preconditions.checkNotNull(value);
        if ((float)this.numSlotsUsed * this.loadFactor >= (float)this.keys.length) {
            if ((float)this.numEntries * this.loadFactor >= (float)this.numSlotsUsed) {
                this.growAndRehash();
            } else {
                this.rehash();
            }
        }
        if (this.keys[index = this.findForAdd(key)] == key) {
            V oldValue = this.values[index];
            this.values[index] = value;
            return oldValue;
        }
        if (this.countingAccesses && this.numEntries >= this.maxSize) {
            this.clearStaleEntry(index);
        }
        this.keys[index] = key;
        this.values[index] = value;
        ++this.numEntries;
        ++this.numSlotsUsed;
        return null;
    }

    private void clearStaleEntry(int index) {
        while (true) {
            index = index == 0 ? this.keys.length - 1 : --index;
            K currentKey = this.keys[index];
            if (currentKey == null || currentKey == REMOVED) continue;
            if (!this.recentlyAccessed.get(index)) break;
            this.recentlyAccessed.clear(index);
        }
        this.keys[index] = REMOVED;
        --this.numEntries;
        this.values[index] = null;
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> map) {
        for (Map.Entry<K, V> entry : map.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public V remove(Object key) {
        if (key == null) {
            return null;
        }
        int index = this.find(key);
        if (this.keys[index] == null) {
            return null;
        }
        this.keys[index] = REMOVED;
        --this.numEntries;
        V oldValue = this.values[index];
        this.values[index] = null;
        return oldValue;
    }

    @Override
    public void clear() {
        this.numEntries = 0;
        this.numSlotsUsed = 0;
        Arrays.fill(this.keys, null);
        Arrays.fill(this.values, null);
        if (this.countingAccesses) {
            this.recentlyAccessed.clear();
        }
    }

    @Override
    public Set<K> keySet() {
        return new KeySet();
    }

    @Override
    public Collection<V> values() {
        return new ValueCollection();
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return new EntrySet();
    }

    public void rehash() {
        this.rehash(RandomUtils.nextTwinPrime((int)((int)(this.loadFactor * (float)this.numEntries))));
    }

    private void growAndRehash() {
        if ((float)this.keys.length * this.loadFactor >= 2.147483E9f) {
            throw new IllegalStateException("Can't grow any more");
        }
        this.rehash(RandomUtils.nextTwinPrime((int)((int)(this.loadFactor * (float)this.keys.length))));
    }

    private void rehash(int newHashSize) {
        K[] oldKeys = this.keys;
        V[] oldValues = this.values;
        this.numEntries = 0;
        this.numSlotsUsed = 0;
        if (this.countingAccesses) {
            this.recentlyAccessed = new BitSet(newHashSize);
        }
        this.keys = new Object[newHashSize];
        this.values = new Object[newHashSize];
        int length = oldKeys.length;
        for (int i = 0; i < length; ++i) {
            K key = oldKeys[i];
            if (key == null || key == REMOVED) continue;
            this.put(key, oldValues[i]);
        }
    }

    void iteratorRemove(int lastNext) {
        if (lastNext >= this.values.length) {
            throw new NoSuchElementException();
        }
        if (lastNext < 0) {
            throw new IllegalStateException();
        }
        this.values[lastNext] = null;
        this.keys[lastNext] = REMOVED;
        --this.numEntries;
    }

    public FastMap<K, V> clone() {
        FastMap clone;
        try {
            clone = (FastMap)super.clone();
        }
        catch (CloneNotSupportedException cnse) {
            throw new AssertionError();
        }
        clone.keys = (Object[])this.keys.clone();
        clone.values = (Object[])this.values.clone();
        clone.recentlyAccessed = this.countingAccesses ? new BitSet(this.keys.length) : null;
        return clone;
    }

    @Override
    public int hashCode() {
        int hash = 0;
        K[] keys = this.keys;
        int max = keys.length;
        for (int i = 0; i < max; ++i) {
            K key = keys[i];
            if (key == null || key == REMOVED) continue;
            hash = 31 * hash + key.hashCode();
            hash = 31 * hash + this.values[i].hashCode();
        }
        return hash;
    }

    @Override
    public boolean equals(Object other) {
        K key;
        int i;
        if (!(other instanceof FastMap)) {
            return false;
        }
        FastMap otherMap = (FastMap)other;
        K[] otherKeys = otherMap.keys;
        V[] otherValues = otherMap.values;
        int length = this.keys.length;
        int otherLength = otherKeys.length;
        int max = Math.min(length, otherLength);
        for (i = 0; i < max; ++i) {
            key = this.keys[i];
            K otherKey = otherKeys[i];
            if (!(key == null || key == REMOVED ? otherKey != null && otherKey != REMOVED : key != otherKey || !this.values[i].equals(otherValues[i]))) continue;
            return false;
        }
        while (i < length) {
            key = this.keys[i];
            if (key != null && key != REMOVED) {
                return false;
            }
            ++i;
        }
        while (i < otherLength) {
            key = otherKeys[i];
            if (key != null && key != REMOVED) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public String toString() {
        if (this.isEmpty()) {
            return "{}";
        }
        StringBuilder result = new StringBuilder();
        result.append('{');
        for (int i = 0; i < this.keys.length; ++i) {
            K key = this.keys[i];
            if (key == null || key == REMOVED) continue;
            result.append(key).append('=').append(this.values[i]).append(',');
        }
        result.setCharAt(result.length() - 1, '}');
        return result.toString();
    }

    private final class ValueCollection
    extends AbstractCollection<V> {
        private ValueCollection() {
        }

        @Override
        public int size() {
            return FastMap.this.size();
        }

        @Override
        public boolean isEmpty() {
            return FastMap.this.isEmpty();
        }

        @Override
        public boolean contains(Object o) {
            return FastMap.this.containsValue(o);
        }

        @Override
        public Iterator<V> iterator() {
            return new ValueIterator();
        }

        @Override
        public boolean add(V v) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean remove(Object o) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean addAll(Collection<? extends V> vs) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean removeAll(Collection<?> objects) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean retainAll(Collection<?> objects) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void clear() {
            FastMap.this.clear();
        }

        private final class ValueIterator
        implements Iterator<V> {
            private int position;
            private int lastNext = -1;

            private ValueIterator() {
            }

            @Override
            public boolean hasNext() {
                this.goToNext();
                return this.position < FastMap.this.values.length;
            }

            @Override
            public V next() {
                this.goToNext();
                this.lastNext = this.position;
                if (this.position >= FastMap.this.values.length) {
                    throw new NoSuchElementException();
                }
                return FastMap.this.values[this.position++];
            }

            private void goToNext() {
                int length = FastMap.this.values.length;
                while (this.position < length && FastMap.this.values[this.position] == null) {
                    ++this.position;
                }
            }

            @Override
            public void remove() {
                FastMap.this.iteratorRemove(this.lastNext);
            }
        }
    }

    private final class KeySet
    extends AbstractSet<K> {
        private KeySet() {
        }

        @Override
        public int size() {
            return FastMap.this.size();
        }

        @Override
        public boolean isEmpty() {
            return FastMap.this.isEmpty();
        }

        @Override
        public boolean contains(Object o) {
            return FastMap.this.containsKey(o);
        }

        @Override
        public Iterator<K> iterator() {
            return new KeyIterator();
        }

        @Override
        public boolean add(K t) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean remove(Object o) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean addAll(Collection<? extends K> ts) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean retainAll(Collection<?> objects) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean removeAll(Collection<?> objects) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void clear() {
            FastMap.this.clear();
        }

        private final class KeyIterator
        implements Iterator<K> {
            private int position;
            private int lastNext = -1;

            private KeyIterator() {
            }

            @Override
            public boolean hasNext() {
                this.goToNext();
                return this.position < FastMap.this.keys.length;
            }

            @Override
            public K next() {
                this.goToNext();
                this.lastNext = this.position;
                if (this.position >= FastMap.this.keys.length) {
                    throw new NoSuchElementException();
                }
                return FastMap.this.keys[this.position++];
            }

            private void goToNext() {
                int length = FastMap.this.values.length;
                while (this.position < length && FastMap.this.values[this.position] == null) {
                    ++this.position;
                }
            }

            @Override
            public void remove() {
                FastMap.this.iteratorRemove(this.lastNext);
            }
        }
    }

    private final class EntrySet
    extends AbstractSet<Map.Entry<K, V>> {
        private EntrySet() {
        }

        @Override
        public int size() {
            return FastMap.this.size();
        }

        @Override
        public boolean isEmpty() {
            return FastMap.this.isEmpty();
        }

        @Override
        public boolean contains(Object o) {
            return FastMap.this.containsKey(o);
        }

        @Override
        public Iterator<Map.Entry<K, V>> iterator() {
            return new EntryIterator();
        }

        @Override
        public boolean add(Map.Entry<K, V> t) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean remove(Object o) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean addAll(Collection<? extends Map.Entry<K, V>> ts) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean retainAll(Collection<?> objects) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean removeAll(Collection<?> objects) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void clear() {
            FastMap.this.clear();
        }

        private final class EntryIterator
        implements Iterator<Map.Entry<K, V>> {
            private int position;
            private int lastNext = -1;

            private EntryIterator() {
            }

            @Override
            public boolean hasNext() {
                this.goToNext();
                return this.position < FastMap.this.keys.length;
            }

            @Override
            public Map.Entry<K, V> next() {
                this.goToNext();
                this.lastNext = this.position;
                if (this.position >= FastMap.this.keys.length) {
                    throw new NoSuchElementException();
                }
                return new MapEntry(this.position++);
            }

            private void goToNext() {
                int length = FastMap.this.values.length;
                while (this.position < length && FastMap.this.values[this.position] == null) {
                    ++this.position;
                }
            }

            @Override
            public void remove() {
                FastMap.this.iteratorRemove(this.lastNext);
            }
        }

        private final class MapEntry
        implements Map.Entry<K, V> {
            private final int index;

            private MapEntry(int index) {
                this.index = index;
            }

            @Override
            public K getKey() {
                return FastMap.this.keys[this.index];
            }

            @Override
            public V getValue() {
                return FastMap.this.values[this.index];
            }

            @Override
            public V setValue(V value) {
                Preconditions.checkArgument((value != null ? 1 : 0) != 0);
                Object oldValue = FastMap.this.values[this.index];
                ((FastMap)FastMap.this).values[this.index] = value;
                return oldValue;
            }
        }
    }
}

