/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.clustering.display;

import java.awt.Graphics;
import java.awt.Graphics2D;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.net.URI;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.mahout.clustering.display.DisplayClustering;
import org.apache.mahout.clustering.spectral.kmeans.SpectralKMeansDriver;
import org.apache.mahout.common.HadoopUtil;
import org.apache.mahout.common.RandomUtils;
import org.apache.mahout.common.distance.DistanceMeasure;
import org.apache.mahout.common.distance.ManhattanDistanceMeasure;
import org.apache.mahout.math.VectorWritable;

public class DisplaySpectralKMeans
extends DisplayClustering {
    protected static final String SAMPLES = "samples";
    protected static final String OUTPUT = "output";
    protected static final String TEMP = "tmp";
    protected static final String AFFINITIES = "affinities";

    DisplaySpectralKMeans() {
        this.initialize();
        this.setTitle("Spectral k-Means Clusters (>" + (int)(significance * 100.0) + "% of population)");
    }

    public static void main(String[] args) throws Exception {
        ManhattanDistanceMeasure measure = new ManhattanDistanceMeasure();
        Path samples = new Path(SAMPLES);
        Path output = new Path(OUTPUT);
        Path tempDir = new Path(TEMP);
        Configuration conf = new Configuration();
        HadoopUtil.delete((Configuration)conf, (Path[])new Path[]{samples});
        HadoopUtil.delete((Configuration)conf, (Path[])new Path[]{output});
        RandomUtils.useTestSeed();
        DisplayClustering.generateSamples();
        DisplaySpectralKMeans.writeSampleData(samples);
        Path affinities = new Path(output, AFFINITIES);
        FileSystem fs = FileSystem.get((URI)output.toUri(), (Configuration)conf);
        if (!fs.exists(output)) {
            fs.mkdirs(output);
        }
        try (BufferedWriter writer = new BufferedWriter(new FileWriter(affinities.toString()));){
            for (int i = 0; i < SAMPLE_DATA.size(); ++i) {
                for (int j = 0; j < SAMPLE_DATA.size(); ++j) {
                    writer.write(i + "," + j + ',' + measure.distance(((VectorWritable)SAMPLE_DATA.get(i)).get(), ((VectorWritable)SAMPLE_DATA.get(j)).get()) + '\n');
                }
            }
        }
        int maxIter = 10;
        double convergenceDelta = 0.001;
        SpectralKMeansDriver.run((Configuration)new Configuration(), (Path)affinities, (Path)output, (int)SAMPLE_DATA.size(), (int)3, (DistanceMeasure)measure, (double)convergenceDelta, (int)maxIter, (Path)tempDir);
        new DisplaySpectralKMeans();
    }

    @Override
    public void paint(Graphics g) {
        DisplaySpectralKMeans.plotClusteredSampleData((Graphics2D)g, new Path(new Path(OUTPUT), "kmeans_out"));
    }
}

