/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.classifier.stats;

import java.text.DecimalFormat;
import java.util.Collection;
import org.apache.mahout.classifier.stats.ClassifierResult;
import org.apache.mahout.classifier.stats.ConfusionMatrix;
import org.apache.mahout.classifier.stats.RunningAverageAndStdDev;
import org.apache.mahout.math.stats.OnlineSummarizer;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0001a4A!\u0001\u0002\u0001\u001b\tq!+Z:vYR\fe.\u00197zu\u0016\u0014(BA\u0002\u0005\u0003\u0015\u0019H/\u0019;t\u0015\t)a!\u0001\u0006dY\u0006\u001c8/\u001b4jKJT!a\u0002\u0005\u0002\r5\f\u0007n\\;u\u0015\tI!\"\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002\u0017\u0005\u0019qN]4\u0004\u0001M\u0011\u0001A\u0004\t\u0003\u001fIi\u0011\u0001\u0005\u0006\u0002#\u0005)1oY1mC&\u00111\u0003\u0005\u0002\u0007\u0003:L(+\u001a4\t\u0011U\u0001!Q1A\u0005\nY\t\u0001\u0002\\1cK2\u001cV\r^\u000b\u0002/A\u0019\u0001$H\u0010\u000e\u0003eQ!AG\u000e\u0002\tU$\u0018\u000e\u001c\u0006\u00029\u0005!!.\u0019<b\u0013\tq\u0012D\u0001\u0006D_2dWm\u0019;j_:\u0004\"\u0001I\u0012\u000f\u0005=\t\u0013B\u0001\u0012\u0011\u0003\u0019\u0001&/\u001a3fM&\u0011A%\n\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005\t\u0002\u0002\u0002C\u0014\u0001\u0005\u0003\u0005\u000b\u0011B\f\u0002\u00131\f'-\u001a7TKR\u0004\u0003\u0002C\u0015\u0001\u0005\u0003\u0005\u000b\u0011B\u0010\u0002\u0019\u0011,g-Y;mi2\u000b'-\u001a7\t\u000b-\u0002A\u0011\u0001\u0017\u0002\rqJg.\u001b;?)\ris\u0006\r\t\u0003]\u0001i\u0011A\u0001\u0005\u0006+)\u0002\ra\u0006\u0005\u0006S)\u0002\ra\b\u0005\be\u0001\u0011\r\u0011\"\u00014\u0003=\u0019wN\u001c4vg&|g.T1ue&DX#\u0001\u001b\u0011\u00059*\u0014B\u0001\u001c\u0003\u0005=\u0019uN\u001c4vg&|g.T1ue&D\bB\u0002\u001d\u0001A\u0003%A'\u0001\td_:4Wo]5p]6\u000bGO]5yA!9!\b\u0001b\u0001\n\u0003Y\u0014AC:v[6\f'/\u001b>feV\tA\b\u0005\u0002>\u00036\taH\u0003\u0002\u0004\u007f)\u0011\u0001IB\u0001\u0005[\u0006$\b.\u0003\u0002C}\t\u0001rJ\u001c7j]\u0016\u001cV/\\7be&TXM\u001d\u0005\u0007\t\u0002\u0001\u000b\u0011\u0002\u001f\u0002\u0017M,X.\\1sSj,'\u000f\t\u0005\b\r\u0002\u0001\r\u0011\"\u0003H\u0003\u0015A\u0017m\u001d'M+\u0005A\u0005CA\bJ\u0013\tQ\u0005CA\u0004C_>dW-\u00198\t\u000f1\u0003\u0001\u0019!C\u0005\u001b\u0006I\u0001.Y:M\u0019~#S-\u001d\u000b\u0003\u001dF\u0003\"aD(\n\u0005A\u0003\"\u0001B+oSRDqAU&\u0002\u0002\u0003\u0007\u0001*A\u0002yIEBa\u0001\u0016\u0001!B\u0013A\u0015A\u00025bg2c\u0005\u0005C\u0004W\u0001\u0001\u0007I\u0011B,\u0002'\r|'O]3di2L8\t\\1tg&4\u0017.\u001a3\u0016\u0003a\u0003\"aD-\n\u0005i\u0003\"aA%oi\"9A\f\u0001a\u0001\n\u0013i\u0016aF2peJ,7\r\u001e7z\u00072\f7o]5gS\u0016$w\fJ3r)\tqe\fC\u0004S7\u0006\u0005\t\u0019\u0001-\t\r\u0001\u0004\u0001\u0015)\u0003Y\u0003Q\u0019wN\u001d:fGRd\u0017p\u00117bgNLg-[3eA!9!\r\u0001a\u0001\n\u00139\u0016!F5oG>\u0014(/Z2uYf\u001cE.Y:tS\u001aLW\r\u001a\u0005\bI\u0002\u0001\r\u0011\"\u0003f\u0003eIgnY8se\u0016\u001cG\u000f\\=DY\u0006\u001c8/\u001b4jK\u0012|F%Z9\u0015\u000593\u0007b\u0002*d\u0003\u0003\u0005\r\u0001\u0017\u0005\u0007Q\u0002\u0001\u000b\u0015\u0002-\u0002-%t7m\u001c:sK\u000e$H._\"mCN\u001c\u0018NZ5fI\u0002BQA\u001b\u0001\u0005\u0002M\n!cZ3u\u0007>tg-^:j_:l\u0015\r\u001e:jq\")A\u000e\u0001C\u0001[\u0006Y\u0011\r\u001a3J]N$\u0018M\\2f)\rAe\u000e\u001d\u0005\u0006_.\u0004\raH\u0001\rG>\u0014(/Z2u\u0019\u0006\u0014W\r\u001c\u0005\u0006c.\u0004\rA]\u0001\u0011G2\f7o]5gS\u0016$'+Z:vYR\u0004\"AL:\n\u0005Q\u0014!\u0001E\"mCN\u001c\u0018NZ5feJ+7/\u001e7u\u0011\u00151\b\u0001\"\u0011x\u0003!!xn\u0015;sS:<G#A\u0010")
public class ResultAnalyzer {
    private final Collection<String> labelSet;
    private final ConfusionMatrix confusionMatrix;
    private final OnlineSummarizer summarizer;
    private boolean hasLL;
    private int correctlyClassified;
    private int incorrectlyClassified;

    private Collection<String> labelSet() {
        return this.labelSet;
    }

    public ConfusionMatrix confusionMatrix() {
        return this.confusionMatrix;
    }

    public OnlineSummarizer summarizer() {
        return this.summarizer;
    }

    private boolean hasLL() {
        return this.hasLL;
    }

    private void hasLL_$eq(boolean x$1) {
        this.hasLL = x$1;
    }

    private int correctlyClassified() {
        return this.correctlyClassified;
    }

    private void correctlyClassified_$eq(int x$1) {
        this.correctlyClassified = x$1;
    }

    private int incorrectlyClassified() {
        return this.incorrectlyClassified;
    }

    private void incorrectlyClassified_$eq(int x$1) {
        this.incorrectlyClassified = x$1;
    }

    public ConfusionMatrix getConfusionMatrix() {
        return this.confusionMatrix();
    }

    /*
     * WARNING - void declaration
     */
    public boolean addInstance(String correctLabel, ClassifierResult classifiedResult) {
        void var3_4;
        boolean result;
        String string = correctLabel;
        String string2 = classifiedResult.getLabel();
        boolean bl = !(string != null ? !string.equals(string2) : string2 != null) ? true : (result = false);
        if (result) {
            this.correctlyClassified_$eq(this.correctlyClassified() + 1);
        } else {
            this.incorrectlyClassified_$eq(this.incorrectlyClassified() + 1);
        }
        this.confusionMatrix().addInstance(correctLabel, classifiedResult);
        if (classifiedResult.getLogLikelihood() != (double)Integer.MAX_VALUE) {
            this.summarizer().add(classifiedResult.getLogLikelihood());
            this.hasLL_$eq(true);
        }
        return (boolean)var3_4;
    }

    public String toString() {
        BoxedUnit boxedUnit;
        StringBuilder returnString = new StringBuilder();
        returnString.append('\n');
        returnString.append("=======================================================\n");
        returnString.append("Summary\n");
        returnString.append("-------------------------------------------------------\n");
        int totalClassified = this.correctlyClassified() + this.incorrectlyClassified();
        double percentageCorrect = (double)100 * (double)this.correctlyClassified() / (double)totalClassified;
        double percentageIncorrect = (double)100 * (double)this.incorrectlyClassified() / (double)totalClassified;
        DecimalFormat decimalFormatter = new DecimalFormat("0.####");
        returnString.append("Correctly Classified Instances").append(": ").append(Integer.toString(this.correctlyClassified())).append('\t').append(decimalFormatter.format(percentageCorrect)).append("%\n");
        returnString.append("Incorrectly Classified Instances").append(": ").append(Integer.toString(this.incorrectlyClassified())).append('\t').append(decimalFormatter.format(percentageIncorrect)).append("%\n");
        returnString.append("Total Classified Instances").append(": ").append(Integer.toString(totalClassified)).append('\n');
        returnString.append('\n');
        returnString.append((Object)this.confusionMatrix());
        returnString.append("=======================================================\n");
        returnString.append("Statistics\n");
        returnString.append("-------------------------------------------------------\n");
        RunningAverageAndStdDev normStats = this.confusionMatrix().getNormalizedStats();
        returnString.append("Kappa: \t").append(decimalFormatter.format(this.confusionMatrix().getKappa())).append('\n');
        returnString.append("Accuracy: \t").append(decimalFormatter.format(this.confusionMatrix().getAccuracy())).append("%\n");
        returnString.append("Reliability: \t").append(decimalFormatter.format(normStats.getAverage() * 100.00000001)).append("%\n");
        returnString.append("Reliability (std dev): \t").append(decimalFormatter.format(normStats.getStandardDeviation())).append('\n');
        returnString.append("Weighted precision: \t").append(decimalFormatter.format(this.confusionMatrix().getWeightedPrecision())).append('\n');
        returnString.append("Weighted recall: \t").append(decimalFormatter.format(this.confusionMatrix().getWeightedRecall())).append('\n');
        returnString.append("Weighted F1 score: \t").append(decimalFormatter.format(this.confusionMatrix().getWeightedF1score())).append('\n');
        if (this.hasLL()) {
            returnString.append("Log-likelihood: \t").append("mean      :  \t").append(decimalFormatter.format(this.summarizer().getMean())).append('\n');
            returnString.append("25%-ile   :  \t").append(decimalFormatter.format(this.summarizer().getQuartile(1))).append('\n');
            boxedUnit = returnString.append("75%-ile   :  \t").append(decimalFormatter.format(this.summarizer().getQuartile(3))).append('\n');
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        return returnString.toString();
    }

    public ResultAnalyzer(Collection<String> labelSet, String defaultLabel) {
        this.labelSet = labelSet;
        this.confusionMatrix = new ConfusionMatrix(labelSet, defaultLabel);
        this.summarizer = new OnlineSummarizer();
        this.hasLL = false;
        this.correctlyClassified = 0;
        this.incorrectlyClassified = 0;
    }
}

