/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.cf.taste.impl.model.hbase;

import java.io.Closeable;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.NavigableMap;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.HBaseAdmin;
import org.apache.hadoop.hbase.client.HTableFactory;
import org.apache.hadoop.hbase.client.HTableInterface;
import org.apache.hadoop.hbase.client.HTableInterfaceFactory;
import org.apache.hadoop.hbase.client.HTablePool;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.filter.Filter;
import org.apache.hadoop.hbase.filter.FilterList;
import org.apache.hadoop.hbase.filter.FirstKeyOnlyFilter;
import org.apache.hadoop.hbase.filter.KeyOnlyFilter;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.mahout.cf.taste.common.NoSuchItemException;
import org.apache.mahout.cf.taste.common.NoSuchUserException;
import org.apache.mahout.cf.taste.common.Refreshable;
import org.apache.mahout.cf.taste.common.TasteException;
import org.apache.mahout.cf.taste.impl.common.FastIDSet;
import org.apache.mahout.cf.taste.impl.common.LongPrimitiveIterator;
import org.apache.mahout.cf.taste.impl.model.GenericItemPreferenceArray;
import org.apache.mahout.cf.taste.impl.model.GenericUserPreferenceArray;
import org.apache.mahout.cf.taste.model.DataModel;
import org.apache.mahout.cf.taste.model.PreferenceArray;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class HBaseDataModel
implements DataModel,
Closeable {
    private static final Logger log = LoggerFactory.getLogger(HBaseDataModel.class);
    private static final String DEFAULT_TABLE = "taste";
    private static final byte[] USERS_CF = Bytes.toBytes((String)"users");
    private static final byte[] ITEMS_CF = Bytes.toBytes((String)"items");
    private final HTablePool pool;
    private final String tableName;
    private volatile FastIDSet itemIDs;
    private volatile FastIDSet userIDs;

    public HBaseDataModel(String zkConnect) throws IOException {
        this(zkConnect, DEFAULT_TABLE);
    }

    public HBaseDataModel(String zkConnect, String tableName) throws IOException {
        log.info("Using HBase table {}", (Object)tableName);
        Configuration conf = HBaseConfiguration.create();
        conf.set("hbase.zookeeper.quorum", zkConnect);
        HTableFactory tableFactory = new HTableFactory();
        this.pool = new HTablePool(conf, 8, (HTableInterfaceFactory)tableFactory);
        this.tableName = tableName;
        this.bootstrap(conf);
        this.refresh(null);
    }

    public HBaseDataModel(HTablePool pool, String tableName, Configuration conf) throws IOException {
        log.info("Using HBase table {}", (Object)tableName);
        this.pool = pool;
        this.tableName = tableName;
        this.bootstrap(conf);
        this.refresh(null);
    }

    public String getTableName() {
        return this.tableName;
    }

    private void bootstrap(Configuration conf) throws IOException {
        HTableDescriptor tDesc = new HTableDescriptor(Bytes.toBytes((String)this.tableName));
        tDesc.addFamily(new HColumnDescriptor(USERS_CF));
        tDesc.addFamily(new HColumnDescriptor(ITEMS_CF));
        try (HBaseAdmin admin = new HBaseAdmin(conf);){
            admin.createTable(tDesc);
            log.info("Created table {}", (Object)this.tableName);
        }
    }

    private static byte[] userToBytes(long userID) {
        ByteBuffer bb = ByteBuffer.allocate(9);
        bb.put((byte)117);
        bb.putLong(userID);
        return bb.array();
    }

    private static byte[] itemToBytes(long itemID) {
        ByteBuffer bb = ByteBuffer.allocate(9);
        bb.put((byte)105);
        bb.putLong(itemID);
        return bb.array();
    }

    private static long bytesToUserOrItemID(byte[] ba) {
        ByteBuffer bb = ByteBuffer.wrap(ba);
        return bb.getLong(1);
    }

    public LongPrimitiveIterator getUserIDs() {
        return this.userIDs.iterator();
    }

    public PreferenceArray getPreferencesFromUser(long userID) throws TasteException {
        Result result;
        try {
            HTableInterface table = this.pool.getTable(this.tableName);
            Get get = new Get(HBaseDataModel.userToBytes(userID));
            get.addFamily(ITEMS_CF);
            result = table.get(get);
            table.close();
        }
        catch (IOException e) {
            throw new TasteException("Failed to retrieve user preferences from HBase", (Throwable)e);
        }
        if (result.isEmpty()) {
            throw new NoSuchUserException(userID);
        }
        NavigableMap families = result.getFamilyMap(ITEMS_CF);
        GenericUserPreferenceArray prefs = new GenericUserPreferenceArray(families.size());
        prefs.setUserID(0, userID);
        int i = 0;
        for (Map.Entry entry : families.entrySet()) {
            prefs.setItemID(i, Bytes.toLong((byte[])((byte[])entry.getKey())));
            prefs.setValue(i, Bytes.toFloat((byte[])((byte[])entry.getValue())));
            ++i;
        }
        return prefs;
    }

    public FastIDSet getItemIDsFromUser(long userID) throws TasteException {
        Result result;
        try {
            HTableInterface table = this.pool.getTable(this.tableName);
            Get get = new Get(HBaseDataModel.userToBytes(userID));
            get.addFamily(ITEMS_CF);
            result = table.get(get);
            table.close();
        }
        catch (IOException e) {
            throw new TasteException("Failed to retrieve item IDs from HBase", (Throwable)e);
        }
        if (result.isEmpty()) {
            throw new NoSuchUserException(userID);
        }
        NavigableMap families = result.getFamilyMap(ITEMS_CF);
        FastIDSet ids = new FastIDSet(families.size());
        for (byte[] family : families.keySet()) {
            ids.add(Bytes.toLong((byte[])family));
        }
        return ids;
    }

    public LongPrimitiveIterator getItemIDs() {
        return this.itemIDs.iterator();
    }

    public PreferenceArray getPreferencesForItem(long itemID) throws TasteException {
        Result result;
        try {
            HTableInterface table = this.pool.getTable(this.tableName);
            Get get = new Get(HBaseDataModel.itemToBytes(itemID));
            get.addFamily(USERS_CF);
            result = table.get(get);
            table.close();
        }
        catch (IOException e) {
            throw new TasteException("Failed to retrieve item preferences from HBase", (Throwable)e);
        }
        if (result.isEmpty()) {
            throw new NoSuchItemException(itemID);
        }
        NavigableMap families = result.getFamilyMap(USERS_CF);
        GenericItemPreferenceArray prefs = new GenericItemPreferenceArray(families.size());
        prefs.setItemID(0, itemID);
        int i = 0;
        for (Map.Entry entry : families.entrySet()) {
            prefs.setUserID(i, Bytes.toLong((byte[])((byte[])entry.getKey())));
            prefs.setValue(i, Bytes.toFloat((byte[])((byte[])entry.getValue())));
            ++i;
        }
        return prefs;
    }

    public Float getPreferenceValue(long userID, long itemID) throws TasteException {
        Result result;
        try {
            HTableInterface table = this.pool.getTable(this.tableName);
            Get get = new Get(HBaseDataModel.userToBytes(userID));
            get.addColumn(ITEMS_CF, Bytes.toBytes((long)itemID));
            result = table.get(get);
            table.close();
        }
        catch (IOException e) {
            throw new TasteException("Failed to retrieve user preferences from HBase", (Throwable)e);
        }
        if (result.isEmpty()) {
            throw new NoSuchUserException(userID);
        }
        if (result.containsColumn(ITEMS_CF, Bytes.toBytes((long)itemID))) {
            return Float.valueOf(Bytes.toFloat((byte[])result.getValue(ITEMS_CF, Bytes.toBytes((long)itemID))));
        }
        return null;
    }

    public Long getPreferenceTime(long userID, long itemID) throws TasteException {
        Result result;
        try {
            HTableInterface table = this.pool.getTable(this.tableName);
            Get get = new Get(HBaseDataModel.userToBytes(userID));
            get.addColumn(ITEMS_CF, Bytes.toBytes((long)itemID));
            result = table.get(get);
            table.close();
        }
        catch (IOException e) {
            throw new TasteException("Failed to retrieve user preferences from HBase", (Throwable)e);
        }
        if (result.isEmpty()) {
            throw new NoSuchUserException(userID);
        }
        if (result.containsColumn(ITEMS_CF, Bytes.toBytes((long)itemID))) {
            KeyValue kv = result.getColumnLatest(ITEMS_CF, Bytes.toBytes((long)itemID));
            return kv.getTimestamp();
        }
        return null;
    }

    public int getNumItems() {
        return this.itemIDs.size();
    }

    public int getNumUsers() {
        return this.userIDs.size();
    }

    public int getNumUsersWithPreferenceFor(long itemID) throws TasteException {
        PreferenceArray prefs = this.getPreferencesForItem(itemID);
        return prefs.length();
    }

    public int getNumUsersWithPreferenceFor(long itemID1, long itemID2) throws TasteException {
        Result[] results;
        try {
            HTableInterface table = this.pool.getTable(this.tableName);
            ArrayList<Get> gets = new ArrayList<Get>(2);
            gets.add(new Get(HBaseDataModel.itemToBytes(itemID1)));
            gets.add(new Get(HBaseDataModel.itemToBytes(itemID2)));
            ((Get)gets.get(0)).addFamily(USERS_CF);
            ((Get)gets.get(1)).addFamily(USERS_CF);
            results = table.get(gets);
            table.close();
        }
        catch (IOException e) {
            throw new TasteException("Failed to retrieve item preferences from HBase", (Throwable)e);
        }
        if (results[0].isEmpty()) {
            throw new NoSuchItemException(itemID1);
        }
        if (results[1].isEmpty()) {
            throw new NoSuchItemException(itemID2);
        }
        Result result = results[0];
        NavigableMap families = result.getFamilyMap(USERS_CF);
        FastIDSet idSet1 = new FastIDSet(families.size());
        for (byte[] id : families.keySet()) {
            idSet1.add(Bytes.toLong((byte[])id));
        }
        result = results[1];
        families = result.getFamilyMap(USERS_CF);
        FastIDSet idSet2 = new FastIDSet(families.size());
        for (byte[] id : families.keySet()) {
            idSet2.add(Bytes.toLong((byte[])id));
        }
        return idSet1.intersectionSize(idSet2);
    }

    public void setPreference(long userID, long itemID, float value) throws TasteException {
        try {
            HTableInterface table = this.pool.getTable(this.tableName);
            ArrayList<Put> puts = new ArrayList<Put>(2);
            puts.add(new Put(HBaseDataModel.userToBytes(userID)));
            puts.add(new Put(HBaseDataModel.itemToBytes(itemID)));
            ((Put)puts.get(0)).add(ITEMS_CF, Bytes.toBytes((long)itemID), Bytes.toBytes((float)value));
            ((Put)puts.get(1)).add(USERS_CF, Bytes.toBytes((long)userID), Bytes.toBytes((float)value));
            table.put(puts);
            table.close();
        }
        catch (IOException e) {
            throw new TasteException("Failed to store preference in HBase", (Throwable)e);
        }
    }

    public void removePreference(long userID, long itemID) throws TasteException {
        try {
            HTableInterface table = this.pool.getTable(this.tableName);
            ArrayList<Delete> deletes = new ArrayList<Delete>(2);
            deletes.add(new Delete(HBaseDataModel.userToBytes(userID)));
            deletes.add(new Delete(HBaseDataModel.itemToBytes(itemID)));
            ((Delete)deletes.get(0)).deleteColumns(ITEMS_CF, Bytes.toBytes((long)itemID));
            ((Delete)deletes.get(1)).deleteColumns(USERS_CF, Bytes.toBytes((long)userID));
            table.delete(deletes);
            table.close();
        }
        catch (IOException e) {
            throw new TasteException("Failed to remove preference from HBase", (Throwable)e);
        }
    }

    public boolean hasPreferenceValues() {
        return true;
    }

    public float getMaxPreference() {
        throw new UnsupportedOperationException();
    }

    public float getMinPreference() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void close() throws IOException {
        this.pool.close();
    }

    public void refresh(Collection<Refreshable> alreadyRefreshed) {
        if (alreadyRefreshed == null || !alreadyRefreshed.contains(this)) {
            try {
                log.info("Refreshing item and user ID caches");
                long t1 = System.currentTimeMillis();
                this.refreshItemIDs();
                this.refreshUserIDs();
                long t2 = System.currentTimeMillis();
                log.info("Finished refreshing caches in {} ms", (Object)(t2 - t1));
            }
            catch (IOException e) {
                throw new IllegalStateException("Could not reload DataModel", e);
            }
        }
    }

    private synchronized void refreshItemIDs() throws IOException {
        HTableInterface table = this.pool.getTable(this.tableName);
        Scan scan = new Scan(new byte[]{105}, new byte[]{112});
        scan.setFilter((Filter)new FilterList(FilterList.Operator.MUST_PASS_ALL, new Filter[]{new KeyOnlyFilter(), new FirstKeyOnlyFilter()}));
        ResultScanner scanner = table.getScanner(scan);
        LinkedList<Long> ids = new LinkedList<Long>();
        for (Result result : scanner) {
            ids.add(HBaseDataModel.bytesToUserOrItemID(result.getRow()));
        }
        table.close();
        FastIDSet itemIDs = new FastIDSet(ids.size());
        Iterator i$ = ids.iterator();
        while (i$.hasNext()) {
            long l = (Long)i$.next();
            itemIDs.add(l);
        }
        this.itemIDs = itemIDs;
    }

    private synchronized void refreshUserIDs() throws IOException {
        HTableInterface table = this.pool.getTable(this.tableName);
        Scan scan = new Scan(new byte[]{117}, new byte[]{118});
        scan.setFilter((Filter)new FilterList(FilterList.Operator.MUST_PASS_ALL, new Filter[]{new KeyOnlyFilter(), new FirstKeyOnlyFilter()}));
        ResultScanner scanner = table.getScanner(scan);
        LinkedList<Long> ids = new LinkedList<Long>();
        for (Result result : scanner) {
            ids.add(HBaseDataModel.bytesToUserOrItemID(result.getRow()));
        }
        table.close();
        FastIDSet userIDs = new FastIDSet(ids.size());
        Iterator i$ = ids.iterator();
        while (i$.hasNext()) {
            long l = (Long)i$.next();
            userIDs.add(l);
        }
        this.userIDs = userIDs;
    }
}

